/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.utils;

import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.resources.Messages;
import java.beans.IndexedPropertyDescriptor;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import org.apache.commons.logging.Log;

public class BeanPropertyDescriptor {
    protected static Log log = LogFactory.getLog(BeanPropertyDescriptor.class.getName());
    protected PropertyDescriptor myPD = null;

    public BeanPropertyDescriptor(PropertyDescriptor propertyDescriptor) {
        this.myPD = propertyDescriptor;
    }

    protected BeanPropertyDescriptor() {
    }

    public String getName() {
        return this.myPD.getName();
    }

    public boolean isReadable() {
        return this.myPD.getReadMethod() != null;
    }

    public boolean isWriteable() {
        return this.myPD.getWriteMethod() != null;
    }

    public boolean isIndexed() {
        return this.myPD instanceof IndexedPropertyDescriptor;
    }

    public Object get(Object object) throws InvocationTargetException, IllegalAccessException {
        if (this.myPD.getReadMethod() != null) {
            return this.myPD.getReadMethod().invoke(object, null);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("get() obj=" + object.getClass().getName()));
            log.debug((Object)("get() name=" + this.getName()));
            log.debug((Object)("get() readable=" + this.isReadable()));
            log.debug((Object)("get() writeable=" + this.isWriteable()));
            log.debug((Object)("get() indexed=" + this.isIndexed()));
            log.debug((Object)("get() type=" + this.getType()));
        }
        throw new IllegalAccessException(Messages.getMessage("badGetter00"));
    }

    public void set(Object object, Object object2) throws InvocationTargetException, IllegalAccessException {
        if (this.myPD.getWriteMethod() == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("set() obj=" + object.getClass().getName()));
                log.debug((Object)("set() newValue=" + object2));
                log.debug((Object)("set() name=" + this.getName()));
                log.debug((Object)("set() readable=" + this.isReadable()));
                log.debug((Object)("set() writeable=" + this.isWriteable()));
                log.debug((Object)("set() indexed=" + this.isIndexed()));
                log.debug((Object)("set() type=" + this.getType()));
            }
            throw new IllegalAccessException(Messages.getMessage("badSetter00"));
        }
        this.myPD.getWriteMethod().invoke(object, object2);
    }

    public Object get(Object object, int n) throws InvocationTargetException, IllegalAccessException {
        if (!this.isIndexed()) {
            return Array.get(this.get(object), n);
        }
        IndexedPropertyDescriptor indexedPropertyDescriptor = (IndexedPropertyDescriptor)this.myPD;
        return indexedPropertyDescriptor.getIndexedReadMethod().invoke(object, new Integer(n));
    }

    public void set(Object object, int n, Object object2) throws InvocationTargetException, IllegalAccessException {
        if (this.isIndexed()) {
            IndexedPropertyDescriptor indexedPropertyDescriptor = (IndexedPropertyDescriptor)this.myPD;
            this.growArrayToSize(object, indexedPropertyDescriptor.getIndexedPropertyType(), n);
            indexedPropertyDescriptor.getIndexedWriteMethod().invoke(object, new Integer(n), object2);
        } else {
            Object object3 = this.get(object);
            if (object3 == null) {
                object3 = this.growArrayToSize(object, this.myPD.getPropertyType().getComponentType(), n);
            }
            Array.set(object3, n, object2);
        }
    }

    protected Object growArrayToSize(Object object, Class clazz, int n) throws InvocationTargetException, IllegalAccessException {
        Object object2 = this.get(object);
        if (object2 == null || Array.getLength(object2) <= n) {
            Object object3 = Array.newInstance(clazz, n + 1);
            if (object2 != null) {
                System.arraycopy(object2, 0, object3, 0, Array.getLength(object2));
            }
            this.set(object, object3);
            return object3;
        }
        return object2;
    }

    public Class getType() {
        if (this.isIndexed()) {
            return ((IndexedPropertyDescriptor)this.myPD).getIndexedPropertyType();
        }
        return this.myPD.getPropertyType();
    }

    public Class getFullType() {
        return this.myPD.getPropertyType();
    }
}

