/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.transport.jms;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.mq.jms.MQDestination;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.engine.Message;
import com.ibm.ws.webservices.engine.MessageContext;
import com.ibm.ws.webservices.engine.WebServicesFault;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.engine.server.ServerEngine;
import com.ibm.ws.webservices.engine.transport.TransactionSuspender;
import com.ibm.ws.webservices.engine.utils.JavaUtils;
import com.ibm.ws.webservices.trace.MessageTrace;
import com.ibm.ws.webservices.trace.UserExceptionTrace;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.HashMap;
import javax.ejb.EJBException;
import javax.ejb.MessageDrivenBean;
import javax.ejb.MessageDrivenContext;
import javax.jms.BytesMessage;
import javax.jms.JMSException;
import javax.jms.MessageListener;
import javax.jms.Queue;
import javax.jms.QueueConnectionFactory;
import javax.jms.TextMessage;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public class JMSListenerMDB
implements MessageDrivenBean,
MessageListener {
    private static final TraceComponent _tc = Tr.register((Class)JMSListenerMDB.class, (String)"WebServices", (String)"com.ibm.ws.webservices.engine.resources.engineMessages");
    private MessageDrivenContext fMessageDrivenCtx = null;
    private ServerEngine serverEngine = null;
    private InitialContext initialContext = null;
    private QueueConnectionFactory replyQCF = null;

    public MessageDrivenContext getMessageDrivenContext() {
        return this.fMessageDrivenCtx;
    }

    public void setMessageDrivenContext(MessageDrivenContext messageDrivenContext) {
        this.fMessageDrivenCtx = messageDrivenContext;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private InitialContext getInitialContext() throws NamingException {
        if (_tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)_tc, (String)"getInitialContext");
        }
        try {
            block5: {
                try {
                    if (this.initialContext != null) break block5;
                    this.initialContext = new InitialContext();
                }
                catch (NamingException namingException) {
                    FFDCFilter.processException((Throwable)namingException, (String)"com.ibm.ws.webservices.engine.transport.jms.JMSListenerMDB.getInitialContext", (String)"138", (Object)this);
                    if (!_tc.isDebugEnabled()) throw namingException;
                    Tr.debug((TraceComponent)_tc, (String)"Failed to create initial context!");
                    throw namingException;
                }
            }
            Object var3_1 = null;
            if (!_tc.isEntryEnabled()) return this.initialContext;
            Tr.exit((TraceComponent)_tc, (String)"getInitialContext");
            return this.initialContext;
        }
        catch (Throwable throwable) {
            Object var3_2 = null;
            if (!_tc.isEntryEnabled()) throw throwable;
            Tr.exit((TraceComponent)_tc, (String)"getInitialContext");
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private synchronized QueueConnectionFactory getReplyQCF() throws Exception {
        try {
            block6: {
                try {
                    if (_tc.isEntryEnabled()) {
                        Tr.entry((TraceComponent)_tc, (String)"getReplyQCF");
                    }
                    if (this.replyQCF != null) break block6;
                    InitialContext initialContext = this.getInitialContext();
                    String string = "java:comp/env/jms/WebServicesReplyQCF";
                    if (_tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)_tc, (String)("About to look up QCF: " + string));
                    }
                    this.replyQCF = (QueueConnectionFactory)initialContext.lookup(string);
                    if (!_tc.isDebugEnabled()) break block6;
                    Tr.debug((TraceComponent)_tc, (String)"Found the QCF!");
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.webservices.engine.transport.jms.JMSListenerMDB.getReplyQCF", (String)"189", (Object)this);
                    if (!_tc.isDebugEnabled()) throw exception;
                    Tr.debug((TraceComponent)_tc, (String)("Failed to locate my reply QCF, exception = " + exception.toString()));
                    throw exception;
                }
            }
            Object var4_4 = null;
            if (!_tc.isEntryEnabled()) return this.replyQCF;
            Tr.exit((TraceComponent)_tc, (String)"getReplyQCF");
            return this.replyQCF;
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            if (!_tc.isEntryEnabled()) throw throwable;
            Tr.exit((TraceComponent)_tc, (String)"getReplyQCF");
            throw throwable;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void ejbCreate() {
        if (_tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)_tc, (String)"ejbCreate");
        }
        try {
            try {
                HashMap hashMap = new HashMap();
                this.serverEngine = ServerEngine.getServer(null, hashMap);
                if (this.serverEngine == null) {
                    throw new WebServicesFault(Messages.getMessage("JMS.ServerEngine"));
                }
                Object var3_3 = null;
            }
            catch (WebServicesFault webServicesFault) {
                FFDCFilter.processException((Throwable)webServicesFault, (String)"com.ibm.ws.webservices.engine.transport.jms.JMSListenerMDB.ejbCreate", (String)"232", (Object)this);
                Tr.error((TraceComponent)_tc, (String)"JMS.Fault01", (Object)webServicesFault.toString());
                throw new EJBException(webServicesFault.toString());
            }
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            if (!_tc.isEntryEnabled()) throw throwable;
            Tr.exit((TraceComponent)_tc, (String)"ejbCreate");
            throw throwable;
        }
        if (!_tc.isEntryEnabled()) return;
        Tr.exit((TraceComponent)_tc, (String)"ejbCreate");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void onMessage(javax.jms.Message message) {
        block57: {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            Object object5;
            Object object6;
            Object object7;
            if (_tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)_tc, (String)"onMessage");
            }
            if (_tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)_tc, (String)("Received JMS Message: " + message.toString()));
            }
            MessageContext messageContext = new MessageContext(this.serverEngine);
            Message message2 = null;
            Message message3 = null;
            Queue queue = null;
            String string = null;
            boolean bl = false;
            long l = 0L;
            int n = 4;
            int n2 = 2;
            boolean bl2 = true;
            TransactionSuspender transactionSuspender = null;
            try {
                object7 = message.getStringProperty("enableTransaction");
                bl2 = JavaUtils.isFalse((String)object7);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (bl2) {
                transactionSuspender = new TransactionSuspender();
            }
            try {
                if (bl2) {
                    transactionSuspender.suspendTransaction();
                }
                if ((l = message.getJMSExpiration() - message.getJMSTimestamp()) < 0L) {
                    l = 0L;
                }
                n = message.getJMSPriority();
                n2 = message.getJMSDeliveryMode();
                if (_tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)_tc, (String)("Values extracted from JMS resquest message:\nTimeToLive = " + l + " Priority = " + n + " DeliveryMode = " + n2 + "\n"));
                }
                string = message.getJMSMessageID();
                queue = (Queue)message.getJMSReplyTo();
                object7 = message.getStringProperty("targetService");
                if (object7 == null || ((String)object7).length() == 0) {
                    Tr.error((TraceComponent)_tc, (String)"JMS.NoTargetService", (Object)"targetService");
                    throw new WebServicesFault("JMS", Messages.getMessage("JMS.NoTargetService", "targetService"), null, null);
                }
                messageContext.setTargetPort((String)object7);
                if (_tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)_tc, (String)("Set target port on message context to: " + (String)object7));
                }
                if ((object6 = message.getStringProperty("endpointURL")) != null && ((String)object6).length() > 0) {
                    messageContext.setProperty("inbound.url", object6);
                    if (_tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)_tc, (String)("Set inbound.url property on MessageContext to: " + (String)object6));
                    }
                }
                object5 = (object5 = message.getStringProperty("contentType")) == null ? null : ((String)object5).trim();
                object4 = null;
                if (message instanceof BytesMessage) {
                    if (_tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)_tc, (String)("Got BytesMessage, contentType=" + (String)object5));
                    }
                    object3 = (BytesMessage)message;
                    bl = true;
                    object2 = new ByteArrayOutputStream();
                    object = new byte[4096];
                    int n3 = 1;
                    while (n3 > 0) {
                        n3 = object3.readBytes((byte[])object);
                        if (n3 <= 0) continue;
                        ((ByteArrayOutputStream)object2).write((byte[])object, 0, n3);
                    }
                    if (_tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)_tc, (String)("Extracted the following SOAP message from the JMS request message:\n" + ((ByteArrayOutputStream)object2).toString()));
                    }
                    object4 = ((ByteArrayOutputStream)object2).toByteArray();
                    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream((byte[])object4);
                    message2 = new Message(byteArrayInputStream, (String)object5, null);
                } else {
                    if (!(message instanceof TextMessage)) {
                        Tr.error((TraceComponent)_tc, (String)"JMS.BadMsgType");
                        throw new WebServicesFault("JMS", Messages.getMessage("JMS.BadMsgType"), null, null);
                    }
                    if (_tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)_tc, (String)("Got TextMessage, contentType=" + (String)object5));
                    }
                    object3 = ((TextMessage)message).getText();
                    if (_tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)_tc, (String)("Extracted the following SOAP text message from the JMS request message:\n" + (String)object3));
                    }
                    message2 = new Message(object3, (String)object5, null);
                    if (MessageTrace.isTraceEnabled()) {
                        object4 = ((String)object3).getBytes();
                    }
                }
                messageContext.setRequestMessage(message2);
                messageContext.setTransportName("jms");
                messageContext.setProperty("transport.jms.requestMessage", message);
                this.handleSoapAction(message, messageContext);
                if (MessageTrace.isTraceEnabled() && object4 != null) {
                    MessageTrace.log(MessageTrace.INBOUND_JMS_REQUEST, (String)object5, (byte[])object4);
                }
                if (_tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)_tc, (String)"Calling ServerEngine.invoke()...");
                }
                this.serverEngine.invoke(messageContext);
                if (_tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)_tc, (String)"Returned from ServerEngine.invoke()...");
                }
            }
            catch (Exception exception) {
                boolean bl3 = false;
                if (UserExceptionTrace.isUserDefinedException(exception)) {
                    UserExceptionTrace.log(exception);
                    bl3 = true;
                }
                object7 = WebServicesFault.makeFault(exception);
                if (!bl3) {
                    FFDCFilter.processException((Throwable)object7, (String)"com.ibm.ws.webservices.engine.transport.jms.JMSListenerMDB.onMessage", (String)"490", (Object)this);
                    Tr.error((TraceComponent)_tc, (String)"JMS.JMSError03", (Object)((Throwable)object7).toString());
                }
                if (queue != null) {
                    message3 = new Message(object7);
                    messageContext.setResponseMessage(message3);
                }
                if (queue == null && !bl3) {
                    throw new RuntimeException(((Throwable)object7).getMessage());
                }
            }
            finally {
                if (bl2) {
                    transactionSuspender.resumeTransaction();
                }
            }
            try {
                if (queue == null || (message3 = messageContext.getResponseMessage()) == null) break block57;
                object7 = this.getReplyQCF();
                object6 = object7.createQueueConnection();
                if (_tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)_tc, (String)"Created the queue connection.");
                }
                try {
                    block58: {
                        try {
                            object5 = object6.createQueueSession(false, 1);
                            if (_tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)_tc, (String)"Created the queue session.");
                            }
                            if (message.getJMSDestination() == null) {
                                try {
                                    if (queue instanceof MQDestination) {
                                        ((MQDestination)queue).setTargetClient(1);
                                    }
                                }
                                catch (NoClassDefFoundError noClassDefFoundError) {
                                    // empty catch block
                                }
                            }
                            object4 = object5.createSender(queue);
                            if (_tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)_tc, (String)"Created the queue sender.");
                            }
                            object3 = null;
                            object2 = message3.getContentType(messageContext.getSOAPConstants());
                            if (bl || message3.countAttachments() > 0) {
                                object3 = object5.createBytesMessage();
                                object = new ByteArrayOutputStream();
                                message3.writeTo((OutputStream)object, (String)object2);
                                message3.removeAllAttachments();
                                object3.writeBytes(((ByteArrayOutputStream)object).toByteArray());
                                if (MessageTrace.isTraceEnabled()) {
                                    MessageTrace.log(MessageTrace.OUTBOUND_JMS_RESPONSE, (String)object2, ((ByteArrayOutputStream)object).toByteArray());
                                }
                            } else {
                                object3 = object5.createTextMessage();
                                object = message3.getSOAPPartAsString();
                                ((TextMessage)object3).setText((String)object);
                                if (MessageTrace.isTraceEnabled()) {
                                    MessageTrace.log(MessageTrace.OUTBOUND_JMS_RESPONSE, (String)object2, (String)object);
                                }
                            }
                            object3.setStringProperty("contentType", (String)object2);
                            object3.setStringProperty("transportVersion", "1");
                            object3.setJMSCorrelationID(string);
                            if (_tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)_tc, (String)("About to send the following reply message:\n" + object3.toString() + " TimeToLive = " + l + " Priority = " + n + " DeliveryMode = " + n2));
                            }
                            object4.send((javax.jms.Message)object3, n2, n, l);
                            if (!_tc.isDebugEnabled()) break block58;
                            Tr.debug((TraceComponent)_tc, (String)"Sent the reply message.");
                        }
                        catch (Exception exception) {
                            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.webservices.engine.transport.jms.JMSListenerMDB.onMessage", (String)"653", (Object)this);
                            WebServicesFault webServicesFault = WebServicesFault.makeFault(exception);
                            Tr.error((TraceComponent)_tc, (String)"JMS.unexpected", (Object)((Throwable)webServicesFault).toString());
                            Object var24_32 = null;
                            object6.close();
                            if (_tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)_tc, (String)"Closed the queue connection.");
                            }
                            break block57;
                        }
                    }
                    Object var24_31 = null;
                }
                catch (Throwable throwable) {
                    Object var24_33 = null;
                    object6.close();
                    if (_tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)_tc, (String)"Closed the queue connection.");
                    }
                    throw throwable;
                }
                object6.close();
                if (_tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)_tc, (String)"Closed the queue connection.");
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.webservices.engine.transport.jms.JMSListenerMDB.onMessage", (String)"671", (Object)this);
                WebServicesFault webServicesFault = WebServicesFault.makeFault(exception);
                Tr.error((TraceComponent)_tc, (String)"JMS.unexpected", (Object)((Throwable)webServicesFault).toString());
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)_tc, (String)"onMessage");
        }
    }

    private void handleSoapAction(javax.jms.Message message, MessageContext messageContext) throws JMSException {
        String string = message.getStringProperty("soapAction");
        if (_tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)_tc, (String)("Retrieve soapAction property from JMS message: " + (string == null ? "<null>" : string)));
        }
        if (string == null || string.length() == 0) {
            messageContext.setUseSOAPAction(false);
            messageContext.setSOAPActionURI(null);
            if (_tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)_tc, (String)"Disabling soapAction on MessageContext...");
            }
        } else {
            messageContext.setUseSOAPAction(true);
            messageContext.setSOAPActionURI(string);
            if (_tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)_tc, (String)("Setting soapAction on MessageContext to: " + string));
            }
        }
    }

    public void ejbRemove() {
    }
}

