/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.transport.http;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.deploy.DeployUtils;
import com.ibm.ws.webservices.deploy.PublishWSDLInfo;
import com.ibm.ws.webservices.engine.ConfigurationException;
import com.ibm.ws.webservices.engine.Constants;
import com.ibm.ws.webservices.engine.EngineConfiguration;
import com.ibm.ws.webservices.engine.Message;
import com.ibm.ws.webservices.engine.MessageContext;
import com.ibm.ws.webservices.engine.SimpleTargetedChain;
import com.ibm.ws.webservices.engine.WebServicesEngine;
import com.ibm.ws.webservices.engine.WebServicesFault;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.configuration.EngineConfigurationFactoryFinder;
import com.ibm.ws.webservices.engine.handlers.soap.SOAPPort;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.engine.security.servlet.ServletSecurityProvider;
import com.ibm.ws.webservices.engine.server.ServerEngine;
import com.ibm.ws.webservices.engine.transport.http.HTTPConstants;
import com.ibm.ws.webservices.engine.transport.http.HTTPSender;
import com.ibm.ws.webservices.engine.transport.http.ServletEndpointContextImpl;
import com.ibm.ws.webservices.engine.transport.http.WebServicesHttpSession;
import com.ibm.ws.webservices.engine.transport.http.WebServicesServletBase;
import com.ibm.ws.webservices.engine.utils.JavaUtils;
import com.ibm.ws.webservices.engine.utils.QNameTable;
import com.ibm.ws.webservices.engine.utils.XMLUtils;
import com.ibm.ws.webservices.trace.MessageTrace;
import com.ibm.ws.webservices.trace.UserExceptionTrace;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.wsdl.WSDLException;
import javax.xml.soap.SOAPException;
import org.apache.commons.logging.Log;
import org.w3c.dom.Document;

public class WebServicesServlet
extends WebServicesServletBase
implements MessageContext.OneWayListener {
    protected static Log log = LogFactory.getLog(WebServicesServlet.class.getName());
    public static final String INIT_PROPERTY_TRANSPORT_NAME = "transport.name";
    public static final String INIT_PROPERTY_USE_SECURITY = "use-servlet-security";
    public static final String INIT_PROPERTY_JWS_CLASS_DIR = "webservices.jws.servletClassDir";
    public static final String DOUBLE_QUOTES = "\"";
    private static boolean isResponseCacheable = true;
    private String transportName;
    private ServletSecurityProvider securityProvider = null;
    private static boolean isDebug = false;
    private String jwsClassDir = null;

    protected String getJWSClassDir() {
        return this.jwsClassDir;
    }

    public static boolean getCacheableStatus() {
        return isResponseCacheable;
    }

    public void init() {
        super.init();
        ServletContext servletContext = this.getServletConfig().getServletContext();
        isDebug = log.isDebugEnabled();
        if (isDebug) {
            log.debug((Object)"In servlet init");
        }
        this.transportName = this.getOption(servletContext, INIT_PROPERTY_TRANSPORT_NAME, "http");
        if (JavaUtils.isTrueExplicitly(this.getOption(servletContext, INIT_PROPERTY_USE_SECURITY, null))) {
            this.securityProvider = new ServletSecurityProvider();
        }
        this.jwsClassDir = this.getOption(servletContext, INIT_PROPERTY_JWS_CLASS_DIR, null);
        if (this.jwsClassDir != null) {
            if (this.getHomeDir() != null) {
                this.jwsClassDir = this.getHomeDir() + this.jwsClassDir;
            }
        } else {
            this.jwsClassDir = this.getDefaultJWSClassDir();
        }
    }

    private void processWsdlRequest(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, PrintWriter printWriter, String string, boolean bl) throws WebServicesFault {
        block25: {
            String string2 = "INF" + File.separator + "wsdl" + File.separator;
            boolean bl2 = false;
            String string3 = httpServletRequest.getServletPath();
            String string4 = httpServletRequest.getPathInfo();
            try {
                SOAPPort sOAPPort = this.getEngine().getPort(string);
                if (sOAPPort != null) {
                    String string5 = "";
                    String string6 = sOAPPort.getPortDesc().getWSDLFile();
                    int n = string6.lastIndexOf(string2);
                    string5 = n > 0 ? string6.substring(n + string2.length()) : string6.substring(string6.lastIndexOf(File.separator) + 1);
                    try {
                        Object object;
                        if (string4 == null || string4.equals("") || string4.equals("/")) {
                            object = httpServletRequest.getRequestURL().toString();
                            if (!((String)object).endsWith("/")) {
                                object = (String)object + "/";
                            }
                            object = ((String)object).endsWith("wsdl/") || ((String)object).endsWith("extwsdl/") ? (String)object + string5 : (bl ? (String)object + "extwsdl/" : (String)object + "wsdl/") + string5;
                            httpServletResponse.sendRedirect((String)object);
                            string6 = null;
                        } else {
                            n = string6.lastIndexOf(string2);
                            string6 = n > 0 ? string6.substring(0, n + string2.length()) : string6.substring(0, string6.lastIndexOf(File.separator) + 1);
                            if (string4.startsWith("/")) {
                                string4 = string4.substring(1);
                            }
                            string6 = string6 + string4;
                        }
                        if (string6 == null) break block25;
                        string6 = string6.replace('\\', '/');
                        string6 = string6.replace('/', File.separatorChar);
                        object = null;
                        PublishWSDLInfo publishWSDLInfo = null;
                        try {
                            Map map = (Map)this.getEngine().getConfiguration().getGlobalOptions().get(DeployUtils.APPLICATION_MODULE_DATA);
                            String string7 = httpServletRequest.getContextPath();
                            if (string7 != null && string7.length() == 0) {
                                bl2 = true;
                            }
                            publishWSDLInfo = DeployUtils.getUpdatedWSDLFile(map, string6, httpServletRequest.getScheme(), httpServletRequest.getServerName(), Integer.toString(httpServletRequest.getServerPort()), string7, string, bl);
                            object = publishWSDLInfo.getWSDLDoc();
                        }
                        catch (WSDLException wSDLException) {
                            if (!bl2) {
                                FFDCFilter.processException((Throwable)wSDLException, (String)"com.ibm.ws.webservices.engine.transport.http.WebServicesServlet.processWsdlRequest", (String)"1:383:1.68", (Object)this);
                            }
                            if (isDebug) {
                                if (bl2) {
                                    log.debug((Object)"Context root is an empty string");
                                } else {
                                    log.debug((Object)"wsdl exception caught while getting wsdl", (Throwable)wSDLException);
                                }
                            }
                            try {
                                object = XMLUtils.newDocument(string6);
                            }
                            catch (Exception exception) {
                                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.webservices.engine.transport.http.WebServicesServlet.processWsdlRequest", (String)"1:375:1.55", (Object)this);
                            }
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                        if (object != null) {
                            if (!bl && publishWSDLInfo != null && publishWSDLInfo.hasService() && !publishWSDLInfo.hasSOAPPorts()) {
                                this.reportNoSOAPPorts(httpServletResponse, printWriter);
                                object = null;
                            } else {
                                httpServletResponse.setContentType("text/xml");
                                XMLUtils.DocumentToWriter((Document)object, printWriter);
                            }
                            break block25;
                        }
                        this.reportNoWSDL(httpServletResponse, printWriter);
                    }
                    catch (IOException iOException) {
                        FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.webservices.engine.transport.http.WebServicesServlet.processWsdlRequest", (String)"1:405:1.55", (Object)this);
                        log.error((Object)Messages.getMessage("exception00"), (Throwable)iOException);
                        try {
                            httpServletResponse.sendError(500);
                            break block25;
                        }
                        catch (IOException iOException2) {
                            FFDCFilter.processException((Throwable)iOException2, (String)"com.ibm.ws.webservices.engine.transport.http.WebServicesServlet.processWsdlRequest", (String)"1:415:1.55", (Object)this);
                            log.error((Object)Messages.getMessage("exception00"), (Throwable)iOException2);
                        }
                    }
                    break block25;
                }
                this.reportNoWSDL(httpServletResponse, printWriter);
            }
            catch (WebServicesFault webServicesFault) {
                FFDCFilter.processException((Throwable)webServicesFault, (String)"com.ibm.ws.webservices.engine.transport.http.WebServicesServlet.processWsdlRequest", (String)"1:428:1.55", (Object)this);
                if (webServicesFault.getFaultCode().equals(Constants.QNAME_NO_SERVICE_FAULT_CODE)) {
                    this.reportNoWSDL(httpServletResponse, printWriter);
                }
                throw webServicesFault;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        if (isDebug) {
            log.debug((Object)"Enter: doGet()");
        }
        PrintWriter printWriter = httpServletResponse.getWriter();
        try {
            ServerEngine serverEngine = this.getEngine();
            ServletContext servletContext = this.getServletConfig().getServletContext();
            String string = httpServletRequest.getPathInfo();
            String string2 = httpServletRequest.getServletPath();
            String string3 = servletContext.getRealPath(httpServletRequest.getServletPath());
            if (string3 == null) {
                string3 = string2;
            }
            boolean bl = false;
            boolean bl2 = false;
            if (httpServletRequest.getRequestURI().endsWith(".jws")) {
                string = httpServletRequest.getServletPath();
            }
            String string4 = httpServletRequest.getQueryString();
            String string5 = string2.substring(1);
            if (string4 != null) {
                if (string4.equalsIgnoreCase("wsdl")) {
                    bl = true;
                } else if (string4.equalsIgnoreCase("extwsdl")) {
                    bl2 = true;
                }
            } else if (string2.endsWith("/wsdl") || string2.endsWith("/wsdl/")) {
                bl = true;
                string5 = string5.substring(0, string5.lastIndexOf("/wsdl"));
            } else if (string2.endsWith("/extwsdl") || string2.endsWith("/extwsdl/")) {
                bl2 = true;
                string5 = string5.substring(0, string5.lastIndexOf("/extwsdl"));
            }
            if (bl || bl2) {
                this.processWsdlRequest(httpServletRequest, httpServletResponse, printWriter, string5, bl2);
            } else {
                this.reportAvailableServices(httpServletResponse, printWriter, httpServletRequest, string5);
            }
            Object var14_13 = null;
            printWriter.close();
            if (!isDebug) return;
        }
        catch (Throwable throwable) {
            Object var14_14 = null;
            printWriter.close();
            if (!isDebug) throw throwable;
            log.debug((Object)"Exit: doGet()");
            throw throwable;
        }
        log.debug((Object)"Exit: doGet()");
    }

    protected void reportNoWSDL(HttpServletResponse httpServletResponse, PrintWriter printWriter) {
        httpServletResponse.setStatus(404);
        httpServletResponse.setContentType("text/html");
        printWriter.println("<h2>" + Messages.getMessage("error00") + "</h2>");
        printWriter.println("<p>" + Messages.getMessage("noWSDL00") + "</p>");
    }

    protected void reportNoSOAPPorts(HttpServletResponse httpServletResponse, PrintWriter printWriter) {
        httpServletResponse.setStatus(200);
        httpServletResponse.setContentType("text/html");
        printWriter.println("<h2>" + Messages.getMessage("noSoapPorts00") + "</h2>");
    }

    protected void reportAvailableServices(HttpServletResponse httpServletResponse, PrintWriter printWriter, HttpServletRequest httpServletRequest, String string) throws ConfigurationException, WebServicesFault {
        ServerEngine serverEngine = this.getEngine();
        httpServletResponse.setContentType("text/html");
        SOAPPort sOAPPort = serverEngine.getPort(string);
        if (sOAPPort != null) {
            printWriter.println("<h2>" + sOAPPort.getPortDesc().getWSDLPort() + "</h2>");
            printWriter.println("<h3>" + Messages.getMessage("webServicesService00") + "</h3>");
        }
    }

    public void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        Object object;
        String string;
        Message message;
        MessageContext messageContext;
        block51: {
            String string2 = null;
            messageContext = null;
            if (isDebug) {
                log.debug((Object)"Enter: doPost()");
            }
            message = null;
            ServerEngine serverEngine = null;
            try {
                serverEngine = this.getEngine();
            }
            catch (WebServicesFault webServicesFault) {
                FFDCFilter.processException((Throwable)webServicesFault, (String)"com.ibm.ws.webservices.engine.transport.http.WebServicesServlet.doPost", (String)"1:608:1.55", (Object)this);
                ServletException servletException = new ServletException(Messages.getMessage("noEngine00"), (Throwable)webServicesFault);
                if (isDebug) {
                    log.debug((Object)"No Engine Found..possibly startup errors occurred!", (Throwable)webServicesFault);
                }
                throw servletException;
            }
            if (serverEngine == null) {
                ServletException servletException = new ServletException(Messages.getMessage("noEngine00"));
                if (isDebug) {
                    log.debug((Object)"No Engine Found!", (Throwable)servletException);
                }
                throw servletException;
            }
            try {
                httpServletResponse.setBufferSize(8192);
                messageContext = this.createMessageContext(serverEngine, httpServletRequest, httpServletResponse);
                if (this.securityProvider != null) {
                    if (isDebug) {
                        log.debug((Object)("securityProvider:" + this.securityProvider));
                    }
                    messageContext.setProperty("securityProvider", this.securityProvider);
                }
                if ((string = httpServletRequest.getRequestURL().toString()) != null && string.length() > 0) {
                    messageContext.setProperty("inbound.url", string);
                    if (isDebug) {
                        log.debug((Object)("Set inbound.url property on MessageContext to: " + string));
                    }
                }
                object = httpServletRequest.getInputStream();
                byte[] byArray = null;
                boolean bl = MessageTrace.isTraceEnabled();
                if (bl) {
                    byArray = this.extractRequestBytesForTrace(httpServletRequest, (InputStream)object);
                    object = new ByteArrayInputStream(byArray);
                }
                String string3 = httpServletRequest.getHeader("Content-Type");
                Message message2 = new Message(object, string3, httpServletRequest.getHeader("Content-Location"));
                message2.setCharacterEncoding(httpServletRequest.getCharacterEncoding());
                messageContext.setRequestMessage(message2);
                if (bl && byArray != null) {
                    MessageTrace.log(MessageTrace.INBOUND_HTTP_REQUEST, string3, byArray);
                }
                try {
                    string2 = this.getSoapAction(httpServletRequest);
                    if (string2 != null) {
                        messageContext.setUseSOAPAction(true);
                        messageContext.setSOAPActionURI(string2);
                    } else {
                        messageContext.setUseSOAPAction(false);
                        messageContext.setSOAPActionURI(string2);
                    }
                    messageContext.setSession(new WebServicesHttpSession(httpServletRequest));
                    if (isDebug) {
                        log.debug((Object)"Invoking WebServices Engine.");
                    }
                    serverEngine.invoke(messageContext);
                    if (isDebug) {
                        log.debug((Object)"Return from WebServices Engine.");
                    }
                    if ((message = messageContext.getResponseMessage()) != null) {
                        message.ifFaultThrowSelf();
                    }
                }
                catch (WebServicesFault webServicesFault) {
                    UserExceptionTrace.log(webServicesFault, "com.ibm.ws.webservices.engine.transport.http.WebServicesServlet.doPost", "713", this);
                    isResponseCacheable = false;
                    httpServletRequest.setAttribute("httpResponseIsCacheable", (Object)new Boolean(false));
                    int n = this.getHttpServletResponseStatus(webServicesFault);
                    if (n == 401) {
                        httpServletResponse.setHeader("WWW-Authenticate", "Basic realm=\"WebServices\"");
                    }
                    httpServletResponse.setStatus(n);
                    message = messageContext.getResponseMessage();
                    if (message == null) {
                        message = new Message(webServicesFault);
                        messageContext.setResponseMessage(message);
                    }
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.webservices.engine.transport.http.WebServicesServlet.doPost", (String)"1:753:1.55", (Object)this);
                    log.error((Object)Messages.getMessage("exception00"), (Throwable)exception);
                    if (exception instanceof IOException) {
                        ServletException servletException = new ServletException(Messages.getMessage("exception00"), (Throwable)exception);
                        throw servletException;
                    }
                    isResponseCacheable = false;
                    httpServletRequest.setAttribute("httpResponseIsCacheable", (Object)new Boolean(false));
                    httpServletResponse.setStatus(500);
                    message = messageContext.getResponseMessage();
                    if (message == null) {
                        message = new Message(WebServicesFault.makeFault(exception));
                        messageContext.setResponseMessage(message);
                    }
                }
            }
            catch (WebServicesFault webServicesFault) {
                FFDCFilter.processException((Throwable)webServicesFault, (String)"com.ibm.ws.webservices.engine.transport.http.WebServicesServlet.doPost", (String)"1:767:1.55", (Object)this);
                log.error((Object)Messages.getMessage("webServicesFault00"), (Throwable)webServicesFault);
                isResponseCacheable = false;
                httpServletRequest.setAttribute("httpResponseIsCacheable", (Object)new Boolean(false));
                message = messageContext.getResponseMessage();
                if (message != null) break block51;
                message = new Message(webServicesFault);
                messageContext.setResponseMessage(message);
            }
        }
        if (message != null) {
            if (messageContext.isOneWay()) {
                log.error((Object)Messages.getMessage("servlet.unexpected.oneway.response00"));
                if (isDebug) {
                    log.debug((Object)"No Response Sent");
                }
            } else {
                string = httpServletRequest.getHeader(HTTPConstants.HEADER_ACCEPT_ENCODING);
                if (isDebug) {
                    log.debug((Object)Messages.getMessage("acceptEncHdrFromHttpRequest", string));
                }
                if (JavaUtils.hasValue(string)) {
                    object = messageContext.getStrProp("com.ibm.websphere.webservices.http.responseContentEncoding");
                    if (!JavaUtils.hasValue((String)object)) {
                        object = System.getProperty("com.ibm.websphere.webservices.http.responseContentEncoding");
                    }
                    if (isDebug) {
                        log.debug((Object)("com.ibm.websphere.webservices.http.responseContentEncoding = " + (String)object));
                    }
                    if (JavaUtils.hasValue((String)object)) {
                        if (((String)object).equalsIgnoreCase(HTTPConstants.HEADER_C_ENC_GZIP)) {
                            httpServletResponse.setHeader(HTTPConstants.HEADER_CF_WSZIP, HTTPConstants.HEADER_C_ENC_GZIP);
                        } else if (((String)object).equalsIgnoreCase(HTTPConstants.HEADER_C_ENC_XGZIP)) {
                            httpServletResponse.setHeader(HTTPConstants.HEADER_CF_WSZIP, HTTPConstants.HEADER_C_ENC_XGZIP);
                        } else if (((String)object).equalsIgnoreCase(HTTPConstants.HEADER_C_ENC_DEFLATE)) {
                            httpServletResponse.setHeader(HTTPConstants.HEADER_CF_WSZIP, HTTPConstants.HEADER_C_ENC_DEFLATE);
                        } else if (isDebug) {
                            log.debug((Object)Messages.getMessage("noCompression"));
                        }
                    } else if (isDebug) {
                        log.debug((Object)Messages.getMessage("noCompression"));
                    }
                } else if (isDebug) {
                    log.debug((Object)Messages.getMessage("noCompression"));
                }
                this.sendResponse(this.getProtocolVersion(httpServletRequest), message.getContentType(messageContext.getSOAPConstants()), httpServletResponse, message);
                if (isDebug) {
                    log.debug((Object)"Response sent.");
                }
            }
        } else if (isDebug) {
            log.debug((Object)"No Response Sent");
        }
        if (messageContext.getRequestMessage() != null) {
            messageContext.getRequestMessage().removeAllAttachments();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Exit: doPost()");
        }
    }

    private byte[] extractRequestBytesForTrace(HttpServletRequest httpServletRequest, InputStream inputStream) throws IOException {
        String string;
        byte[] byArray = null;
        if (isDebug) {
            log.debug((Object)"Start copying HTTP request to trace buffer");
        }
        if ((string = httpServletRequest.getHeader("Content-Length")) != null) {
            int n = 0;
            try {
                n = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                FFDCFilter.processException((Throwable)numberFormatException, (String)"com.ibm.ws.webservices.engine.transport.http.WebServicesServlet.doPost", (String)"1:902:1.55", (Object)this);
                log.error((Object)Messages.getMessage("exception00"), (Throwable)numberFormatException);
                n = inputStream.available();
            }
            byArray = new byte[n];
            int n2 = n;
            int n3 = 0;
            while (n2 > 0) {
                int n4 = inputStream.read(byArray, n3, n2);
                if (isDebug) {
                    log.debug((Object)("Trace buffer needs " + n2 + " bytes at offset " + n3 + " got " + n4 + " bytes"));
                }
                if (n4 < 0) {
                    if (isDebug) {
                        log.debug((Object)("End of stream with " + n2 + " bytes still expected"));
                    }
                    n2 = 0;
                    continue;
                }
                n2 -= n4;
                n3 += n4;
            }
        } else {
            ArrayList<byte[]> arrayList = new ArrayList<byte[]>();
            ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
            int n = 0;
            int n5 = 0;
            while (n5 >= 0) {
                byte[] byArray2 = new byte[1024];
                n5 = inputStream.read(byArray2, 0, 1024);
                if (n5 < 0) continue;
                arrayList.add(byArray2);
                arrayList2.add(new Integer(n5));
                n += n5;
            }
            byArray = new byte[n];
            int n6 = 0;
            for (int i = 0; i < arrayList.size(); ++i) {
                byte[] byArray3 = (byte[])arrayList.get(i);
                int n7 = (Integer)arrayList2.get(i);
                System.arraycopy(byArray3, 0, byArray, n6, n7);
                n6 += n7;
            }
        }
        if (isDebug) {
            log.debug((Object)"Done copying HTTP request to trace buffer");
        }
        return byArray;
    }

    public void oneWay(MessageContext messageContext) {
        Object object;
        if (isDebug) {
            log.debug((Object)"Entry: oneWay()");
        }
        if ((object = messageContext.getProperty(HTTPConstants.MC_HTTP_SERVLETRESPONSE)) != null) {
            HttpServletResponse httpServletResponse = (HttpServletResponse)object;
            try {
                httpServletResponse.setContentLength(0);
                if (this.thisResponseShouldBeRedirected(messageContext)) {
                    if (isDebug) {
                        log.debug((Object)"Sending 202 back...");
                    }
                    httpServletResponse.setStatus(202);
                } else if (isDebug) {
                    log.debug((Object)"Oneway is back...");
                }
                httpServletResponse.flushBuffer();
            }
            catch (IOException iOException) {
                FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.webservices.engine.transport.http.WebServicesServlet.oneWay", (String)"1:995:1.55", (Object)this);
            }
        }
        if (isDebug) {
            log.debug((Object)"Exit: oneWay()");
        }
    }

    protected int getHttpServletResponseStatus(WebServicesFault webServicesFault) {
        return webServicesFault.getFaultCode().getLocalPart().startsWith("Server.Unauth") ? 401 : 500;
    }

    private void sendResponse(String string, String string2, HttpServletResponse httpServletResponse, Message message) throws WebServicesFault, IOException {
        if (message == null) {
            httpServletResponse.setStatus(204);
            if (isDebug) {
                log.debug((Object)"NO WEBSERVICES MESSAGE TO RETURN!");
            }
        } else {
            if (isDebug) {
                log.debug((Object)("Returned Content-Type:" + string2));
            }
            try {
                httpServletResponse.setContentType(string2);
                MessageContext messageContext = message.getMessageContext();
                if (this.thisResponseShouldBeRedirected(messageContext)) {
                    EngineConfiguration engineConfiguration = EngineConfigurationFactoryFinder.newFactory("NONE").getClientEngineConfig();
                    try {
                        SimpleTargetedChain simpleTargetedChain = (SimpleTargetedChain)engineConfiguration.getTransport(QNameTable.createQName(null, "http"));
                        HTTPSender hTTPSender = (HTTPSender)simpleTargetedChain.getPivotHandler();
                        MessageContext.setCurrentThreadsContext(messageContext);
                        hTTPSender.invoke(messageContext);
                    }
                    catch (Exception exception) {
                        FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.webservices.engine.transport.http.WebServicesServlet.sendResponse", (String)"1:1101:1.55", (Object)this);
                        log.error((Object)Messages.getMessage("exception00"), (Throwable)exception);
                        throw new SOAPException((Throwable)exception);
                    }
                } else {
                    message.writeTo((OutputStream)httpServletResponse.getOutputStream());
                    if (MessageTrace.isTraceEnabled()) {
                        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                        message.writeTo(byteArrayOutputStream);
                        byte[] byArray = byteArrayOutputStream.toByteArray();
                        MessageTrace.log(MessageTrace.OUTBOUND_HTTP_RESPONSE, string2, byArray);
                    }
                }
                message.removeAllAttachments();
            }
            catch (SOAPException sOAPException) {
                FFDCFilter.processException((Throwable)sOAPException, (String)"com.ibm.ws.webservices.engine.transport.http.WebServicesServlet.sendResponse", (String)"1:1128:1.55", (Object)this);
                log.error((Object)Messages.getMessage("exception00"), (Throwable)sOAPException);
            }
        }
    }

    private MessageContext createMessageContext(WebServicesEngine webServicesEngine, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        String string;
        MessageContext messageContext = new MessageContext(webServicesEngine);
        if (isDebug) {
            log.debug((Object)("MessageContext:" + messageContext));
            log.debug((Object)("HEADER_CONTENT_TYPE:" + httpServletRequest.getHeader("Content-Type")));
            log.debug((Object)("HEADER_CONTENT_LOCATION:" + httpServletRequest.getHeader("Content-Location")));
            log.debug((Object)("Constants.MC_HOME_DIR:" + String.valueOf(this.getHomeDir())));
            log.debug((Object)("Constants.MC_RELATIVE_PATH:" + httpServletRequest.getServletPath()));
            log.debug((Object)("HTTPConstants.MC_HTTP_SERVLETLOCATION:" + String.valueOf(this.getWebInfPath())));
            log.debug((Object)("HTTPConstants.MC_HTTP_SERVLETPATHINFO:" + httpServletRequest.getPathInfo()));
            log.debug((Object)("HTTPConstants.HEADER_AUTHORIZATION:" + httpServletRequest.getHeader("Authorization")));
            log.debug((Object)("Constants.MC_REMOTE_ADDR:" + httpServletRequest.getRemoteAddr()));
            log.debug((Object)("configPath:" + String.valueOf(this.getWebInfPath())));
        }
        if (this.transportName != null) {
            messageContext.setTransportName(this.transportName);
        }
        if (this.jwsClassDir != null) {
            messageContext.setProperty("jws.classDir", this.jwsClassDir);
        }
        if ((string = this.getHomeDir()) != null) {
            messageContext.setProperty("home.dir", string);
        }
        if ((string = httpServletRequest.getServletPath()) != null) {
            messageContext.setProperty("path", string);
        }
        messageContext.setProperty(HTTPConstants.MC_HTTP_SERVLET, this);
        messageContext.setProperty(HTTPConstants.MC_HTTP_SERVLETREQUEST, httpServletRequest);
        if (httpServletResponse != null) {
            messageContext.setProperty(HTTPConstants.MC_HTTP_SERVLETRESPONSE, httpServletResponse);
        }
        if ((string = this.getWebInfPath()) != null) {
            messageContext.setProperty(HTTPConstants.MC_HTTP_SERVLETLOCATION, string);
            messageContext.setProperty("configPath", string);
        }
        if ((string = httpServletRequest.getPathInfo()) != null) {
            messageContext.setProperty(HTTPConstants.MC_HTTP_SERVLETPATHINFO, string);
        }
        if ((string = httpServletRequest.getHeader("Authorization")) != null) {
            messageContext.setProperty("Authorization", string);
        }
        if ((string = httpServletRequest.getRemoteAddr()) != null) {
            messageContext.setProperty("remoteaddr", string);
        }
        ServletEndpointContextImpl servletEndpointContextImpl = ServletEndpointContextImpl.get();
        messageContext.setProperty("servletEndpointContext", servletEndpointContextImpl);
        String string2 = this.getServletConfig().getServletContext().getRealPath(httpServletRequest.getServletPath());
        if (string2 != null) {
            messageContext.setProperty("realpath", string2);
        }
        messageContext.addOneWayListener(this);
        return messageContext;
    }

    private String getSoapAction(HttpServletRequest httpServletRequest) throws WebServicesFault {
        String string = httpServletRequest.getHeader("SOAPAction");
        if (isDebug) {
            log.debug((Object)("HEADER_SOAP_ACTION:" + string));
        }
        if (string == null) {
            WebServicesFault webServicesFault = new WebServicesFault("Client.NoSOAPAction", Messages.getMessage("noHeader00", "SOAPAction"), null, null);
            log.error((Object)Messages.getMessage("genFault00"), (Throwable)webServicesFault);
            throw webServicesFault;
        }
        if (string.length() == 0) {
            string = null;
        } else if (string.length() > 1 && string.startsWith(DOUBLE_QUOTES) && string.endsWith(DOUBLE_QUOTES)) {
            string = string.substring(1, string.length() - 1);
        }
        return string;
    }

    protected String getDefaultJWSClassDir() {
        return this.getWebInfPath() == null ? null : this.getWebInfPath() + File.separator + "jwsClasses";
    }

    protected String getProtocolVersion(HttpServletRequest httpServletRequest) {
        String string;
        int n;
        String string2 = HTTPConstants.HEADER_PROTOCOL_V10;
        String string3 = httpServletRequest.getProtocol();
        if (string3 != null && -1 != (n = string3.indexOf(47)) && HTTPConstants.HEADER_PROTOCOL_V11.equals((string = string3.substring(n + 1)).trim())) {
            string2 = HTTPConstants.HEADER_PROTOCOL_V11;
        }
        return string2;
    }

    public void sendHTTPAccepted(MessageContext messageContext) {
        Object object;
        if (isDebug) {
            log.debug((Object)"Entry: sendHTTPAccepted()");
        }
        if ((object = messageContext.getProperty(HTTPConstants.MC_HTTP_SERVLETRESPONSE)) != null) {
            HttpServletResponse httpServletResponse = (HttpServletResponse)object;
            try {
                httpServletResponse.setContentLength(0);
                httpServletResponse.setStatus(202);
                httpServletResponse.flushBuffer();
            }
            catch (IOException iOException) {
                FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.webservices.engine.transport.http.WebServicesServlet.sendHTTPAccepted", (String)"1:1347:1.55", (Object)this);
            }
        }
        if (isDebug) {
            log.debug((Object)"Exit: sendHTTPAccepted()");
        }
    }

    public boolean thisResponseShouldBeRedirected(MessageContext messageContext) {
        Object object;
        if (log.isDebugEnabled()) {
            log.debug((Object)"Entry: thisResponseShouldBeRedirected()");
        }
        if (messageContext != null && (object = messageContext.getProperty("com.ibm.ws.wsaddressing.redirection.RedirectedResponseMessage")) != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Exit: thisResponseShouldBeRedirected() - true");
            }
            return true;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Exit: thisResponseShouldBeRedirected() - false");
        }
        return false;
    }
}

