/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.transport.http;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ws.webservices.engine.WebServicesFault;
import com.ibm.ws.webservices.engine.components.net.SSLConfiguration;
import com.ibm.ws.webservices.engine.components.net.TransportClientProperties;
import com.ibm.ws.webservices.engine.components.net.TransportClientPropertiesFactory;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.engine.transport.channel.WSAddress;
import com.ibm.ws.webservices.engine.transport.channel.WSChannelManager;
import com.ibm.ws.webservices.engine.utils.JavaUtils;
import com.ibm.ws.webservices.engine.utils.XMLUtils;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashMap;
import java.util.StringTokenizer;

public class HttpChannelAddress
extends WSAddress {
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.webservices.resources.webservicesMessages");
    private static final TraceComponent _tc = Tr.register((Class)HttpChannelAddress.class, (String)"WebServices", (String)"com.ibm.ws.webservices.resources.webservicesMessages");
    private InetSocketAddress isAddr = null;
    private String targetEndpoint = null;
    private String targetURIPath = null;
    private String targetHost = null;
    private int targetPort = -1;
    private TransportClientProperties _tcp = null;
    private boolean forProxy = false;
    private URI _uri = null;
    private static final String PROXY_AUTH_INFO = "PROXY_TARGET_USER_PASS";
    private static final String PROXY_HOST_INFO = "PROXY_TARGET_HOST_PORT";
    private static final int DEFAULT_HTTPS_PORT = 443;
    private static final String DEFAULT_HTTPS_PORT_STRING = "443";
    private static final int DEFAULT_HTTP_PORT = 80;
    private static final String DEFAULT_HTTP_PORT_STRING = "80";

    public HttpChannelAddress(URL uRL) throws URISyntaxException {
        if (uRL != null) {
            this.targetEndpoint = uRL.toString();
            URI uRI = new URI(this.targetEndpoint);
            this.targetURIPath = uRI.getPath();
            this.targetHost = uRL.getHost();
            this.targetPort = uRL.getPort();
            if (uRL.getProtocol().compareToIgnoreCase("https") == 0) {
                this.schemaType = 2;
                if (this.targetPort == -1) {
                    this.targetPort = 443;
                }
            } else if (uRL.getProtocol().compareToIgnoreCase("http") == 0) {
                this.schemaType = 1;
                if (this.targetPort == -1) {
                    this.targetPort = 80;
                }
            }
            this.isAddr = new InetSocketAddress(this.targetHost, this.targetPort);
            this._tcp = TransportClientPropertiesFactory.create(this.getSchemaInString());
        }
    }

    public HttpChannelAddress(URL uRL, TransportClientProperties transportClientProperties) throws URISyntaxException {
        if (uRL != null && transportClientProperties != null) {
            this.targetEndpoint = uRL.toString();
            this.targetHost = transportClientProperties.getProxyHost();
            this.targetPort = Integer.valueOf(transportClientProperties.getProxyPort());
            if (uRL.getProtocol().compareToIgnoreCase("https") == 0) {
                this.schemaType = 2;
                if (this.targetPort == -1) {
                    this.targetPort = 443;
                }
            } else if (uRL.getProtocol().compareToIgnoreCase("http") == 0) {
                this.schemaType = 1;
                if (this.targetPort == -1) {
                    this.targetPort = 80;
                }
            }
            this.isAddr = new InetSocketAddress(this.targetHost, this.targetPort);
            URI uRI = new URI(this.getSchemaInString() + "://" + this.targetHost + ":" + this.targetPort);
            this.targetURIPath = uRI.getPath();
            this._tcp = TransportClientPropertiesFactory.create(this.getSchemaInString());
        }
        this.forProxy = true;
    }

    public HashMap infoForTunneling() throws MalformedURLException {
        HashMap<String, byte[]> hashMap = null;
        if (this.forProxy && this._tcp != null) {
            String string = this._tcp.getProxyUser();
            String string2 = this._tcp.getProxyPassword();
            URL uRL = new URL(this.targetEndpoint);
            String string3 = uRL.getHost();
            String string4 = String.valueOf(uRL.getPort());
            if (JavaUtils.hasValue(string3) && JavaUtils.hasValue(string4)) {
                hashMap = new HashMap<String, byte[]>();
                if (Integer.valueOf(string4) == -1 && this.schemaType == 1) {
                    string4 = DEFAULT_HTTP_PORT_STRING;
                }
                if (Integer.valueOf(string4) == -1 && this.schemaType == 2) {
                    string4 = DEFAULT_HTTPS_PORT_STRING;
                }
                hashMap.put(PROXY_HOST_INFO, (string3 + ":" + string4).getBytes());
                if (JavaUtils.hasValue(string) && JavaUtils.hasValue(string2)) {
                    hashMap.put(PROXY_AUTH_INFO, XMLUtils.base64encode((string + ":" + string2).getBytes()).getBytes());
                }
            }
            if (_tc.isEventEnabled()) {
                String string5 = this.schemaType == 1 ? "httpProxyConfiguration00" : "httpsProxyConfiguration00";
                Tr.event((TraceComponent)_tc, (String)Messages.getMessage(string5, this.targetHost, String.valueOf(this.targetPort), string, JavaUtils.hasValue(string2) ? "******" : ""));
                if (_tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)_tc, (String)("Target endpoint host: " + string3 + ", Target endpoint port: " + string4));
                }
            }
        }
        return hashMap;
    }

    public boolean isForwardProxy() {
        return this.schemaType == 1 ? this.isProxy() : false;
    }

    public boolean isProxy() {
        return this.forProxy;
    }

    public String keyValueforPool(String string) {
        if (this.keyforPool == null) {
            if (this.getSchema() == 2) {
                SSLConfiguration sSLConfiguration = new SSLConfiguration(1 == WSChannelManager.getInstance().getRuntime());
                this.keyforPool = string + ":" + this.getHostname() + ":" + this.getPort() + ":" + sSLConfiguration.getIdentityKey();
            } else {
                this.keyforPool = string + ":" + this.getHostname() + ":" + this.getPort();
            }
        }
        return this.isInProcess() ? this.keyforPool + ":" + "LOCAL" : this.keyforPool;
    }

    public InetSocketAddress getLocalAddress() {
        return null;
    }

    public InetSocketAddress getRemoteAddress() {
        return this.isAddr;
    }

    public String getHostname() {
        return this.targetHost;
    }

    public URI getURI() throws URISyntaxException {
        if (this._uri == null && JavaUtils.hasValue(this.targetEndpoint)) {
            this._uri = new URI(this.targetEndpoint);
        }
        return this._uri;
    }

    public String getURIPath() throws URISyntaxException {
        if (this.targetURIPath == null && this.getURI() != null) {
            this.targetURIPath = this.getURI().getPath();
        }
        return this.targetURIPath;
    }

    public int getPort() {
        return this.targetPort;
    }

    public String toString() {
        if (this.forProxy) {
            return this.getSchemaInString() + "://" + this.getHostname() + ":" + String.valueOf(this.getPort());
        }
        return this.targetEndpoint;
    }

    public String getTargetURL() {
        return this.targetEndpoint;
    }

    public void updateTargetURL(String string) {
        this.targetEndpoint = string;
    }

    public void setConnectTimeout(int n) {
        this.connTimeout = n;
    }

    public TransportClientProperties getTCproperties() {
        return this._tcp;
    }

    public static WSAddress getProxyAddress(URL uRL, TransportClientProperties transportClientProperties) throws MalformedURLException, URISyntaxException, WebServicesFault {
        HttpChannelAddress httpChannelAddress = null;
        if (HttpChannelAddress.hostIsInNonProxyList(uRL.getHost(), transportClientProperties.getNonProxyHosts())) {
            return httpChannelAddress;
        }
        if (uRL.getProtocol().equalsIgnoreCase("https")) {
            if (JavaUtils.hasValue(transportClientProperties.getProxyHost()) && JavaUtils.hasValue(transportClientProperties.getProxyPort())) {
                httpChannelAddress = new HttpChannelAddress(uRL, transportClientProperties);
            }
        } else if (uRL.getProtocol().equalsIgnoreCase("http")) {
            if (JavaUtils.hasValue(transportClientProperties.getProxyHost()) && JavaUtils.hasValue(transportClientProperties.getProxyPort())) {
                httpChannelAddress = new HttpChannelAddress(uRL, transportClientProperties);
            }
        } else {
            throw new WebServicesFault(Messages.getMessage("httpUnsupportedSchema", uRL.getProtocol()));
        }
        return httpChannelAddress;
    }

    private static boolean hostIsInNonProxyList(String string, String string2) {
        if (string2 == null || string == null) {
            return false;
        }
        if (_tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)_tc, (String)("http.nonProxyHosts: " + string2));
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string2, "|\"");
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            if (!HttpChannelAddress.match(string3, string, false)) continue;
            if (_tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)_tc, (String)Messages.getMessage("match00", new String[]{"HttpChannelAddress", string, string3}));
            }
            return true;
        }
        return false;
    }

    private static boolean match(String string, String string2, boolean bl) {
        char c;
        int n;
        char[] cArray = string.toCharArray();
        char[] cArray2 = string2.toCharArray();
        int n2 = 0;
        int n3 = cArray.length - 1;
        int n4 = 0;
        int n5 = cArray2.length - 1;
        boolean bl2 = false;
        for (n = 0; n < cArray.length; ++n) {
            if (cArray[n] != '*') continue;
            bl2 = true;
            break;
        }
        if (!bl2) {
            if (n3 != n5) {
                return false;
            }
            for (n = 0; n <= n3; ++n) {
                char c2 = cArray[n];
                if (bl && c2 != cArray2[n]) {
                    return false;
                }
                if (bl || Character.toUpperCase(c2) == Character.toUpperCase(cArray2[n])) continue;
                return false;
            }
            return true;
        }
        if (n3 == 0) {
            return true;
        }
        while ((c = cArray[n2]) != '*' && n4 <= n5) {
            if (bl && c != cArray2[n4]) {
                return false;
            }
            if (!bl && Character.toUpperCase(c) != Character.toUpperCase(cArray2[n4])) {
                return false;
            }
            ++n2;
            ++n4;
        }
        if (n4 > n5) {
            for (n = n2; n <= n3; ++n) {
                if (cArray[n] == '*') continue;
                return false;
            }
            return true;
        }
        while ((c = cArray[n3]) != '*' && n4 <= n5) {
            if (bl && c != cArray2[n5]) {
                return false;
            }
            if (!bl && Character.toUpperCase(c) != Character.toUpperCase(cArray2[n5])) {
                return false;
            }
            --n3;
            --n5;
        }
        if (n4 > n5) {
            for (n = n2; n <= n3; ++n) {
                if (cArray[n] == '*') continue;
                return false;
            }
            return true;
        }
        while (n2 != n3 && n4 <= n5) {
            int n6;
            n = -1;
            for (n6 = n2 + 1; n6 <= n3; ++n6) {
                if (cArray[n6] != '*') continue;
                n = n6;
                break;
            }
            if (n == n2 + 1) {
                ++n2;
                continue;
            }
            n6 = n - n2 - 1;
            int n7 = n5 - n4 + 1;
            int n8 = -1;
            block8: for (int i = 0; i <= n7 - n6; ++i) {
                for (int j = 0; j < n6; ++j) {
                    c = cArray[n2 + j + 1];
                    if (bl && c != cArray2[n4 + i + j] || !bl && Character.toUpperCase(c) != Character.toUpperCase(cArray2[n4 + i + j])) continue block8;
                }
                n8 = n4 + i;
                break;
            }
            if (n8 == -1) {
                return false;
            }
            n2 = n;
            n4 = n8 + n6;
        }
        for (n = n2; n <= n3; ++n) {
            if (cArray[n] == '*') continue;
            return false;
        }
        return true;
    }
}

