/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.transport.http;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.webservices.engine.Message;
import com.ibm.ws.webservices.engine.MessageContext;
import com.ibm.ws.webservices.engine.WebServicesFault;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.components.net.DefaultHTTPTransportClientProperties;
import com.ibm.ws.webservices.engine.components.net.TransportClientProperties;
import com.ibm.ws.webservices.engine.components.net.TransportClientPropertiesFactory;
import com.ibm.ws.webservices.engine.handlers.BasicHandler;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.engine.transport.channel.OutboundConnectionCache;
import com.ibm.ws.webservices.engine.transport.channel.OutboundOutputStream;
import com.ibm.ws.webservices.engine.transport.channel.WSAddress;
import com.ibm.ws.webservices.engine.transport.channel.WSCFEndPointCriteriaImpl;
import com.ibm.ws.webservices.engine.transport.channel.WSChannelManager;
import com.ibm.ws.webservices.engine.transport.channel.WSOutboundConnection;
import com.ibm.ws.webservices.engine.transport.http.HTTPConstants;
import com.ibm.ws.webservices.engine.transport.http.HttpChannelAddress;
import com.ibm.ws.webservices.engine.transport.http.HttpOutboundChannelConnection;
import com.ibm.ws.webservices.engine.transport.security.SecurityDataPrompt;
import com.ibm.ws.webservices.engine.transport.security.SecurityDataPromptFactory;
import com.ibm.ws.webservices.engine.utils.ClassUtils;
import com.ibm.ws.webservices.engine.utils.JavaUtils;
import com.ibm.ws.webservices.trace.MessageTrace;
import com.ibm.wsspi.channel.framework.CFEndPoint;
import com.ibm.wsspi.cluster.Identity;
import com.ibm.wsspi.http.channel.HttpConstants;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Hashtable;
import java.util.Properties;
import org.apache.commons.logging.Log;

public class HTTPSender
extends BasicHandler {
    protected static Log log = LogFactory.getLog(HTTPSender.class.getName());
    private static boolean HttpRedirectEnabledSysProp = Boolean.getBoolean("com.ibm.ws.webservices.HttpRedirectEnabled");
    private static String IN_PROCESS_ENABLED = null;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void invoke(MessageContext messageContext) throws WebServicesFault {
        if (log.isDebugEnabled()) {
            log.debug((Object)Messages.getMessage("enter00", "HTTPSender::invoke"));
        }
        WSOutboundConnection wSOutboundConnection = null;
        OutboundConnectionCache outboundConnectionCache = (OutboundConnectionCache)AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction(){

            public Object run() {
                return OutboundConnectionCache.getInstance();
            }
        });
        WSChannelManager wSChannelManager = WSChannelManager.getInstance();
        Object object = null;
        try {
            try {
                String string;
                Object object2;
                Object object3;
                Object object4;
                Object object5;
                block63: {
                    block61: {
                        Identity identity;
                        block62: {
                            WSCFEndPointCriteriaImpl wSCFEndPointCriteriaImpl;
                            URL uRL;
                            block60: {
                                block59: {
                                    block56: {
                                        uRL = messageContext.getTargetEndpointAddressAsURL();
                                        wSCFEndPointCriteriaImpl = null;
                                        wSCFEndPointCriteriaImpl = uRL.getProtocol().equalsIgnoreCase("http") ? new WSCFEndPointCriteriaImpl(1, uRL.getHost()) : new WSCFEndPointCriteriaImpl(2, uRL.getHost());
                                        if (log.isDebugEnabled()) {
                                            log.debug((Object)("javax.xml.rpc.service.endpoint.address: " + uRL.toString()));
                                        }
                                        object = WSAddress.getAddress(uRL);
                                        identity = wSChannelManager.clusterIdenFromEPR();
                                        if (identity != null) break block59;
                                        if (log.isDebugEnabled()) {
                                            log.debug((Object)Messages.getMessage("clusterFromWsAddr", String.valueOf(identity)));
                                        }
                                        if ((object = HttpChannelAddress.getProxyAddress(uRL, (TransportClientProperties)(object5 = TransportClientPropertiesFactory.create(uRL.getProtocol())))) == null) {
                                            object = WSAddress.getAddress(uRL);
                                        } else if (log.isDebugEnabled()) {
                                            log.debug((Object)Messages.getMessage("targetAddress01", object.toString()));
                                        }
                                        if (wSChannelManager.getRuntime() == 3) break block60;
                                        try {
                                            if (IN_PROCESS_ENABLED == null) {
                                                if (log.isDebugEnabled()) {
                                                    log.debug((Object)Messages.getMessage("j2wLoadClass00", "com.ibm.wsspi.webcontainer.WebContainer"));
                                                }
                                                if ((object4 = ClassUtils.forName("com.ibm.wsspi.webcontainer.WebContainer")) != null) {
                                                    if (log.isDebugEnabled()) {
                                                        log.debug((Object)Messages.getMessage("invokeMethod00", "getWebContainerProperties", "com.ibm.wsspi.webcontainer.WebContainer"));
                                                    }
                                                    if ((object3 = (Properties)((Method)(object2 = ((Class)object4).getMethod("getWebContainerProperties", null))).invoke(null, null)) != null) {
                                                        IN_PROCESS_ENABLED = ((Properties)object3).getProperty("enableinprocessconnections");
                                                    }
                                                }
                                            }
                                            if (log.isDebugEnabled()) {
                                                log.debug((Object)("enableInProcessConnections : " + IN_PROCESS_ENABLED));
                                            }
                                            if (IN_PROCESS_ENABLED == null) {
                                                IN_PROCESS_ENABLED = "null";
                                            }
                                        }
                                        catch (Exception exception) {
                                            if (IN_PROCESS_ENABLED == null) {
                                                IN_PROCESS_ENABLED = "null";
                                            }
                                            if (!log.isDebugEnabled()) break block56;
                                            log.debug((Object)(exception.toString() + " is caught. Failed to read WebContainer properties. Proceed with HTTP in-process connection disabled."));
                                        }
                                    }
                                    if (IN_PROCESS_ENABLED != null && IN_PROCESS_ENABLED.equalsIgnoreCase("true") && wSChannelManager.isWLMable()) {
                                        identity = wSChannelManager.clusterIdenFromDWLMClient((WSAddress)object, wSCFEndPointCriteriaImpl);
                                        if (log.isDebugEnabled()) {
                                            log.debug((Object)Messages.getMessage("clusterFromRequestMapper", String.valueOf(identity), object.toString()));
                                        }
                                    }
                                    break block60;
                                }
                                if (log.isDebugEnabled()) {
                                    log.debug((Object)Messages.getMessage("clusterFromWsAddr", String.valueOf(identity)));
                                }
                            }
                            if (identity == null) break block61;
                            object5 = null;
                            object5 = wSChannelManager.identityToCFEndPoint(identity, wSCFEndPointCriteriaImpl);
                            if (object5 == null) break block62;
                            object4 = uRL.getProtocol() + "://" + object5.getAddress().getHostName() + ":" + object5.getPort() + uRL.getFile();
                            object = WSAddress.getAddress(new URL((String)object4));
                            ((WSAddress)object).setCFEndPoint((CFEndPoint)object5);
                            if (object5.isLocal()) {
                                if (log.isDebugEnabled()) {
                                    log.debug((Object)Messages.getMessage("usedHttpChannelType", "In-process"));
                                }
                                break block63;
                            } else if (log.isDebugEnabled()) {
                                log.debug((Object)Messages.getMessage("usedHttpChannelType", "Network"));
                            }
                            break block63;
                        }
                        if (log.isDebugEnabled()) {
                            log.debug((Object)Messages.getMessage("cannotConvertCFEndPt", String.valueOf(identity)));
                        }
                        break block63;
                    }
                    if (log.isDebugEnabled()) {
                        log.debug((Object)Messages.getMessage("usedHttpChannelType", "Network"));
                    }
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)Messages.getMessage("targetAddress00", object.toString()));
                }
                object5 = MessageContext.getCurrentThreadsContext();
                object4 = ((MessageContext)object5).getRequestMessage();
                object2 = ((Message)object4).getContentType(((MessageContext)object5).getSOAPConstants());
                if (log.isDebugEnabled()) {
                    log.debug((Object)("HTTP Content-Type: " + (String)object2));
                }
                object3 = new OutboundOutputStream((String)object2);
                ((Message)object4).writeTo((OutputStream)object3);
                ((Message)object4).removeAllAttachments();
                int n = 0;
                Integer n2 = null;
                String string2 = null;
                boolean bl = false;
                while (!bl) {
                    boolean bl2;
                    wSOutboundConnection = ((WSAddress)object).getSchema() == 2 ? outboundConnectionCache.findGroupAndGetConnection("httpclient-https-chain", (WSAddress)object) : outboundConnectionCache.findGroupAndGetConnection("httpclient-http-chain", (WSAddress)object);
                    try {
                        if (wSOutboundConnection == null) throw new WebServicesFault("No WSOutboundConnection object returned from outbound connection pool.");
                        if (MessageTrace.isTraceEnabled() && object2 != null && object3 != null) {
                            MessageTrace.log(MessageTrace.OUTBOUND_HTTP_REQUEST, (String)object2, ((OutboundOutputStream)object3).toByteArray());
                        }
                        wSOutboundConnection.connect();
                        wSOutboundConnection.sendSOAPRequest((OutboundOutputStream)object3);
                    }
                    catch (SocketTimeoutException socketTimeoutException) {
                        FFDCFilter.processException((Throwable)socketTimeoutException, (String)"com.ibm.ws.webservices.engine.transport.http.HTTPSender.invoke", (String)"421", (Object)this);
                        TransportClientProperties transportClientProperties = TransportClientPropertiesFactory.create(((WSAddress)object).getSchemaInString());
                        bl2 = false;
                        bl2 = ((DefaultHTTPTransportClientProperties)transportClientProperties).isResendEnabled();
                        if (!wSOutboundConnection.hasbeenUsed()) throw WebServicesFault.makeFault(socketTimeoutException);
                        if (wSOutboundConnection.isMessageSent()) throw WebServicesFault.makeFault(socketTimeoutException);
                        if (bl2) throw WebServicesFault.makeFault(socketTimeoutException);
                        if (log.isDebugEnabled()) {
                            log.debug((Object)"SOAP message has not been sent and messageResend is disabled. Use another connection object.");
                        }
                        wSOutboundConnection.disconnect(socketTimeoutException);
                        outboundConnectionCache.findGroupAndReturnConnection(wSOutboundConnection);
                        continue;
                    }
                    catch (SocketException socketException) {
                        FFDCFilter.processException((Throwable)socketException, (String)"com.ibm.ws.webservices.engine.transport.http.HTTPSender.invoke", (String)"450", (Object)this);
                        TransportClientProperties transportClientProperties = TransportClientPropertiesFactory.create(((WSAddress)object).getSchemaInString());
                        bl2 = false;
                        bl2 = ((DefaultHTTPTransportClientProperties)transportClientProperties).isResendEnabled();
                        if (!wSOutboundConnection.hasbeenUsed()) throw WebServicesFault.makeFault(socketException);
                        if (wSOutboundConnection.isMessageSent()) throw WebServicesFault.makeFault(socketException);
                        if (bl2) throw WebServicesFault.makeFault(socketException);
                        if (log.isDebugEnabled()) {
                            log.debug((Object)"SOAP message has not been sent and messageResend is disabled. Use another connection object.");
                        }
                        wSOutboundConnection.disconnect(socketException);
                        outboundConnectionCache.findGroupAndReturnConnection(wSOutboundConnection);
                        continue;
                    }
                    wSOutboundConnection.receiveSOAPResponse();
                    n2 = (Integer)messageContext.getProperty(HTTPConstants.MC_HTTP_STATUS_CODE);
                    string2 = messageContext.getStrProp(HTTPConstants.MC_HTTP_STATUS_MESSAGE);
                    if (n2 != null) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)Messages.getMessage("httpStatusInResponse00", n2.toString(), string2));
                        }
                        if ((n = n2.intValue()) == HttpConstants.STATUS_FOUND.getIntCode()) {
                            if (!HTTPSender.isHttpRedirectEnabled()) {
                                bl = true;
                                throw new WebServicesFault(Messages.getMessage("http302StatusCode", object.toString()));
                            }
                            string2 = messageContext.getStrProp(MessageContext.TRANS_URL_HTTP_REDIRECTED);
                            if (JavaUtils.hasValue(string2)) {
                                object = WSAddress.getAddress(new URL(string2));
                                if (log.isDebugEnabled()) {
                                    log.debug((Object)Messages.getMessage("http302StatusCode", object.toString()));
                                }
                                wSOutboundConnection.disconnect(null);
                                outboundConnectionCache.findGroupAndReturnConnection(wSOutboundConnection);
                                wSOutboundConnection = null;
                            }
                            messageContext.removeProperty(MessageContext.TRANS_URL_HTTP_REDIRECTED);
                            continue;
                        }
                        if (n == HttpConstants.STATUS_UNAUTHORIZED.getIntCode()) {
                            if (wSChannelManager.getRuntime() != 1) {
                                string = messageContext.getStrProp("WWW-Authenticate");
                                boolean bl3 = (Boolean)messageContext.getProperty("com.ibm.ws.webservices.spnegoUsed");
                                if (bl3 && string != null && string.indexOf("Negotiate") == 0) {
                                    log.debug((Object)("WWW-Authenticate: " + string));
                                    bl = true;
                                    continue;
                                }
                                if (this.receivedHTTPBasicAuth()) {
                                    log.debug((Object)Messages.getMessage("challengeStatus01"));
                                    wSOutboundConnection.reset();
                                    outboundConnectionCache.findGroupAndReturnConnection(wSOutboundConnection);
                                    wSOutboundConnection = null;
                                    continue;
                                }
                                log.debug((Object)Messages.getMessage("challengeStatus02"));
                                bl = true;
                                continue;
                            }
                            bl = true;
                            continue;
                        }
                        bl = true;
                        continue;
                    }
                    bl = true;
                }
                if (n == 0) throw new WebServicesFault(Messages.getMessage("httpStatusInResponse01"));
                string = ((HttpOutboundChannelConnection)wSOutboundConnection).getHeaderFromResponse(HttpConstants.HDR_CONTENT_TYPE);
                this.processStatusCode(n, string, (WSAddress)object);
                Object var21_26 = null;
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.webservices.engine.transport.http.HTTPSender.invoke", (String)"575", (Object)this);
                if (log.isDebugEnabled()) {
                    log.debug((Object)Messages.getMessage("exception01", exception.toString()));
                    if (JavaUtils.hasValue(object.toString())) {
                        log.debug((Object)("URL = " + object.toString()));
                    } else {
                        log.debug((Object)("URL = " + messageContext.getTargetEndpointAddress()));
                    }
                }
                if (wSOutboundConnection == null) throw WebServicesFault.makeFault(exception);
                wSOutboundConnection.disconnect(exception);
                throw WebServicesFault.makeFault(exception);
            }
        }
        catch (Throwable throwable) {
            Object var21_27 = null;
            try {
                if (wSOutboundConnection != null) {
                    wSOutboundConnection.reset();
                    outboundConnectionCache.findGroupAndReturnConnection(wSOutboundConnection);
                    wSOutboundConnection = null;
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.webservices.engine.transport.http.HTTPSender.invoke", (String)"605", (Object)this);
                if (!log.isDebugEnabled()) throw WebServicesFault.makeFault(exception);
                log.debug((Object)Messages.getMessage("exception01", exception.toString()));
                throw WebServicesFault.makeFault(exception);
            }
            if (!log.isDebugEnabled()) throw throwable;
            log.debug((Object)Messages.getMessage("exit00", "HTTPSender::invoke"));
            throw throwable;
        }
        try {}
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.webservices.engine.transport.http.HTTPSender.invoke", (String)"605", (Object)this);
            if (!log.isDebugEnabled()) throw WebServicesFault.makeFault(exception);
            log.debug((Object)Messages.getMessage("exception01", exception.toString()));
            throw WebServicesFault.makeFault(exception);
        }
        if (wSOutboundConnection != null) {
            wSOutboundConnection.reset();
            outboundConnectionCache.findGroupAndReturnConnection(wSOutboundConnection);
            wSOutboundConnection = null;
        }
        if (!log.isDebugEnabled()) return;
        log.debug((Object)Messages.getMessage("exit00", "HTTPSender::invoke"));
    }

    private void processStatusCode(int n, String string, WSAddress wSAddress) throws WebServicesFault {
        if (log.isDebugEnabled()) {
            log.debug((Object)Messages.getMessage("enter00", "HTTPSender::processStatusCode"));
        }
        MessageContext messageContext = MessageContext.getCurrentThreadsContext();
        String string2 = string = null == string ? null : string.trim();
        if (!(n > 199 && n < 300 || string != null && !string.startsWith("text/html") && n > 499 && n < 600)) {
            String string3 = messageContext.getStrProp(HTTPConstants.MC_HTTP_STATUS_MESSAGE);
            String string4 = wSAddress.getSchemaInString().toLowerCase() + "://" + wSAddress.getHostname() + ":" + wSAddress.getPort();
            WebServicesFault webServicesFault = new WebServicesFault("HTTP", "( " + n + " ) " + string3, string4, null);
            String string5 = messageContext.getResponseMessage() == null ? "" : messageContext.getResponseMessage().getSOAPPartAsString();
            webServicesFault.setFaultDetailString(Messages.getMessage("return01", "( " + n + " ) " + string3, string5));
            throw webServicesFault;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)Messages.getMessage("exit00", "HTTPSender::processStatusCode"));
        }
    }

    public String getCookieFromHeaders(String string, String string2, Hashtable hashtable) {
        if (log.isDebugEnabled()) {
            log.debug((Object)Messages.getMessage("enter00", "HTTPSender::getCookieFromHeaders"));
        }
        String string3 = null;
        if (hashtable.containsKey(string2.toLowerCase())) {
            string3 = (String)hashtable.get(string2.toLowerCase());
            int n = (string3 = string3.trim()).indexOf(59);
            if (n != -1) {
                string3 = string3.substring(0, n);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)Messages.getMessage("exit00", "HTTPSender::getCookieFromHeaders"));
        }
        return string3;
    }

    public static boolean isHttpRedirectEnabled() {
        MessageContext messageContext = MessageContext.getCurrentThreadsContext();
        Boolean bl = (Boolean)messageContext.getProperty("http.redirect.enabled");
        if (bl == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("com.ibm.ws.webservices.HttpRedirectEnabled: " + bl));
            }
            return HttpRedirectEnabledSysProp;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("http.redirect.enabled: " + bl));
        }
        return bl;
    }

    private boolean receivedHTTPBasicAuth() {
        MessageContext messageContext;
        boolean bl;
        block10: {
            if (log.isDebugEnabled()) {
                log.debug((Object)Messages.getMessage("enter00", "HTTPSender::receiveHTTPBasicAuth"));
            }
            bl = false;
            messageContext = MessageContext.getCurrentThreadsContext();
            if (!JavaUtils.hasValue(messageContext.getUsername()) && !JavaUtils.hasValue(messageContext.getPassword())) {
                String string = System.getProperty("com.ibm.ws.webservices.loginSource");
                if (log.isDebugEnabled()) {
                    log.debug((Object)("com.ibm.ws.webservices.loginSource: " + string));
                }
                try {
                    if (!JavaUtils.hasValue(string) || "prompt".compareToIgnoreCase(string) != 0 && "stdin".compareToIgnoreCase(string) != 0) break block10;
                    SecurityDataPrompt securityDataPrompt = SecurityDataPromptFactory.getPrompt(string);
                    String[] stringArray = null;
                    try {
                        final String string2 = messageContext.getStrProp("WWW-Authenticate");
                        final SecurityDataPrompt securityDataPrompt2 = securityDataPrompt;
                        if (log.isDebugEnabled()) {
                            log.debug((Object)Messages.getMessage("challengeRealmInfo", string2));
                        }
                        stringArray = (String[])AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                            public Object run() throws Exception {
                                return securityDataPrompt2.launch(string2 == null ? "" : string2);
                            }
                        });
                    }
                    catch (PrivilegedActionException privilegedActionException) {
                        FFDCFilter.processException((Throwable)privilegedActionException, (String)"com.ibm.ws.webservices.engine.transport.http.HTTPSender.receivedHTTPBasicAuth", (String)"788", (Object)this);
                        log.debug((Object)privilegedActionException);
                        throw privilegedActionException.getException();
                    }
                    if (stringArray != null && JavaUtils.hasValue(stringArray[0]) && JavaUtils.hasValue(stringArray[1])) {
                        messageContext.setUsername(stringArray[0]);
                        messageContext.setPassword(stringArray[1]);
                        bl = true;
                    }
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.webservices.engine.transport.http.HTTPSender.receivedHTTPBasicAuth", (String)"803", (Object)this);
                    if (!log.isDebugEnabled()) break block10;
                    log.debug((Object)Messages.getMessage("exception01", exception.toString()));
                }
            }
        }
        messageContext.removeProperty("WWW-Authenticate");
        if (log.isDebugEnabled()) {
            log.debug((Object)Messages.getMessage("exit00", "HTTPSender::receiveHTTPBasicAuth"));
        }
        return bl;
    }
}

