/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.transport.channel;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ws.webservices.engine.WebServicesFault;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.engine.transport.channel.WSAddress;
import com.ibm.ws.webservices.engine.transport.channel.WSChannelManager;
import com.ibm.ws.webservices.engine.transport.channel.WSOutboundConnection;
import com.ibm.wsspi.channel.framework.VirtualConnectionFactory;
import com.ibm.wsspi.channel.framework.exception.ChainException;
import com.ibm.wsspi.channel.framework.exception.ChannelException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;

public class OutboundConnectionGroup {
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.webservices.resources.webservicesMessages");
    private static final TraceComponent _tc = Tr.register((Class)OutboundConnectionGroup.class, (String)"WebServices", (String)"com.ibm.ws.webservices.resources.webservicesMessages");
    private static final Boolean USED = Boolean.TRUE;
    private static final Boolean NOT_USED = Boolean.FALSE;
    private static float ldFactor = 0.75f;
    private static int initSize = 131;
    private static WSChannelManager wMgr = null;
    private VirtualConnectionFactory vcf = null;
    private long idleTime = Long.getLong("com.ibm.websphere.webservices.http.connectionIdleTimeout", 5L) * 1000L;
    private HashMap thePool = new HashMap(initSize, ldFactor);
    private Vector Cleanup = new Vector();

    public OutboundConnectionGroup() {
        wMgr = WSChannelManager.getInstance();
    }

    public WSOutboundConnection createConnection(String string, WSAddress wSAddress) throws WebServicesFault, Exception {
        if (_tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)_tc, (String)"OutboundConnectionGroup.createConnection()");
        }
        WSOutboundConnection wSOutboundConnection = null;
        String string2 = wSAddress.keyValueforPool(string);
        if (this.vcf == null) {
            this.vcf = wMgr.getVCFactory(string2, wSAddress);
        }
        wSOutboundConnection = wMgr.getWSOutboundConnection(string2, wSAddress, this.vcf);
        this.thePool.put(wSOutboundConnection, USED);
        if (_tc.isEventEnabled()) {
            Tr.event((TraceComponent)_tc, (String)Messages.getMessage("createdOCobject", wSOutboundConnection.toString(), String.valueOf(this.vcf)));
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)_tc, (String)"OutboundConnectionGroup.createConnection()");
        }
        return wSOutboundConnection;
    }

    protected WSOutboundConnection getConnection(String string, WSAddress wSAddress) throws WebServicesFault, InterruptedException, Exception {
        if (_tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)_tc, (String)"OutboundConnectionGroup.getConnection()");
        }
        WSOutboundConnection wSOutboundConnection = null;
        boolean bl = false;
        if (_tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)_tc, (String)("com.ibm.websphere.webservices.http.connectionIdleTimeout: " + this.idleTime + " ms."));
        }
        if (this.thePool.size() > 0) {
            Iterator iterator = this.thePool.keySet().iterator();
            while (iterator.hasNext()) {
                wSOutboundConnection = (WSOutboundConnection)iterator.next();
                long l = wSOutboundConnection.timeFromLastAccess();
                boolean bl2 = (Boolean)this.thePool.get(wSOutboundConnection);
                if (l >= this.idleTime) {
                    if (!bl2) {
                        this.Cleanup.add(wSOutboundConnection);
                        iterator.remove();
                        wSOutboundConnection.release(null);
                        if (_tc.isEventEnabled()) {
                            Tr.event((TraceComponent)_tc, (String)Messages.getMessage("expiredOCobject", wSOutboundConnection.toString(), String.valueOf(l)));
                        }
                        bl = true;
                    }
                } else if (!bl2) break;
                wSOutboundConnection = null;
            }
            if (wSOutboundConnection != null) {
                wSOutboundConnection.updateEndpoint(wSAddress);
                this.thePool.put(wSOutboundConnection, USED);
                if (_tc.isEventEnabled()) {
                    Tr.event((TraceComponent)_tc, (String)Messages.getMessage("existedOCobject", wSOutboundConnection.toString()));
                }
            }
        }
        if (bl && wSOutboundConnection == null) {
            wSOutboundConnection = this.createConnection(string, wSAddress);
            if (_tc.isEventEnabled()) {
                Tr.event((TraceComponent)_tc, (String)"Found expired object, and now create a new one.");
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)_tc, (String)"OutboundConnectionGroup.getConnection()");
        }
        return wSOutboundConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void returnConnection(WSOutboundConnection wSOutboundConnection) {
        if (_tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)_tc, (String)"OutboundConnectionGroup.returnConnection()");
        }
        if (wSOutboundConnection.isClosed()) {
            this.thePool.remove(wSOutboundConnection);
        } else {
            this.thePool.put(wSOutboundConnection, NOT_USED);
        }
        if (wSOutboundConnection.isClosed()) {
            if (_tc.isEventEnabled()) {
                Tr.event((TraceComponent)_tc, (String)Messages.getMessage("returnClosedOCobject", wSOutboundConnection.toString()));
            }
            wSOutboundConnection.release(null);
            Vector vector = this.Cleanup;
            synchronized (vector) {
                this.Cleanup.add(wSOutboundConnection);
            }
        } else if (_tc.isEventEnabled()) {
            Tr.event((TraceComponent)_tc, (String)Messages.getMessage("returnValidOCobject", wSOutboundConnection.toString()));
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)_tc, (String)"OutboundConnectionGroup.returnConnection()");
        }
    }

    protected boolean isEmpty() {
        return this.thePool.isEmpty() && this.Cleanup.isEmpty();
    }

    protected int currPoolSize() {
        return this.thePool.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanup() throws ChannelException, ChainException {
        if (_tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)_tc, (String)"cleanup()");
        }
        WSOutboundConnection wSOutboundConnection = null;
        Vector vector = this.Cleanup;
        synchronized (vector) {
            Iterator iterator = this.Cleanup.iterator();
            while (iterator.hasNext()) {
                wSOutboundConnection = (WSOutboundConnection)iterator.next();
                wSOutboundConnection.release(null);
                if (!_tc.isEventEnabled()) continue;
                Tr.event((TraceComponent)_tc, (String)Messages.getMessage("removeOCobject", wSOutboundConnection.toString()));
            }
            this.Cleanup.clear();
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)_tc, (String)"cleanup()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() throws ChannelException, ChainException {
        if (_tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)_tc, (String)"release()");
        }
        if (this.vcf != null) {
            VirtualConnectionFactory virtualConnectionFactory = this.vcf;
            synchronized (virtualConnectionFactory) {
                if (this.vcf != null) {
                    this.vcf.destroy();
                    if (_tc.isEventEnabled()) {
                        Tr.event((TraceComponent)_tc, (String)Messages.getMessage("objectReleased", String.valueOf(this.vcf)));
                    }
                    this.vcf = null;
                }
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)_tc, (String)"release()");
        }
    }

    public int totalInUse() {
        int n = 0;
        if (_tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)_tc, (String)"totalInUse()");
        }
        Iterator iterator = this.thePool.values().iterator();
        while (iterator.hasNext()) {
            if (!((Boolean)iterator.next()).booleanValue()) continue;
            ++n;
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)_tc, (String)"totalInUse()");
        }
        return n;
    }

    public boolean findUnused() {
        boolean bl = false;
        WSOutboundConnection wSOutboundConnection = null;
        if (this.thePool.size() > 1) {
            Iterator iterator = this.thePool.keySet().iterator();
            while (iterator.hasNext()) {
                wSOutboundConnection = (WSOutboundConnection)iterator.next();
                boolean bl2 = (Boolean)this.thePool.get(wSOutboundConnection);
                if (bl2) continue;
                this.Cleanup.add(wSOutboundConnection);
                iterator.remove();
                wSOutboundConnection.release(null);
                bl = true;
                break;
            }
        }
        return bl;
    }
}

