/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.handlers;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.engine.Message;
import com.ibm.ws.webservices.engine.MessageContext;
import com.ibm.ws.webservices.engine.WebServicesFault;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.handlers.BasicHandler;
import com.ibm.ws.webservices.engine.resources.Messages;
import java.io.FileWriter;
import java.io.PrintWriter;
import org.apache.commons.logging.Log;

public class LogHandler
extends BasicHandler {
    protected static Log log = LogFactory.getLog(LogHandler.class.getName());
    long start = 0L;

    public void invoke(MessageContext messageContext) throws WebServicesFault {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Enter: LogHandler::invoke");
        }
        if (!messageContext.getPastPivot()) {
            this.start = System.currentTimeMillis();
        } else {
            try {
                FileWriter fileWriter = new FileWriter("webservices.handler.log", true);
                PrintWriter printWriter = new PrintWriter(fileWriter);
                Message message = messageContext.getRequestMessage();
                Message message2 = messageContext.getResponseMessage();
                printWriter.println("=======================================================");
                printWriter.println("= " + Messages.getMessage("elapsed00", "" + (System.currentTimeMillis() - this.start)));
                printWriter.println("= " + Messages.getMessage("inMsg00", message == null ? "null" : message.getSOAPPartAsString()));
                printWriter.println("= " + Messages.getMessage("outMsg00", message2 == null ? "null" : message2.getSOAPPartAsString()));
                printWriter.println("=======================================================");
                printWriter.close();
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.webservices.engine.handlers.LogHandler.invoke", (String)"103", (Object)this);
                log.error((Object)Messages.getMessage("exception00"), (Throwable)exception);
                throw WebServicesFault.makeFault(exception);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Exit: LogHandler::invoke");
        }
    }

    public void onFault(MessageContext messageContext) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Enter: LogHandler::onFault");
        }
        try {
            FileWriter fileWriter = new FileWriter("webservices.handler.log", true);
            PrintWriter printWriter = new PrintWriter(fileWriter);
            printWriter.println("=====================");
            printWriter.println("= " + Messages.getMessage("fault00"));
            printWriter.println("=====================");
            printWriter.close();
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.webservices.engine.handlers.LogHandler.onFault", (String)"121", (Object)this);
            log.error((Object)Messages.getMessage("exception00"), (Throwable)exception);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Exit: LogHandler::onFault");
        }
    }
}

