/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.encoding.ser;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.engine.Constants;
import com.ibm.ws.webservices.engine.encoding.DeserializationContext;
import com.ibm.ws.webservices.engine.encoding.ser.SimpleDeserializer;
import com.ibm.ws.webservices.engine.events.DEventProcessor;
import com.ibm.ws.webservices.engine.utils.MappingScope;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPElement;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPFactory;
import java.io.InputStream;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPException;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class SOAPElementDeserializer
extends SimpleDeserializer {
    protected SOAPElement myElement = null;
    protected SOAPElement myChildElement = null;

    public SOAPElementDeserializer(Class clazz, QName qName) {
        super(clazz, qName);
    }

    public void setMyElement(SOAPElement sOAPElement) {
        this.myElement = sOAPElement;
    }

    public void onStartElement(String string, String string2, String string3, Attributes attributes, MappingScope mappingScope, DeserializationContext deserializationContext) throws SAXException {
        try {
            InputStream inputStream;
            SOAPFactory sOAPFactory = null;
            if (this.myElement == null) {
                sOAPFactory = new SOAPFactory(deserializationContext.getMessageContext().getSOAPConstants());
                mappingScope = mappingScope.flatten();
                this.myElement = sOAPFactory.createSOAPElement(string, string2, string3, attributes, mappingScope, deserializationContext, this.myElement);
            }
            if (!deserializationContext.isSimpleEventEnabled() && (inputStream = deserializationContext.getLazyParse()) != null) {
                this.myElement.setAlternateContent(inputStream);
            }
        }
        catch (SOAPException sOAPException) {
            FFDCFilter.processException((Throwable)sOAPException, (String)"com.ibm.ws.webservices.engine.encoding.ser.SOAPElementDeserializer.onStartElement", (String)"80", (Object)this);
            throw new SAXException((Exception)((Object)sOAPException));
        }
    }

    public DEventProcessor onStartChild(String string, String string2, String string3, Attributes attributes, MappingScope mappingScope, DeserializationContext deserializationContext) throws SAXException {
        try {
            SOAPElementDeserializer sOAPElementDeserializer = new SOAPElementDeserializer(SOAPElement.class, Constants.WEBSERVICES_SOAPELEMENT);
            SOAPFactory sOAPFactory = this.myElement.getSOAPFactory();
            this.myChildElement = sOAPFactory.createSOAPElement(string, string2, string3, attributes, mappingScope, deserializationContext, this.myElement);
            sOAPElementDeserializer.setMyElement(this.myChildElement);
            return sOAPElementDeserializer;
        }
        catch (SOAPException sOAPException) {
            FFDCFilter.processException((Throwable)sOAPException, (String)"com.ibm.ws.webservices.engine.encoding.ser.SOAPElementDeserializer.onStartChild", (String)"107", (Object)this);
            throw new SAXException((Exception)((Object)sOAPException));
        }
    }

    public void onEndElement(String string, String string2, DeserializationContext deserializationContext) throws SAXException {
        this.value = this.myElement;
        super.onEndElement(string, string2, deserializationContext);
    }

    public void characters(String string) throws SAXException {
        if (this.myElement != null) {
            try {
                this.myElement.addTextNode(string);
            }
            catch (SOAPException sOAPException) {
                FFDCFilter.processException((Throwable)sOAPException, (String)"com.ibm.ws.webservices.engine.encoding.ser.SOAPElementDeserializer.characters", (String)"122", (Object)this);
                throw new SAXException((Exception)((Object)sOAPException));
            }
        }
    }

    public void comment(char[] cArray, int n, int n2) throws SAXException {
        String string = new String(cArray, n, n2);
        if (this.myElement != null) {
            try {
                this.myElement.addComment(string);
            }
            catch (SOAPException sOAPException) {
                FFDCFilter.processException((Throwable)sOAPException, (String)"com.ibm.ws.webservices.engine.encoding.ser.SOAPElementDeserializer.comment", (String)"166", (Object)this);
                throw new SAXException((Exception)((Object)sOAPException));
            }
        }
    }

    protected Object makeValue(String string) throws Exception {
        return this.myElement;
    }

    public boolean recycle() {
        boolean bl = super.recycle();
        if (bl) {
            this.myElement = null;
            this.myChildElement = null;
        }
        return bl;
    }
}

