/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.encoding.ser;

import com.ibm.ws.webservices.engine.Constants;
import com.ibm.ws.webservices.engine.MessageContext;
import com.ibm.ws.webservices.engine.Part;
import com.ibm.ws.webservices.engine.attachments.Attachments;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.description.OperationDesc;
import com.ibm.ws.webservices.engine.description.ParameterDesc;
import com.ibm.ws.webservices.engine.encoding.SerializationContext;
import com.ibm.ws.webservices.engine.encoding.Serializer;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.engine.utils.MCUtils;
import com.ibm.ws.webservices.engine.xmlsoap.ext.ParamValue;
import com.ibm.ws.webservices.engine.xmlsoap.ext.RequestResponse;
import java.io.IOException;
import java.util.Vector;
import javax.activation.DataHandler;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPElement;
import org.apache.commons.logging.Log;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.AttributesImpl;

public class JAFDataHandlerSerializer
implements Serializer {
    protected static Log log = LogFactory.getLog(JAFDataHandlerSerializer.class.getName());
    protected QName xmlType;
    protected Class javaType;

    public JAFDataHandlerSerializer(Class clazz, QName qName) {
        this.xmlType = qName;
        this.javaType = clazz;
    }

    public void serialize(QName qName, Attributes attributes, Object object, SerializationContext serializationContext) throws IOException {
        DataHandler dataHandler = (DataHandler)object;
        Attachments attachments = serializationContext.getCurrentMessage().getAttachmentsImpl();
        if (attachments == null) {
            throw new IOException(Messages.getMessage("noAttachments"));
        }
        Part part = attachments.createAttachmentPart(dataHandler, qName.getLocalPart());
        if (this.isSwaRefOrAXISAttachment(qName, serializationContext)) {
            serializationContext.getSerializationWriter().simpleElement(qName, attributes, part.getContentIdRef());
        } else {
            boolean bl;
            String string = (String)serializationContext.getMessageContext().getProperty("com.ibm.ws.webservices.engine.attachment.style");
            boolean bl2 = bl = string != null && string.equals("HREF");
            if (!bl && Constants.MIME_DATA_HANDLER.equals(this.xmlType)) {
                bl = MCUtils.isPropertyEnabled(serializationContext.getMessageContext(), "com.ibm.websphere.webservices.serializeDataHandlerAxisStyle");
                if (log.isDebugEnabled()) {
                    log.debug((Object)MCUtils.getSettingMsg("com.ibm.websphere.webservices.serializeDataHandlerAxisStyle", bl));
                }
            }
            if (bl) {
                AttributesImpl attributesImpl = new AttributesImpl();
                if (attributes != null && 0 < attributes.getLength()) {
                    attributesImpl.setAttributes(attributes);
                }
                int n = -1;
                n = attributesImpl.getIndex("http://www.w3.org/2001/XMLSchema-instance", "type");
                if (n != -1) {
                    attributesImpl.removeAttribute(n);
                }
                attributesImpl.addAttribute("", "href", "href", "CDATA", part.getContentIdRef());
                serializationContext.getSerializationWriter().simpleElement(qName, attributesImpl, null);
            }
        }
    }

    public void serialize(QName qName, Attributes attributes, Object object, SerializationContext serializationContext, RequestResponse requestResponse) throws IOException {
        Object object2;
        Object object3;
        DataHandler dataHandler = (DataHandler)object;
        Attachments attachments = serializationContext.getCurrentMessage().getAttachmentsImpl();
        if (attachments == null) {
            throw new IOException(Messages.getMessage("noAttachments"));
        }
        String string = null;
        try {
            Vector vector = requestResponse.getParams();
            object3 = (ParamValue)vector.elementAt(0);
            String string2 = ((ParamValue)object3).getName();
            object2 = ((ParamValue)object3).getValue();
            if (object2 instanceof SOAPElement && string2.equals("body")) {
                String string3 = ((SOAPElement)object2).getFirstChild().getFirstChild().getNodeValue();
                int n = string3.indexOf(":");
                string = string3.substring(n + 1);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        object3 = attachments.createAttachmentPart(dataHandler, qName.getLocalPart(), string);
        if (this.isSwaRefOrAXISAttachment(qName, serializationContext)) {
            serializationContext.getSerializationWriter().simpleElement(qName, attributes, object3.getContentIdRef());
        } else {
            boolean bl;
            object2 = (String)serializationContext.getMessageContext().getProperty("com.ibm.ws.webservices.engine.attachment.style");
            boolean bl2 = bl = object2 != null && ((String)object2).equals("HREF");
            if (!bl && Constants.MIME_DATA_HANDLER.equals(this.xmlType)) {
                bl = MCUtils.isPropertyEnabled(serializationContext.getMessageContext(), "com.ibm.websphere.webservices.serializeDataHandlerAxisStyle");
                if (log.isDebugEnabled()) {
                    log.debug((Object)MCUtils.getSettingMsg("com.ibm.websphere.webservices.serializeDataHandlerAxisStyle", bl));
                }
            }
            if (bl) {
                AttributesImpl attributesImpl = new AttributesImpl();
                if (attributes != null && 0 < attributes.getLength()) {
                    attributesImpl.setAttributes(attributes);
                }
                int n = -1;
                n = attributesImpl.getIndex("http://www.w3.org/2001/XMLSchema-instance", "type");
                if (n != -1) {
                    attributesImpl.removeAttribute(n);
                }
                attributesImpl.addAttribute("", "href", "href", "CDATA", object3.getContentIdRef());
                serializationContext.getSerializationWriter().simpleElement(qName, attributesImpl, null);
            }
        }
    }

    private boolean isSwaRefOrAXISAttachment(QName qName, SerializationContext serializationContext) {
        OperationDesc operationDesc;
        MessageContext messageContext;
        if (Constants.WSI_SWAREF.equals(this.xmlType)) {
            return true;
        }
        if ("http://xml.apache.org/xml-soap".equals(this.xmlType.getNamespaceURI()) && serializationContext != null && (messageContext = serializationContext.getMessageContext()) != null && (operationDesc = messageContext.getOperation()) != null) {
            ParameterDesc parameterDesc = operationDesc.getParamByQName(qName);
            if (parameterDesc == null && (parameterDesc = operationDesc.getReturnParamDesc()) != null && !parameterDesc.getQName().equals(qName)) {
                parameterDesc = null;
            }
            if (parameterDesc != null) {
                return !parameterDesc.isWSDL11MIME();
            }
        }
        return false;
    }

    public String getMechanismType() {
        return "WebServices SAX Mechanism";
    }

    public String getBuildNumber() {
        return null;
    }
}

