/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.encoding.ser;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.engine.Constants;
import com.ibm.ws.webservices.engine.encoding.ser.SimpleDeserializer;
import com.ibm.ws.webservices.engine.resources.Messages;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import javax.xml.namespace.QName;

public class CalendarDeserializer
extends SimpleDeserializer {
    private static final SimpleDateFormat zuluDateTime = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.000'Z'");
    private static final SimpleDateFormat zuluDateTime2 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
    private static final SimpleDateFormat zuluDate = new SimpleDateFormat("yyyy-MM-dd");
    private static final SimpleDateFormat zuluTime = new SimpleDateFormat("HH:mm:ss.SSS'Z'");
    private static final SimpleDateFormat zuluTime2 = new SimpleDateFormat("HH:mm:ss");
    private QName componentTypeQName;

    public CalendarDeserializer(Class clazz, QName qName, QName qName2, QName qName3) {
        super(clazz, qName);
        this.componentTypeQName = qName3 == null ? qName : qName3;
    }

    public Object makeValue(String string) {
        if (Constants.equals(Constants.XSD_DATE, this.componentTypeQName)) {
            return CalendarDeserializer.makeDateValue(string);
        }
        if (Constants.equals(Constants.XSD_TIME, this.componentTypeQName)) {
            return CalendarDeserializer.makeTimeValue(string);
        }
        return CalendarDeserializer.makeDateTimeValue(string);
    }

    public static synchronized Object makeDateTimeValue(String string) {
        boolean bl = false;
        if (string == "") {
            throw new NumberFormatException(Messages.getMessage("badDateTime01"));
        }
        if (string != null) {
            if (string.charAt(0) == '+') {
                string = string.substring(1);
            }
            if (string.charAt(0) == '-') {
                string = string.substring(1);
                bl = true;
            }
        }
        CalendarDeserializer.validateDateTime(string);
        Calendar calendar = CalendarDeserializer.makeCalendar(string, 19, zuluDateTime, zuluDateTime2);
        if (bl) {
            calendar.set(0, 0);
        }
        return calendar;
    }

    public static synchronized Object makeTimeValue(String string) {
        CalendarDeserializer.validateTime(string);
        Calendar calendar = CalendarDeserializer.makeCalendar(string, 8, zuluTime, zuluTime2);
        calendar.set(0, 0, 0);
        return calendar;
    }

    public static synchronized Object makeDateValue(String string) {
        Date date;
        Calendar calendar = Calendar.getInstance();
        boolean bl = false;
        if (string == "") {
            throw new NumberFormatException(Messages.getMessage("badDate01"));
        }
        if (string != null) {
            if (string.charAt(0) == '+') {
                string = string.substring(1);
            }
            if (string.charAt(0) == '-') {
                string = string.substring(1);
                bl = true;
            }
            if (string.length() < 10) {
                throw new NumberFormatException(Messages.getMessage("badDate00", string));
            }
            if (string.charAt(4) != '-' || string.charAt(7) != '-') {
                throw new NumberFormatException(Messages.getMessage("badDate00", string));
            }
        }
        try {
            date = zuluDate.parse(string == null ? null : string.substring(0, 10));
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.webservices.engine.encoding.ser.CalendarDeserializer.makeDateValue", (String)"214");
            throw new NumberFormatException(exception.toString());
        }
        calendar.setTime(date);
        if (bl) {
            calendar.set(0, 0);
        }
        return calendar;
    }

    private static void validateTime(String string) {
        if (string != null) {
            if (string == "") {
                throw new NumberFormatException(Messages.getMessage("badTime01"));
            }
            if (string.charAt(2) != ':' || string.charAt(5) != ':') {
                throw new NumberFormatException(Messages.getMessage("badTime00", string));
            }
            if (string.length() < 8) {
                throw new NumberFormatException(Messages.getMessage("badTime00", string));
            }
        }
    }

    private static void validateDateTime(String string) {
        if (string.length() < 19) {
            throw new NumberFormatException(Messages.getMessage("badDateTime00", string));
        }
        if (string.charAt(4) != '-' || string.charAt(7) != '-' || string.charAt(10) != 'T') {
            throw new NumberFormatException(Messages.getMessage("badDate00", string));
        }
        if (string.charAt(13) != ':' || string.charAt(16) != ':') {
            throw new NumberFormatException(Messages.getMessage("badTime00", string));
        }
    }

    private static Calendar makeCalendar(String string, int n, SimpleDateFormat simpleDateFormat, SimpleDateFormat simpleDateFormat2) {
        Calendar calendar = Calendar.getInstance();
        Date date = null;
        boolean bl = false;
        boolean bl2 = false;
        int n2 = 0;
        int n3 = 0;
        int n4 = n;
        if (string != null) {
            int n5;
            if (n4 < string.length() && string.charAt(n4) == '.') {
                n5 = ++n4;
                while (n4 < string.length() && Character.isDigit(string.charAt(n4))) {
                    ++n4;
                }
                String string2 = string.substring(n5, n4);
                if (string2.length() == 3) {
                    n2 = Integer.parseInt(string2);
                } else if (string2.length() < 3) {
                    n2 = Integer.parseInt((string2 + "000").substring(0, 3));
                } else {
                    n2 = Integer.parseInt(string2.substring(0, 3));
                    if (string2.charAt(3) >= '5') {
                        ++n2;
                    }
                }
            }
            if (n4 + 5 < string.length() && (string.charAt(n4) == '+' || string.charAt(n4) == '-')) {
                if (!(Character.isDigit(string.charAt(n4 + 1)) && Character.isDigit(string.charAt(n4 + 2)) && string.charAt(n4 + 3) == ':' && Character.isDigit(string.charAt(n4 + 4)) && Character.isDigit(string.charAt(n4 + 5)))) {
                    throw new NumberFormatException(Messages.getMessage("badTimezone00", string));
                }
                n5 = (string.charAt(n4 + 1) - 48) * 10 + string.charAt(n4 + 2) - 48;
                int n6 = (string.charAt(n4 + 4) - 48) * 10 + string.charAt(n4 + 5) - 48;
                n3 = (n5 * 60 + n6) * 60 * 1000;
                if (string.charAt(n4) == '+') {
                    n3 = -n3;
                }
                n4 += 6;
                bl = true;
            }
            if (n4 < string.length() && string.charAt(n4) == 'Z') {
                ++n4;
                calendar.setTimeZone(TimeZone.getTimeZone("GMT"));
                bl2 = true;
            }
            if (bl || bl2) {
                try {
                    date = simpleDateFormat.parse(string == null ? null : string.substring(0, n) + ".000Z");
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.webservices.engine.encoding.ser.CalendarDeserializer.makeCalendar", (String)"345");
                    throw new NumberFormatException(exception.toString());
                }
            }
            if (!bl) {
                try {
                    date = simpleDateFormat2.parse(string == null ? null : string.substring(0, n));
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.webservices.engine.encoding.ser.CalendarDeserializer.makeCalendar", (String)"355");
                    throw new NumberFormatException(exception.toString());
                }
            }
            if (date != null) {
                date.setTime(date.getTime() + (long)n2);
                date.setTime(date.getTime() + (long)n3);
            }
            if (n4 < string.length()) {
                throw new NumberFormatException(Messages.getMessage("badChars00", string));
            }
        }
        calendar.setTime(date);
        return calendar;
    }

    static {
        zuluDateTime.setTimeZone(TimeZone.getTimeZone("GMT"));
        zuluDateTime2.setTimeZone(TimeZone.getDefault());
        zuluTime.setTimeZone(TimeZone.getTimeZone("GMT"));
        zuluTime2.setTimeZone(TimeZone.getDefault());
    }
}

