/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.encoding.ser;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.engine.Constants;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.description.TypeDesc;
import com.ibm.ws.webservices.engine.encoding.SerializationContext;
import com.ibm.ws.webservices.engine.encoding.SerializationContextImpl;
import com.ibm.ws.webservices.engine.encoding.Serializer;
import com.ibm.ws.webservices.engine.encoding.utils.BeanDesc;
import com.ibm.ws.webservices.engine.encoding.utils.FieldDesc;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.engine.utils.BeanPropertyDescriptor;
import com.ibm.ws.webservices.engine.utils.BeanUtils;
import com.ibm.ws.webservices.engine.utils.JavaUtils;
import com.ibm.ws.webservices.engine.utils.QNameTable;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPElement;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.util.Calendar;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.AttributesImpl;

public class BeanSerializer
implements Serializer,
Serializable {
    protected static Log log = LogFactory.getLog(BeanSerializer.class.getName());
    QName xmlType;
    Class javaType;
    protected BeanPropertyDescriptor[] propertyDescriptor = null;
    protected BeanDesc beanDesc = null;

    public BeanSerializer(Class clazz, QName qName) {
        this(clazz, qName, BeanDesc.getBeanDescForClass(clazz));
    }

    public BeanSerializer(Class clazz, QName qName, TypeDesc typeDesc) {
        this(clazz, qName, null, null);
    }

    public BeanSerializer(Class clazz, QName qName, BeanDesc beanDesc) {
        this(clazz, qName, beanDesc, null);
        this.propertyDescriptor = beanDesc != null ? beanDesc.getPropertyDescriptors() : BeanUtils.getPd(clazz, null);
    }

    public BeanSerializer(Class clazz, QName qName, BeanDesc beanDesc, BeanPropertyDescriptor[] beanPropertyDescriptorArray) {
        this.xmlType = qName;
        this.javaType = clazz;
        this.beanDesc = beanDesc;
        this.propertyDescriptor = beanPropertyDescriptorArray;
    }

    void setup(BeanDesc beanDesc, BeanPropertyDescriptor[] beanPropertyDescriptorArray) {
        this.beanDesc = beanDesc;
        this.propertyDescriptor = beanPropertyDescriptorArray;
    }

    public void serialize(QName qName, Attributes attributes, Object object, SerializationContext serializationContext) throws IOException {
        boolean bl;
        Attributes attributes2 = this.getObjectAttributes(object, attributes, serializationContext);
        String string = serializationContext.getEncodingStyle();
        boolean bl2 = Constants.isSOAP_ENC(string);
        boolean bl3 = bl = !bl2 && qName.getNamespaceURI().equals("") && qName.getLocalPart().equals("any");
        if (!bl) {
            serializationContext.getSerializationWriter().startElement(qName, attributes2);
        }
        try {
            BeanPropertyDescriptor beanPropertyDescriptor;
            Object object2;
            Object object3;
            for (int i = 0; i < this.propertyDescriptor.length; ++i) {
                Object object4;
                object3 = this.propertyDescriptor[i].getName();
                if (((String)object3).equals("class")) continue;
                object2 = null;
                QName qName2 = null;
                boolean bl4 = false;
                if (this.beanDesc != null && (object4 = this.beanDesc.getFieldByName((String)object3)) != null) {
                    if (!((com.ibm.ws.webservices.engine.description.FieldDesc)object4).isElement()) continue;
                    object2 = ((com.ibm.ws.webservices.engine.description.FieldDesc)object4).getXmlName();
                    bl4 = ((com.ibm.ws.webservices.engine.description.FieldDesc)object4).isMinOccursIs0();
                    qName2 = ((com.ibm.ws.webservices.engine.description.FieldDesc)object4).getXmlType();
                }
                if (object2 == null) {
                    object2 = QNameTable.createQName("", (String)object3);
                }
                if (qName2 == null) {
                    qName2 = serializationContext.getTypeMapping().getTypeQName(this.propertyDescriptor[i].getType());
                }
                if (!this.propertyDescriptor[i].isReadable()) continue;
                if (!this.propertyDescriptor[i].isIndexed()) {
                    object4 = this.propertyDescriptor[i].get(object);
                    if (object4 == null && bl4 && !bl2) continue;
                    serializationContext.serialize((QName)object2, null, object4, qName2, true, null);
                    continue;
                }
                int n = 0;
                int n2 = 0;
                Object object5 = this.propertyDescriptor[i].get(object);
                if (object5 != null) {
                    n2 = Array.getLength(object5);
                }
                while (n < n2) {
                    Object object6 = null;
                    try {
                        object6 = this.propertyDescriptor[i].get(object, n);
                        ++n;
                    }
                    catch (Exception exception) {
                        n = n2;
                    }
                    if (n < 0) continue;
                    serializationContext.serialize((QName)object2, null, object6, qName2, true, null);
                }
            }
            BeanPropertyDescriptor beanPropertyDescriptor2 = beanPropertyDescriptor = this.beanDesc == null ? null : this.beanDesc.getAnyDesc();
            if (beanPropertyDescriptor != null && (object3 = beanPropertyDescriptor.get(object)) != null && object3 instanceof javax.xml.soap.SOAPElement[]) {
                object2 = (javax.xml.soap.SOAPElement[])object3;
                for (int i = 0; i < ((javax.xml.soap.SOAPElement[])object2).length; ++i) {
                    SOAPElement sOAPElement = (SOAPElement)object2[i];
                    sOAPElement.output(serializationContext);
                }
            }
        }
        catch (InvocationTargetException invocationTargetException) {
            FFDCFilter.processException((Throwable)invocationTargetException, (String)"com.ibm.ws.webservices.engine.encoding.ser.BeanSerializer.serialize", (String)"279", (Object)this);
            Throwable throwable = invocationTargetException.getTargetException();
            if (log.isDebugEnabled()) {
                log.debug((Object)Messages.getMessage("exception01", JavaUtils.stackToString(invocationTargetException)));
            }
            log.error((Object)Messages.getMessage("exception00"), throwable);
            throw new IOException(throwable.toString());
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.webservices.engine.encoding.ser.BeanSerializer.serialize", (String)"284", (Object)this);
            if (log.isDebugEnabled()) {
                log.debug((Object)Messages.getMessage("exception01", JavaUtils.stackToString(exception)));
            }
            log.error((Object)Messages.getMessage("exception00"), (Throwable)exception);
            throw new IOException(exception.toString());
        }
        if (!bl) {
            serializationContext.getSerializationWriter().endElement();
        }
    }

    public String getMechanismType() {
        return "WebServices SAX Mechanism";
    }

    private Attributes getObjectAttributes(Object object, Attributes attributes, SerializationContext serializationContext) {
        if (this.beanDesc == null || !this.beanDesc.hasAttributes()) {
            return attributes;
        }
        AttributesImpl attributesImpl = attributes == null ? new AttributesImpl() : (attributes instanceof AttributesImpl ? (AttributesImpl)attributes : new AttributesImpl(attributes));
        try {
            for (int i = 0; i < this.propertyDescriptor.length; ++i) {
                Object object2;
                FieldDesc fieldDesc;
                String string = this.propertyDescriptor[i].getName();
                if (string.equals("class") || (fieldDesc = this.beanDesc.getFieldByName(string)) == null || fieldDesc.isElement()) continue;
                QName qName = fieldDesc.getXmlName();
                if (qName == null) {
                    qName = QNameTable.createQName("", string);
                }
                if (!this.propertyDescriptor[i].isReadable() || this.propertyDescriptor[i].isIndexed() || (object2 = this.propertyDescriptor[i].get(object)) == null) continue;
                this.setAttributeProperty(object2, qName, attributesImpl, serializationContext);
            }
        }
        catch (Exception exception) {
            return attributesImpl;
        }
        return attributesImpl;
    }

    private void setAttributeProperty(Object object, QName qName, AttributesImpl attributesImpl, SerializationContext serializationContext) throws Exception {
        String string = serializationContext.getValueAsString(object, null);
        String string2 = qName.getNamespaceURI();
        String string3 = qName.getLocalPart();
        attributesImpl.addAttribute(string2, string3, serializationContext.getSerializationWriter().qName2String(qName, true), "CDATA", string);
    }

    protected final void serializeChild(QName qName, Attributes attributes, Object object, QName qName2, boolean bl, Boolean bl2, SerializationContext serializationContext) throws IOException {
        Class clazz;
        Serializer serializer = null;
        Class clazz2 = clazz = object != null ? object.getClass() : null;
        if (this.beanDesc != null) {
            Class clazz3;
            FieldDesc fieldDesc = this.beanDesc.getFieldDesc(qName.getNamespaceURI(), qName.getLocalPart());
            if (fieldDesc != null && ((clazz3 = fieldDesc.getJavaType()) != null && clazz3.isPrimitive() || clazz == null)) {
                clazz = clazz3;
            }
            if (fieldDesc != null && qName2 == fieldDesc.getXmlType() && (object == null || object.getClass() == fieldDesc.getJavaType() || fieldDesc.getJavaType().isPrimitive() || fieldDesc.getJavaType().equals(Calendar.class) && fieldDesc.getJavaType().isAssignableFrom(object.getClass())) && (serializer = fieldDesc.getSerializer()) == null && (serializer = serializationContext.getSerializer(fieldDesc.getJavaType(), fieldDesc.getXmlType())) != null) {
                fieldDesc.setSerializer(serializer);
            }
        }
        ((SerializationContextImpl)serializationContext).serialize(qName, attributes, object, qName2, clazz, bl, bl2, serializer);
    }

    public String getBuildNumber() {
        return this.beanDesc == null ? null : this.beanDesc.getBuildNumber();
    }
}

