/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.encoding.custom;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.encoding.DeserializerFactory;
import com.ibm.ws.webservices.engine.encoding.SerializerFactory;
import com.ibm.ws.webservices.engine.encoding.custom.CustomProvider;
import com.ibm.ws.webservices.engine.encoding.ser.BaseDeserializerFactory;
import com.ibm.ws.webservices.engine.encoding.ser.BaseSerializerFactory;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.engine.utils.QNameTable;
import com.ibm.ws.webservices.engine.utils.XMLUtils;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.xml.namespace.QName;
import javax.xml.rpc.encoding.TypeMapping;
import org.apache.commons.logging.Log;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class Utils {
    public static final String PROVIDER_NAMESPACE = "http://www.ibm.com/webservices/customdatabinding/2004/06";
    public static final String ATTRIBUTE_SCOPE = "scope";
    public static final String ATTRIBUTE_SCOPE_SERVER = "server";
    public static final String ATTRIBUTE_SCOPE_APPLICATION = "application";
    public static final String ATTRIBUTE_SCOPE_MODULE = "module";
    public static final String ELEM_MAPPING = "mapping";
    public static final String ELEM_XML_QNAME = "xmlQName";
    public static final String ELEM_QNAME_SCOPE = "qnameScope";
    public static final String ELEM_JAVA_NAME = "javaName";
    public static final String ELEM_BINDER = "binder";
    public static final String ELEM_DESCRIPTION = "description";
    public static final String ELEM_PROPERTY = "initParam";
    public static final String ELEM_PROPERTY_NAME = "name";
    public static final String ELEM_PROPERTY_VALUE = "value";
    public static final String CUSTOM_BINDING_PROVIDER_XML = "META-INF/services/CustomBindingProvider.xml";
    private static Log log = LogFactory.getLog(Utils.class.getName());
    static final Map providerCache = new HashMap();
    static /* synthetic */ Class class$com$ibm$ws$webservices$engine$encoding$ser$CustomSerializerFactory;
    static /* synthetic */ Class class$com$ibm$ws$webservices$engine$encoding$ser$CustomDeserializerFactory;

    public static final synchronized List loadCustomProviders(ClassLoader classLoader) {
        ArrayList<CustomProvider> arrayList;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Entered loadCustomProviders with classloader: " + classLoader.toString()));
        }
        if ((arrayList = (ArrayList<CustomProvider>)providerCache.get(classLoader)) != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Found cached custom binding providers...");
            }
            return arrayList;
        }
        arrayList = new ArrayList<CustomProvider>();
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)"About to load custom binding providers...");
            }
            Enumeration<URL> enumeration = classLoader.getResources(CUSTOM_BINDING_PROVIDER_XML);
            while (enumeration.hasMoreElements()) {
                InputStream inputStream;
                Document document;
                Element element;
                String string;
                URL uRL = enumeration.nextElement();
                String string2 = uRL.getPath();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Parsing custom binding provider file: " + string2));
                }
                if ((string = (element = (document = XMLUtils.newDocument(inputStream = uRL.openStream())).getDocumentElement()).getAttributeNS(PROVIDER_NAMESPACE, ATTRIBUTE_SCOPE)) == null || string.length() == 0) {
                    string = ATTRIBUTE_SCOPE_MODULE;
                }
                CustomProvider customProvider = new CustomProvider(string2, string);
                for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
                    String string3 = node.getLocalName();
                    if (string3 == null || !string3.equals(ELEM_MAPPING)) continue;
                    String string4 = null;
                    String string5 = null;
                    String string6 = null;
                    String string7 = null;
                    String string8 = null;
                    Properties properties = new Properties();
                    for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
                        string3 = node2.getLocalName();
                        if (string3 == null) continue;
                        if (string3.equals(ELEM_XML_QNAME)) {
                            String string9 = node2.getFirstChild().getNodeValue();
                            int n = string9.indexOf(58);
                            String string10 = string9.substring(0, n);
                            string5 = string9.substring(n + 1);
                            Element element2 = (Element)node2;
                            while (string4 == null) {
                                string4 = element2.getAttribute("xmlns:" + string10);
                                if (string4 == null || string4.length() != 0) continue;
                                string4 = null;
                                if ((element2 = element2.getParentNode() instanceof Document ? null : (Element)element2.getParentNode()) != null) continue;
                            }
                            if (string4 != null) continue;
                            log.warn((Object)Messages.getMessage("noNamespaceForMapping", string2));
                            continue;
                        }
                        if (string3.equals(ELEM_JAVA_NAME)) {
                            string6 = node2.getFirstChild().getNodeValue();
                            continue;
                        }
                        if (string3.equals(ELEM_QNAME_SCOPE)) {
                            string7 = node2.getFirstChild().getNodeValue();
                            continue;
                        }
                        if (!string3.equals(ELEM_BINDER)) continue;
                        string8 = node2.getFirstChild().getNodeValue();
                    }
                    if (string7.equals("element") && !string5.startsWith(">")) {
                        string5 = ">" + string5;
                    }
                    customProvider.addMapping(QNameTable.createQName(string4, string5), string6, string7, string8, properties);
                }
                arrayList.add(customProvider);
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.webservices.engine.encoding.custom.Utils.loadCustomProviders", (String)"220");
            log.error((Object)Messages.getMessage("loadCustomProviderError"), (Throwable)exception);
        }
        providerCache.put(classLoader, arrayList);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Cached custom binding providers with classloader: " + classLoader.toString()));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Exiting loadCustomProviders");
        }
        return arrayList;
    }

    public static void populateTypeMapping(List list, TypeMapping typeMapping) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            CustomProvider customProvider = (CustomProvider)iterator.next();
            QName[] qNameArray = customProvider.getQNames();
            for (int i = 0; i < qNameArray.length; ++i) {
                String string = customProvider.getJavaName(qNameArray[i]);
                String string2 = customProvider.getBinderName(qNameArray[i], string);
                try {
                    Class<?> clazz = Class.forName(string);
                    SerializerFactory serializerFactory = BaseSerializerFactory.createFactory(class$com$ibm$ws$webservices$engine$encoding$ser$CustomSerializerFactory == null ? Utils.class$("com.ibm.ws.webservices.engine.encoding.ser.CustomSerializerFactory") : class$com$ibm$ws$webservices$engine$encoding$ser$CustomSerializerFactory, clazz, qNameArray[i], string2);
                    DeserializerFactory deserializerFactory = BaseDeserializerFactory.createFactory(class$com$ibm$ws$webservices$engine$encoding$ser$CustomDeserializerFactory == null ? Utils.class$("com.ibm.ws.webservices.engine.encoding.ser.CustomDeserializerFactory") : class$com$ibm$ws$webservices$engine$encoding$ser$CustomDeserializerFactory, clazz, qNameArray[i], string2);
                    typeMapping.register(clazz, qNameArray[i], (javax.xml.rpc.encoding.SerializerFactory)serializerFactory, (javax.xml.rpc.encoding.DeserializerFactory)deserializerFactory);
                    continue;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    FFDCFilter.processException((Throwable)classNotFoundException, (String)"com.ibm.ws.webservices.engine.encoding.custom.Utils.populateTypeMapping", (String)"251");
                    new RuntimeException(classNotFoundException);
                }
            }
        }
    }
}

