/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.encoding.custom;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.engine.encoding.custom.CustomMapping;
import com.ibm.ws.webservices.engine.utils.QNameTable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Properties;
import javax.xml.namespace.QName;

public class CustomProvider {
    public static final short SCOPE_SERVER = 1;
    public static final short SCOPE_APPLICATION = 2;
    public static final short SCOPE_MODULE = 3;
    private String path;
    private short scope;
    private ArrayList mappings = new ArrayList();
    private QName[] qnames;

    CustomProvider(String string, String string2) {
        this.path = string;
        if (string2.equals("application")) {
            this.scope = (short)2;
        } else if (string2.equals("module")) {
            this.scope = (short)3;
        } else if (string2.equals("server")) {
            this.scope = 1;
        } else {
            throw new IllegalArgumentException("Wrong scope: " + string2);
        }
    }

    public synchronized void addMapping(QName qName, String string, String string2, String string3, Properties properties) {
        this.mappings.add(new CustomMapping(qName, string, string2, string3, properties));
        this.qnames = null;
    }

    public synchronized QName[] getQNames() {
        if (this.qnames == null) {
            this.qnames = new QName[this.mappings.size()];
            int n = 0;
            Iterator iterator = this.mappings.iterator();
            while (iterator.hasNext()) {
                CustomMapping customMapping = (CustomMapping)iterator.next();
                QName qName = customMapping.getQName();
                this.qnames[n++] = QNameTable.createQName(qName.getNamespaceURI(), qName.getLocalPart());
            }
        }
        return this.qnames;
    }

    public String getPath() {
        return this.path;
    }

    public short getScope() {
        return this.scope;
    }

    public synchronized QName getQName(String string) {
        CustomMapping customMapping = this.getMapping(null, string);
        return customMapping == null ? null : customMapping.getQName();
    }

    public synchronized String getJavaName(QName qName) {
        CustomMapping customMapping = this.getMapping(qName, null);
        return customMapping == null ? null : customMapping.getJavaName();
    }

    public synchronized String getBinderName(QName qName, String string) {
        CustomMapping customMapping = this.getMapping(qName, string);
        return customMapping == null ? null : customMapping.getBinder();
    }

    public synchronized Properties getMappingInitParams(QName qName, String string) {
        CustomMapping customMapping = this.getMapping(qName, string);
        return customMapping == null ? null : customMapping.getInitParams();
    }

    private CustomMapping getMapping(QName qName, String string) {
        CustomMapping customMapping = null;
        Iterator iterator = this.mappings.iterator();
        block2: while (iterator.hasNext()) {
            CustomMapping customMapping2 = (CustomMapping)iterator.next();
            if (qName != null) {
                if (!customMapping2.getQName().equals(qName)) continue;
                if (string != null) {
                    String string2 = customMapping2.getJavaName();
                    if (string2.equals(string)) {
                        customMapping = customMapping2;
                        break;
                    }
                    try {
                        Class<?> clazz = Class.forName(string, false, Thread.currentThread().getContextClassLoader());
                        Class<?>[] classArray = clazz.getInterfaces();
                        if (classArray == null) continue;
                        for (int i = 0; i < classArray.length; ++i) {
                            Class<?> clazz2 = classArray[i];
                            if (!clazz2.getName().equals(string2)) continue;
                            customMapping = customMapping2;
                            continue block2;
                        }
                        continue;
                    }
                    catch (Exception exception) {
                        FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.webservices.engine.encoding.custom.CustomProvider.getBinderName", (String)"157", (Object)this);
                        continue;
                    }
                }
                customMapping = customMapping2;
                break;
            }
            if (!customMapping2.getJavaName().equals(string)) continue;
            customMapping = customMapping2;
            break;
        }
        return customMapping;
    }
}

