/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.dispatchers.java;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.engine.WebServicesFault;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.configurable.Configurable;
import com.ibm.ws.webservices.engine.dispatchers.java.SessionDispatcher;
import com.ibm.ws.webservices.engine.handlers.soap.SOAPPort;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.engine.utils.ClassUtils;
import org.apache.commons.logging.Log;

public class JavaBeanDispatcher
extends SessionDispatcher {
    protected static Log log = LogFactory.getLog(JavaBeanDispatcher.class.getName());
    private static final String D_OPTION_CLASSNAME = "className";

    public static final void setClassName(Configurable configurable, String string) {
        configurable.setOption(D_OPTION_CLASSNAME, string);
    }

    public static final String getClassName(Configurable configurable) {
        return (String)configurable.getOption(D_OPTION_CLASSNAME);
    }

    protected ClassLoader getClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    protected Class getServiceClass(SOAPPort sOAPPort) throws WebServicesFault {
        String string = JavaBeanDispatcher.getClassName(sOAPPort);
        if (string == null || string.length() == 0) {
            throw new WebServicesFault("Server.NoClassForService", Messages.getMessage("noServiceClass01"), null, null);
        }
        Class clazz = null;
        try {
            clazz = ClassUtils.forName(string, true, this.getClassLoader());
        }
        catch (ClassNotFoundException classNotFoundException) {
            FFDCFilter.processException((Throwable)classNotFoundException, (String)"com.ibm.ws.webservices.engine.dispatchers.java.JavaBeanDispatcher.getServiceClass", (String)"147", (Object)this);
            String string2 = Messages.getMessage("noClassForService01", string, sOAPPort.getName());
            log.error((Object)string2, (Throwable)classNotFoundException);
            throw new WebServicesFault(string2, classNotFoundException);
        }
        return clazz;
    }

    protected Object createServiceObject(SOAPPort sOAPPort) throws WebServicesFault {
        Object t;
        Class clazz = this.getServiceClass(sOAPPort);
        try {
            t = clazz.newInstance();
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.webservices.engine.dispatchers.java.JavaBeanDispatcher.createServiceObject", (String)"169", (Object)this);
            String string = Messages.getMessage("cantInstantiateClass", clazz.getName());
            log.error((Object)string, (Throwable)exception);
            throw new WebServicesFault(string, exception);
        }
        return t;
    }
}

