/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.deployment.wsdd;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.engine.ConfigurationException;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.deployment.wsdd.WSDDConstants;
import com.ibm.ws.webservices.engine.deployment.wsdd.WSDDDeployment;
import com.ibm.ws.webservices.engine.deployment.wsdd.WSDDException;
import com.ibm.ws.webservices.engine.deployment.wsdd.WSDDUndeployment;
import com.ibm.ws.webservices.engine.encoding.SerializationContext;
import com.ibm.ws.webservices.engine.encoding.SerializationContextImpl;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.engine.utils.XMLUtils;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.commons.logging.Log;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

public class WSDDDocument
extends WSDDConstants {
    protected static Log log = LogFactory.getLog(WSDDDocument.class.getName());
    private Document doc;
    private WSDDDeployment deployment;
    private WSDDUndeployment undeployment;

    public WSDDDocument() {
    }

    public WSDDDocument(int n, Document document) throws WSDDException {
        this.doc = document;
        Element element = document.getDocumentElement();
        if ("undeployment".equals(element.getLocalName())) {
            this.undeployment = new WSDDUndeployment(element);
        } else {
            this.deployment = new WSDDDeployment(n, element);
        }
    }

    public WSDDDocument(int n, Element element) throws WSDDException {
        this.doc = element.getOwnerDocument();
        if ("undeployment".equals(element.getLocalName())) {
            this.undeployment = new WSDDUndeployment(element);
        } else {
            this.deployment = new WSDDDeployment(n, element);
        }
    }

    public WSDDDeployment getDeployment() {
        if (this.deployment == null) {
            this.deployment = new WSDDDeployment();
        }
        return this.deployment;
    }

    public Document getDOMDocument() throws ConfigurationException {
        StringWriter stringWriter = new StringWriter();
        BufferedWriter bufferedWriter = new BufferedWriter(stringWriter);
        SerializationContextImpl serializationContextImpl = new SerializationContextImpl(bufferedWriter, null);
        serializationContextImpl.getSerializationWriter().setPretty(true);
        try {
            this.deployment.writeToContext(serializationContextImpl);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.webservices.engine.deployment.wsdd.WSDDDocument.getDOMDocument", (String)"159", (Object)this);
            log.error((Object)Messages.getMessage("exception00"), (Throwable)exception);
        }
        try {
            ((Writer)bufferedWriter).close();
            return XMLUtils.newDocument(new InputSource(new StringReader(stringWriter.getBuffer().toString())));
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void writeToContext(SerializationContext serializationContext) throws IOException {
        this.getDeployment().writeToContext(serializationContext);
    }

    public void setDocument(Document document) {
        this.doc = document;
        this.deployment = null;
    }

    public void deploy(WSDDDeployment wSDDDeployment) throws ConfigurationException {
        if (this.deployment != null) {
            this.deployment.deployToRegistry(wSDDDeployment);
        }
        if (this.undeployment != null) {
            this.undeployment.undeployFromRegistry(wSDDDeployment);
        }
    }
}

