/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.components.net;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.service.SecurityService;
import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.security.util.InvalidPasswordDecodingException;
import com.ibm.ws.security.util.PasswordUtil;
import com.ibm.ws.ssl.SSLConfig;
import com.ibm.ws.webservices.component.WSServerImpl;
import com.ibm.ws.webservices.engine.components.net.DefaultHTTPSTransportClientProperties;
import com.ibm.ws.webservices.engine.components.net.TransportClientPropertiesFactory;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.engine.utils.JavaUtils;
import java.io.InputStream;
import java.net.URL;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Properties;
import javax.net.ssl.SSLSocketFactory;

public class SSLConfiguration {
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.webservices.resources.webservicesMessages");
    private static final TraceComponent _tc = Tr.register((Class)SSLConfiguration.class, (String)"WebServices", (String)"com.ibm.ws.webservices.resources.webservicesMessages");
    public static final String configURLProperty = "com.ibm.CORBA.ConfigURL";
    public static final String wsSSLconfigURLProperty = "com.ibm.webservices.sslConfigURL";
    private String sslAliasConfigured = null;
    private SSLConfig sslConfigured = null;
    private boolean asServer = false;

    public SSLConfiguration(boolean bl) {
        this.sslConfigured = new SSLConfig(bl);
        this.asServer = bl;
        DefaultHTTPSTransportClientProperties defaultHTTPSTransportClientProperties = (DefaultHTTPSTransportClientProperties)TransportClientPropertiesFactory.create("https");
        this.sslAliasConfigured = defaultHTTPSTransportClientProperties == null ? null : defaultHTTPSTransportClientProperties.getSSLConfigurationName();
    }

    public String getIdentityKey() {
        Object object;
        if (_tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)_tc, (String)Messages.getMessage("enter00", "SSLConfiguration.getIdentityKey()"));
        }
        String string = null;
        Properties properties = null;
        if (this.asServer) {
            if (JavaUtils.hasValue(this.sslAliasConfigured) && (object = WSServerImpl.getSecurityService()) != null && JavaUtils.hasValue(this.sslAliasConfigured)) {
                properties = object.getSecureSocketLayer(this.sslAliasConfigured);
            }
        } else {
            properties = this.getPropertiesObject();
        }
        if (properties != null && JavaUtils.hasValue(string = properties.getProperty("com.ibm.ssl.keyStore")) && JavaUtils.hasValue((String)(object = properties.getProperty("com.ibm.ssl.keyStoreClientAlias")))) {
            string = string + " : " + (String)object;
        }
        if (string == null) {
            string = System.getProperty("javax.net.ssl.keyStore");
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)_tc, (String)Messages.getMessage("exit00", "SSLConfiguration.getIdentityKey()"));
        }
        return string;
    }

    public String configuredSSLAlias() {
        if (_tc.isEventEnabled()) {
            Tr.event((TraceComponent)_tc, (String)Messages.getMessage("enter00", "SSLConfiguration.configuredSSLAlias()..."));
            if (this.asServer) {
                Properties properties = null;
                if (JavaUtils.hasValue(this.sslAliasConfigured)) {
                    Tr.event((TraceComponent)_tc, (String)Messages.getMessage("sslConfiguration00", this.sslAliasConfigured));
                    SecurityService securityService = WSServerImpl.getSecurityService();
                    if (securityService != null && JavaUtils.hasValue(this.sslAliasConfigured)) {
                        properties = securityService.getSecureSocketLayer(this.sslAliasConfigured);
                    }
                } else {
                    Tr.event((TraceComponent)_tc, (String)Messages.getMessage("sslConfiguration00", "JSSE"));
                }
                SSLConfiguration.printInfofromProperties(properties);
            }
            Tr.event((TraceComponent)_tc, (String)Messages.getMessage("exit00", "SSLConfiguration.configuredSSLAlias()"));
        }
        return this.sslAliasConfigured;
    }

    public Properties getPropertiesObject() {
        Properties properties;
        block13: {
            properties = null;
            try {
                String string;
                if (_tc.isEntryEnabled()) {
                    Tr.entry((TraceComponent)_tc, (String)Messages.getMessage("enter00", "SSLConfiguration.getPropertiesObject()"));
                }
                String string2 = string = JavaUtils.hasValue(System.getProperty(wsSSLconfigURLProperty)) ? System.getProperty(wsSSLconfigURLProperty) : System.getProperty(configURLProperty);
                if (string != null && (properties = (Properties)AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        InputStream inputStream = null;
                        Properties properties = null;
                        try {
                            URL uRL = new URL(string);
                            inputStream = uRL.openStream();
                            if (inputStream != null) {
                                properties = new Properties();
                                properties.load(inputStream);
                            }
                        }
                        catch (Exception exception) {
                            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.webservices.engine.components.net.SSLConfiguration.run", (String)"231", (Object)this);
                            throw exception;
                        }
                        finally {
                            if (inputStream != null) {
                                inputStream.close();
                            }
                        }
                        return properties;
                    }
                })) != null) {
                    String[] stringArray = new String[]{"com.ibm.ssl.keyStorePassword", "com.ibm.ssl.trustStorePassword", "com.ibm.ssl.tokenPassword"};
                    String string3 = null;
                    for (int i = 0; i < stringArray.length; ++i) {
                        string3 = properties.getProperty(stringArray[i]);
                        if (!JavaUtils.hasValue(string3)) continue;
                        try {
                            string3 = PasswordUtil.decode(string3);
                            properties.setProperty(stringArray[i], string3);
                            if (!_tc.isEventEnabled()) continue;
                            Tr.event((TraceComponent)_tc, (String)Messages.getMessage("readKsPwdProperty", stringArray[i]));
                            continue;
                        }
                        catch (InvalidPasswordDecodingException invalidPasswordDecodingException) {
                            // empty catch block
                        }
                    }
                }
                if (_tc.isEventEnabled()) {
                    if (JavaUtils.hasValue(string)) {
                        Tr.event((TraceComponent)_tc, (String)Messages.getMessage("sslConfiguration00", string));
                    } else {
                        Tr.event((TraceComponent)_tc, (String)Messages.getMessage("sslConfiguration00", "JSSE"));
                    }
                }
            }
            catch (PrivilegedActionException privilegedActionException) {
                FFDCFilter.processException((Throwable)privilegedActionException, (String)"com.ibm.ws.webservices.engine.components.net.SSLConfiguration.getPropertiesObject", (String)"286");
                if (_tc.isEventEnabled()) {
                    Tr.event((TraceComponent)_tc, (String)Messages.getMessage("exception01", JavaUtils.stackToString(privilegedActionException.getCause() == null ? privilegedActionException : privilegedActionException.getCause())));
                }
            }
            catch (Throwable throwable) {
                FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.webservices.engine.components.net.SSLConfiguration.getPropertiesObject", (String)"292");
                if (!_tc.isEventEnabled()) break block13;
                Tr.event((TraceComponent)_tc, (String)Messages.getMessage("exception01", JavaUtils.stackToString(throwable)));
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)_tc, (String)Messages.getMessage("exit00", "SSLConfiguration.getPropertiesObject()"));
        }
        return properties;
    }

    public boolean isValid(Properties properties) {
        SecurityService securityService;
        Properties properties2 = properties;
        String string = properties2.getProperty("alias");
        if (JavaUtils.hasValue(string) && (securityService = WSServerImpl.getSecurityService()) != null) {
            properties2 = securityService.getSecureSocketLayer(string);
        }
        boolean bl = JavaUtils.hasValue(properties2.getProperty("com.ibm.ssl.keyStore")) && JavaUtils.hasValue(properties2.getProperty("com.ibm.ssl.keyStorePassword"));
        boolean bl2 = JavaUtils.hasValue(properties2.getProperty("com.ibm.ssl.trustStore")) && JavaUtils.hasValue(properties2.getProperty("com.ibm.ssl.trustStorePassword"));
        boolean bl3 = JavaUtils.hasValue(properties2.getProperty("com.ibm.ssl.tokenLibraryFile")) && JavaUtils.hasValue(properties2.getProperty("com.ibm.ssl.tokenPassword")) && JavaUtils.hasValue(properties2.getProperty("com.ibm.ssl.tokenType"));
        boolean bl4 = JavaUtils.hasValue(System.getProperty("javax.net.ssl.keyStore")) && JavaUtils.hasValue(System.getProperty("javax.net.ssl.keyStorePassword")) && JavaUtils.hasValue(System.getProperty("javax.net.ssl.trustStore")) && JavaUtils.hasValue(System.getProperty("javax.net.ssl.trustStorePassword"));
        return bl && bl2 || bl3 || bl4;
    }

    public static void printInfofromProperties(Properties properties) {
        block4: {
            if (!_tc.isDebugEnabled()) break block4;
            String[] stringArray = new String[]{"com.ibm.ssl.keyManager", "com.ibm.ssl.keyStoreType", "com.ibm.ssl.keyStoreProvider", "com.ibm.ssl.keyStore", "com.ibm.ssl.trustManager", "com.ibm.ssl.trustStoreType", "com.ibm.ssl.trustStoreProvider", "com.ibm.ssl.trustStore", "com.ibm.ssl.clientAuthentication", "com.ibm.ssl.tokenType", "com.ibm.ssl.tokenLibraryFile", "com.ibm.ssl.keyStoreClientAlias", "com.ibm.ssl.keyStoreServerAlias"};
            String[] stringArray2 = new String[]{"javax.net.ssl.keyStore", "javax.net.ssl.keyStoreType", "javax.net.ssl.trustStore", "javax.net.ssl.trustStoreType"};
            if (properties != null) {
                for (int i = 0; i < stringArray.length; ++i) {
                    Tr.debug((TraceComponent)_tc, (String)(stringArray[i] + ": " + properties.getProperty(stringArray[i])));
                }
            } else {
                for (int i = 0; i < stringArray2.length; ++i) {
                    Tr.debug((TraceComponent)_tc, (String)(stringArray2[i] + ": " + System.getProperty(stringArray2[i])));
                }
            }
        }
    }

    public SSLSocketFactory getSocketFactoryByPropFile(final String string) {
        Properties properties;
        SSLSocketFactory sSLSocketFactory;
        block11: {
            sSLSocketFactory = null;
            properties = null;
            try {
                properties = (Properties)AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        InputStream inputStream = null;
                        Properties properties = null;
                        try {
                            URL uRL = new URL(string);
                            inputStream = uRL.openStream();
                            if (inputStream != null) {
                                properties = new Properties();
                                properties.load(inputStream);
                            }
                        }
                        catch (Exception exception) {
                            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.webservices.engine.components.net.SSLConfiguration.run", (String)"430", (Object)this);
                            throw exception;
                        }
                        finally {
                            if (inputStream != null) {
                                inputStream.close();
                            }
                        }
                        return properties;
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                FFDCFilter.processException((Throwable)privilegedActionException, (String)"com.ibm.ws.webservices.engine.components.net.SSLConfiguration.getSocketFactoryByPropFile", (String)"444", (Object)this);
                if (!_tc.isEventEnabled()) break block11;
                Tr.event((TraceComponent)_tc, (String)Messages.getMessage("exception01", JavaUtils.stackToString(privilegedActionException.getCause() == null ? privilegedActionException : privilegedActionException.getCause())));
            }
        }
        if (properties != null) {
            this.sslConfigured.init(properties);
            try {
                if (_tc.isEventEnabled()) {
                    String string2 = this.sslConfigured.getKeyFileName();
                    String string3 = this.sslConfigured.getTrustFileName();
                    String string4 = this.sslConfigured.getTokenLibraryFile();
                    if (JavaUtils.hasValue(string2) && JavaUtils.hasValue(string3) && JavaUtils.hasValue(string4)) {
                        Tr.event((TraceComponent)_tc, (String)Messages.getMessage("keyStoresUsed00", string2, string3, null));
                    } else {
                        Tr.event((TraceComponent)_tc, (String)Messages.getMessage("keyStoresUsed00", string2, string3, string4));
                    }
                }
                sSLSocketFactory = this.sslConfigured.getSocketFactory();
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.webservices.engine.components.net.SSLConfiguration.getSocketFactoryByPropFile", (String)"473", (Object)this);
                if (_tc.isEventEnabled()) {
                    Tr.event((TraceComponent)_tc, (String)Messages.getMessage("exception01", JavaUtils.stackToString(exception)));
                }
            }
        } else if (_tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)_tc, (String)("SSL Properties: " + properties));
        }
        return sSLSocketFactory;
    }

    public SSLSocketFactory getSocketFactoryBySSLAlias(String string) {
        SSLSocketFactory sSLSocketFactory;
        block12: {
            sSLSocketFactory = null;
            Properties properties = null;
            if (string != null) {
                this.sslAliasConfigured = new String(string);
                try {
                    SecurityService securityService = WSServerImpl.getSecurityService();
                    if (securityService != null) {
                        properties = securityService.getSecureSocketLayer(this.sslAliasConfigured);
                        if (properties != null) {
                            this.sslConfigured.init(properties);
                            String string2 = this.sslConfigured.getKeyFileName();
                            String string3 = this.sslConfigured.getTrustFileName();
                            String string4 = this.sslConfigured.getTokenLibraryFile();
                            if (_tc.isEventEnabled()) {
                                if (JavaUtils.hasValue(string2) && JavaUtils.hasValue(string3) && JavaUtils.hasValue(string4)) {
                                    Tr.event((TraceComponent)_tc, (String)Messages.getMessage("keyStoresUsed00", string2, string3, null));
                                } else {
                                    Tr.event((TraceComponent)_tc, (String)Messages.getMessage("keyStoresUsed00", string2, string3, string4));
                                }
                            }
                            sSLSocketFactory = this.sslConfigured.getSocketFactory();
                        } else if (_tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)_tc, (String)("SSL Properties: " + properties));
                        }
                    } else if (_tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)_tc, (String)("SecurityService: " + securityService));
                    }
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.webservices.engine.components.net.SSLConfiguration.getSocketFactoryBySSLAlias", (String)"540", (Object)this);
                    if (!_tc.isEventEnabled()) break block12;
                    Tr.event((TraceComponent)_tc, (String)Messages.getMessage("exception01", JavaUtils.stackToString(exception)));
                }
            }
        }
        return sSLSocketFactory;
    }
}

