/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.components.net;

import com.ibm.ws.webservices.WebServicesServiceHome;
import com.ibm.ws.webservices.component.WSServerImpl;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.components.net.BooleanHolder;
import com.ibm.ws.webservices.engine.components.net.DefaultHTTPSTransportClientProperties;
import com.ibm.ws.webservices.engine.components.net.DefaultSocketFactory;
import com.ibm.ws.webservices.engine.components.net.SSLConfiguration;
import com.ibm.ws.webservices.engine.components.net.SecureSocketFactory;
import com.ibm.ws.webservices.engine.components.net.TransportClientPropertiesFactory;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.engine.utils.JavaUtils;
import com.ibm.ws.webservices.engine.utils.XMLUtils;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.Socket;
import java.util.Hashtable;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import org.apache.commons.logging.Log;

public class JSSESocketFactory
extends DefaultSocketFactory
implements SecureSocketFactory {
    private static Log log = LogFactory.getLog(JSSESocketFactory.class.getName());
    private static final SSLSocketFactory sslFactoryDefault = (SSLSocketFactory)SSLSocketFactory.getDefault();

    public JSSESocketFactory(Hashtable hashtable) {
        super(hashtable);
    }

    public Socket create(String string, int n, StringBuffer stringBuffer, BooleanHolder booleanHolder) throws Exception {
        if (n == -1) {
            n = 443;
        }
        DefaultHTTPSTransportClientProperties defaultHTTPSTransportClientProperties = (DefaultHTTPSTransportClientProperties)TransportClientPropertiesFactory.create("https");
        boolean bl = this.isHostInNonProxyList(string, defaultHTTPSTransportClientProperties.getNonProxyHosts());
        SSLSocketFactory sSLSocketFactory = null;
        boolean bl2 = WebServicesServiceHome.getWebServicesService() instanceof WSServerImpl;
        SSLConfiguration sSLConfiguration = new SSLConfiguration(bl2);
        String string2 = null;
        if (bl2) {
            string2 = defaultHTTPSTransportClientProperties.getSSLConfigurationName();
            sSLSocketFactory = !JavaUtils.hasValue(string2) ? sslFactoryDefault : sSLConfiguration.getSocketFactoryBySSLAlias(string2);
        } else {
            string2 = System.getProperty("com.ibm.webservices.sslConfigURL");
            if (!JavaUtils.hasValue(string2)) {
                string2 = System.getProperty("com.ibm.CORBA.ConfigURL");
            }
            sSLSocketFactory = !JavaUtils.hasValue(string2) ? sslFactoryDefault : sSLConfiguration.getSocketFactoryByPropFile(string2);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)Messages.getMessage("sslConfiguration00", string2 == null ? "JSSE" : string2));
        }
        Socket socket = null;
        if (sSLSocketFactory == null) {
            if (JavaUtils.hasValue(string2)) {
                throw new IOException(Messages.getMessage("badSecureSocketFactory00", string2));
            }
            throw new IOException(Messages.getMessage("badSecureSocketFactory01"));
        }
        if (defaultHTTPSTransportClientProperties.getProxyHost().length() == 0 || bl) {
            socket = sSLSocketFactory.createSocket(string, n);
        } else {
            Object object;
            int n2;
            if (log.isDebugEnabled()) {
                log.debug((Object)Messages.getMessage("httpsProxyConfiguration00", defaultHTTPSTransportClientProperties.getProxyHost(), defaultHTTPSTransportClientProperties.getProxyPort(), defaultHTTPSTransportClientProperties.getProxyUser(), JavaUtils.hasValue(defaultHTTPSTransportClientProperties.getProxyPassword()) ? "******" : ""));
            }
            int n3 = n2 = defaultHTTPSTransportClientProperties.getProxyPort().length() != 0 ? Integer.parseInt(defaultHTTPSTransportClientProperties.getProxyPort()) : 80;
            if (n2 < 0) {
                n2 = 80;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)Messages.getMessage("setupTunnel00", defaultHTTPSTransportClientProperties.getProxyHost(), "" + n2));
            }
            Socket socket2 = new Socket(defaultHTTPSTransportClientProperties.getProxyHost(), n2);
            OutputStream outputStream = socket2.getOutputStream();
            PrintWriter printWriter = new PrintWriter(new BufferedWriter(new OutputStreamWriter(outputStream)));
            printWriter.print("CONNECT " + string + ":" + n + " HTTP/1.0\r\n" + "User-Agent: ClientEngine");
            if (defaultHTTPSTransportClientProperties.getProxyUser().length() != 0 && defaultHTTPSTransportClientProperties.getProxyPassword().length() != 0) {
                object = XMLUtils.base64encode((defaultHTTPSTransportClientProperties.getProxyUser() + ":" + defaultHTTPSTransportClientProperties.getProxyPassword()).getBytes());
                printWriter.print("\nProxy-Authorization: Basic " + (String)object);
            }
            printWriter.print("\nContent-Length: 0");
            printWriter.print("\nPragma: no-cache");
            printWriter.print("\r\n\r\n");
            printWriter.flush();
            object = socket2.getInputStream();
            if (log.isDebugEnabled()) {
                log.debug((Object)Messages.getMessage("isNull00", "tunnelInputStream", "" + (object == null)));
            }
            String string3 = "";
            int n4 = 0;
            boolean bl3 = false;
            while (n4 < 2) {
                int n5 = ((InputStream)object).read();
                if (n5 < 0) {
                    throw new IOException("Unexpected EOF from proxy");
                }
                if (n5 == 10) {
                    bl3 = true;
                    ++n4;
                    continue;
                }
                if (n5 == 13) continue;
                n4 = 0;
                if (bl3) continue;
                string3 = string3 + String.valueOf((char)n5);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)Messages.getMessage("proxyResponseForhttpConnect", string3));
            }
            String string4 = string3.replaceAll("\\s{2,}", " ");
            if (log.isDebugEnabled()) {
                log.debug((Object)Messages.getMessage("proxyResponseForhttpConnect", string4));
            }
            if (!string4.startsWith("HTTP/1.0 200") && !string4.startsWith("HTTP/1.1 200")) {
                throw new IOException(Messages.getMessage("cantTunnel00", new String[]{defaultHTTPSTransportClientProperties.getProxyHost(), "" + n2, string4}));
            }
            socket = sSLSocketFactory.createSocket(socket2, string, n, true);
        }
        ((SSLSocket)socket).startHandshake();
        if (log.isDebugEnabled()) {
            log.debug((Object)Messages.getMessage("createdSSL00"));
        }
        return socket;
    }
}

