/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.components.discovery;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.Vector;
import org.apache.commons.discovery.Resource;
import org.apache.commons.discovery.ResourceDiscover;
import org.apache.commons.discovery.ResourceIterator;
import org.apache.commons.discovery.ResourceNameDiscover;
import org.apache.commons.discovery.ResourceNameIterator;
import org.apache.commons.discovery.log.DiscoveryLogFactory;
import org.apache.commons.discovery.resource.ClassLoaders;
import org.apache.commons.discovery.resource.DiscoverResources;
import org.apache.commons.discovery.resource.names.ResourceNameDiscoverImpl;
import org.apache.commons.logging.Log;

public class DiscoverNamesInFile
extends ResourceNameDiscoverImpl
implements ResourceNameDiscover {
    private static Log log = DiscoveryLogFactory.newLog((Class)DiscoverNamesInFile.class);
    private ResourceDiscover _discoverResources;
    private final String _prefix;
    private final String _suffix;

    public static void setLog(Log log) {
        DiscoverNamesInFile.log = log;
    }

    public DiscoverNamesInFile() {
        this._discoverResources = new DiscoverResources();
        this._prefix = null;
        this._suffix = null;
    }

    public DiscoverNamesInFile(String string, String string2) {
        this._discoverResources = new DiscoverResources();
        this._prefix = string;
        this._suffix = string2;
    }

    public DiscoverNamesInFile(ClassLoaders classLoaders) {
        this._discoverResources = new DiscoverResources(classLoaders);
        this._prefix = null;
        this._suffix = null;
    }

    public DiscoverNamesInFile(ClassLoaders classLoaders, String string, String string2) {
        this._discoverResources = new DiscoverResources(classLoaders);
        this._prefix = string;
        this._suffix = string2;
    }

    public DiscoverNamesInFile(ResourceDiscover resourceDiscover) {
        this._discoverResources = resourceDiscover;
        this._prefix = null;
        this._suffix = null;
    }

    public DiscoverNamesInFile(ResourceDiscover resourceDiscover, String string, String string2) {
        this._discoverResources = resourceDiscover;
        this._prefix = string;
        this._suffix = string2;
    }

    public void setDiscoverer(ResourceDiscover resourceDiscover) {
        this._discoverResources = resourceDiscover;
    }

    public ResourceDiscover getDiscover() {
        return this._discoverResources;
    }

    public ResourceNameIterator findResourceNames(String string) {
        String string2 = this._prefix != null && this._prefix.length() > 0 ? this._prefix + string : string;
        if (this._suffix != null && this._suffix.length() > 0) {
            string2 = string2 + this._suffix;
        }
        if (log.isDebugEnabled()) {
            if (this._prefix != null && this._suffix != null) {
                log.debug((Object)("find: serviceName='" + string + "' as '" + string2 + "'"));
            } else {
                log.debug((Object)("find: serviceName = '" + string2 + "'"));
            }
        }
        final ResourceIterator resourceIterator = this.getDiscover().findResources(string2);
        return new ResourceNameIterator(){
            private int idx = 0;
            private Vector classNames = null;
            private String resource = null;

            public boolean hasNext() {
                if (this.resource == null) {
                    this.resource = this.getNextClassName();
                }
                return this.resource != null;
            }

            public String nextResourceName() {
                String string = this.resource;
                this.resource = null;
                return string;
            }

            private String getNextClassName() {
                if (this.classNames == null || this.idx >= this.classNames.size()) {
                    this.classNames = this.getNextClassNames();
                    this.idx = 0;
                    if (this.classNames == null) {
                        return null;
                    }
                }
                String string = (String)this.classNames.get(this.idx++);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("getNextClassResource: next class='" + string + "'"));
                }
                return string;
            }

            private Vector getNextClassNames() {
                while (resourceIterator.hasNext()) {
                    Vector vector = DiscoverNamesInFile.this.readServices(resourceIterator.nextResource());
                    if (vector == null || vector.size() <= 0) continue;
                    return vector;
                }
                return null;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Vector readServices(Resource resource) {
        Vector<String> vector = new Vector<String>();
        InputStream inputStream = resource.getResourceAsStream();
        if (inputStream != null) {
            try {
                try {
                    BufferedReader bufferedReader;
                    try {
                        bufferedReader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
                    }
                    try {
                        String string;
                        while ((string = bufferedReader.readLine()) != null) {
                            int n = string.indexOf(35);
                            if (n >= 0) {
                                string = string.substring(0, n);
                            }
                            if ((string = string.trim()).length() == 0) continue;
                            vector.add(string);
                        }
                    }
                    finally {
                        bufferedReader.close();
                    }
                }
                finally {
                    inputStream.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return vector;
    }
}

