/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.client;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.protocol.Protocols;
import com.ibm.ws.webservices.engine.InternalException;
import com.ibm.ws.webservices.engine.Message;
import com.ibm.ws.webservices.engine.MessageContext;
import com.ibm.ws.webservices.engine.SOAPPart;
import com.ibm.ws.webservices.engine.WebServicesFault;
import com.ibm.ws.webservices.engine.attachments.Attachments;
import com.ibm.ws.webservices.engine.client.Service;
import com.ibm.ws.webservices.engine.client.Transport;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.description.OperationDesc;
import com.ibm.ws.webservices.engine.description.ParameterDesc;
import com.ibm.ws.webservices.engine.encoding.DeserializationContextImpl;
import com.ibm.ws.webservices.engine.enum.MessageType;
import com.ibm.ws.webservices.engine.handlers.soap.SOAPPort;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.engine.transport.http.HTTPTransport;
import com.ibm.ws.webservices.engine.transport.java.JavaTransport;
import com.ibm.ws.webservices.engine.transport.jms.JMSTransport;
import com.ibm.ws.webservices.engine.transport.local.LocalTransport;
import com.ibm.ws.webservices.engine.utils.QNameTable;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPBody;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPBodyElement;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPElement;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPEnvelope;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPFactory;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPHeader;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPHeaderElement;
import com.ibm.ws.webservices.engine.xmlsoap.ext.ParamValue;
import com.ibm.ws.webservices.engine.xmlsoap.ext.RequestResponse;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Vector;
import javax.xml.namespace.QName;
import javax.xml.rpc.JAXRPCException;
import javax.xml.soap.SOAPException;
import org.apache.commons.logging.Log;

public class Connection {
    protected static Log log = LogFactory.getLog(Connection.class.getName());
    protected static Log entLog = LogFactory.getLog("com.ibm.ws.webservices.engine.enterprise");
    private final Service service;
    private final Transport transport;
    private final URL url;
    public static final boolean FAULT_ON_NO_RESPONSE = false;
    private static final Hashtable transports = new Hashtable();

    public static void initProtocols() {
    }

    Connection(Service service, URL uRL) {
        this.service = service;
        this.transport = this.getTransportForURL(uRL);
        this.url = uRL;
    }

    Connection(Service service, Transport transport2, URL uRL) {
        this.service = service;
        this.transport = transport2;
        this.url = uRL;
    }

    private Transport getTransportForURL(URL uRL) {
        Transport transport2 = null;
        if (uRL != null) {
            String string = uRL.getProtocol();
            transport2 = this.getTransportForProtocol(string);
            if (transport2 == null) {
                String string2 = Messages.getMessage("noTransport01", string);
                JAXRPCException jAXRPCException = new JAXRPCException(string2);
                log.error((Object)string2);
                throw jAXRPCException;
            }
            transport2.setUrl(uRL.toString());
        }
        return transport2;
    }

    private Transport getTransportForProtocol(String string) {
        Class clazz = (Class)transports.get(string);
        Transport transport2 = null;
        if (clazz != null) {
            try {
                transport2 = (Transport)clazz.newInstance();
            }
            catch (InstantiationException instantiationException) {
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        return transport2;
    }

    public static void setTransportForProtocol(String string, Class clazz) {
        if (!Transport.class.isAssignableFrom(clazz)) {
            throw new InternalException(clazz.toString());
        }
        transports.put(string, clazz);
    }

    private Object[] getParamList(OperationDesc operationDesc, Object[] objectArray, Vector vector) {
        int n = 0;
        if (log.isDebugEnabled()) {
            log.debug((Object)("operation=" + operationDesc));
            log.debug((Object)("operation.getNumParams()=" + operationDesc.getNumParams()));
        }
        if (operationDesc.getNumParams() == 0) {
            return objectArray;
        }
        n = operationDesc.getNumInParams();
        if (objectArray == null || n != objectArray.length) {
            throw new JAXRPCException(Messages.getMessage("parmMismatch00", "" + (objectArray != null ? objectArray.length : 0), "" + n));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("getParamList number of params: " + objectArray.length));
        }
        Vector<ParamValue> vector2 = new Vector<ParamValue>();
        int n2 = 0;
        ArrayList arrayList = operationDesc.getParameters();
        for (int i = 0; i < arrayList.size(); ++i) {
            Object object;
            ParameterDesc parameterDesc = (ParameterDesc)arrayList.get(i);
            if (parameterDesc.getMode() == 2) continue;
            QName qName = parameterDesc.getQName();
            ParamValue paramValue = null;
            paramValue = (object = objectArray[n2++]) instanceof ParamValue ? (ParamValue)object : new ParamValue(qName.getNamespaceURI(), qName.getLocalPart(), object);
            paramValue.setParamDesc(parameterDesc);
            if (parameterDesc.isInHeader()) {
                vector.add(paramValue);
                continue;
            }
            vector2.add(paramValue);
        }
        return vector2.toArray();
    }

    public Vector invoke(MessageContext messageContext, Object[] objectArray, Vector vector, Vector vector2) throws WebServicesFault {
        Object object;
        OperationDesc operationDesc;
        if (vector == null) {
            vector = new Vector();
        }
        if ((operationDesc = messageContext.getOperation()) == null) {
            throw new WebServicesFault(QNameTable.createQName(messageContext.getSOAPConstants().getEnvelopeURI(), "Client"), Messages.getMessage("mustSpecifyOperation"), null, null);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Enter: Connection::invoke(MessageContext, Object[] args, Vector, Vector)");
        }
        QName qName = operationDesc.getElementQName();
        SOAPFactory sOAPFactory = new SOAPFactory(messageContext.getSOAPConstants());
        SOAPEnvelope sOAPEnvelope = null;
        SOAPBody sOAPBody = null;
        SOAPHeader sOAPHeader = null;
        try {
            sOAPEnvelope = sOAPFactory.createSOAPEnvelope(true);
            sOAPBody = (SOAPBody)sOAPEnvelope.getBody();
            sOAPHeader = (SOAPHeader)sOAPEnvelope.getHeader();
        }
        catch (SOAPException sOAPException) {
            FFDCFilter.processException((Throwable)sOAPException, (String)"com.ibm.ws.webservices.engine.client.Connection.invoke", (String)"408", (Object)this);
            throw WebServicesFault.makeFault(sOAPException);
        }
        RequestResponse requestResponse = null;
        try {
            requestResponse = new RequestResponse(qName.getNamespaceURI(), qName.getLocalPart(), sOAPBody, false);
        }
        catch (SOAPException sOAPException) {
            FFDCFilter.processException((Throwable)sOAPException, (String)"com.ibm.ws.webservices.engine.client.Connection.invoke", (String)"418", (Object)this);
            throw WebServicesFault.makeFault(sOAPException);
        }
        requestResponse.addParams(this.getParamList(operationDesc, objectArray, vector));
        SOAPEnvelope sOAPEnvelope2 = null;
        Message message = new Message(sOAPEnvelope);
        Message message2 = null;
        Vector vector3 = null;
        String string = messageContext.getCharacterEncoding();
        if (string != null && string.length() > 0) {
            message.setCharacterEncoding(string);
            message.setMessageContext(messageContext);
        }
        try {
            object = messageContext.getEncodingStyle();
            if (object != null && ((String)object).length() > 0) {
                sOAPBody.setEncodingStyle((String)object);
                sOAPHeader.setEncodingStyle((String)object);
            }
            messageContext.setRequestMessage(message);
            sOAPEnvelope.getSOAPFactory().setMessageType(MessageType.REQUEST);
            this.invoke(messageContext, vector, vector2);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.webservices.engine.client.Connection.invoke", (String)"438", (Object)this);
            if (entLog.isDebugEnabled()) {
                entLog.debug((Object)Messages.getMessage("toWebServicesFault00"), (Throwable)exception);
            }
            throw WebServicesFault.makeFault(exception);
        }
        message2 = messageContext.getResponseMessage();
        if (!this.isRPCOneway(messageContext)) {
            if (message2 == null) {
                return null;
            }
            sOAPEnvelope2 = message2.getSOAPEnvelope();
            object = null;
            try {
                if (sOAPEnvelope2.getBody() == null) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"detected no body.  A body is created.");
                    }
                    SOAPBody sOAPBody2 = (SOAPBody)sOAPEnvelope2.addBody();
                    new RequestResponse("", "", sOAPBody2, true, new OperationDesc[]{operationDesc}, new DeserializationContextImpl(messageContext, null));
                }
                object = ((SOAPBody)sOAPEnvelope2.getBody()).getRequestResponse();
            }
            catch (SOAPException sOAPException) {
                FFDCFilter.processException((Throwable)sOAPException, (String)"com.ibm.ws.webservices.engine.client.Connection.invoke", (String)"460", (Object)this);
                throw WebServicesFault.makeFault(sOAPException);
            }
            if (object != null) {
                try {
                    vector3 = ((RequestResponse)object).getParams();
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.webservices.engine.client.Connection.invoke", (String)"468", (Object)this);
                    log.error((Object)Messages.getMessage("exception00"), (Throwable)exception);
                    throw WebServicesFault.makeFault(exception);
                }
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)"Exit: Connection::invoke(msgCtx, args)");
            }
        }
        return vector3;
    }

    public void invoke(MessageContext messageContext, Vector vector, Vector vector2) throws WebServicesFault {
        SOAPElement sOAPElement;
        Object object;
        Serializable serializable;
        if (log.isDebugEnabled()) {
            log.debug((Object)"Enter: Connection::invoke(MessageContext, Vector headers, Vector attachments)");
        }
        Message message = messageContext.getRequestMessage();
        QName qName = messageContext.getPortName();
        if (qName != null) {
            messageContext.setTargetPort(qName.getLocalPart());
        } else if (message != null) {
            try {
                QName qName2;
                serializable = message.getSOAPEnvelope();
                object = ((SOAPBody)((SOAPEnvelope)serializable).getBody()).getRequestResponse();
                if (object != null) {
                    qName2 = ((RequestResponse)object).getQName();
                } else {
                    sOAPElement = (SOAPBodyElement)((SOAPBody)((SOAPEnvelope)serializable).getBody()).getChildElement(0);
                    qName2 = QNameTable.createQName(sOAPElement.getNamespaceURI(), sOAPElement.getLocalPart());
                }
                if (qName2.getNamespaceURI() == null) {
                    throw new WebServicesFault(QNameTable.createQName(messageContext.getSOAPConstants().getEnvelopeURI(), "Client"), Messages.getMessage("cantInvoke00", qName2.getLocalPart()), null, null);
                }
                messageContext.setTargetPort(qName2.getNamespaceURI());
            }
            catch (SOAPException sOAPException) {
                FFDCFilter.processException((Throwable)sOAPException, (String)"com.ibm.ws.webservices.engine.client.Connection.invoke", (String)"541", (Object)this);
                throw WebServicesFault.makeFault(sOAPException);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)Messages.getMessage("targetService", messageContext.getTargetPortName()));
        }
        if (message != null) {
            serializable = message.getSOAPEnvelope();
            ((SOAPElement)serializable).getSOAPFactory().setMessageContext(messageContext);
            try {
                for (int i = 0; vector != null && i < vector.size(); ++i) {
                    if (vector.get(i) instanceof ParamValue) {
                        object = (ParamValue)vector.get(i);
                        sOAPElement = ((SOAPElement)serializable).getSOAPFactory().createSOAPHeaderElement(((ParamValue)object).getQName().getNamespaceURI(), ((ParamValue)object).getQName().getLocalPart());
                        sOAPElement.setAlternateContent(object);
                        ((SOAPEnvelope)serializable).getHeader().addChildElement((javax.xml.soap.SOAPElement)sOAPElement);
                        continue;
                    }
                    ((SOAPEnvelope)serializable).getHeader().addChildElement((javax.xml.soap.SOAPElement)((SOAPHeaderElement)vector.get(i)));
                }
            }
            catch (SOAPException sOAPException) {
                FFDCFilter.processException((Throwable)sOAPException, (String)"com.ibm.ws.webservices.engine.client.Connection.invoke", (String)"575", (Object)this);
                throw WebServicesFault.makeFault(sOAPException);
            }
            if (log.isDebugEnabled()) {
                SOAPPart sOAPPart = (SOAPPart)message.getSOAPPart();
                try {
                    object = sOAPPart.getString();
                    log.debug(object);
                }
                catch (Exception exception) {
                    log.debug((Object)Messages.getMessage("exceptionPrinting"), (Throwable)exception);
                }
            }
        }
        serializable = messageContext.getRequestMessage();
        this.addAttachments((Message)serializable, vector2);
        this.invoke(messageContext);
    }

    public void invoke(MessageContext messageContext) throws WebServicesFault {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Enter: Connection::invoke(MessageContext)");
        }
        if (messageContext.getTargetEndpointAddress() == null && this.url != null) {
            messageContext.setTargetEndpointAddress(this.url);
        }
        if (this.transport != null) {
            this.transport.setupMessageContext(messageContext, this.service.getEngine());
        }
        messageContext.addImplicitSOAPHeadersToRequest();
        if (this.isRPCOneway(messageContext)) {
            this.invokeEngineOneWay(messageContext);
        } else {
            this.invokeEngine(messageContext);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Exit: Call::invoke()");
        }
    }

    private void addAttachments(Message message, Vector vector) {
        if (vector != null && !vector.isEmpty()) {
            try {
                Attachments attachments = message.getAttachmentsImpl();
                if (attachments == null) {
                    throw new RuntimeException(Messages.getMessage("noAttachments"));
                }
                attachments.setAttachmentParts(vector);
                vector.clear();
            }
            catch (WebServicesFault webServicesFault) {
                FFDCFilter.processException((Throwable)webServicesFault, (String)"com.ibm.ws.webservices.engine.client.Connection.addAttachments", (String)"1564", (Object)this);
                log.info((Object)Messages.getMessage("webServicesFault00"), (Throwable)webServicesFault);
                throw new RuntimeException(webServicesFault.getMessage());
            }
        }
    }

    private boolean isRPCOneway(MessageContext messageContext) {
        return messageContext != null && messageContext.getOperation() != null ? messageContext.getOperation().isOneway() : false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void setTimeout(MessageContext messageContext) {
        String string;
        QName qName;
        block12: {
            qName = messageContext.getPortName();
            string = null;
            try {
                try {
                    SOAPPort sOAPPort = this.service.getEngine().getPort(qName);
                    if (sOAPPort != null) {
                        string = (String)sOAPPort.getOption("SyncTimeout");
                    }
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.webservices.engine.client.Connection.setTimeout", (String)"660", (Object)this);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)Messages.getMessage("exceptionPrinting"), (Throwable)exception);
                    }
                    Object var6_7 = null;
                    if (string == null) {
                        string = "300";
                    }
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("PortComponent: " + qName + "  Timeout: " + string));
                    }
                    messageContext.setTimeout(Integer.parseInt(string) * 1000);
                    return;
                }
                Object var6_6 = null;
                if (string != null) break block12;
                string = "300";
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                if (string == null) {
                    string = "300";
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("PortComponent: " + qName + "  Timeout: " + string));
                }
                messageContext.setTimeout(Integer.parseInt(string) * 1000);
                throw throwable;
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("PortComponent: " + qName + "  Timeout: " + string));
        }
        messageContext.setTimeout(Integer.parseInt(string) * 1000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void setWriteTimeout(MessageContext messageContext) {
        String string;
        QName qName;
        block12: {
            qName = messageContext.getPortName();
            string = null;
            try {
                try {
                    SOAPPort sOAPPort = this.service.getEngine().getPort(qName);
                    if (sOAPPort != null) {
                        string = (String)sOAPPort.getOption("write_timeout");
                    }
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.webservices.engine.client.Connection.setWriteTimeout", (String)"811", (Object)this);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)Messages.getMessage("exceptionPrinting"), (Throwable)exception);
                    }
                    Object var6_7 = null;
                    if (string == null) {
                        string = "300";
                    }
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("PortComponent: " + qName + "write_timeout: " + string));
                    }
                    messageContext.setWriteTimeout(Integer.parseInt(string) * 1000);
                    return;
                }
                Object var6_6 = null;
                if (string != null) break block12;
                string = "300";
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                if (string == null) {
                    string = "300";
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("PortComponent: " + qName + "write_timeout: " + string));
                }
                messageContext.setWriteTimeout(Integer.parseInt(string) * 1000);
                throw throwable;
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("PortComponent: " + qName + "write_timeout: " + string));
        }
        messageContext.setWriteTimeout(Integer.parseInt(string) * 1000);
    }

    private void invokeEngine(MessageContext messageContext) throws WebServicesFault {
        Message message;
        if (messageContext.getTimeout() == 0) {
            this.setTimeout(messageContext);
        }
        if (messageContext.getWriteTimeout() == 0) {
            this.setWriteTimeout(messageContext);
        }
        this.service.getEngine().invoke(messageContext);
        if (this.transport != null) {
            this.transport.processReturnedMessageContext(messageContext);
        }
        if ((message = messageContext.getResponseMessage()) == null) {
            return;
        }
        message.setMessageType(MessageType.RESPONSE);
        message.ifFaultThrowSelf();
        messageContext.getImplicitSOAPHeadersFromResponse();
    }

    private void invokeEngineOneWay(MessageContext messageContext) throws WebServicesFault {
        try {
            Message message;
            this.service.getEngine().invoke(messageContext);
            if (this.transport != null) {
                this.transport.processReturnedMessageContext(messageContext);
            }
            if ((message = messageContext.getResponseMessage()) != null) {
                message.setMessageType(MessageType.RESPONSE);
                message.ifFaultThrowSelf();
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.webservices.engine.client.Connection.invokeEngineOneWay", (String)"783", (Object)this);
            throw WebServicesFault.makeFault(exception);
        }
    }

    public Service getService() {
        return this.service;
    }

    static {
        Protocols.init();
        Connection.setTransportForProtocol("java", JavaTransport.class);
        Connection.setTransportForProtocol("local", LocalTransport.class);
        Connection.setTransportForProtocol("http", HTTPTransport.class);
        Connection.setTransportForProtocol("https", HTTPTransport.class);
        Connection.setTransportForProtocol("jms", JMSTransport.class);
    }
}

