/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.attachments;

import com.ibm.ws.ffdc.FFDCFilter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.activation.DataSource;
import javax.mail.internet.MimeMultipart;

public class MimeMultipartDataSource
implements DataSource {
    public static final String CONTENT_TYPE = "multipart/mixed";
    private final String name;
    private final String contentType;
    private byte[] data;
    private ByteArrayInputStream is;
    private ByteArrayOutputStream os;

    public MimeMultipartDataSource(String string, MimeMultipart mimeMultipart) {
        this.name = string;
        this.contentType = mimeMultipart == null ? CONTENT_TYPE : mimeMultipart.getContentType();
        this.os = new ByteArrayOutputStream();
        try {
            if (mimeMultipart != null) {
                mimeMultipart.writeTo((OutputStream)this.os);
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.webservices.engine.attachments.MimeMultipartDataSource.MimeMultipartDataSource", (String)"90", (Object)this);
        }
    }

    public String getName() {
        return this.name;
    }

    public String getContentType() {
        return this.contentType;
    }

    public InputStream getInputStream() throws IOException {
        if (this.os.size() != 0) {
            this.data = this.os.toByteArray();
            this.os.reset();
        }
        return new ByteArrayInputStream(this.data == null ? new byte[]{} : this.data);
    }

    public OutputStream getOutputStream() throws IOException {
        if (this.os.size() != 0) {
            this.data = this.os.toByteArray();
            this.os.reset();
        }
        return this.os;
    }
}

