/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.attachments;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.webservices.engine.attachments.DimeTypeNameFormat;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.resources.Messages;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.StringTokenizer;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import org.apache.commons.logging.Log;

public class DimeBodyPart {
    protected static Log log = LogFactory.getLog(DimeBodyPart.class.getName());
    protected Object data = null;
    protected DimeTypeNameFormat dtnf = null;
    protected byte[] type = null;
    protected byte[] id = null;
    static final byte POSITION_FIRST = 4;
    static final byte POSITION_LAST = 2;
    private static final byte CHUNK = 1;
    private static final byte CHUNK_NEXT = 2;
    private static int MAX_TYPE_LENGTH = 65535;
    private static int MAX_ID_LENGTH = 65535;
    static final long MAX_DWORD = 0xFFFFFFFFL;
    private static final byte[] pad = new byte[4];
    static final byte CURRENT_OPT_T = 0;

    protected DimeBodyPart() {
    }

    public DimeBodyPart(byte[] byArray, DimeTypeNameFormat dimeTypeNameFormat, String string, String string2) {
        byte[] byArray2 = new byte[byArray.length];
        this.data = byArray2;
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        this.dtnf = dimeTypeNameFormat;
        this.type = string.getBytes();
        if (this.type.length > MAX_TYPE_LENGTH) {
            throw new IllegalArgumentException(Messages.getMessage("attach.dimetypeexceedsmax", "" + this.type.length, "" + MAX_TYPE_LENGTH));
        }
        this.id = string2.getBytes();
        if (this.id.length > MAX_ID_LENGTH) {
            throw new IllegalArgumentException(Messages.getMessage("attach.dimelengthexceedsmax", "" + this.id.length, "" + MAX_ID_LENGTH));
        }
    }

    public DimeBodyPart(DataHandler dataHandler, DimeTypeNameFormat dimeTypeNameFormat, String string, String string2) {
        this.data = dataHandler;
        this.dtnf = dimeTypeNameFormat;
        if (string == null || string.length() == 0) {
            string = "application/octet-stream";
        }
        this.type = string.getBytes();
        if (this.type.length > MAX_TYPE_LENGTH) {
            throw new IllegalArgumentException(Messages.getMessage("attach.dimetypeexceedsmax", "" + this.type.length, "" + MAX_TYPE_LENGTH));
        }
        this.id = string2.getBytes();
        if (this.id.length > MAX_ID_LENGTH) {
            throw new IllegalArgumentException(Messages.getMessage("attach.dimelengthexceedsmax", "" + this.id.length, "" + MAX_ID_LENGTH));
        }
    }

    public DimeBodyPart(DataHandler dataHandler, String string) {
        this(dataHandler, DimeTypeNameFormat.MIME, dataHandler.getContentType(), string);
        StringTokenizer stringTokenizer;
        String string2;
        String string3 = dataHandler.getContentType();
        if (string3 != null && (string3 = string3.trim()).toLowerCase().startsWith("application/uri") && (string2 = (stringTokenizer = new StringTokenizer(string3, " \t;")).nextToken(" \t;")).equalsIgnoreCase("application/uri")) {
            while (stringTokenizer.hasMoreTokens()) {
                string2 = stringTokenizer.nextToken(" \t;");
                if (string2.equalsIgnoreCase("uri")) {
                    string2 = stringTokenizer.nextToken("=");
                    if (string2 != null) {
                        if ((string2 = string2.trim()).startsWith("\"")) {
                            string2 = string2.substring(1);
                        }
                        if (string2.endsWith("\"")) {
                            string2 = string2.substring(0, string2.length() - 1);
                        }
                        this.type = string2.getBytes();
                        this.dtnf = DimeTypeNameFormat.URI;
                    }
                    return;
                }
                if (string2.equalsIgnoreCase("uri=")) {
                    string2 = stringTokenizer.nextToken(" \t;");
                    if (null == string2 || string2.length() == 0) continue;
                    if ((string2 = string2.trim()).startsWith("\"")) {
                        string2 = string2.substring(1);
                    }
                    if (string2.endsWith("\"")) {
                        string2 = string2.substring(0, string2.length() - 1);
                    }
                    this.type = string2.getBytes();
                    this.dtnf = DimeTypeNameFormat.URI;
                    return;
                }
                if (!string2.toLowerCase().startsWith("uri=") || -1 == string2.indexOf(61) || (string2 = string2.substring(string2.indexOf(61)).trim()).length() == 0) continue;
                if ((string2 = string2.trim()).startsWith("\"")) {
                    string2 = string2.substring(1);
                }
                if (string2.endsWith("\"")) {
                    string2 = string2.substring(0, string2.length() - 1);
                }
                this.type = string2.getBytes();
                this.dtnf = DimeTypeNameFormat.URI;
                return;
            }
        }
    }

    void write(OutputStream outputStream, byte by, long l) throws IOException {
        if (l < 1L) {
            throw new IllegalArgumentException(Messages.getMessage("attach.dimeMaxChunkSize0", "" + l));
        }
        if (l > 0xFFFFFFFFL) {
            throw new IllegalArgumentException(Messages.getMessage("attach.dimeMaxChunkSize1", "" + l));
        }
        if (this.data instanceof byte[]) {
            this.send(outputStream, by, (byte[])this.data, l);
        }
        if (this.data instanceof DataHandler) {
            this.send(outputStream, by, (DataHandler)this.data, l);
        }
    }

    void write(OutputStream outputStream, byte by) throws IOException {
        this.write(outputStream, by, 0xFFFFFFFFL);
    }

    void send(OutputStream outputStream, byte by, byte[] byArray, long l) throws IOException {
        this.send(outputStream, by, byArray, 0, byArray.length, l);
    }

    void send(OutputStream outputStream, byte by, byte[] byArray, int n, int n2, long l) throws IOException {
        int n3;
        int n4 = 0;
        do {
            this.sendChunk(outputStream, by, byArray, n, n3, (byte)(((n3 = (int)Math.min(l, (long)(n2 - n))) < n2 - n ? 1 : 0) | n4));
            n4 = 2;
        } while ((n += n3) < n2);
    }

    void send(OutputStream outputStream, byte by, DataHandler dataHandler, long l) throws IOException {
        int n;
        boolean bl = false;
        long l2 = this.getDataSize();
        InputStream inputStream = null;
        final DataHandler dataHandler2 = dataHandler;
        try {
            inputStream = (InputStream)AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    return dataHandler2.getInputStream();
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            FFDCFilter.processException((Throwable)privilegedActionException, (String)"com.ibm.ws.webservices.engine.attachments.DimeBodyPart.send", (String)"330", (Object)this);
            throw (IOException)privilegedActionException.getException();
        }
        byte[] byArray = new byte[65536];
        this.sendHeader(outputStream, by, l2, (byte)0);
        long l3 = 0L;
        do {
            if ((n = inputStream.read(byArray)) <= 0) continue;
            outputStream.write(byArray, 0, n);
            l3 += (long)n;
        } while (n > -1);
        outputStream.write(pad, 0, DimeBodyPart.dimePadding(l3));
    }

    protected void sendChunk(OutputStream outputStream, byte by, byte[] byArray, byte by2) throws IOException {
        this.sendChunk(outputStream, by, byArray, 0, byArray.length, by2);
    }

    protected void sendChunk(OutputStream outputStream, byte by, byte[] byArray, int n, int n2, byte by2) throws IOException {
        this.sendHeader(outputStream, by, n2, by2);
        outputStream.write(byArray, n, n2);
        outputStream.write(pad, 0, DimeBodyPart.dimePadding(n2));
    }

    protected void sendHeader(OutputStream outputStream, byte by, long l, byte by2) throws IOException {
        byte[] byArray = new byte[12];
        byArray[0] = 8;
        byArray[0] = (byte)(byArray[0] | (byte)(by & 6 & ((by2 & 1) != 0 ? -3 : -1) & ((by2 & 2) != 0 ? -5 : -1)));
        byArray[0] = (byte)(byArray[0] | by2 & 1);
        if ((by2 & 2) == 0) {
            byArray[1] = (byte)(this.dtnf.toByte() << 4 & 0xF0);
        }
        byArray[1] = (byte)(byArray[1] | 0);
        byArray[2] = 0;
        byArray[3] = 0;
        if ((by2 & 2) == 0) {
            byArray[4] = (byte)(this.id.length >>> 8 & 0xFF);
            byArray[5] = (byte)(this.id.length & 0xFF);
        }
        if ((by2 & 2) == 0) {
            byArray[6] = (byte)(this.type.length >>> 8 & 0xFF);
            byArray[7] = (byte)(this.type.length & 0xFF);
        }
        byArray[8] = (byte)(l >>> 24 & 0xFFL);
        byArray[9] = (byte)(l >>> 16 & 0xFFL);
        byArray[10] = (byte)(l >>> 8 & 0xFFL);
        byArray[11] = (byte)(l & 0xFFL);
        outputStream.write(byArray);
        if ((by2 & 2) == 0) {
            outputStream.write(this.id);
            outputStream.write(pad, 0, DimeBodyPart.dimePadding(this.id.length));
        }
        if ((by2 & 2) == 0) {
            outputStream.write(this.type);
            outputStream.write(pad, 0, DimeBodyPart.dimePadding(this.type.length));
        }
    }

    static final int dimePadding(long l) {
        return (int)(4L - (l & 3L) & 3L);
    }

    long getTransmissionSize(long l) {
        long l2 = 0L;
        l2 += (long)this.id.length;
        l2 += (long)DimeBodyPart.dimePadding(this.id.length);
        l2 += (long)this.type.length;
        l2 += (long)DimeBodyPart.dimePadding(this.type.length);
        long l3 = this.getDataSize();
        if (0L == l3) {
            l2 += 12L;
        } else {
            long l4 = l3 / l;
            long l5 = l3 % l;
            if (0L != l5) {
                l2 += 12L;
            }
            l2 += 12L * l4;
            l2 += l4 * (long)DimeBodyPart.dimePadding(l);
            l2 += (long)DimeBodyPart.dimePadding(l5);
            l2 += l3;
        }
        return l2;
    }

    long getTransmissionSize() {
        return this.getTransmissionSize(0xFFFFFFFFL);
    }

    protected long getDataSize() {
        if (this.data instanceof byte[]) {
            return ((byte[])this.data).length;
        }
        if (this.data instanceof DataHandler) {
            return this.getDataSize((DataHandler)this.data);
        }
        return -1L;
    }

    protected long getDataSize(DataHandler dataHandler) {
        long l = -1L;
        try {
            DataSource dataSource = dataHandler.getDataSource();
            if (dataSource instanceof FileDataSource) {
                FileDataSource fileDataSource = (FileDataSource)dataSource;
                File file = fileDataSource.getFile();
                if (!file.exists()) {
                    throw new RuntimeException(Messages.getMessage("noFile", file.getAbsolutePath()));
                }
                l = file.length();
            } else {
                int n;
                l = 0L;
                final DataSource dataSource2 = dataSource;
                InputStream inputStream = null;
                inputStream = (InputStream)AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                    public Object run() throws IOException {
                        return dataSource2.getInputStream();
                    }
                });
                byte[] byArray = new byte[65536];
                do {
                    if ((n = inputStream.read(byArray)) <= 0) continue;
                    l += (long)n;
                } while (n > -1);
                inputStream.close();
            }
        }
        catch (PrivilegedActionException privilegedActionException) {
            FFDCFilter.processException((Throwable)privilegedActionException.getException(), (String)"com.ibm.ws.webservices.engine.attachments.DimeBodyPart.getDataSize", (String)"512", (Object)this);
            log.error((Object)Messages.getMessage("exception00"), (Throwable)privilegedActionException.getException());
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.webservices.engine.attachments.DimeBodyPart.getDataSize", (String)"515", (Object)this);
            log.error((Object)Messages.getMessage("exception00"), (Throwable)exception);
        }
        return l;
    }
}

