/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.attachments;

import com.ibm.ws.webservices.engine.Constants;
import com.ibm.ws.webservices.engine.Part;
import com.ibm.ws.webservices.engine.WebServicesFault;
import com.ibm.ws.webservices.engine.attachments.AttachmentPart;
import com.ibm.ws.webservices.engine.attachments.ImageDataSource;
import com.ibm.ws.webservices.engine.attachments.MimeMultipartDataSource;
import com.ibm.ws.webservices.engine.attachments.PlainTextDataSource;
import com.ibm.ws.webservices.engine.attachments.SourceDataSource;
import com.ibm.ws.webservices.engine.encoding.ser.ImageDataHandlerDeserializer;
import com.ibm.ws.webservices.engine.encoding.ser.JAFDataHandlerDeserializer;
import com.ibm.ws.webservices.engine.encoding.ser.MimeMultipartDataHandlerDeserializer;
import com.ibm.ws.webservices.engine.encoding.ser.PlainTextDataHandlerDeserializer;
import com.ibm.ws.webservices.engine.encoding.ser.SourceDataHandlerDeserializer;
import com.ibm.ws.webservices.engine.resources.Messages;
import java.awt.Image;
import javax.activation.DataHandler;
import javax.mail.internet.MimeMultipart;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPException;
import javax.xml.transform.stream.StreamSource;

public class AttachmentUtils {
    private AttachmentUtils() {
    }

    public static DataHandler getActivationDataHandler(Part part) throws WebServicesFault {
        if (null == part) {
            throw new WebServicesFault(Messages.getMessage("gotNullPart"));
        }
        if (!(part instanceof AttachmentPart)) {
            throw new WebServicesFault(Messages.getMessage("unsupportedAttach", part.getClass().getName(), AttachmentPart.class.getName()));
        }
        return ((AttachmentPart)part).getActivationDataHandler();
    }

    public static boolean isAttachment(Object object) {
        if (null == object) {
            return false;
        }
        return object instanceof DataHandler;
    }

    public static boolean isMIME(QName qName) {
        if (qName != null && "http://xml.apache.org/xml-soap".equals(qName.getNamespaceURI())) {
            return Constants.MIME_IMAGE.equals(qName) || Constants.MIME_PLAINTEXT.equals(qName) || Constants.MIME_MULTIPART.equals(qName) || Constants.MIME_SOURCE.equals(qName) || Constants.MIME_OCTETSTREAM.equals(qName) || Constants.MIME_DATA_HANDLER.equals(qName);
        }
        return false;
    }

    public static String mime(QName qName) {
        if (qName != null && "http://xml.apache.org/xml-soap".equals(qName.getNamespaceURI())) {
            String string = null;
            if (Constants.MIME_IMAGE.equals(qName)) {
                string = "image/jpeg";
            } else if (Constants.MIME_PLAINTEXT.equals(qName)) {
                string = "text/plain";
            } else if (Constants.MIME_MULTIPART.equals(qName)) {
                string = "multipart/*";
            } else if (Constants.MIME_SOURCE.equals(qName)) {
                string = "text/xml";
            } else if (Constants.MIME_OCTETSTREAM.equals(qName)) {
                string = "application/octet-stream";
            } else if (Constants.MIME_DATA_HANDLER.equals(qName)) {
                string = "application/octet-stream";
            }
            return string;
        }
        return null;
    }

    public static DataHandler dataHandlerForObject(String string, Object object) throws SOAPException {
        Object object2 = null;
        if (object instanceof DataHandler) {
            return (DataHandler)object;
        }
        if (string != null) {
            if (object instanceof Image && string.startsWith("image/")) {
                object2 = new ImageDataSource("image", string, (Image)object);
            } else if (object instanceof String && string.equals("text/plain")) {
                object2 = new PlainTextDataSource("plainText", (String)object);
            } else if (object instanceof MimeMultipart && string.startsWith("multipart/")) {
                object2 = new MimeMultipartDataSource("multipart", (MimeMultipart)object);
            } else if (object instanceof StreamSource && (string.equals("application/xml") || string.equals("text/xml"))) {
                object2 = new SourceDataSource("source", string, (StreamSource)object);
            }
        }
        if (object2 == null) {
            throw new SOAPException(Messages.getMessage("mimeObjectClash00", string, object.getClass().toString()));
        }
        return new DataHandler(object2);
    }

    public static Object objectForDataHandler(DataHandler dataHandler) {
        String string = dataHandler.getContentType();
        JAFDataHandlerDeserializer jAFDataHandlerDeserializer = null;
        if (string != null) {
            if (string.startsWith("image/")) {
                jAFDataHandlerDeserializer = new ImageDataHandlerDeserializer(null, null);
            } else if (string.equals("text/plain")) {
                jAFDataHandlerDeserializer = new PlainTextDataHandlerDeserializer(null, null);
            } else if (string.startsWith("multipart/")) {
                jAFDataHandlerDeserializer = new MimeMultipartDataHandlerDeserializer(null, null);
            } else if (string.equals("application/xml") || string.equals("text/xml")) {
                jAFDataHandlerDeserializer = new SourceDataHandlerDeserializer(null, null);
            }
        }
        return jAFDataHandlerDeserializer == null ? dataHandler : jAFDataHandlerDeserializer.makeValue(dataHandler);
    }
}

