/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.enabler;

import com.ibm.ejs.models.base.bindings.applicationbnd.ApplicationbndFactory;
import com.ibm.ejs.models.base.bindings.applicationbnd.AuthorizationTable;
import com.ibm.ejs.models.base.bindings.applicationbnd.RoleAssignment;
import com.ibm.ejs.models.base.bindings.ejbbnd.EjbbndFactory;
import com.ibm.ejs.models.base.bindings.ejbbnd.MessageDrivenBeanBinding;
import com.ibm.ejs.models.base.bindings.webappbnd.WebAppBinding;
import com.ibm.ejs.models.base.extensions.webappext.WebAppExtension;
import com.ibm.etools.application.Application;
import com.ibm.etools.application.WebModule;
import com.ibm.etools.commonarchive.CommonarchiveFactory;
import com.ibm.etools.commonarchive.EARFile;
import com.ibm.etools.commonarchive.EJBJarFile;
import com.ibm.etools.commonarchive.WARFile;
import com.ibm.etools.ejb.ActivationConfig;
import com.ibm.etools.ejb.ActivationConfigProperty;
import com.ibm.etools.ejb.AssemblyDescriptor;
import com.ibm.etools.ejb.DestinationType;
import com.ibm.etools.ejb.EJBJar;
import com.ibm.etools.ejb.EjbFactory;
import com.ibm.etools.ejb.EnterpriseBean;
import com.ibm.etools.ejb.MessageDriven;
import com.ibm.etools.ejb.MessageDrivenDestination;
import com.ibm.etools.ejb.MethodPermission;
import com.ibm.etools.ejb.TransactionType;
import com.ibm.etools.j2ee.common.CommonFactory;
import com.ibm.etools.j2ee.common.SecurityRole;
import com.ibm.etools.j2ee.commonarchivecore.ModuleFile;
import com.ibm.etools.j2ee.commonarchivecore.helpers.ArchiveManifest;
import com.ibm.etools.j2ee.commonarchivecore.strategy.LoadStrategy;
import com.ibm.etools.webapplication.AuthConstraint;
import com.ibm.etools.webapplication.HTTPMethodTypeEnum;
import com.ibm.etools.webapplication.SecurityConstraint;
import com.ibm.etools.webapplication.Servlet;
import com.ibm.etools.webapplication.ServletType;
import com.ibm.etools.webapplication.TransportGuaranteeType;
import com.ibm.etools.webapplication.UserDataConstraint;
import com.ibm.etools.webapplication.WebApp;
import com.ibm.etools.webapplication.WebResourceCollection;
import com.ibm.etools.webapplication.WebType;
import com.ibm.etools.webapplication.WebapplicationFactory;
import com.ibm.etools.webservice.wsbnd.RouterModule;
import com.ibm.etools.webservice.wsbnd.WSBinding;
import com.ibm.etools.webservice.wsdd.PortComponent;
import com.ibm.etools.webservice.wsdd.ServiceImplBean;
import com.ibm.etools.webservice.wsdd.WebServiceDescription;
import com.ibm.etools.webservice.wsdd.WebServices;
import com.ibm.ws.webservices.Version;
import com.ibm.ws.webservices.WSModels;
import com.ibm.ws.webservices.enabler.ClientTraceEnabler;
import com.ibm.ws.webservices.enabler.HTTPRouterDescriptor;
import com.ibm.ws.webservices.enabler.JMSRouterDescriptor;
import com.ibm.ws.webservices.enabler.Utils;
import com.ibm.ws.webservices.enabler.resources.Messages;
import com.ibm.ws.webservices.tools.resource.DefaultToolEnv;
import com.ibm.ws.webservices.tools.resource.ToolEnv;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jem.java.JavaClass;
import org.eclipse.jem.java.impl.JavaClassImpl;

public class EndpointEnabler {
    private static String binaryCopyright = Version.getBinaryCopyright();
    private BufferedReader stdin = null;
    private String earFileName = null;
    private boolean verbose = false;
    private boolean quiet = false;
    private boolean interactive = false;
    private boolean enableHttpRouterSecurity = false;
    private ArrayList routerModuleTransportList = null;
    private Properties props = null;
    private CommonarchiveFactory archiveFactory = null;
    private int moduleCount = 0;
    private boolean forWSAD = false;
    private HashMap defaultModuleSuffixes = null;
    private Vector httpRouters = null;
    private Vector jmsRouters = null;
    private Hashtable wsBindings = null;
    private HashMap listenerPortModuleMap = new HashMap();
    private static EjbFactory ejbFactory = null;
    private static EjbbndFactory ejbbndFactory = null;
    private static CommonFactory commonFactory = null;
    private static WebapplicationFactory webappFactory = null;
    private static ApplicationbndFactory appBndFactory = null;
    private static ToolEnv env = null;
    public static final String PRP_VERBOSE = "verbose";
    public static final String PRP_QUIET = "quiet";
    public static final String PRP_DEFAULTTRANSPORTS = "defaultTransports";
    public static final String PRP_ROUTERNAME = ".routerModuleName";
    public static final String PRP_CONTEXTROOT = ".contextRoot";
    public static final String PRP_SKIP = ".skip";
    public static final String PRP_TRANSPORTS = ".transports";
    public static final String PRP_DESTINATIONTYPE = ".destinationType";
    public static final String PRP_DEFAULTDESTTYPE = ".defaultDestinationType";
    public static final String PRP_ROUTERNAMESUFFIX = ".routerModuleNameSuffix";
    public static final String PRP_ENABLEHTTPROUTERSECURITY = "http.enableRouterSecurity";
    public static final String PRP_LPNAME = ".listenerInputPortName";
    public static final String PRP_ASNAME = ".activationSpecJndiName";
    public static final String WS_SERVERBND_XMLFILE = "ibm-webservices-bnd.xml";
    public static final String WAR_EXTENSION = ".war";
    public static final String JAR_EXTENSION = ".jar";
    public static final String TRANSPORT_HTTP = "http";
    public static final String TRANSPORT_JMS = "jms";
    public static final String HTTPROUTER_SUFFIX = "_HTTPRouter";
    public static final String JMSROUTER_SUFFIX = "_JMSRouter";
    public static final String DESTINATION_TYPE_QUEUE = "queue";
    public static final String DESTINATION_TYPE_TOPIC = "topic";
    public static final String DEFAULT_JMS_DESTINATION_TYPE = "queue";
    public static final String DESTINATION_TYPE_QUEUE_CLASS = "javax.jms.Queue";
    public static final String DESTINATION_TYPE_TOPIC_CLASS = "javax.jms.Topic";
    private static final String SERVLET_CLASS_NAME = "com.ibm.ws.webservices.engine.transport.http.WebServicesServlet";
    private static final String SERVLET_ULR_PATTERN_ROOT = "services";
    private static final String JMS_ROUTER_MDB_NAME = "WebServicesJMSRouter";
    private static final String JMS_ROUTER_MDB_CLASSNAME = "com.ibm.ws.webservices.engine.transport.jms.JMSListenerMDB";
    public static final String JMS_MESSAGE_LISTENER_CLASS = "javax.jms.MessageListener";
    public static final String JMS_CONFIG_PROP_NAME = "destinationType";
    public static final String JMS_DESCRIPTION = "QueueConnectionFactory used by the MDB for replies";
    private static final String HTTP_ROUTER_SECURITY_ROLE_NAME = "AuthenticatedWebServicesUsers";
    private static final String HTTP_ROUTER_AUTH_NAME = "AllAuthenticatedUsers";

    public static void main(String[] stringArray) throws Exception {
        env = DefaultToolEnv.create();
        Properties properties = new Properties();
        String string = null;
        boolean bl = false;
        BufferedReader bufferedReader = null;
        System.out.println();
        System.out.println(Messages.getString("enabler.ibmbanner", "IBM WebSphere Application Server Release 6"));
        System.out.println(Messages.getString("enabler.soapbanner", "Web Services Enterprise Archive Endpoint Enabler Tool."));
        System.out.println(Messages.getString("enabler.copyright", "(C) COPYRIGHT International Business Machines Corp. 1997, 2004"));
        try {
            stringArray = ClientTraceEnabler.parseTraceOptions(stringArray);
        }
        catch (Exception exception) {
            return;
        }
        try {
            Object object;
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i].startsWith("-")) {
                    Object[] objectArray;
                    object = stringArray[i].substring(1);
                    if (((String)object).equals("?") || ((String)object).equalsIgnoreCase("h") || ((String)object).equalsIgnoreCase("help")) {
                        EndpointEnabler.printUsage();
                        return;
                    }
                    if (((String)object).equalsIgnoreCase("v") || ((String)object).equalsIgnoreCase(PRP_VERBOSE)) {
                        properties.setProperty(PRP_VERBOSE, "true");
                        bl = true;
                        continue;
                    }
                    if (((String)object).equalsIgnoreCase("q") || ((String)object).equalsIgnoreCase(PRP_QUIET)) {
                        properties.setProperty(PRP_QUIET, "true");
                        continue;
                    }
                    if (((String)object).equalsIgnoreCase("t") || ((String)object).equalsIgnoreCase("transport") || ((String)object).equalsIgnoreCase("transports")) {
                        if (++i >= stringArray.length) {
                            throw new Exception(Messages.getString("enabler.missing_transport", "Missing value for '-transport' parameter."));
                        }
                        properties.setProperty(PRP_DEFAULTTRANSPORTS, stringArray[i]);
                        continue;
                    }
                    if (((String)object).equalsIgnoreCase("p") || ((String)object).equalsIgnoreCase("properties")) {
                        if (++i >= stringArray.length) {
                            throw new Exception(Messages.getString("enabler.missing_properties", "Missing value for '-properties' parameter."));
                        }
                        objectArray = new FileInputStream(stringArray[i]);
                        properties.load((InputStream)objectArray);
                        objectArray.close();
                        if (!bl) continue;
                        Object[] objectArray2 = new String[]{stringArray[i]};
                        System.out.println(Messages.getFormattedMessage("enabler.read_properties", objectArray2, "Read properties from file: {0}"));
                        continue;
                    }
                    if (((String)object).equalsIgnoreCase("enableHttpRouterSecurity")) {
                        properties.setProperty(PRP_ENABLEHTTPROUTERSECURITY, "true");
                        continue;
                    }
                    objectArray = new String[]{stringArray[i]};
                    throw new Exception(Messages.getFormattedMessage("enabler.unrecognized_parameter", objectArray, "ERROR: unrecognized command-line parameter found: {0}"));
                }
                string = stringArray[i];
            }
            EndpointEnabler endpointEnabler = new EndpointEnabler();
            if (string == null || string.equals("")) {
                object = new InputStreamReader(System.in);
                bufferedReader = new BufferedReader((Reader)object);
                endpointEnabler.setInputSource(bufferedReader);
                string = Utils.getReadFileInput(bufferedReader, Messages.getString("enabler.earfilename", "Please enter the name of your EAR file: ")).getPath();
            }
            Utils.backupEar(string);
            endpointEnabler.enableEarFile(string, properties);
        }
        catch (Exception exception) {
            System.out.println(Messages.getMessage("enabler.failed.error", exception.getMessage()));
            return;
        }
    }

    public EndpointEnabler() {
        this.defaultModuleSuffixes = new HashMap();
        this.defaultModuleSuffixes.put(TRANSPORT_HTTP, HTTPROUTER_SUFFIX);
        this.defaultModuleSuffixes.put(TRANSPORT_JMS, JMSROUTER_SUFFIX);
    }

    public void setInputSource(BufferedReader bufferedReader) {
        this.stdin = bufferedReader;
        this.interactive = bufferedReader != null;
    }

    private void processGlobalProperties(Properties properties) throws Exception {
        if (this.props != null) {
            return;
        }
        this.props = properties;
        String string = this.props.getProperty(PRP_VERBOSE, "");
        if (string.equalsIgnoreCase("true")) {
            this.verbose = true;
        }
        if ((string = this.props.getProperty(PRP_QUIET, "")).equalsIgnoreCase("true")) {
            this.quiet = true;
        }
        if ((string = this.props.getProperty(PRP_DEFAULTTRANSPORTS, "")).length() > 0) {
            this.routerModuleTransportList = this.getTransportsListFromString(string);
        }
        if ((string = this.props.getProperty(PRP_ENABLEHTTPROUTERSECURITY, "")).equalsIgnoreCase("true")) {
            this.enableHttpRouterSecurity = true;
        }
        if (this.quiet) {
            this.verbose = false;
        }
        if (this.verbose) {
            env.report(Messages.getString("enabler.display_properties", "The endpoint enabler is using the following properties:"));
            Enumeration<Object> enumeration = this.props.keys();
            while (enumeration.hasMoreElements()) {
                String string2 = (String)enumeration.nextElement();
                env.report("\t" + string2 + ": " + this.props.getProperty(string2));
            }
            env.report(null);
        }
    }

    private ArrayList getTransportsListFromString(String string) throws Exception {
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ;,:");
        ArrayList<String> arrayList = new ArrayList<String>();
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (!string2.equals(TRANSPORT_HTTP) && !string2.equals(TRANSPORT_JMS)) {
                Object[] objectArray = new String[]{string2};
                throw new Exception(Messages.getFormattedMessage("enabler.bad_transport", objectArray, "Unrecognized transport: {0}"));
            }
            arrayList.add(string2);
        }
        return arrayList;
    }

    public void enableEarFile(String string, Properties properties) throws Exception {
        Object[] objectArray;
        Object[] objectArray2;
        this.checkEnv();
        if (string == null || string.equals("")) {
            throw new Exception(Messages.getString("enabler.missing_ear", "'EAR filename' parameter is missing or empty."));
        }
        if (properties == null) {
            throw new Exception(Messages.getString("enabler.missing_props", "'props' parameter is missing."));
        }
        this.earFileName = string;
        this.processGlobalProperties(properties);
        this.archiveFactory = Utils.getArchiveFactory();
        LoadStrategy loadStrategy = this.archiveFactory.createLoadStrategy(this.earFileName);
        if (!this.quiet) {
            objectArray2 = new String[]{this.earFileName};
            env.report(Messages.getFormattedMessage("enabler.load_ear", objectArray2, "Loading EAR file: {0}"));
        }
        objectArray2 = this.archiveFactory.openEARFile(loadStrategy, this.earFileName);
        this.enableEarFile((EARFile)objectArray2, properties);
        if (this.isModified()) {
            objectArray = new String[]{this.earFileName};
            env.report(Messages.getFormattedMessage("enabler.saving_ear", objectArray, "Saving EAR file {0}..."));
            objectArray2.saveNoReopen();
            env.report(Messages.getFormattedMessage("enabler.save_finished", null, "Finished saving the EAR file."));
            this.clearModuleCount();
        }
        objectArray2.close();
        objectArray = new String[]{this.earFileName};
        env.report(Messages.getFormattedMessage("enabler.finished", objectArray, "Finished processing EAR file {0}."));
    }

    public void enableEarFile(EARFile eARFile, Properties properties) throws Exception {
        this.checkEnv();
        if (this.archiveFactory == null) {
            this.archiveFactory = Utils.getArchiveFactory();
        }
        this.clearModuleCount();
        this.processGlobalProperties(properties);
        List list = eARFile.getEJBJarFiles();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            EJBJarFile eJBJarFile = (EJBJarFile)iterator.next();
            Object[] objectArray = new String[]{eJBJarFile.getName()};
            if (!this.quiet) {
                env.report(Messages.getFormattedMessage("enabler.found_ejb", objectArray, "Found EJB Module: {0}"));
            }
            this.enableEJBJar(eARFile, eJBJarFile);
        }
    }

    private void clearModuleCount() {
        this.moduleCount = 0;
    }

    public boolean isModified() {
        return this.moduleCount > 0;
    }

    private boolean containsWebService(EJBJarFile eJBJarFile) throws Exception {
        WebServices webServices = Utils.getWebServices(eJBJarFile);
        return webServices != null;
    }

    public void enableEJBJar(EARFile eARFile, EJBJarFile eJBJarFile, Properties properties) throws Exception {
        this.checkEnv();
        if (this.archiveFactory == null) {
            this.archiveFactory = Utils.getArchiveFactory();
        }
        this.clearModuleCount();
        this.processGlobalProperties(properties);
        this.enableEJBJar(eARFile, eJBJarFile);
    }

    private void enableEJBJar(EARFile eARFile, EJBJarFile eJBJarFile) throws Exception {
        if (this.containsWebService(eJBJarFile)) {
            Object[] objectArray;
            if (this.verbose) {
                objectArray = new String[]{eJBJarFile.getName()};
                env.report(Messages.getFormattedMessage("enabler.enabling_ejb", objectArray, "Enabling EJB Module {0}..."));
            }
            objectArray = this.routersNeeded(eJBJarFile);
            for (int i = 0; i < objectArray.size(); ++i) {
                this.addRouterModule(eARFile, eJBJarFile, (String)objectArray.get(i));
            }
            if (this.verbose) {
                Object[] objectArray2 = new String[]{eJBJarFile.getName()};
                env.report(Messages.getFormattedMessage("enabler.finished_enabling_ejb", objectArray2, "Finished enabling EJB Module {0}."));
            }
        } else if (!this.quiet) {
            Object[] objectArray = new String[]{eJBJarFile.getName()};
            env.report(Messages.getFormattedMessage("enabler.skipping_ejb", objectArray, "Skipping EJB Module {0} since it contains no web services."));
        }
    }

    private ArrayList routersNeeded(EJBJarFile eJBJarFile) throws Exception {
        ArrayList arrayList = null;
        String string = this.getModuleBaseName(eJBJarFile);
        String string2 = string + PRP_TRANSPORTS;
        String string3 = this.props.getProperty(string2, "");
        if (string3.length() > 0) {
            arrayList = this.getTransportsListFromString(string3);
        } else if (this.routerModuleTransportList != null && this.routerModuleTransportList.size() > 0) {
            arrayList = this.routerModuleTransportList;
        } else {
            arrayList = new ArrayList();
            arrayList.add(TRANSPORT_HTTP);
        }
        return arrayList;
    }

    private void addRouterModule(EARFile eARFile, EJBJarFile eJBJarFile, String string) throws Exception {
        WSBinding wSBinding = Utils.getWSBinding(eJBJarFile);
        if (this.containsRouterModule(eARFile, eJBJarFile, wSBinding, string)) {
            if (!this.quiet) {
                Object[] objectArray = new String[]{string, eJBJarFile.getName()};
                env.report(Messages.getFormattedMessage("enabler.ejb_already_enabled", objectArray, "Skipping {0} router module for EJB Module {1} since it already contains a router for this transport."));
            }
        } else {
            if (wSBinding == null) {
                wSBinding = Utils.createWSBinding(eJBJarFile);
                if (this.forWSAD) {
                    this.wsBindings.put(eJBJarFile.getOriginalURI(), wSBinding);
                }
            }
            if (string.equals(TRANSPORT_HTTP)) {
                this.addHTTPRouterModule(eARFile, eJBJarFile, wSBinding);
            } else if (string.equals(TRANSPORT_JMS)) {
                this.addJMSRouterModule(eARFile, eJBJarFile, wSBinding);
            }
        }
    }

    private boolean containsRouterModule(EARFile eARFile, EJBJarFile eJBJarFile, WSBinding wSBinding, String string) {
        if (wSBinding != null) {
            Iterator iterator = wSBinding.getRouterModules().iterator();
            while (iterator.hasNext()) {
                RouterModule routerModule = (RouterModule)iterator.next();
                if (!this.forWSAD && !eARFile.containsFile(routerModule.getName())) {
                    iterator.remove();
                    continue;
                }
                if (!routerModule.getTransport().equals(string)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean shouldSkipRouter(String string, String string2) {
        boolean bl = false;
        String string3 = string + "." + string2 + PRP_SKIP;
        String string4 = this.props.getProperty(string3, "false");
        if (string4.equalsIgnoreCase("true")) {
            bl = true;
        }
        return bl;
    }

    private String getModuleBaseName(EJBJarFile eJBJarFile) {
        String string = eJBJarFile.getOriginalURI();
        if (!string.endsWith(JAR_EXTENSION)) {
            return string;
        }
        int n = string.indexOf(JAR_EXTENSION);
        String string2 = string.substring(0, n);
        return string2;
    }

    private void addHTTPRouterModule(EARFile eARFile, EJBJarFile eJBJarFile, WSBinding wSBinding) throws Exception {
        Object[] objectArray;
        Object[] objectArray2;
        String string = this.getModuleBaseName(eJBJarFile);
        if (this.shouldSkipRouter(string, TRANSPORT_HTTP)) {
            if (!this.quiet) {
                Object[] objectArray3 = new String[]{TRANSPORT_HTTP, eJBJarFile.getName()};
                env.report(Messages.getFormattedMessage("enabler.skipping_router", objectArray3, "Skipping {0} router module for EJB Module {1} due to 'skip' property."));
            }
            return;
        }
        ++this.moduleCount;
        String string2 = this.getRouterName(string, TRANSPORT_HTTP, WAR_EXTENSION);
        String string3 = this.getHTTPContextRoot(string, TRANSPORT_HTTP);
        if (!this.quiet) {
            objectArray2 = new String[]{TRANSPORT_HTTP, eJBJarFile.getName()};
            env.report(Messages.getFormattedMessage("enabler.adding_router", objectArray2, "Adding {0} router module for EJB Module {1}."));
        }
        if (this.verbose) {
            objectArray2 = new String[]{string2};
            env.report(Messages.getFormattedMessage("enabler.router_name", objectArray2, "Router name: {0}"));
            objectArray = new String[]{string3};
            env.report(Messages.getFormattedMessage("enabler.context_root", objectArray, "Context root: {0}"));
        }
        objectArray2 = this.getPortComponentNamesFromModule(eJBJarFile);
        objectArray = new HTTPRouterDescriptor(string2, string3, (List)objectArray2, eJBJarFile.getName());
        objectArray.addClassPathEntry(eJBJarFile.getURI());
        Utils.addRouterToWSBinding(wSBinding, string2, TRANSPORT_HTTP);
        WARFile wARFile = this.createModule((HTTPRouterDescriptor)objectArray, eARFile, eJBJarFile);
        if (this.forWSAD) {
            objectArray.setRouterModule(wARFile);
            this.httpRouters.add(objectArray);
        } else {
            eARFile.addCopy((ModuleFile)wARFile);
            Application application = eARFile.getDeploymentDescriptor();
            WebModule webModule = (WebModule)application.getFirstModule(objectArray.getTargetURI());
            webModule.setContextRoot(objectArray.getContextRoot());
        }
    }

    private void addJMSRouterModule(EARFile eARFile, EJBJarFile eJBJarFile, WSBinding wSBinding) throws Exception {
        EJBJarFile eJBJarFile2;
        Object[] objectArray;
        String string = this.getModuleBaseName(eJBJarFile);
        if (this.shouldSkipRouter(string, TRANSPORT_JMS)) {
            if (!this.quiet) {
                Object[] objectArray2 = new String[]{TRANSPORT_JMS, eJBJarFile.getName()};
                env.report(Messages.getFormattedMessage("enabler.skipping_router", objectArray2, "Skipping {0} router module for EJB Module {1} due to 'skip' property."));
            }
            return;
        }
        ++this.moduleCount;
        String string2 = this.getRouterName(string, TRANSPORT_JMS, JAR_EXTENSION);
        String string3 = this.getActivationSpecJNDIName(string, TRANSPORT_JMS);
        String string4 = this.getJMSListenerInputPortName(string, TRANSPORT_JMS);
        String string5 = this.getJMSDestinationType(string, TRANSPORT_JMS);
        if (!this.quiet) {
            objectArray = new String[]{TRANSPORT_JMS, eJBJarFile.getName()};
            env.report(Messages.getFormattedMessage("enabler.adding_router", objectArray, "Adding {0} router module for EJB Module {1}."));
        }
        if (this.verbose) {
            objectArray = new String[]{string2};
            env.report(Messages.getFormattedMessage("enabler.router_name", objectArray, "Router name: {0}"));
            eJBJarFile2 = new EJBJarFile[]{string3};
            env.report(Messages.getFormattedMessage("enabler.activation_spec", (Object[])eJBJarFile2, "Activation Spec JNDI Name: {0}"));
            Object[] objectArray3 = new String[]{string4};
            env.report(Messages.getFormattedMessage("enabler.listener_port", objectArray3, "Listener Input Port Name: {0}"));
            Object[] objectArray4 = new String[]{string5};
            env.report(Messages.getFormattedMessage("enabler.destination_type", objectArray4, "Destination type: {0}"));
        }
        objectArray = new JMSRouterDescriptor(string2, string3, string4, string5, eJBJarFile.getName());
        objectArray.addClassPathEntry(eJBJarFile.getURI());
        Utils.addRouterToWSBinding(wSBinding, string2, TRANSPORT_JMS);
        eJBJarFile2 = this.createModule((JMSRouterDescriptor)objectArray, eARFile, eJBJarFile);
        if (this.forWSAD) {
            objectArray.setRouterModule(eJBJarFile2);
            this.jmsRouters.add(objectArray);
        } else {
            eARFile.addCopy((ModuleFile)eJBJarFile2);
        }
    }

    private String getRouterName(String string, String string2, String string3) throws Exception {
        Object[] objectArray;
        String string4 = string + "." + string2 + PRP_ROUTERNAME;
        String string5 = this.props.getProperty(string4, null);
        if (string5 == null) {
            string4 = string2 + PRP_ROUTERNAMESUFFIX;
            objectArray = this.props.getProperty(string4, null);
            if (objectArray == null) {
                objectArray = (String)this.defaultModuleSuffixes.get(string2);
            }
            string5 = string + (String)objectArray + string3;
        }
        if (this.interactive) {
            env.report(null);
            objectArray = new String[]{string2, string, string5};
            String string6 = Messages.getFormattedMessage("enabler.router_name_prompt", objectArray, "Enter {0} router name for EJB Module {1} [{2}]: ");
            String string7 = Utils.getStringInputWithDefaults(this.stdin, string6);
            if (!string7.equals("")) {
                string5 = string7;
            }
        }
        if (!string5.endsWith(string3)) {
            string5 = string5 + string3;
        }
        return string5;
    }

    private String getHTTPContextRoot(String string, String string2) throws Exception {
        String string3 = string + "." + string2 + PRP_CONTEXTROOT;
        String string4 = this.props.getProperty(string3, null);
        if (string4 == null) {
            string4 = "/" + string;
        }
        if (this.interactive) {
            env.report(null);
            Object[] objectArray = new String[]{string2, string, string4};
            String string5 = Messages.getFormattedMessage("enabler.context_root_prompt", objectArray, "Enter {0} context root for EJB Module {1} [{2}]: ");
            String string6 = Utils.getStringInputWithDefaults(this.stdin, string5);
            if (!string6.equals("")) {
                string4 = string6;
            }
        }
        return string4;
    }

    private String getActivationSpecJNDIName(String string, String string2) throws Exception {
        String string3 = string + "." + string2 + PRP_ASNAME;
        String string4 = this.props.getProperty(string3, null);
        if (this.interactive) {
            env.report(null);
            Object[] objectArray = new String[]{string2, string, string4};
            String string5 = Messages.getFormattedMessage("enabler.asname_prompt", objectArray, "Enter {0} Activation Spec Jndi name for EJB Module {1} [{2}]: ");
            String string6 = Utils.getStringInputWithDefaults(this.stdin, string5);
            if (!string6.equals("")) {
                string4 = string6;
            }
        }
        return string4;
    }

    private String getJMSListenerInputPortName(String string, String string2) throws Exception {
        String string3 = string + "." + string2 + PRP_LPNAME;
        String string4 = this.props.getProperty(string3, null);
        if (this.interactive) {
            env.report(null);
            Object[] objectArray = new String[]{string2, string, string4};
            String string5 = Messages.getFormattedMessage("enabler.lpname_prompt", objectArray, "Enter {0} listener input port name for EJB Module {1} [{2}]: ");
            String string6 = Utils.getStringInputWithDefaults(this.stdin, string5);
            if (!string6.equals("")) {
                string4 = string6;
            }
        }
        return string4;
    }

    private String getJMSDestinationType(String string, String string2) throws Exception {
        String string3;
        Object[] objectArray;
        String string4 = string + "." + string2 + PRP_DESTINATIONTYPE;
        String string5 = this.props.getProperty(string4, null);
        if (string5 == null) {
            string4 = string2 + PRP_DEFAULTDESTTYPE;
            string5 = this.props.getProperty(string4, null);
        }
        if (string5 == null) {
            string5 = "queue";
        }
        if (this.interactive) {
            env.report(null);
            objectArray = new String[]{string2, string, string5};
            string3 = Messages.getFormattedMessage("enabler.destination_type_prompt", objectArray, "Enter {0} destination type for EJB Module {1} [{2}]: ");
            String string6 = Utils.getStringInputWithDefaults(this.stdin, string3);
            if (!string6.equals("")) {
                string5 = string6;
            }
        }
        if (!string5.equals("queue") && !string5.equals(DESTINATION_TYPE_TOPIC)) {
            objectArray = new String[]{string5};
            string3 = Messages.getFormattedMessage("enabler.invalid_destination_type", objectArray, "Invalid destination type specified: {0}");
            throw new Exception(string3);
        }
        return string5;
    }

    private List getPortComponentNamesFromModule(EJBJarFile eJBJarFile) throws Exception {
        ArrayList<String> arrayList = new ArrayList<String>();
        WebServices webServices = Utils.getWebServices(eJBJarFile);
        if (webServices == null) {
            Object[] objectArray = new String[]{"META-INF/webservices.xml", eJBJarFile.getName()};
            String string = Messages.getFormattedMessage("enabler.ddloaderr", objectArray, "Error loading the JSR 109 deployment descriptor {0} for EJB Module {1}.");
            env.reporterr(string);
            throw new IOException(string);
        }
        Iterator iterator = webServices.getWebServiceDescriptions().iterator();
        while (iterator.hasNext()) {
            WebServiceDescription webServiceDescription = (WebServiceDescription)iterator.next();
            if (webServiceDescription == null) continue;
            Iterator iterator2 = webServiceDescription.getPortComponents().iterator();
            while (iterator2.hasNext()) {
                PortComponent portComponent = (PortComponent)iterator2.next();
                String string = portComponent.getPortComponentName();
                arrayList.add(string);
            }
        }
        return arrayList;
    }

    public void setToolEnv(ToolEnv toolEnv) {
        env = toolEnv;
    }

    public void setArchiveFactory(CommonarchiveFactory commonarchiveFactory) {
        this.archiveFactory = commonarchiveFactory;
    }

    public ToolEnv getToolEnv() {
        return env;
    }

    private void checkEnv() {
        if (env == null) {
            env = DefaultToolEnv.create();
        }
    }

    private static void printUsage() {
        String string = Messages.getMessage("clienttrace.trace_options", "");
        String string2 = "Usage syntax:  endptEnabler [options] [trace options] [<ear-file-name>]";
        Object[] objectArray = new String[]{string};
        env.report(null);
        env.report(Messages.getFormattedMessage("enabler.usage_syntax", objectArray, string2));
    }

    private WARFile createModule(HTTPRouterDescriptor hTTPRouterDescriptor, EARFile eARFile, EJBJarFile eJBJarFile) throws Exception {
        Object object;
        String string;
        Servlet servlet;
        String string2;
        WARFile wARFile = this.archiveFactory.createWARFileInitialized(hTTPRouterDescriptor.getTargetURI());
        wARFile.setJ2EEVersion(eARFile.getSpecVersionID());
        ArchiveManifest archiveManifest = wARFile.getManifest();
        archiveManifest.setManifestVersion("1.0");
        archiveManifest.setClassPath(hTTPRouterDescriptor.getClassPath());
        WebApp webApp = wARFile.getDeploymentDescriptor();
        Object[] objectArray = new String[]{"HTTP", hTTPRouterDescriptor.getEjbJarName()};
        webApp.setDisplayName(Messages.getFormattedMessage("enabler.routerDisplayName", objectArray, "{0} router for {1}"));
        EList eList = webApp.getServlets();
        EList eList2 = webApp.getServletMappings();
        WebAppBinding webAppBinding = hTTPRouterDescriptor.getPortComponentNames().iterator();
        while (webAppBinding.hasNext()) {
            string2 = (String)webAppBinding.next();
            servlet = webappFactory.createServlet();
            servlet.setWebApp(webApp);
            servlet.setServletName(string2);
            string = Messages.getFormattedMessage("enabler.servletDisplayNamePrefix", new Object[]{string2}, "Web Services Router servlet for port-component {0}");
            servlet.setDisplayName(string);
            ServletType servletType = webappFactory.createServletType();
            servletType.setClassName(SERVLET_CLASS_NAME);
            servlet.setWebType((WebType)servletType);
            object = webappFactory.createServletMapping();
            object.setServlet(servlet);
            object.setUrlPattern("services/" + string2);
            eList.add((Object)servlet);
            eList2.add(object);
        }
        wARFile.setDeploymentDescriptor(webApp);
        webAppBinding = wARFile.getBindings();
        webAppBinding.setVirtualHostName("default_host");
        wARFile.setBindings(webAppBinding);
        string2 = wARFile.getExtensions();
        string2.setReloadInterval(3);
        string2.setReloadingEnabled(false);
        string2.setDirectoryBrowsingEnabled(false);
        string2.setFileServingEnabled(false);
        string2.setServeServletsByClassnameEnabled(false);
        string2.setPreCompileJSPs(false);
        wARFile.setExtensions((WebAppExtension)string2);
        servlet = eJBJarFile.getDeploymentDescriptor();
        string = eARFile.getBindings();
        boolean bl = this.ejbJarContainsProtectedEJB((EJBJar)servlet);
        if (bl && !this.enableHttpRouterSecurity) {
            object = "EJB jar {0} contains protected EJBs, yet the -enableHttpRouterSecurity option was not specified, so the resulting HTTP router module, {1}, will not include security information.";
            Object[] objectArray2 = new String[]{hTTPRouterDescriptor.getEjbJarName(), hTTPRouterDescriptor.getTargetURI()};
            env.report(Messages.getFormattedMessage("enabler.security_warning_1", objectArray2, (String)object));
        } else if (!bl && this.enableHttpRouterSecurity) {
            object = "The -enableHttpRouterSecurity option was specified, yet the EJB jar {0} contains at least one unprotected EJB or the existing security information is incomplete.  Therefore, security information will not be added to the {1} HTTP router module.";
            Object[] objectArray3 = new String[]{hTTPRouterDescriptor.getEjbJarName(), hTTPRouterDescriptor.getTargetURI()};
            env.report(Messages.getFormattedMessage("enabler.security_warning_2", objectArray3, (String)object));
        } else if (bl && this.enableHttpRouterSecurity) {
            EnterpriseBean enterpriseBean;
            String string3;
            SecurityConstraint securityConstraint;
            AuthorizationTable authorizationTable;
            object = eARFile.getDeploymentDescriptor();
            SecurityRole securityRole = object.getSecurityRoleNamed(HTTP_ROUTER_SECURITY_ROLE_NAME);
            if (securityRole == null) {
                securityRole = commonFactory.createSecurityRole();
                securityRole.setRoleName(HTTP_ROUTER_SECURITY_ROLE_NAME);
                authorizationTable = object.getSecurityRoles();
                authorizationTable.add((Object)securityRole);
            }
            if ((authorizationTable = string.getAuthorizationTable()) == null) {
                authorizationTable = appBndFactory.createAuthorizationTable();
                string.setAuthorizationTable(authorizationTable);
            }
            EList eList3 = authorizationTable.getAuthorizations();
            RoleAssignment roleAssignment = null;
            boolean bl2 = true;
            Iterator iterator = eList3.iterator();
            while (bl2 && iterator.hasNext()) {
                roleAssignment = (RoleAssignment)iterator.next();
                if (roleAssignment.getRole() != securityRole) continue;
                bl2 = false;
            }
            if (bl2) {
                roleAssignment = appBndFactory.createRoleAssignment();
                roleAssignment.setRole(securityRole);
                iterator = appBndFactory.createAllAuthenticatedUsers();
                iterator.setName(HTTP_ROUTER_AUTH_NAME);
                securityConstraint = roleAssignment.getSpecialSubjects();
                securityConstraint.add((Object)iterator);
                eList3.add((Object)roleAssignment);
            }
            iterator = webApp.getConstraints();
            securityConstraint = webappFactory.createSecurityConstraint();
            AuthConstraint authConstraint = webappFactory.createAuthConstraint();
            EList eList4 = authConstraint.getRoles();
            eList4.add((Object)HTTP_ROUTER_SECURITY_ROLE_NAME);
            securityConstraint.setAuthConstraint(authConstraint);
            UserDataConstraint userDataConstraint = webappFactory.createUserDataConstraint();
            userDataConstraint.setTransportGuarantee(TransportGuaranteeType.NONE_LITERAL);
            securityConstraint.setUserDataConstraint(userDataConstraint);
            WebResourceCollection webResourceCollection = webappFactory.createWebResourceCollection();
            String string4 = "WebResourceCollection_for_" + hTTPRouterDescriptor.getTargetURI();
            webResourceCollection.setWebResourceName(string4);
            String string5 = webApp.getVersion();
            if (string5.equals("2.4")) {
                webResourceCollection.getHttpMethod().add((Object)HTTPMethodTypeEnum.get((int)1));
            } else {
                webResourceCollection.addHTTP("POST");
            }
            WebServices webServices = Utils.getWebServices(eJBJarFile);
            AssemblyDescriptor assemblyDescriptor = servlet.getAssemblyDescriptor();
            EList eList5 = hTTPRouterDescriptor.getPortComponentNames().iterator();
            while (eList5.hasNext()) {
                string3 = (String)eList5.next();
                enterpriseBean = this.getEjbForPortComponent((EJBJar)servlet, webServices, string3);
                if (enterpriseBean == null || !this.ejbIsProtected(enterpriseBean, assemblyDescriptor)) continue;
                String string6 = "/services/" + string3;
                if (string5.equals("2.4")) {
                    webResourceCollection.getUrlPattern().add((Object)string6);
                    continue;
                }
                webResourceCollection.addURL(string6);
            }
            eList5 = securityConstraint.getWebResourceCollections();
            eList5.add((Object)webResourceCollection);
            iterator.add(securityConstraint);
            string3 = commonFactory.createSecurityRole();
            string3.setRoleName(HTTP_ROUTER_SECURITY_ROLE_NAME);
            enterpriseBean = webApp.getSecurityRoles();
            enterpriseBean.add((Object)string3);
        }
        return wARFile;
    }

    private boolean ejbJarContainsProtectedEJB(EJBJar eJBJar) {
        AssemblyDescriptor assemblyDescriptor = eJBJar.getAssemblyDescriptor();
        if (assemblyDescriptor == null) {
            return false;
        }
        EList eList = assemblyDescriptor.getSecurityRoles();
        if (eList.size() == 0) {
            return false;
        }
        Iterator iterator = eJBJar.getEnterpriseBeans().iterator();
        while (iterator.hasNext()) {
            EnterpriseBean enterpriseBean = (EnterpriseBean)iterator.next();
            List list = assemblyDescriptor.getMethodPermissionMethodElements(enterpriseBean);
            if (list.size() == 0) continue;
            return true;
        }
        return false;
    }

    private EnterpriseBean getEjbForPortComponent(EJBJar eJBJar, WebServices webServices, String string) {
        ServiceImplBean serviceImplBean;
        Object object;
        WebServiceDescription webServiceDescription;
        EnterpriseBean enterpriseBean = null;
        EList eList = webServices.getWebServiceDescriptions();
        PortComponent portComponent = null;
        for (int i = 0; i < eList.size() && portComponent == null; ++i) {
            webServiceDescription = (WebServiceDescription)eList.get(i);
            object = webServiceDescription.getPortComponents();
            for (int j = 0; j < object.size() && portComponent == null; ++j) {
                PortComponent portComponent2 = (PortComponent)object.get(j);
                if (!string.equals(portComponent2.getPortComponentName())) continue;
                portComponent = portComponent2;
            }
        }
        if (portComponent != null && (serviceImplBean = portComponent.getServiceImplBean()) != null && (webServiceDescription = serviceImplBean.getEEJBLink()) != null && (object = webServiceDescription.getEjbLink()) != null) {
            enterpriseBean = eJBJar.getEnterpriseBeanNamed((String)object);
        }
        return enterpriseBean;
    }

    private boolean ejbIsProtected(EnterpriseBean enterpriseBean, AssemblyDescriptor assemblyDescriptor) {
        EList eList = assemblyDescriptor.getMethodPermissions();
        for (int i = 0; i < eList.size(); ++i) {
            List list;
            MethodPermission methodPermission = (MethodPermission)eList.get(i);
            if (methodPermission.isUnchecked() || (list = methodPermission.getMethodElements(enterpriseBean)).size() <= 0) continue;
            return true;
        }
        return false;
    }

    private EJBJarFile createModule(JMSRouterDescriptor jMSRouterDescriptor, EARFile eARFile, EJBJarFile eJBJarFile) throws Exception {
        Object object;
        ActivationConfigProperty activationConfigProperty;
        ActivationConfig activationConfig;
        MessageDrivenDestination messageDrivenDestination;
        int n = eARFile.getSpecVersionID();
        EJBJarFile eJBJarFile2 = this.archiveFactory.createEJBJarFileInitialized(jMSRouterDescriptor.getTargetURI());
        eJBJarFile2.setJ2EEVersion(n);
        ArchiveManifest archiveManifest = eJBJarFile2.getManifest();
        archiveManifest.setManifestVersion("1.0");
        archiveManifest.setClassPath(jMSRouterDescriptor.getClassPath());
        EJBJar eJBJar = eJBJarFile2.getDeploymentDescriptor();
        Object[] objectArray = new String[]{"JMS", jMSRouterDescriptor.getEjbJarName()};
        eJBJar.setDisplayName(Messages.getFormattedMessage("enabler.routerDisplayName", objectArray, "{0} router for {1}"));
        MessageDriven messageDriven = ejbFactory.createMessageDriven();
        messageDriven.setName(JMS_ROUTER_MDB_NAME);
        messageDriven.setEjbClassName(JMS_ROUTER_MDB_CLASSNAME);
        messageDriven.setTransactionType(TransactionType.CONTAINER_LITERAL);
        if (n > 13) {
            messageDriven.setMessagingType(JavaClassImpl.createClassRef((String)JMS_MESSAGE_LISTENER_CLASS));
        }
        String string = jMSRouterDescriptor.getDestinationType();
        if (n > 13) {
            messageDrivenDestination = null;
            messageDrivenDestination = string.equalsIgnoreCase(DESTINATION_TYPE_TOPIC) ? JavaClassImpl.createClassRef((String)DESTINATION_TYPE_TOPIC_CLASS) : JavaClassImpl.createClassRef((String)DESTINATION_TYPE_QUEUE_CLASS);
            messageDriven.setMessageDestination((JavaClass)messageDrivenDestination);
            activationConfig = ejbFactory.createActivationConfig();
            activationConfigProperty = ejbFactory.createActivationConfigProperty();
            activationConfigProperty.setName(JMS_CONFIG_PROP_NAME);
            activationConfigProperty.setValue(messageDrivenDestination.getQualifiedName());
            activationConfig.getConfigProperties().add((Object)activationConfigProperty);
            messageDriven.setActivationConfig(activationConfig);
        } else {
            messageDrivenDestination = ejbFactory.createMessageDrivenDestination();
            if (string.equalsIgnoreCase(DESTINATION_TYPE_TOPIC)) {
                messageDrivenDestination.setType(DestinationType.TOPIC_LITERAL);
            } else {
                messageDrivenDestination.setType(DestinationType.QUEUE_LITERAL);
            }
            messageDriven.setDestination(messageDrivenDestination);
        }
        messageDrivenDestination = commonFactory.createResourceEnvRef();
        messageDrivenDestination.setName("jms/WebServicesReplyQCF");
        messageDrivenDestination.setTypeName("javax.jms.QueueConnectionFactory");
        activationConfig = commonFactory.createDescription();
        activationConfig.setValue(JMS_DESCRIPTION);
        messageDrivenDestination.getDescriptions().add((Object)activationConfig);
        activationConfigProperty = messageDriven.getResourceEnvRefs();
        activationConfigProperty.add(messageDrivenDestination);
        EList eList = eJBJar.getEnterpriseBeans();
        eList.add(messageDriven);
        MessageDrivenBeanBinding messageDrivenBeanBinding = ejbbndFactory.createMessageDrivenBeanBinding();
        if (n > 13 && jMSRouterDescriptor.getActivationSpec() != null) {
            messageDrivenBeanBinding.setActivationSpecJndiName(jMSRouterDescriptor.getActivationSpec());
        } else if (jMSRouterDescriptor.getListenerPort() != null) {
            messageDrivenBeanBinding.setListenerInputPortName(jMSRouterDescriptor.getListenerPort());
        }
        if (string.equalsIgnoreCase("queue") && jMSRouterDescriptor.getActivationSpec() == null && jMSRouterDescriptor.getListenerPort() != null) {
            object = (String)this.listenerPortModuleMap.get(jMSRouterDescriptor.getListenerPort());
            if (object != null) {
                if (object != jMSRouterDescriptor.getTargetURI()) {
                    String string2 = "Listener input port {0} has already been configured for JMS router module {1}.";
                    Object[] objectArray2 = new String[]{jMSRouterDescriptor.getListenerPort(), object};
                    String string3 = Messages.getFormattedMessage("enabler.listenerPortWarn1", objectArray2, string2);
                    throw new Exception(string3);
                }
            } else {
                this.listenerPortModuleMap.put(jMSRouterDescriptor.getListenerPort(), jMSRouterDescriptor.getTargetURI());
            }
        }
        messageDrivenBeanBinding.setEnterpriseBean((EnterpriseBean)messageDriven);
        object = eJBJarFile2.getBindings();
        EList eList2 = object.getEjbBindings();
        eList2.add((Object)messageDrivenBeanBinding);
        return eJBJarFile2;
    }

    public void setForWSAD(boolean bl) {
        this.forWSAD = bl;
        if (this.forWSAD) {
            this.httpRouters = new Vector();
            this.jmsRouters = new Vector();
            this.wsBindings = new Hashtable();
        }
    }

    public Vector getHTTPRouters() {
        return this.httpRouters;
    }

    public Vector getJMSRouters() {
        return this.jmsRouters;
    }

    public Hashtable getWsBindings() {
        return this.wsBindings;
    }

    static {
        WSModels.init();
        webappFactory = WebapplicationFactory.eINSTANCE;
        ejbFactory = EjbFactory.eINSTANCE;
        ejbbndFactory = EjbbndFactory.eINSTANCE;
        commonFactory = CommonFactory.eINSTANCE;
        appBndFactory = ApplicationbndFactory.eINSTANCE;
    }
}

