/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.deploy;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.models.config.host.HostAlias;
import com.ibm.websphere.models.config.host.VirtualHost;
import com.ibm.ws.webservices.deploy.WebserviceDescriptionInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ModuleData {
    private static TraceComponent tc = Tr.register((Class)ModuleData.class, (String)"WebServices", (String)"com.ibm.ws.webservices.deploy.resources.deployMessages");
    public static final String TRANSPORT_HTTP = "http";
    public static final String TRANSPORT_HTTPS = "https";
    public static final String TRANSPORT_JMS = "jms";
    public static final String TRANSPORT_EJB = "ejb";
    private String name;
    private String node;
    private String host;
    private String defaultPrefix;
    private String virtualHostName;
    private String contextRoot;
    private String applicationName;
    private String defaultJMSPrefix;
    private boolean hasHTTPRouter = false;
    private boolean hasJMSRouter = false;
    private String defaultEJBPrefix;
    private List modulesWsdlFiles;
    private String server;
    private List prefixList = new LinkedList();
    private Set virtualHostPorts = new HashSet();
    private boolean isWebModule;
    private List webservicesDescriptions = new ArrayList();

    public void setVirtualHost(VirtualHost virtualHost) {
        Object object;
        Iterator iterator;
        Object object2;
        if (virtualHost != null) {
            this.virtualHostName = virtualHost.getName();
            object2 = virtualHost.getAliases();
            iterator = object2.iterator();
            while (iterator.hasNext()) {
                object = (HostAlias)iterator.next();
                this.virtualHostPorts.add(object.getPort());
            }
        } else {
            this.virtualHostName = "";
        }
        if (tc.isDebugEnabled()) {
            object2 = "null";
            if (virtualHost != null) {
                object2 = virtualHost.getName();
            }
            Tr.debug((TraceComponent)tc, (String)("setVirtualHost: for module \"" + this.name + "\" the virtualHost is \"" + (String)object2 + "\" and its ports are:"));
            iterator = this.virtualHostPorts.iterator();
            while (iterator.hasNext()) {
                object = (String)iterator.next();
                Tr.debug((TraceComponent)tc, (String)object);
            }
            Tr.debug((TraceComponent)tc, (String)"\n");
        }
    }

    public boolean addPrefix(String string, String string2) {
        if (this.virtualHostPorts.contains(string2)) {
            return this.prefixList.add(new Prefix(string, this.host, string2));
        }
        return false;
    }

    public boolean addPrefix(String string, String string2, String string3) {
        return this.prefixList.add(new Prefix(string, string2, string3));
    }

    public List getPrefixList() {
        if (this.prefixList.size() == 0) {
            this.prefixList.add(new Prefix("", "", ""));
        }
        LinkedList<String> linkedList = new LinkedList<String>();
        Iterator iterator = this.prefixList.iterator();
        while (iterator.hasNext()) {
            linkedList.add(((Prefix)iterator.next()).toString());
        }
        return linkedList;
    }

    public String getDefaultPrefix() {
        if (this.defaultPrefix == null) {
            this.defaultPrefix = "";
            if (this.prefixList != null) {
                Iterator iterator = this.prefixList.iterator();
                while (iterator.hasNext()) {
                    Prefix prefix = (Prefix)iterator.next();
                    this.defaultPrefix = prefix.toString();
                    if (!prefix.protocol.equals(TRANSPORT_HTTP)) continue;
                }
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("default http prefix is: " + this.defaultPrefix));
        }
        return this.defaultPrefix;
    }

    public void setDefaultPrefix(String string) {
        this.defaultPrefix = string;
    }

    public String getContextRoot() {
        return this.contextRoot;
    }

    public String getHost() {
        return this.host;
    }

    public String getNode() {
        return this.node;
    }

    public void setContextRoot(String string) {
        this.contextRoot = string;
    }

    public void setHost(String string) {
        this.host = string;
    }

    public void setNode(String string) {
        this.node = string;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getVirtualHostName() {
        return this.virtualHostName;
    }

    public void setServer(String string) {
        this.server = string;
    }

    public String getServer() {
        return this.server;
    }

    public void addWebservicesDescription(WebserviceDescriptionInfo webserviceDescriptionInfo) {
        this.webservicesDescriptions.add(webserviceDescriptionInfo);
    }

    public List getWebservicesDescritions() {
        return this.webservicesDescriptions;
    }

    public Map getMergedQNameToUrlPatternMap(String string) {
        HashMap hashMap = new HashMap();
        Map map = null;
        Iterator iterator = this.webservicesDescriptions.iterator();
        while (iterator.hasNext()) {
            WebserviceDescriptionInfo webserviceDescriptionInfo = (WebserviceDescriptionInfo)iterator.next();
            Map map2 = webserviceDescriptionInfo.getQNameToUrlPatternMap();
            if (string != null && webserviceDescriptionInfo.getWebserviceDescriptionName().equals(string)) {
                map = map2;
            }
            hashMap.putAll(map2);
        }
        if (map != null) {
            hashMap.putAll(map);
        }
        return hashMap;
    }

    public Map getMergedQNameToPortComponentNameMap(String string) {
        HashMap hashMap = new HashMap();
        Map map = null;
        Iterator iterator = this.webservicesDescriptions.iterator();
        while (iterator.hasNext()) {
            WebserviceDescriptionInfo webserviceDescriptionInfo = (WebserviceDescriptionInfo)iterator.next();
            Map map2 = webserviceDescriptionInfo.getQnameToPortComponentNameMap();
            if (string != null && webserviceDescriptionInfo.getWebserviceDescriptionName().equals(string)) {
                map = map2;
            }
            hashMap.putAll(map2);
        }
        if (map != null) {
            hashMap.putAll(map);
        }
        return hashMap;
    }

    public Map getMergedQNameToEJBUrlPrefixMap(String string) {
        HashMap hashMap = new HashMap();
        Map map = null;
        Iterator iterator = this.webservicesDescriptions.iterator();
        while (iterator.hasNext()) {
            WebserviceDescriptionInfo webserviceDescriptionInfo = (WebserviceDescriptionInfo)iterator.next();
            Map map2 = webserviceDescriptionInfo.getQNameToEJBUrlPrefixMap();
            if (string != null && webserviceDescriptionInfo.getWebserviceDescriptionName().equals(string)) {
                map = map2;
            }
            hashMap.putAll(map2);
        }
        if (map != null) {
            hashMap.putAll(map);
        }
        return hashMap;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("\n");
        stringBuffer.append(this.getClass().getName() + '@' + Integer.toHexString(this.hashCode()) + "\n");
        stringBuffer.append("applicationName=").append(this.applicationName).append("\n");
        stringBuffer.append("name=").append(this.name).append("\n");
        stringBuffer.append("node=").append(this.node).append("\n");
        stringBuffer.append("host=").append(this.host).append("\n");
        stringBuffer.append("defaultPrefix=").append(this.defaultPrefix).append("\n");
        stringBuffer.append("virtuaHostName=").append(this.virtualHostName).append("\n");
        stringBuffer.append("server=").append(this.server).append("\n");
        stringBuffer.append("contextRoot=").append(this.contextRoot).append("\n");
        stringBuffer.append("prefixList contains:\n");
        Iterator iterator = this.prefixList.iterator();
        while (iterator.hasNext()) {
            stringBuffer.append("\t").append(iterator.next()).append("\n");
        }
        stringBuffer.append("webServicesDescriptions contains:\n");
        iterator = this.webservicesDescriptions.iterator();
        while (iterator.hasNext()) {
            WebserviceDescriptionInfo webserviceDescriptionInfo = (WebserviceDescriptionInfo)iterator.next();
            stringBuffer.append(webserviceDescriptionInfo.toString());
        }
        stringBuffer.append("virtualHostPorts contains:\n");
        iterator = this.virtualHostPorts.iterator();
        while (iterator.hasNext()) {
            stringBuffer.append(iterator.next()).append("\n");
        }
        stringBuffer.append("modulesWsdlFiles contains:\n");
        iterator = this.modulesWsdlFiles.iterator();
        while (iterator.hasNext()) {
            stringBuffer.append(iterator.next()).append("\n");
        }
        return stringBuffer.toString();
    }

    public void setIsWebModule(boolean bl) {
        this.isWebModule = bl;
    }

    public boolean isWebModule() {
        return this.isWebModule;
    }

    public void setModulesWsdlFiles(List list) {
        this.modulesWsdlFiles = list;
    }

    public List getModulesWsdlFiles() {
        return this.modulesWsdlFiles;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public void setApplicationName(String string) {
        this.applicationName = string;
    }

    public String getDefaultJMSPrefix() {
        return this.defaultJMSPrefix;
    }

    public void setDefaultJMSPrefix(String string) {
        this.defaultJMSPrefix = string;
    }

    public boolean hasHTTPRouter() {
        return this.hasHTTPRouter;
    }

    public void setHasHTTPRouter(boolean bl) {
        this.hasHTTPRouter = bl;
    }

    public boolean hasJMSRouter() {
        return this.hasJMSRouter;
    }

    public void setHasJMSRouter(boolean bl) {
        this.hasJMSRouter = bl;
    }

    public String getDefaultEJBPrefix() {
        return this.defaultEJBPrefix;
    }

    public void setDefaultEJBPrefix(String string) {
        this.defaultEJBPrefix = string;
    }

    private class Prefix {
        String protocol;
        String host;
        String port;

        Prefix(String string, String string2, String string3) {
            this.protocol = string;
            this.host = string2;
            this.port = string3;
        }

        public String toString() {
            return this.protocol + "://" + this.host + ":" + this.port;
        }
    }
}

