/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.deploy;

import com.ibm.ejs.models.base.bindings.ejbbnd.EJBJarBinding;
import com.ibm.ejs.models.base.bindings.ejbbnd.EnterpriseBeanBinding;
import com.ibm.ejs.models.base.bindings.ejbbnd.MessageDrivenBeanBinding;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.etools.application.Application;
import com.ibm.etools.application.EjbModule;
import com.ibm.etools.application.Module;
import com.ibm.etools.application.WebModule;
import com.ibm.etools.commonarchive.CommonarchiveFactory;
import com.ibm.etools.commonarchive.EARFile;
import com.ibm.etools.commonarchive.EJBJarFile;
import com.ibm.etools.ejb.EnterpriseBean;
import com.ibm.etools.j2ee.commonarchivecore.ModuleFile;
import com.ibm.etools.j2ee.commonarchivecore.helpers.ArchiveOptions;
import com.ibm.etools.webapplication.Servlet;
import com.ibm.etools.webapplication.ServletMapping;
import com.ibm.etools.webapplication.WebApp;
import com.ibm.etools.webservice.wsbnd.DefaultEndpointURIPrefix;
import com.ibm.etools.webservice.wsbnd.RouterModule;
import com.ibm.etools.webservice.wsbnd.WSDescBinding;
import com.ibm.etools.webservice.wsdd.EJBLink;
import com.ibm.etools.webservice.wsdd.PortComponent;
import com.ibm.etools.webservice.wsdd.WebServiceDescription;
import com.ibm.etools.webservice.wsdd.WebServices;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.repository.ConfigRepositoryFactory;
import com.ibm.websphere.models.config.appdeployment.ApplicationDeployment;
import com.ibm.websphere.models.config.appdeployment.Deployment;
import com.ibm.websphere.models.config.appdeployment.DeploymentTargetMapping;
import com.ibm.websphere.models.config.appdeployment.ModuleDeployment;
import com.ibm.websphere.models.config.appdeployment.ServerTarget;
import com.ibm.websphere.models.config.applicationserver.ApplicationServer;
import com.ibm.websphere.models.config.applicationserver.ejbcontainer.EJBContainer;
import com.ibm.websphere.models.config.applicationserver.ejbcontainer.messagelistener.ListenerPort;
import com.ibm.websphere.models.config.applicationserver.ejbcontainer.messagelistener.MessageListenerService;
import com.ibm.websphere.models.config.applicationserver.webcontainer.HTTPTransport;
import com.ibm.websphere.models.config.applicationserver.webcontainer.WebContainer;
import com.ibm.websphere.models.config.channelservice.TransportChannel;
import com.ibm.websphere.models.config.channelservice.TransportChannelService;
import com.ibm.websphere.models.config.channelservice.channels.TCPInboundChannel;
import com.ibm.websphere.models.config.host.VirtualHost;
import com.ibm.websphere.models.config.ipc.EndPoint;
import com.ibm.websphere.models.config.ipc.Transport;
import com.ibm.websphere.models.config.process.Component;
import com.ibm.websphere.models.config.process.Server;
import com.ibm.websphere.models.config.process.Service;
import com.ibm.websphere.models.config.serverindex.NamedEndPoint;
import com.ibm.websphere.models.config.serverindex.ServerEntry;
import com.ibm.websphere.models.config.serverindex.ServerIndex;
import com.ibm.websphere.models.config.topology.cluster.ClusterMember;
import com.ibm.websphere.models.config.topology.cluster.ServerCluster;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sm.workspace.RepositoryContext;
import com.ibm.ws.sm.workspace.WorkSpaceException;
import com.ibm.ws.webservices.WSModels;
import com.ibm.ws.webservices.deploy.DeployUtils;
import com.ibm.ws.webservices.deploy.ModuleData;
import com.ibm.ws.webservices.deploy.WebserviceDescriptionInfo;
import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.management.ObjectName;
import javax.xml.namespace.QName;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;

public class MetaDataLoader {
    private static TraceComponent tc = Tr.register((Class)MetaDataLoader.class, (String)"WebServices", (String)"com.ibm.ws.webservices.deploy.resources.deployMessages");
    private static TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.webservices.deploy.resources.deployMessages");
    private static final String SERVLET_URL_PATTERN_ROOT = "services/";
    private Map nodeHostNames;
    private RepositoryContext appDeployCtx;
    private RepositoryContext applicationContext;
    private RepositoryContext cellContext;
    private List moduleDataList;
    private String earFileLocation;
    private EARFile earFile;
    private List deployedModules;

    public MetaDataLoader(RepositoryContext repositoryContext, String string) {
        this.appDeployCtx = repositoryContext;
        this.earFileLocation = string;
        this.nodeHostNames = new HashMap();
        this.moduleDataList = new LinkedList();
    }

    public List getModuleDataList() {
        return this.moduleDataList;
    }

    public boolean isWebServiceEnabled() {
        boolean bl = false;
        List list = this.getDeployedModules();
        EARFile eARFile = this.getEAR(this.getApplicationContext());
        Application application = eARFile.getDeploymentDescriptor();
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("isWebServiceEnabled on app: " + application.getDisplayName()));
        }
        for (int i = 0; i < list.size(); ++i) {
            Module module;
            ModuleDeployment moduleDeployment = (ModuleDeployment)list.get(i);
            Module module2 = module = moduleDeployment.getAltDD() != null ? application.getModuleHavingAltDD(moduleDeployment.getAltDD()) : application.getModule(moduleDeployment.getUri(), null);
            if (module == null) continue;
            String string = module.isWebModule() ? "WEB-INF/webservices.xml" : "META-INF/webservices.xml";
            ModuleFile moduleFile = eARFile.getModuleRef(module).getModuleFile();
            WebServices webServices = null;
            try {
                webServices = WSModels.getWebServices(moduleFile.getLoadStrategy(), string);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.webservices.deploy.MetaDataLoader.isWebServiceEnabled", (String)"204");
            }
            if (webServices == null) continue;
            bl = true;
            break;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("isWebServiceEnabled returning: " + bl));
        }
        return bl;
    }

    public void cleanup() {
        this.nodeHostNames.clear();
        this.moduleDataList.clear();
        this.deployedModules = null;
        this.appDeployCtx = null;
        this.applicationContext = null;
        this.cellContext = null;
        if (this.earFile != null) {
            this.earFile.close();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void load() throws Exception {
        boolean bl;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"load");
        }
        if (!(bl = this.isWebServiceEnabled())) {
            if (!tc.isEntryEnabled()) return;
            Tr.exit((TraceComponent)tc, (String)"load: no webservices information found");
            return;
        }
        RepositoryContext repositoryContext = this.getCellContext();
        List list = this.getDeployedModules();
        EARFile eARFile = this.getEAR(this.applicationContext);
        Application application = eARFile.getDeploymentDescriptor();
        for (int i = 0; i < list.size(); ++i) {
            WebModule webModule;
            WebServices webServices;
            ModuleFile moduleFile;
            Module module;
            String string = null;
            boolean bl2 = false;
            ModuleDeployment moduleDeployment = (ModuleDeployment)list.get(i);
            Module module2 = module = moduleDeployment.getAltDD() != null ? application.getModuleHavingAltDD(moduleDeployment.getAltDD()) : application.getModule(moduleDeployment.getUri(), null);
            if (module == null) continue;
            ModuleData moduleData = null;
            if (module.isWebModule()) {
                moduleFile = eARFile.getModuleRef(module).getModuleFile();
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("load: starting to process WEB module " + moduleFile.getName()));
                }
                if ((webServices = WSModels.getWebServices(moduleFile.getLoadStrategy(), "WEB-INF/webservices.xml")) == null) {
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug((TraceComponent)tc, (String)"load: loadWebServicesXML returned null");
                    continue;
                }
                webModule = (WebModule)module;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("load: calling loadModuleData for module " + moduleFile.getName()));
                }
                moduleData = this.loadModuleData(repositoryContext, eARFile, moduleFile, moduleDeployment, webModule, webServices, false);
            } else if (module.isEjbModule()) {
                String string2;
                RouterModule routerModule;
                Object object;
                moduleFile = eARFile.getModuleRef(module).getModuleFile();
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("load: starting to process EJB module " + moduleFile.getName()));
                }
                if ((webServices = WSModels.getWebServices(moduleFile.getLoadStrategy(), "META-INF/webservices.xml")) == null) {
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug((TraceComponent)tc, (String)"load: loadWebServicesXML returned null");
                    continue;
                }
                webModule = WSModels.getWSBinding(moduleFile.getLoadStrategy(), "META-INF/ibm-webservices-bnd.xmi");
                if (webModule != null) {
                    object = webModule.getRouterModules().iterator();
                    while (object.hasNext()) {
                        routerModule = (RouterModule)object.next();
                        string2 = routerModule.getTransport();
                        if (string2 == null || !string2.equals("http")) continue;
                        string = routerModule.getName();
                        bl2 = true;
                        break;
                    }
                }
                if (string != null) {
                    object = null;
                    for (int j = 0; j < list.size(); ++j) {
                        string2 = (ModuleDeployment)list.get(j);
                        if (!string2.getUri().equals(string)) continue;
                        object = string2;
                        break;
                    }
                    if (object == null) {
                        throw new Exception(nls.getFormattedMessage("WSWS0043E", new Object[]{moduleDeployment.getUri()}, "WSWS0043E: The EJB module {0} does not have an associated router module"));
                    }
                    routerModule = application.getModule(string, null);
                    if (routerModule == null) {
                        throw new Exception(nls.getFormattedMessage("WSWS0043E", new Object[]{moduleDeployment.getUri()}, "WSWS0043E: The EJB module {0} does not have an associated router module"));
                    }
                    if (!routerModule.isWebModule()) throw new Exception(nls.getFormattedMessage("WSWS0043E", new Object[]{moduleDeployment.getUri()}, "WSWS0043E: The EJB module {0} does not have an associated router module"));
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("load: calling loadModuleData for module " + moduleFile.getName()));
                    }
                    moduleData = this.loadModuleData(repositoryContext, eARFile, moduleFile, moduleDeployment, (WebModule)routerModule, webServices, bl2);
                } else {
                    moduleData = this.loadModuleData(repositoryContext, eARFile, moduleFile, moduleDeployment, null, webServices, bl2);
                }
            }
            if (moduleData == null) continue;
            this.moduleDataList.add(moduleData);
        }
        if (!tc.isEntryEnabled()) return;
        Tr.exit((TraceComponent)tc, (String)"load");
    }

    private RepositoryContext getApplicationContext() {
        if (this.applicationContext == null) {
            this.applicationContext = this.appDeployCtx.getParent();
        }
        return this.applicationContext;
    }

    private RepositoryContext getCellContext() {
        if (this.cellContext == null) {
            this.cellContext = this.getApplicationContext().getParent();
        }
        return this.cellContext;
    }

    private List getDeployedModules() {
        block3: {
            if (this.deployedModules == null) {
                try {
                    ResourceSet resourceSet = this.appDeployCtx.getResourceSet();
                    Resource resource = resourceSet.getResource(URI.createURI((String)"deployment.xml"), true);
                    Deployment deployment = (Deployment)resource.getContents().get(0);
                    ApplicationDeployment applicationDeployment = (ApplicationDeployment)deployment.getDeployedObject();
                    this.deployedModules = applicationDeployment.getModules();
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.webservices.deploy.MetaDataLoader.getDeployedModules", (String)"476");
                    if (!tc.isDebugEnabled()) break block3;
                    Tr.debug((TraceComponent)tc, (String)"getDeploymentModules: caught exception ", (Object)exception);
                }
            }
        }
        return this.deployedModules;
    }

    private EARFile getEAR(RepositoryContext repositoryContext) {
        block7: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"getEAR");
            }
            if (this.earFile == null) {
                String string;
                String string2;
                if (this.earFileLocation == null) {
                    string2 = repositoryContext.getName();
                    string = repositoryContext.getURI();
                    Properties properties = ConfigRepositoryFactory.getConfigRepository().getConfig();
                    String string3 = (String)properties.get("was.repository.root");
                    this.earFileLocation = string3 + File.separator + string + File.separator + string2;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"ear file location: ", (Object)this.earFileLocation);
                }
                try {
                    string2 = (CommonarchiveFactory)EPackage.Registry.INSTANCE.getEPackage("http:///com/ibm/etools/commonarchive.ecore").getEFactoryInstance();
                    string = new ArchiveOptions();
                    string.setIsReadOnly(true);
                    string.setUseJavaReflection(false);
                    this.earFile = string2.openEARFile((ArchiveOptions)string, this.earFileLocation);
                    this.earFile.getDeploymentDescriptor();
                    this.earFile.getBindings();
                    this.earFile.getExtensions();
                }
                catch (Throwable throwable) {
                    FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.webservices.deploy.MetaDataLoader.getEAR", (String)"534");
                    if (this.earFile == null) break block7;
                    this.earFile.close();
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getEAR");
        }
        return this.earFile;
    }

    private String findServletUrl(WebApp webApp, String string) {
        String string2 = null;
        Servlet servlet = webApp.getServletNamed(string);
        ServletMapping servletMapping = webApp.getServletMapping(servlet);
        if (servletMapping != null) {
            string2 = servletMapping.getUrlPattern();
        }
        return string2;
    }

    private static String getHostName(RepositoryContext repositoryContext) {
        String string = null;
        try {
            ResourceSet resourceSet = repositoryContext.getResourceSet();
            Resource resource = resourceSet.getResource(URI.createURI((String)"serverindex.xml"), true);
            ServerIndex serverIndex = (ServerIndex)resource.getContents().get(0);
            string = serverIndex.getHostName();
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.webservices.deploy.MetaDataLoader.getHostName", (String)"586");
            Tr.error((TraceComponent)tc, (String)"internal.error", (Object)exception);
        }
        return string;
    }

    private ModuleData loadModuleData(RepositoryContext repositoryContext, EARFile eARFile, ModuleFile moduleFile, ModuleDeployment moduleDeployment, WebModule webModule, WebServices webServices, boolean bl) throws Exception {
        String string;
        String string2;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        String string3;
        String string4;
        String string5;
        Object object5;
        Object object6;
        Object object7;
        Object object8;
        CharSequence charSequence;
        ServerTarget serverTarget;
        Object object9;
        Object object10;
        EList eList;
        String string6;
        Object object11;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"loadModuleData for ", (Object)moduleDeployment.getUri());
        }
        boolean bl2 = moduleFile.isWARFile();
        ModuleData moduleData = new ModuleData();
        moduleData.setApplicationName(eARFile.getName());
        moduleData.setIsWebModule(bl2);
        moduleData.setHasHTTPRouter(bl);
        moduleData.setName(moduleDeployment.getUri());
        if (webModule == null) {
            moduleData.setVirtualHost(null);
        } else {
            object11 = eARFile.getBindings(webModule);
            string6 = object11.getVirtualHostName();
            eList = repositoryContext.getResourceSet().getResource(URI.createURI((String)"virtualhosts.xml"), true);
            object10 = eList.getContents();
            object9 = object10.iterator();
            while (object9.hasNext()) {
                serverTarget = (VirtualHost)object9.next();
                if (!serverTarget.getName().equals(string6)) continue;
                moduleData.setVirtualHost((VirtualHost)serverTarget);
                break;
            }
        }
        eList = moduleDeployment.getTargetMappings();
        if (eList.isEmpty()) {
            throw new Exception(nls.getFormattedMessage("WSWS0044E", new Object[]{moduleDeployment.getUri()}, "WSWS0044E: Can not locate the deploy target for module: {0}"));
        }
        object10 = (DeploymentTargetMapping)eList.get(0);
        object9 = object10.getTarget();
        if (object9 instanceof ServerTarget) {
            serverTarget = (ServerTarget)object9;
            object11 = serverTarget.getNodeName();
            string6 = serverTarget.getName();
            charSequence = (String)this.nodeHostNames.get(object11);
            object8 = repositoryContext.findContext("nodes/" + (String)object11);
            if (charSequence == null) {
                charSequence = MetaDataLoader.getHostName((RepositoryContext)object8);
                this.nodeHostNames.put(object11, charSequence);
            }
            object7 = object8.findContext("servers/" + string6);
            object6 = MetaDataLoader.loadWebContainerPorts((RepositoryContext)object8, (RepositoryContext)object7);
            moduleData.setNode((String)object11);
            moduleData.setHost((String)charSequence);
            moduleData.setServer(string6);
            object5 = object6.keySet().iterator();
            while (object5.hasNext()) {
                string5 = (String)object5.next();
                string4 = (String)object6.get(string5);
                moduleData.addPrefix(string4, string5);
            }
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Deployment Target (server)" + object9.getName() + " is a cluster"));
            }
            try {
                serverTarget = repositoryContext.findContext("clusters/" + object9.getName());
                charSequence = serverTarget.getResourceSet();
                object8 = charSequence.getResource(URI.createURI((String)"cluster.xml"), true);
                object7 = (ServerCluster)object8.getContents().get(0);
                object6 = object7.getMembers().iterator();
                while (object6.hasNext()) {
                    object5 = (ClusterMember)object6.next();
                    string5 = object5.getNodeName();
                    string4 = object5.getMemberName();
                    string3 = (String)this.nodeHostNames.get(string5);
                    object4 = repositoryContext.findContext("nodes/" + string5);
                    if (string3 == null) {
                        string3 = MetaDataLoader.getHostName((RepositoryContext)object4);
                        this.nodeHostNames.put(string5, string3);
                    }
                    object3 = object4.findContext("servers/" + string4);
                    object2 = MetaDataLoader.loadWebContainerPorts((RepositoryContext)object4, object3);
                    moduleData.setNode(string5);
                    moduleData.setHost(string3);
                    moduleData.setServer(string4);
                    object = object2.keySet().iterator();
                    while (object.hasNext()) {
                        string2 = (String)object.next();
                        string = (String)object2.get(string2);
                        moduleData.addPrefix(string, string3, string2);
                    }
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.webservices.deploy.MetaDataLoader.loadModuleData", (String)"735", (Object)this);
                Tr.debug((TraceComponent)tc, (String)"Failed to load cluster context while determining application status: {0}", (Object)exception);
            }
            moduleData.setServer("MODULE_ASSIGNED_TO_CLUSTER_TAG");
        }
        if (webModule == null) {
            moduleData.setContextRoot("");
        } else {
            object10 = webModule.getContextRoot();
            moduleData.setContextRoot((String)object10);
        }
        object10 = null;
        if (webModule != null) {
            object10 = eARFile.getDeploymentDescriptor(webModule);
        }
        int n = webServices.getWebServiceDescriptions().size();
        for (int i = 0; i < n; ++i) {
            charSequence = (WebServiceDescription)webServices.getWebServiceDescriptions().get(i);
            object8 = charSequence.getWebServiceDescriptionName();
            object7 = object8;
            object6 = charSequence.getWsdlFile();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("loadModuleData: webServicesDescriptionName=" + (String)object7));
                Tr.debug((TraceComponent)tc, (String)("loadModuleData: theWSDLFileName=" + (String)object6));
            }
            object5 = new WebserviceDescriptionInfo((String)object6, (String)object7);
            int n2 = charSequence.getPortComponents().size();
            for (int j = 0; j < n2; ++j) {
                EJBJarBinding eJBJarBinding;
                Object object12;
                Module module;
                EJBJarFile eJBJarFile;
                string3 = (PortComponent)charSequence.getPortComponents().get(j);
                object4 = string3.getWsdlPort();
                object3 = new QName(object4.getNamespaceURI(), object4.getLocalPart());
                object2 = string3.getServiceImplBean().getEServletLink();
                object = object2 != null ? object2.getServletLink() : string3.getPortComponentName();
                string2 = null;
                if (object10 != null) {
                    string2 = this.findServletUrl((WebApp)object10, (String)object);
                }
                if (string2 != null) {
                    string2 = DeployUtils.trimSlash(string2);
                }
                if (bl2) {
                    if (string2 != null) {
                        ((WebserviceDescriptionInfo)object5).addQnameToUrlPattern((QName)object3, string2);
                    } else {
                        string = SERVLET_URL_PATTERN_ROOT + string3.getPortComponentName();
                        ((WebserviceDescriptionInfo)object5).addQnameToUrlPattern((QName)object3, string);
                    }
                } else if (string2 != null) {
                    ((WebserviceDescriptionInfo)object5).addQnameToUrlPattern((QName)object3, string2);
                } else {
                    string = "null";
                    if (webModule != null) {
                        string = webModule.getUri();
                    }
                    Tr.error((TraceComponent)tc, (String)"WSWS0045E", (Object)new Object[]{moduleDeployment.getUri(), string, string3.getPortComponentName()});
                }
                ((WebserviceDescriptionInfo)object5).addQnameToPortComponentName((QName)object3, string3.getPortComponentName());
                if (bl2) continue;
                string = string3.getServiceImplBean();
                EJBLink eJBLink = string.getEEJBLink();
                String string7 = eJBLink.getEjbLink();
                String string8 = null;
                List list = eARFile.getEJBJarFiles();
                Object object13 = list.iterator();
                while (object13.hasNext()) {
                    eJBJarFile = (EJBJarFile)object13.next();
                    module = null;
                    if (eJBJarFile.getName().equals(moduleData.getName())) {
                        module = eJBJarFile.getDeploymentDescriptor();
                    }
                    if (module == null) continue;
                    object12 = module.getEnterpriseBeans().iterator();
                    while (object12.hasNext()) {
                        eJBJarBinding = (EnterpriseBean)object12.next();
                        if (!eJBJarBinding.getName().equals(string7)) continue;
                        string8 = eJBJarBinding.getHomeInterfaceName();
                    }
                }
                object13 = null;
                eJBJarFile = eARFile.getDeploymentDescriptor();
                module = moduleDeployment.getAltDD() != null ? eJBJarFile.getModuleHavingAltDD(moduleDeployment.getAltDD()) : eJBJarFile.getModule(moduleDeployment.getUri(), null);
                object12 = (EjbModule)module;
                eJBJarBinding = eARFile.getBindings((EjbModule)object12);
                EList eList2 = eJBJarBinding.getEjbBindings();
                Object object14 = eList2.iterator();
                while (object14.hasNext()) {
                    EnterpriseBeanBinding enterpriseBeanBinding = (EnterpriseBeanBinding)object14.next();
                    if (!enterpriseBeanBinding.getEnterpriseBean().getName().equals(string7)) continue;
                    object13 = enterpriseBeanBinding.getJndiName();
                }
                object14 = new StringBuffer();
                ((StringBuffer)object14).append("wsejb:/");
                ((StringBuffer)object14).append(string8);
                ((StringBuffer)object14).append('?');
                ((StringBuffer)object14).append("jndiName=").append((String)object13);
                ((WebserviceDescriptionInfo)object5).addQNameToEJBUrlPrefix((QName)object3, ((StringBuffer)object14).toString());
            }
            moduleData.addWebservicesDescription((WebserviceDescriptionInfo)object5);
        }
        List list = bl2 ? moduleFile.getLoadStrategy().getFiles("WEB-INF/wsdl") : moduleFile.getLoadStrategy().getFiles("META-INF/wsdl");
        moduleData.setModulesWsdlFiles(list);
        moduleData.setDefaultJMSPrefix("");
        moduleData.setDefaultEJBPrefix("");
        moduleData.setHasJMSRouter(false);
        charSequence = new StringBuffer(moduleData.getName());
        ((StringBuffer)charSequence).append("/");
        if (bl2) {
            ((StringBuffer)charSequence).append("WEB-INF/ibm-webservices-bnd.xmi");
        } else {
            ((StringBuffer)charSequence).append("META-INF/ibm-webservices-bnd.xmi");
        }
        object8 = WSModels.getWSBindingFromResourceSet(this.appDeployCtx.getResourceSet(), ((StringBuffer)charSequence).toString());
        if (object8 == null) {
            object7 = null;
            object7 = bl2 ? "WEB-INF/ibm-webservices-bnd.xmi" : "META-INF/ibm-webservices-bnd.xmi";
            object8 = WSModels.getWSBinding(moduleFile.getLoadStrategy(), (String)object7);
        }
        if (object8 != null) {
            boolean bl3 = false;
            object6 = object8.getWsdescBindings();
            if (object6.size() > 0) {
                DefaultEndpointURIPrefix defaultEndpointURIPrefix;
                DefaultEndpointURIPrefix defaultEndpointURIPrefix2;
                object5 = (WSDescBinding)object6.get(0);
                EList eList3 = object5.getDefaultEndpointURIPrefixes();
                if (eList3.size() >= 3) {
                    DefaultEndpointURIPrefix defaultEndpointURIPrefix3 = (DefaultEndpointURIPrefix)eList3.get(2);
                    string3 = defaultEndpointURIPrefix3.getText();
                    if (string3 == null) {
                        string3 = "";
                    }
                    moduleData.setDefaultEJBPrefix(string3);
                }
                if (eList3.size() >= 2 && (string3 = (defaultEndpointURIPrefix2 = (DefaultEndpointURIPrefix)eList3.get(1)).getText()) != null && string3.length() != 0) {
                    bl3 = true;
                    moduleData.setDefaultJMSPrefix(string3);
                }
                if (eList3.size() >= 1 && (string3 = (defaultEndpointURIPrefix = (DefaultEndpointURIPrefix)eList3.get(0)).getText()) != null && string3.length() != 0) {
                    moduleData.setDefaultPrefix(string3);
                }
                EList eList4 = object8.getRouterModules();
                string3 = null;
                object4 = eList4.iterator();
                while (object4.hasNext()) {
                    object3 = (RouterModule)object4.next();
                    object2 = object3.getTransport();
                    if (!((String)object2).equals("jms")) continue;
                    string3 = object3.getName();
                    break;
                }
                if (string3 != null) {
                    moduleData.setHasJMSRouter(true);
                    if (!bl3) {
                        object4 = this.buildDefaultJMSUrlFromconfig(repositoryContext, eARFile, (List)eList, string3);
                        moduleData.setDefaultJMSPrefix((String)object4);
                    }
                } else if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("loadModuleData: did not find a JMS router module name from the bindings file of module " + moduleDeployment.getUri()));
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("loadModuleData: The module " + moduleFile.getName() + " contains a  Web Services bindings file, but the bindings file " + "contains no WSDescBindings"));
            }
        } else if (!bl2) {
            Tr.error((TraceComponent)tc, (String)"WSWS0018E", (Object)new Object[]{moduleFile.getName(), "ibm-webservices-bnd.xmi"});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"loadModuleData");
        }
        return moduleData;
    }

    private String buildDefaultJMSUrlFromconfig(RepositoryContext repositoryContext, EARFile eARFile, List list, String string) {
        Object object;
        EJBJarBinding eJBJarBinding;
        EJBJarFile eJBJarFile;
        String string2 = null;
        String string3 = null;
        String string4 = "";
        String string5 = null;
        String string6 = null;
        String string7 = null;
        ListenerPort listenerPort = null;
        List list2 = eARFile.getEJBJarFiles();
        String string8 = null;
        DeploymentTargetMapping deploymentTargetMapping = list2.iterator();
        while (deploymentTargetMapping.hasNext()) {
            eJBJarFile = (EJBJarFile)deploymentTargetMapping.next();
            if (!eJBJarFile.getName().equals(string)) continue;
            eJBJarBinding = eJBJarFile.getBindings();
            object = eJBJarBinding.getEjbBindings();
            if (object.size() > 0 && object.get(0) instanceof MessageDrivenBeanBinding) {
                MessageDrivenBeanBinding messageDrivenBeanBinding = (MessageDrivenBeanBinding)object.get(0);
                string5 = messageDrivenBeanBinding.getActivationSpecJndiName();
                if (string5 != null) continue;
                string8 = messageDrivenBeanBinding.getListenerInputPortName();
                continue;
            }
            Tr.error((TraceComponent)tc, (String)"WSWS0046E", (Object)string);
        }
        deploymentTargetMapping = (DeploymentTargetMapping)list.get(0);
        eJBJarFile = deploymentTargetMapping.getTarget();
        if (eJBJarFile instanceof ServerTarget) {
            eJBJarBinding = (ServerTarget)eJBJarFile;
            String string9 = eJBJarBinding.getNodeName();
            String string10 = eJBJarBinding.getName();
            if (string5 != null) {
                object = this.getActivationSpecFromCellConfig(string5, repositoryContext, string9);
                string6 = object[0];
                string7 = object[1];
            } else {
                listenerPort = this.getListenerPortFromCellConfig(string8, repositoryContext, string9, string10);
            }
            if (string5 != null) {
                string2 = string6;
            } else if (listenerPort != null) {
                string2 = listenerPort.getDestinationJNDIName();
                string3 = listenerPort.getConnectionFactoryJNDIName();
            }
            if (string2 == null) {
                string2 = "??undefinedDestinationJndiName??";
            }
            if (string3 == null) {
                string3 = "??connectionFactoryJndiName??";
            }
            object = new StringBuffer();
            ((StringBuffer)object).append("jms");
            ((StringBuffer)object).append(':');
            ((StringBuffer)object).append("/");
            if (string7 == null) {
                ((StringBuffer)object).append("??undefinedDestinationType??");
            } else if (string7.equalsIgnoreCase("queue")) {
                ((StringBuffer)object).append("queue");
            } else {
                ((StringBuffer)object).append("topic");
            }
            ((StringBuffer)object).append('?');
            ((StringBuffer)object).append("destination");
            ((StringBuffer)object).append("=");
            ((StringBuffer)object).append(string2);
            ((StringBuffer)object).append('&');
            ((StringBuffer)object).append("connectionFactory");
            ((StringBuffer)object).append("=");
            ((StringBuffer)object).append(string3);
            string4 = ((StringBuffer)object).toString();
        }
        return string4;
    }

    private String[] getActivationSpecFromCellConfig(String string, RepositoryContext repositoryContext, String string2) {
        String[] stringArray;
        block6: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"getActivationSpecFromCellConfig");
            }
            Object var4_4 = null;
            String string3 = null;
            stringArray = new String[3];
            try {
                ConfigService configService = ConfigServiceFactory.getConfigService();
                Session session = new Session();
                ObjectName objectName = configService.resolve(session, "Node=" + string2)[0];
                ObjectName objectName2 = ConfigServiceHelper.createObjectName(null, (String)"J2CResourceAdapter", (String)"SIB JMS Resource Adapter");
                ObjectName objectName3 = configService.queryConfigObjects(session, objectName, objectName2, null)[0];
                if (objectName3 != null) {
                    ObjectName objectName4 = ConfigServiceHelper.createObjectName(null, (String)"J2CActivationSpec");
                    ObjectName[] objectNameArray = configService.queryConfigObjects(session, objectName3, objectName4, null);
                    for (int i = 0; i < objectNameArray.length; ++i) {
                        ObjectName objectName5 = objectNameArray[i];
                        string3 = (String)configService.getAttribute(session, objectName5, "jndiName");
                        if (!string3.equals(string)) continue;
                        stringArray[0] = (String)configService.getAttribute(session, objectName5, "destinationJndiName");
                        ObjectName objectName6 = ConfigServiceHelper.createObjectName(null, (String)"J2EEResourceProperty", (String)"destinationType");
                        ObjectName objectName7 = configService.queryConfigObjects(session, objectName5, objectName6, null)[0];
                        if (objectName7 == null) break;
                        String string4 = (String)configService.getAttribute(session, objectName7, "value");
                        int n = string4.lastIndexOf(".");
                        stringArray[1] = string4.substring(n + 1);
                        break;
                    }
                }
                configService.discard(session);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.webservices.deploy.MetaDataLoader.getActivationSpecFromCellConfig", (String)"1271");
                if (!tc.isDebugEnabled()) break block6;
                Tr.debug((TraceComponent)tc, (String)"loadModuleData caught while trying to create the default JMS  URL prefix from activationSpec", (Object)exception);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getActivationSpecFromCellConfig");
        }
        return stringArray;
    }

    private ListenerPort getListenerPortFromCellConfig(String string, RepositoryContext repositoryContext, String string2, String string3) {
        ListenerPort listenerPort;
        block8: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"getListenerPortFromCellConfig");
            }
            listenerPort = null;
            try {
                RepositoryContext repositoryContext2 = repositoryContext.findContext("nodes/" + string2 + "/servers/" + string3);
                ResourceSet resourceSet = repositoryContext2.getResourceSet();
                Resource resource = resourceSet.getResource(URI.createURI((String)"server.xml"), true);
                Server server2 = (Server)resource.getContents().get(0);
                EList eList = server2.getComponents();
                Iterator iterator = eList.iterator();
                while (iterator.hasNext()) {
                    Component component = (Component)iterator.next();
                    if (!(component instanceof ApplicationServer)) continue;
                    ApplicationServer applicationServer = (ApplicationServer)component;
                    EList eList2 = applicationServer.getComponents();
                    Iterator iterator2 = eList2.iterator();
                    while (iterator2.hasNext()) {
                        Component component2 = (Component)iterator2.next();
                        if (!(component2 instanceof EJBContainer)) continue;
                        EJBContainer eJBContainer = (EJBContainer)component2;
                        EList eList3 = eJBContainer.getServices();
                        Iterator iterator3 = eList3.iterator();
                        while (iterator3.hasNext()) {
                            Object e = iterator3.next();
                            if (!(e instanceof MessageListenerService)) continue;
                            MessageListenerService messageListenerService = (MessageListenerService)e;
                            EList eList4 = messageListenerService.getListenerPorts();
                            Iterator iterator4 = eList4.iterator();
                            while (iterator4.hasNext()) {
                                ListenerPort listenerPort2 = (ListenerPort)iterator4.next();
                                String string4 = listenerPort2.getName();
                                if (!string4.equals(string)) continue;
                                listenerPort = listenerPort2;
                                if (!tc.isDebugEnabled()) continue;
                                Tr.debug((TraceComponent)tc, (String)("found listenerInputPortName: " + string));
                            }
                        }
                    }
                }
            }
            catch (WorkSpaceException workSpaceException) {
                FFDCFilter.processException((Throwable)workSpaceException, (String)"com.ibm.ws.webservices.deploy.MetaDataLoader.getListenerPortFromCellConfig", (String)"1345");
                if (!tc.isDebugEnabled()) break block8;
                Tr.debug((TraceComponent)tc, (String)"loadModuleData caught while trying to create the default JMS  URL prefix", (Object)((Object)workSpaceException));
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getListenerPortFromCellConfig");
        }
        return listenerPort;
    }

    private static Map loadWebContainerPorts(RepositoryContext repositoryContext, RepositoryContext repositoryContext2) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"loadHTTPPorts");
        }
        Map map = new HashMap();
        try {
            Service service;
            ResourceSet resourceSet = repositoryContext2.getResourceSet();
            Resource resource = resourceSet.getResource(URI.createURI((String)"server.xml"), true);
            Server server2 = (Server)resource.getContents().get(0);
            String string = server2.getName();
            EList eList = server2.getServices();
            TransportChannelService transportChannelService = null;
            TCPInboundChannel tCPInboundChannel = null;
            HashMap hashMap = new HashMap();
            boolean bl = false;
            EList eList2 = eList.iterator();
            while (eList2.hasNext() && !bl) {
                service = (Service)eList2.next();
                if (!(service instanceof TransportChannelService)) continue;
                transportChannelService = (TransportChannelService)service;
                EList eList3 = transportChannelService.getTransportChannels();
                if (eList3.isEmpty()) break;
                bl = true;
                break;
            }
            eList2 = server2.getComponents();
            service = null;
            boolean bl2 = false;
            Iterator iterator = eList2.iterator();
            block3: while (iterator.hasNext() && !bl2) {
                Component component = (Component)iterator.next();
                if (!(component instanceof ApplicationServer)) continue;
                ApplicationServer applicationServer = (ApplicationServer)component;
                EList eList4 = applicationServer.getComponents();
                Iterator iterator2 = eList4.iterator();
                while (iterator2.hasNext()) {
                    Component component2 = (Component)iterator2.next();
                    if (!(component2 instanceof WebContainer)) continue;
                    service = (WebContainer)component2;
                    bl2 = true;
                    continue block3;
                }
            }
            if (service != null && bl2) {
                map = MetaDataLoader.loadHTTPPortsFromV5Template(server2, (List)eList2, (WebContainer)service, map);
            }
            if (transportChannelService != null && bl) {
                map = MetaDataLoader.loadHTTPPortsFromV6Template(repositoryContext, server2, string, (List)eList, transportChannelService, tCPInboundChannel, hashMap, map);
            } else {
                Tr.error((TraceComponent)tc, (String)"loadWebContainerPorts could not find any http or https ports");
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.webservices.deploy.MetaDataLoader.loadWebContainerPorts", (String)"1523");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"loadWebContainerPorts");
        }
        return map;
    }

    private static Map loadHTTPPortsFromV6Template(RepositoryContext repositoryContext, Server server2, String string, List list, TransportChannelService transportChannelService, TCPInboundChannel tCPInboundChannel, Map map, Map map2) {
        block12: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"loadHTTPPortsFromV6Template");
            }
            try {
                Object object;
                String string2;
                TransportChannel transportChannel;
                EList eList = transportChannelService.getTransportChannels();
                ResourceSet resourceSet = eList.iterator();
                while (resourceSet.hasNext()) {
                    transportChannel = (TransportChannel)resourceSet.next();
                    if (!(transportChannel instanceof TCPInboundChannel)) continue;
                    tCPInboundChannel = (TCPInboundChannel)transportChannel;
                    string2 = tCPInboundChannel.getEndPointName();
                    map.put(string2, server2.getName());
                }
                resourceSet = repositoryContext.getResourceSet();
                transportChannel = resourceSet.getResource(URI.createURI((String)"serverindex.xml"), true);
                string2 = (ServerIndex)transportChannel.getContents().get(0);
                ServerEntry serverEntry = null;
                NamedEndPoint namedEndPoint = null;
                String string3 = null;
                Object var15_16 = null;
                EndPoint endPoint = null;
                String string4 = null;
                String string5 = null;
                String string6 = null;
                EList eList2 = string2.getServerEntries();
                boolean bl = false;
                Object object2 = eList2.iterator();
                while (object2.hasNext()) {
                    serverEntry = (ServerEntry)object2.next();
                    string4 = serverEntry.getServerName();
                    if (string4 == null || !(serverEntry instanceof ServerEntry) || !string4.equals(string)) continue;
                    bl = true;
                    break;
                }
                if (bl) {
                    object2 = serverEntry.getSpecialEndpoints();
                    object = object2.iterator();
                    while (object.hasNext()) {
                        namedEndPoint = (NamedEndPoint)object.next();
                        string3 = namedEndPoint.getEndPointName();
                        String string7 = string3.indexOf("secure") >= 0 || string3.indexOf("SSL") >= 0 ? "https" : "http";
                        string5 = (String)map.get(string3);
                        try {
                            if (string4 == null || string5 == null || !string5.equals(string4) || (endPoint = namedEndPoint.getEndPoint()) == null) continue;
                            string6 = new Integer(endPoint.getPort()).toString();
                            map2.put(string6, string7);
                        }
                        catch (Exception exception) {
                            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.webservices.deploy.MetaDataLoader.loadHTTPPortsFromV6Template", (String)"1614");
                        }
                    }
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("loadHTTPPortsFromV6Template: for server \"" + server2.getName() + "\" the container is [" + string + "} and the portMap being returned has " + map2.size() + " elements, which are:\n"));
                    object2 = map2.keySet().iterator();
                    while (object2.hasNext()) {
                        object = (String)object2.next();
                        String string8 = (String)map2.get(object);
                        Tr.debug((TraceComponent)tc, (String)("\tport=" + (String)object + " protocol=" + string8));
                    }
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.webservices.deploy.MetaDataLoader.loadHTTPPortsFromV6Template", (String)"1639");
                if (!tc.isDebugEnabled()) break block12;
                Tr.debug((TraceComponent)tc, (String)"loadHTPPortsFromV6Template caught exeption ", (Object)exception);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"loadHTTPPortsFromV6Template");
        }
        return map2;
    }

    private static Map loadHTTPPortsFromV5Template(Server server2, List list, WebContainer webContainer, Map map) {
        block7: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"loadHTTPPortsFromV5Template");
            }
            try {
                Object object;
                Object object2;
                EList eList = webContainer.getTransports();
                Iterator<Object> iterator = eList.iterator();
                while (iterator.hasNext()) {
                    EndPoint endPoint;
                    object2 = (Transport)iterator.next();
                    if (!(object2 instanceof HTTPTransport) || (endPoint = (object = (HTTPTransport)object2).getAddress()) == null) continue;
                    String string = new Integer(endPoint.getPort()).toString();
                    String string2 = object.isSslEnabled() ? "https" : "http";
                    map.put(string, string2);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("loadHTTPPortsFromV5Template: for server \"" + server2.getName() + "\" the container is [" + webContainer.toString() + "} and the portMap being returned has " + map.size() + " elements, which are:\n"));
                    iterator = map.keySet().iterator();
                    while (iterator.hasNext()) {
                        object2 = (String)iterator.next();
                        object = (String)map.get(object2);
                        Tr.debug((TraceComponent)tc, (String)("\tport=" + (String)object2 + " protocol=" + (String)object));
                    }
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.webservices.deploy.MetaDataLoader.loadHTTPPortsFromV5Template", (String)"1694");
                if (!tc.isDebugEnabled()) break block7;
                Tr.debug((TraceComponent)tc, (String)"loadHTTPPortsFromV5Template caught exeption ", (Object)exception);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"loadHTTPPortsfromV5Template");
        }
        return map;
    }
}

