/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.deploy;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.commonarchive.CommonarchiveFactory;
import com.ibm.etools.commonarchive.EARFile;
import com.ibm.etools.commonarchive.WARFile;
import com.ibm.etools.commonarchive.impl.CommonarchiveFactoryImpl;
import com.ibm.etools.commonarchive.util.ArchiveInit;
import com.ibm.etools.j2ee.commonarchivecore.Archive;
import com.ibm.etools.j2ee.commonarchivecore.ModuleFile;
import com.ibm.etools.j2ee.commonarchivecore.ReadOnlyDirectory;
import com.ibm.etools.j2ee.commonarchivecore.exception.SaveFailureException;
import com.ibm.etools.j2ee.commonarchivecore.helpers.FileIterator;
import com.ibm.etools.webservice.wsbnd.RouterModule;
import com.ibm.etools.webservice.wsbnd.WSBinding;
import com.ibm.etools.webservice.wsdd.WebServices;
import com.ibm.websphere.management.application.client.AppDeploymentException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.application.AppUtils;
import com.ibm.ws.webservices.WSModels;
import com.ibm.ws.webservices.deploy.DeployUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import org.eclipse.emf.common.util.EList;

public class CopyWSDLFilesToRouterWAR {
    private EARFile earFile;
    private ResourceBundle bundle;
    private static TraceComponent tc = Tr.register((Class)CopyWSDLFilesToRouterWAR.class, (String)"WebServices", (String)"com.ibm.ws.webservices.deploy.resources.deployMessages");

    CopyWSDLFilesToRouterWAR(EARFile eARFile, ResourceBundle resourceBundle) {
        this.earFile = eARFile;
        this.bundle = resourceBundle;
    }

    public void copyFiles() throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"copyFiles");
        }
        List list = this.earFile.getEJBJarFiles();
        List list2 = this.earFile.getWARFiles();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            ModuleFile moduleFile = (ModuleFile)iterator.next();
            String string = moduleFile.getURI();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("copyFiles: working on module " + string));
            }
            WebServices webServices = null;
            if (moduleFile.isEJBJarFile()) {
                webServices = WSModels.getWebServices(moduleFile.getLoadStrategy(), "META-INF/webservices.xml");
            }
            if (webServices != null) {
                String string2;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("copyFiles: module " + string + " is Web Service enabled"));
                }
                if ((string2 = this.getNameOfRouterWarForEJBModule(moduleFile, list2)) == null) continue;
                ModuleFile moduleFile2 = moduleFile;
                String string3 = DeployUtils.createWorkingDirectory(null);
                this.extractModulesFilesToTmpDir(string, moduleFile2, string3);
                String string4 = string3 + File.separator + "META-INF/wsdl".replace('/', File.separatorChar);
                this.deepCopyDirToModule(string4, "WEB-INF/wsdl", string2);
                DeployUtils.deleteWorkingDirectory(string3);
                continue;
            }
            if (!tc.isDebugEnabled()) continue;
            Tr.debug((TraceComponent)tc, (String)("copyFiles: module " + string + "is Web NOT Service enabled"));
        }
    }

    private void extractModulesFilesToTmpDir(String string, ModuleFile moduleFile, String string2) throws AppDeploymentException {
        try {
            moduleFile.extractTo(string2, 10);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.webservices.deploy.CopyWSDLFilesToRouterWAR.copyFiles", (String)"403", (Object)this);
            Exception exception2 = exception instanceof SaveFailureException ? ((SaveFailureException)exception).getNestedException() : exception;
            Object[] objectArray = new Object[]{string, exception2};
            String string3 = AppUtils.getMessage((ResourceBundle)this.bundle, (String)"WSWS0005E", (Object[])objectArray);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("extractModulesFilesToTmpDir: " + string3));
            }
            Tr.error((TraceComponent)tc, (String)"WSWS0005E", (Object)objectArray);
            throw new AppDeploymentException(string3, (Throwable)exception2);
        }
    }

    private String getNameOfRouterWarForEJBModule(ModuleFile moduleFile, List list) {
        RouterModule routerModule;
        String string = moduleFile.getURI();
        String string2 = null;
        RouterModule routerModule2 = null;
        String string3 = null;
        WSBinding wSBinding = null;
        try {
            wSBinding = WSModels.getWSBinding(moduleFile.getLoadStrategy(), "META-INF/ibm-webservices-bnd.xmi");
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.webservices.deploy.CopyWSDLFilesToRouterWAR.getNameOfRouterWarForEJBModule", (String)"552", (Object)this);
        }
        EList eList = wSBinding.getRouterModules();
        for (int i = 0; i < eList.size(); ++i) {
            routerModule = (RouterModule)eList.get(i);
            if (!"http".equals(routerModule.getTransport())) continue;
            string2 = routerModule.getName();
            break;
        }
        if (string2 != null) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                routerModule = (WARFile)iterator.next();
                String string4 = routerModule.getURI();
                if (!string4.equals(string2)) continue;
                routerModule2 = routerModule;
                break;
            }
            if (routerModule2 == null) {
                return null;
            }
            string3 = routerModule2.getURI();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("getNameOfRouterWarForEJBModule: for EJB module " + string + " the router WAR is " + string3));
            }
            return string3;
        }
        return null;
    }

    private void copyFileToModule(File file, String string, String string2) throws AppDeploymentException {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("copyFileToModule: fileToBecopie=" + file + " targetModuleName=" + string + " pathInTargetModule=" + string2));
        }
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
        }
        catch (FileNotFoundException fileNotFoundException) {
            FFDCFilter.processException((Throwable)fileNotFoundException, (String)"com.ibm.ws.webservices.deploy.CopyWSDLFilesToRouterWAR.copyFiles", (String)"706", (Object)this);
            Object[] objectArray = new Object[]{file, fileNotFoundException};
            String string3 = AppUtils.getMessage((ResourceBundle)this.bundle, (String)"WSWS0015E", (Object[])objectArray);
            Tr.error((TraceComponent)tc, (String)"WSWS0015E", (Object)objectArray);
            throw new AppDeploymentException(string3, (Throwable)fileNotFoundException);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("copyFiles: about to save the wsdl file \"" + string2 + "\" into module " + string));
        }
        CopyWSDLFilesToRouterWAR.saveAsFile(this.earFile, string, string2, fileInputStream);
        try {
            fileInputStream.close();
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.webservices.deploy.CopyWSDLFilesToRouterWAR.copyFiles", (String)"437", (Object)this);
            Tr.warning((TraceComponent)tc, (String)"WSWS0028W", (Object)fileInputStream);
        }
    }

    private void deepCopyDirToModule(String string, String string2, String string3) throws AppDeploymentException {
        File file;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("deepCopyDirToModule:  sourceDir=" + string + " targetDir=" + string2 + " targetModule=" + string3));
        }
        if (!(file = new File(string)).exists()) {
            return;
        }
        File[] fileArray = file.listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            String string4 = string2 + "/" + fileArray[i].getName();
            if (fileArray[i].isFile()) {
                this.copyFileToModule(fileArray[i], string3, string4);
            }
            if (!fileArray[i].isDirectory()) continue;
            this.deepCopyDirToModule(fileArray[i].getPath(), string4, string3);
        }
    }

    private static String saveAsFile(EARFile eARFile, String string, String string2, InputStream inputStream) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"saveAsFile");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("moduleUri: " + string + ", fileUri: " + string2));
        }
        String string3 = null;
        if (inputStream == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"inputStream is null");
            }
        } else {
            CommonarchiveFactory commonarchiveFactory;
            if (eARFile == null) {
                return null;
            }
            EARFile eARFile2 = null;
            if (string == null || string.trim().equals("")) {
                eARFile2 = eARFile;
            } else {
                commonarchiveFactory = eARFile.getArchiveFiles().iterator();
                while (commonarchiveFactory.hasNext() && !(eARFile2 = (Archive)commonarchiveFactory.next()).getURI().equals(string)) {
                    eARFile2 = null;
                }
            }
            if (eARFile2 != null) {
                Exception exception;
                block37: {
                    String string4;
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("found matching archive: " + eARFile2));
                    }
                    ArchiveInit.init();
                    commonarchiveFactory = CommonarchiveFactoryImpl.getActiveFactory();
                    exception = null;
                    string3 = System.getProperty("java.io.tmpdir");
                    if (!string3.endsWith(File.separator)) {
                        string3 = string3 + File.separator;
                    }
                    File file = new File(eARFile.getURI());
                    string3 = string3 + file.getName();
                    if (string != null && !string.equals("")) {
                        string3 = string3 + "_" + string;
                    }
                    if (string2 != null && !string2.equals("")) {
                        string4 = string2.replace('/', '_');
                        string4 = string4.replace('\\', '_');
                        string3 = string3 + "_" + string4;
                    }
                    string3 = string3 + "_" + System.currentTimeMillis();
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("temp dirname: " + string3));
                    }
                    string4 = string3;
                    if (string2 != null && !string2.equals("")) {
                        string4 = string4 + File.separator + string2;
                    }
                    File file2 = new File(string4);
                    file2 = new File(file2.getParent());
                    FileOutputStream fileOutputStream = null;
                    try {
                        if (file2.exists()) {
                            AppUtils.deleteDirTree((File)file2);
                        }
                        file2.mkdirs();
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("save file location: " + string4));
                        }
                        if ((fileOutputStream = new FileOutputStream(string4)) != null) {
                            int n = 0;
                            byte[] byArray = new byte[1024];
                            while ((n = inputStream.read(byArray)) != -1) {
                                fileOutputStream.write(byArray, 0, n);
                            }
                            fileOutputStream.close();
                            fileOutputStream = null;
                            ReadOnlyDirectory readOnlyDirectory = commonarchiveFactory.openReadOnlyDirectory(string3);
                            com.ibm.etools.j2ee.commonarchivecore.File file3 = readOnlyDirectory.getFileInSelfOrSubdirectory(string2);
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)("file in readDir: " + file3));
                            }
                            if (file3 != null && eARFile2.isDuplicate(string2)) {
                                FileIterator fileIterator = eARFile2.getFilesForSave();
                                while (fileIterator.hasNext()) {
                                    com.ibm.etools.j2ee.commonarchivecore.File file4 = fileIterator.next();
                                    if (!file4.getURI().equals(string2)) continue;
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug((TraceComponent)tc, (String)".... Removing existing file");
                                    }
                                    eARFile2.remove(file4);
                                    break;
                                }
                            }
                            if (file3 != null) {
                                eARFile2.addCopy(file3);
                            }
                        } else if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"Not able to create the input stream as a file");
                        }
                    }
                    catch (Exception exception2) {
                        FFDCFilter.processException((Throwable)exception2, (String)"com.ibm.ws.webservices.deploy.CopyWSDLFilesToRouterWAR.saveAsFile", (String)"505");
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("File IO exception: " + exception2));
                        }
                        exception = exception2;
                    }
                    if (fileOutputStream != null) {
                        try {
                            fileOutputStream.close();
                        }
                        catch (IOException iOException) {
                            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.webservices.deploy.CopyWSDLFilesToRouterWAR.saveAsFile", (String)"516");
                            if (!tc.isDebugEnabled()) break block37;
                            Tr.debug((TraceComponent)tc, (String)("Error closing save file: " + fileOutputStream + ", " + iOException));
                        }
                    }
                }
                if (exception != null) {
                    throw new AppDeploymentException(exception.toString(), (Throwable)exception);
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Not able to find matching module: " + string));
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"saveAsFile");
        }
        return string3;
    }
}

