/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.configuration;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.protocol.Protocols;
import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.webservices.WebServicesService;
import com.ibm.ws.webservices.WebServicesServiceHome;
import com.ibm.ws.webservices.engine.ConfigurationException;
import com.ibm.ws.webservices.engine.deployment.wsdd.WSDDDeployableItem;
import com.ibm.ws.webservices.engine.deployment.wsdd.WSDDDeployment;
import com.ibm.ws.webservices.engine.deployment.wsdd.WSDDDispatcher;
import com.ibm.ws.webservices.engine.deployment.wsdd.WSDDGlobalConfiguration;
import com.ibm.ws.webservices.engine.deployment.wsdd.WSDDJAXRPCHandlerInfo;
import com.ibm.ws.webservices.engine.deployment.wsdd.WSDDJAXRPCHandlerInfoChain;
import com.ibm.ws.webservices.engine.deployment.wsdd.WSDDPort;
import com.ibm.ws.webservices.engine.deployment.wsdd.WSDDTargetedChain;
import com.ibm.ws.webservices.engine.deployment.wsdd.WSDDTransport;
import com.ibm.ws.webservices.engine.handlers.jaxrpc.ExtendedHandlerInfo;
import com.ibm.ws.webservices.engine.lifecycle.LifeCycleException;
import com.ibm.ws.webservices.engine.lifecycle.LifeCycleObject;
import com.ibm.ws.webservices.engine.lifecycle.LifeCycleOwner;
import com.ibm.ws.webservices.engine.lifecycle.LifeCycleSetImpl;
import com.ibm.ws.webservices.engine.lifecycle._LifeCycleObject;
import com.ibm.ws.webservices.engine.utils.JavaUtils;
import com.ibm.ws.webservices.engine.utils.QNameTable;
import com.ibm.ws.webservices.metadata.PortMetaData;
import com.ibm.ws.webservices.xml.WASEntityResolver;
import com.ibm.ws.webservices.xml.waswebservices.client;
import com.ibm.ws.webservices.xml.waswebservices.dispatcher;
import com.ibm.ws.webservices.xml.waswebservices.global;
import com.ibm.ws.webservices.xml.waswebservices.handler;
import com.ibm.ws.webservices.xml.waswebservices.header;
import com.ibm.ws.webservices.xml.waswebservices.parameter;
import com.ibm.ws.webservices.xml.waswebservices.pool;
import com.ibm.ws.webservices.xml.waswebservices.port;
import com.ibm.ws.webservices.xml.waswebservices.server;
import com.ibm.ws.webservices.xml.waswebservices.transport;
import com.ibm.ws.webservices.xml.waswebservices.wasws;
import com.ibm.ws.webservices.xml.waswebservices.waswsFactory;
import com.ibm.wsspi.webservices.rpc.handler.Handler;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.commons.discovery.log.DiscoveryLogFactory;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.InputSource;

public class WebServicesEngineConfigurationGenerator
implements LifeCycleOwner,
_LifeCycleObject {
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.webservices.resources.webservicesMessages");
    private static final TraceComponent _tc = Tr.register((Class)WebServicesEngineConfigurationGenerator.class, (String)"WebServices", (String)"com.ibm.ws.webservices.resources.webservicesMessages");
    private LifeCycleSetImpl _lifeCycleSet = this.lifeCycleSetFactory(this);
    private static final String ALL_TRANSPORTS_PROTOCOL = "com.ibm.ws.webservices.transports.all";
    private static WebServicesEngineConfigurationGenerator[] _aecg = new WebServicesEngineConfigurationGenerator[2];
    private final int engineType;
    private final ClassLoader classLoader = this.getClass().getClassLoader();
    private final WASConfig clientConfig;
    private final WASConfig serverConfig;
    public static final int CLIENT_CONTAINER = 1;
    public static final int SERVER_CONTAINER = 2;

    private static synchronized WebServicesEngineConfigurationGenerator getConfigGenerator() {
        return WebServicesEngineConfigurationGenerator.getConfigGeneratorInternal(0);
    }

    private static synchronized WebServicesEngineConfigurationGenerator getConfigGeneratorInternal(int n) {
        if (WebServicesEngineConfigurationGenerator.isValidEngineSelection(n)) {
            WebServicesEngineConfigurationGenerator.loadConfiguration(n);
            if (_aecg[n] == null) {
                Tr.error((TraceComponent)_tc, (String)"webservices.config.not.loaded");
            }
            return _aecg[n];
        }
        Object[] objectArray = new Object[]{"WebServicesEngineConfigurationGenerator.getConfigGenerator: Invalid engine selection " + n};
        Tr.error((TraceComponent)_tc, (String)"internal.error", (Object)objectArray);
        return null;
    }

    public static synchronized WebServicesEngineConfigurationGenerator getConfigGenerator(int n) {
        WebServicesEngineConfigurationGenerator.loadConfiguration();
        return WebServicesEngineConfigurationGenerator.getConfigGenerator();
    }

    private static synchronized void loadConfiguration(int n) {
        if (_tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)_tc, (String)"loadConfiguration", (Object)("whichEngine=" + n));
        }
        if (WebServicesEngineConfigurationGenerator.isValidEngineSelection(n)) {
            if (_aecg[n] == null) {
                WebServicesEngineConfigurationGenerator._aecg[n] = new WebServicesEngineConfigurationGenerator(n);
                _aecg[n].init();
            }
        } else {
            Object[] objectArray = new Object[]{"Invalid engine selction " + n};
            Tr.error((TraceComponent)_tc, (String)"internal.error", (Object)objectArray);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)_tc, (String)"loadConfiguration");
        }
    }

    private static boolean isValidEngineSelection(int n) {
        return n >= 0 && n <= 1;
    }

    private static synchronized void loadConfiguration() {
        WebServicesEngineConfigurationGenerator.loadConfiguration(0);
    }

    public static synchronized void destroyConfigGenerator() {
        WebServicesEngineConfigurationGenerator.destroyConfigGenerator(0);
    }

    public static synchronized void destroyConfigGenerator(int n) {
        if (WebServicesEngineConfigurationGenerator.isValidEngineSelection(n)) {
            if (_aecg[n] != null) {
                _aecg[n].destroy();
                WebServicesEngineConfigurationGenerator._aecg[n] = null;
            }
        } else {
            Object[] objectArray = new Object[]{"WebServicesEngineConfigurationGenerator.destroyConfigGenerator: Invalid engine selection " + n};
            Tr.error((TraceComponent)_tc, (String)"internal.error", (Object)objectArray);
        }
    }

    private WebServicesEngineConfigurationGenerator() {
        this(0);
    }

    private WebServicesEngineConfigurationGenerator(int n) {
        if (_tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)_tc, (String)"WebServicesEngineConfigurationGenerator ctor", (Object)("engineType=" + n));
        }
        this.engineType = n;
        this.clientConfig = new WASConfig(1, this.classLoader);
        this.serverConfig = new WASConfig(2, this.classLoader);
        if (_tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)_tc, (String)"WebServicesEngineConfigurationGenerator ctor");
        }
    }

    public static WSDDDeployment createServerDeployment(Collection collection) {
        return WebServicesEngineConfigurationGenerator.createServerDeployment(0, collection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static WSDDDeployment createServerDeployment(int n, Collection collection) {
        WSDDDeployment wSDDDeployment;
        if (_tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)_tc, (String)"createServerDeployment");
        }
        if ((collection == null || collection.size() < 1) && _tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)_tc, (String)"no services to deploy for server");
        }
        try {
            WASConfig wASConfig = WebServicesEngineConfigurationGenerator.getConfigGeneratorInternal(n) == null ? null : WebServicesEngineConfigurationGenerator.getConfigGeneratorInternal((int)n).serverConfig;
            wSDDDeployment = WebServicesEngineConfigurationGenerator.getDeployment(wASConfig, collection);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            block5: {
                Object var5_5 = null;
                if (!_tc.isEntryEnabled()) break block5;
                Tr.exit((TraceComponent)_tc, (String)"createServerDeployment");
            }
            throw throwable;
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)_tc, (String)"createServerDeployment");
        }
        return wSDDDeployment;
    }

    public static WSDDDeployment createClientDeployment(Collection collection) {
        return WebServicesEngineConfigurationGenerator.createClientDeployment(0, collection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static WSDDDeployment createClientDeployment(int n, Collection collection) {
        WSDDDeployment wSDDDeployment;
        if (_tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)_tc, (String)"createClientDeployment", (Object)("ports=" + (collection != null ? collection.toString() : "<null>")));
        }
        if ((collection == null || collection.size() < 1) && _tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)_tc, (String)"no services to deploy for client");
        }
        try {
            WASConfig wASConfig = WebServicesEngineConfigurationGenerator.getConfigGeneratorInternal(n) == null ? null : WebServicesEngineConfigurationGenerator.getConfigGeneratorInternal((int)n).clientConfig;
            wSDDDeployment = WebServicesEngineConfigurationGenerator.getDeployment(wASConfig, collection);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            block5: {
                Object var5_5 = null;
                if (!_tc.isEntryEnabled()) break block5;
                Tr.exit((TraceComponent)_tc, (String)"createClientDeployment");
            }
            throw throwable;
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)_tc, (String)"createClientDeployment");
        }
        return wSDDDeployment;
    }

    private boolean isRoleApplicableToService(int n) {
        WebServicesService webServicesService = null;
        if (n == 1) {
            return true;
        }
        webServicesService = this.engineType == 1 ? WebServicesServiceHome.getWebServicesSystemService() : WebServicesServiceHome.getWebServicesService();
        return webServicesService == null ? false : webServicesService.isRoleApplicableToService(n);
    }

    private static WSDDDeployment getDeployment(WASConfig wASConfig, Collection collection) {
        WSDDDeployment wSDDDeployment = (WSDDDeployment)AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction(){

            public Object run() {
                WSDDDeployment wSDDDeployment = new WSDDDeployment();
                wSDDDeployment.setContainerManaged(true);
                return wSDDDeployment;
            }
        });
        if (wASConfig != null) {
            wASConfig.deploy(wSDDDeployment);
        }
        if (collection != null && collection.size() > 0) {
            Iterator iterator = collection.iterator();
            int n = 0;
            while (iterator.hasNext()) {
                WSDDPort wSDDPort = ((PortMetaData)iterator.next()).getWsddPort();
                if (wASConfig != null) {
                    wASConfig.deploy(wSDDPort);
                }
                if (_tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)_tc, (String)("Port(" + n + ") is " + wSDDPort));
                }
                wSDDDeployment.deployPort(wSDDPort);
                ++n;
            }
        }
        if (_tc.isDebugEnabled()) {
            wSDDDeployment.dump();
        }
        return wSDDDeployment;
    }

    private LifeCycleSetImpl lifeCycleSetFactory(_LifeCycleObject _LifeCycleObject2) {
        return new LifeCycleSetImpl(_LifeCycleObject2, true, false);
    }

    public void setOwner(LifeCycleOwner lifeCycleOwner) throws LifeCycleException {
        this._lifeCycleSet.setOwner(lifeCycleOwner);
    }

    public LifeCycleOwner getOwner() {
        return this._lifeCycleSet.getOwner();
    }

    public final void init() throws LifeCycleException {
        this._lifeCycleSet.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void _init() throws LifeCycleException {
        if (_tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)_tc, (String)"_init");
        }
        try {
            AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction(){

                public Object run() {
                    WebServicesEngineConfigurationGenerator.this.privilegedInit();
                    return null;
                }
            });
            this.serverConfig.distributeGlobals();
            this.serverConfig.addGlobalHeadersToPortHandlers();
            this.serverConfig.gatherProtectedHeaders();
            this.clientConfig.distributeGlobals();
            this.clientConfig.addGlobalHeadersToPortHandlers();
            this.clientConfig.gatherProtectedHeaders();
            this._lifeCycleSet._init();
            Object var2_1 = null;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            if (_tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)_tc, (String)"_init");
            }
            throw throwable;
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)_tc, (String)"_init");
        }
    }

    private String getGlobalConfigFile() {
        if (this.engineType == 1) {
            return "META-INF/was-syswebservices.xml";
        }
        return "META-INF/was-webservices.xml";
    }

    private void privilegedInit() {
        if (_tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)_tc, (String)"privilegedInit");
        }
        Enumeration<URL> enumeration = null;
        String string = this.getGlobalConfigFile();
        try {
            enumeration = this.classLoader.getResources(string);
        }
        catch (IOException iOException) {
            Tr.error((TraceComponent)_tc, (String)"cannot.load.resource", (Object)new Object[]{string, iOException});
        }
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                int n;
                int n2;
                int n3;
                int n4;
                int n5;
                InputStream inputStream;
                URL uRL = enumeration.nextElement();
                if (_tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)_tc, (String)("About to read global config file: " + uRL.toString()));
                }
                try {
                    inputStream = uRL.openStream();
                }
                catch (IOException iOException) {
                    Tr.error((TraceComponent)_tc, (String)"internal.error", (Object)iOException);
                    inputStream = null;
                }
                if (inputStream == null) continue;
                waswsFactory waswsFactory2 = new waswsFactory();
                waswsFactory2.setPackageName("com.ibm.ws.webservices.xml.waswebservices");
                wasws wasws2 = (wasws)waswsFactory2.loadDocument("wasws", new InputSource(inputStream), string, false, true, new WASEntityResolver());
                if (wasws2 == null) {
                    Tr.warning((TraceComponent)_tc, (String)"warning.parse.file.failure", (Object)string);
                    continue;
                }
                int n6 = wasws2.getglobalCount();
                for (n5 = 0; n5 < n6; ++n5) {
                    global global2 = wasws2.getGlobal(n5);
                    this.clientConfig.add(global2);
                    this.serverConfig.add(global2);
                }
                n5 = wasws2.getportCount();
                for (n4 = 0; n4 < n5; ++n4) {
                    port port2 = wasws2.getPort(n4);
                    this.clientConfig.add(port2);
                    this.serverConfig.add(port2);
                }
                n4 = wasws2.gettransportCount();
                for (n3 = 0; n3 < n4; ++n3) {
                    transport transport2 = wasws2.getTransport(n3);
                    this.clientConfig.add(transport2);
                    this.serverConfig.add(transport2);
                }
                n3 = wasws2.getparameterCount();
                for (n2 = 0; n2 < n3; ++n2) {
                    parameter parameter2 = wasws2.getParameter(n2);
                    this.clientConfig.add(parameter2);
                    this.serverConfig.add(parameter2);
                }
                n2 = wasws2.getclientCount();
                for (n = 0; n < n2; ++n) {
                    this.clientConfig.add(wasws2.getClient(n));
                }
                n = wasws2.getserverCount();
                for (int i = 0; i < n; ++i) {
                    this.serverConfig.add(wasws2.getServer(i));
                }
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)_tc, (String)"privilegedInit");
        }
    }

    public final void destroy() {
        this._lifeCycleSet.destroy();
    }

    public void _destroy() {
        this._lifeCycleSet._destroy();
    }

    public int getState() {
        return this._lifeCycleSet.getState();
    }

    public boolean isActive() {
        return this._lifeCycleSet.isActive();
    }

    public void verifyActive() throws LifeCycleException {
        this._lifeCycleSet.verifyActive();
    }

    public void verifyInactive() throws LifeCycleException {
        this._lifeCycleSet.verifyInactive();
    }

    public boolean releaseLifeCycleManagementOf(LifeCycleObject lifeCycleObject) throws LifeCycleException {
        return false;
    }

    protected boolean manageLifeCycleOf(LifeCycleObject lifeCycleObject) {
        return this._lifeCycleSet.manageLifeCycleOf(lifeCycleObject);
    }

    protected boolean tempManageLifeCycleOf(LifeCycleObject lifeCycleObject) {
        return this._lifeCycleSet.manageLifeCycleOf(lifeCycleObject, false);
    }

    static {
        DiscoveryLogFactory.setFactory((LogFactory)com.ibm.ws.webservices.engine.components.logger.LogFactory.getLogFactory());
        Protocols.init();
        if (_tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)_tc, (String)("java.protocol.handler.pkgs=" + System.getProperty("java.protocol.handler.pkgs")));
        }
    }

    private final class WASConfig {
        private final String _role;
        private final boolean _applicable;
        private final int _modeClientServer;
        private final ClassLoader _classLoader;
        private WASParameters _parameters;
        private final WASHandlers _globalHandlers;
        private final WASHandlers _portHandlers;
        private HashMap _transportMap;
        private ArrayList _protectedHeaders;

        WASConfig(int n, ClassLoader classLoader) {
            this._parameters = new WASParameters();
            this._transportMap = new HashMap();
            this._protectedHeaders = new ArrayList();
            if (n == 1) {
                this._role = Handler.HANDLER_PARAM_ROLE_CLIENT;
                this._modeClientServer = 1;
            } else {
                this._role = Handler.HANDLER_PARAM_ROLE_SERVER;
                this._modeClientServer = 2;
            }
            this._applicable = WebServicesEngineConfigurationGenerator.this.isRoleApplicableToService(n);
            this._classLoader = classLoader;
            this._globalHandlers = new WASHandlers(Handler.HANDLER_PARAM_CAT_GLOBAL, this._role, this._modeClientServer);
            this._portHandlers = new WASHandlers(Handler.HANDLER_PARAM_CAT_PORT, this._role, this._modeClientServer);
        }

        void add(client client2) {
            if (this._applicable && client2 != null) {
                int n;
                int n2;
                int n3;
                int n4 = client2.getglobalCount();
                for (n3 = 0; n3 < n4; ++n3) {
                    this.add(client2.getGlobal(n3));
                }
                n3 = client2.getportCount();
                for (n2 = 0; n2 < n3; ++n2) {
                    this.add(client2.getPort(n2));
                }
                n2 = client2.gettransportCount();
                for (n = 0; n < n2; ++n) {
                    this.add(client2.getTransport(n));
                }
                n = client2.getparameterCount();
                for (int i = 0; i < n; ++i) {
                    this.add(client2.getParameter(i));
                }
            }
        }

        void add(server server2) {
            if (this._applicable && server2 != null) {
                int n;
                int n2;
                int n3;
                int n4;
                int n5 = server2.getglobalCount();
                for (n4 = 0; n4 < n5; ++n4) {
                    this.add(server2.getGlobal(n4));
                }
                n4 = server2.getportCount();
                for (n3 = 0; n3 < n4; ++n3) {
                    this.add(server2.getPort(n3));
                }
                n3 = server2.gettransportCount();
                for (n2 = 0; n2 < n3; ++n2) {
                    this.add(server2.getTransport(n2));
                }
                n2 = server2.getparameterCount();
                for (n = 0; n < n2; ++n) {
                    this.add(server2.getParameter(n));
                }
                n = server2.getdispatcherCount();
                for (int i = 0; i < n; ++i) {
                    this.add(server2.getDispatcher(i));
                }
            }
        }

        void add(parameter parameter2) {
            if (this._applicable && parameter2 != null) {
                this._parameters.add(parameter2);
            }
        }

        void add(global global2) {
            if (this._applicable && global2 != null) {
                int n;
                int n2 = global2.gethandlerCount();
                for (n = 0; n < n2; ++n) {
                    this._globalHandlers.add(new WASHandler(global2.getHandler(n), this.getClassLoader()));
                }
                n = global2.getroleCount();
                for (int i = 0; i < n; ++i) {
                    this._globalHandlers.addRole(global2.getRole(i));
                    this._portHandlers.addRole(global2.getRole(i));
                }
            }
        }

        void add(port port2) {
            if (this._applicable && port2 != null) {
                int n;
                int n2 = port2.gethandlerCount();
                for (n = 0; n < n2; ++n) {
                    this._portHandlers.add(new WASHandler(port2.getHandler(n), this.getClassLoader()));
                }
                n = port2.getroleCount();
                for (int i = 0; i < n; ++i) {
                    this._portHandlers.addRole(port2.getRole(i));
                }
            }
        }

        void add(transport transport2) {
            block6: {
                int n;
                int n2;
                block7: {
                    if (!this._applicable || transport2 == null) break block6;
                    n2 = transport2.getprotocolCount();
                    if (n2 <= 0) break block7;
                    for (int i = 0; i < n2; ++i) {
                        int n3;
                        String string = transport2.getProtocol(i);
                        WASTransport wASTransport = this.getTransport(string);
                        wASTransport.addParameters(transport2);
                        if (transport2.getJavaclass() != null) {
                            wASTransport.setPivot(transport2.getJavaclass());
                        }
                        int n4 = transport2.gethandlerCount();
                        for (n3 = 0; n3 < n4; ++n3) {
                            wASTransport.addHandler(new WASHandler(transport2.getHandler(n3), this.getClassLoader()));
                        }
                        n3 = transport2.getroleCount();
                        for (int j = 0; j < n3; ++j) {
                            this._portHandlers.addRole(transport2.getRole(j));
                        }
                    }
                    break block6;
                }
                if (n2 != 0) break block6;
                WASTransport wASTransport = this.getTransport(WebServicesEngineConfigurationGenerator.ALL_TRANSPORTS_PROTOCOL);
                wASTransport.addParameters(transport2);
                int n5 = transport2.gethandlerCount();
                for (n = 0; n < n5; ++n) {
                    wASTransport.addHandler(new WASHandler(transport2.getHandler(n), this.getClassLoader()));
                }
                n = transport2.getroleCount();
                for (int i = 0; i < n; ++i) {
                    this._portHandlers.addRole(transport2.getRole(i));
                }
            }
        }

        Iterator getTransports() {
            return this._transportMap.values().iterator();
        }

        WASTransport getTransport(String string) {
            WASTransport wASTransport = (WASTransport)this._transportMap.get(string);
            if (wASTransport == null) {
                wASTransport = new WASTransport(string, this._role, this._modeClientServer);
                this._transportMap.put(string, wASTransport);
            }
            return wASTransport;
        }

        void removeTransport(String string) {
            this._transportMap.remove(string);
        }

        void add(dispatcher dispatcher2) {
            if (this._applicable && dispatcher2 != null) {
                String string = dispatcher2.getName();
                String string2 = dispatcher2.getJavaclass();
                try {
                    WSDDDispatcher.registerDispatcher(QNameTable.createQName("http://websphere.ibm.com/webservices/wsdd/dispatchers/java", string), string2);
                }
                catch (ConfigurationException configurationException) {
                    Tr.error((TraceComponent)_tc, (String)"warning.provider.not.verified", (Object)new Object[]{string2, string, configurationException});
                }
            }
        }

        void distributeGlobals() {
            WASTransport wASTransport = this.getTransport(WebServicesEngineConfigurationGenerator.ALL_TRANSPORTS_PROTOCOL);
            this.removeTransport(WebServicesEngineConfigurationGenerator.ALL_TRANSPORTS_PROTOCOL);
            this._portHandlers.addRoles(wASTransport.getRoles());
            if (this._portHandlers._chain != null && wASTransport.getHandlers()._chain != null) {
                this._portHandlers._chain.addGlobalHeaders(wASTransport.getHandlers()._chain.getAllHeaders());
            }
            Iterator iterator = this.getTransports();
            while (iterator.hasNext()) {
                WASTransport wASTransport2 = (WASTransport)iterator.next();
                this._portHandlers.addRoles(wASTransport2.getRoles());
                if (wASTransport2.getHandlers()._chain != null) {
                    this._portHandlers._chain.addGlobalHeaders(wASTransport2.getHandlers()._chain.getAllHeaders());
                }
                wASTransport2.addParameters(wASTransport.getMap());
                wASTransport2.addHandlers(wASTransport.getHandlers());
            }
        }

        void addGlobalHeadersToPortHandlers() {
            ArrayList arrayList = (ArrayList)this._globalHandlers._chain.getAllHeaders();
            if (arrayList != null) {
                this._portHandlers._chain.addGlobalHeaders(arrayList);
            }
        }

        void gatherProtectedHeaders() {
            if (this._globalHandlers._chain != null) {
                this._protectedHeaders.addAll(this._globalHandlers._chain.getProtectedHeaders());
            }
            if (this._portHandlers._chain != null) {
                this._protectedHeaders.addAll(this._portHandlers._chain.getProtectedHeaders());
            }
            Iterator iterator = this.getTransports();
            while (iterator.hasNext()) {
                WASTransport wASTransport = (WASTransport)iterator.next();
                if (wASTransport.getHandlers()._chain == null) continue;
                this._protectedHeaders.addAll(wASTransport.getHandlers()._chain.getProtectedHeaders());
            }
        }

        void deploy(WSDDDeployment wSDDDeployment) {
            Object object = this.getTransports();
            while (object.hasNext()) {
                wSDDDeployment.deployTransport(((WASTransport)object.next()).createWSDDTransport());
            }
            object = new WSDDGlobalConfiguration(this.getModeClientServer());
            ((WSDDDeployableItem)object).setParameters(this._parameters.getMap());
            ((WSDDTargetedChain)object).setHandlerInfoChain(this._globalHandlers._chain);
            ((WSDDGlobalConfiguration)object).setProtectedHeaders(this._protectedHeaders);
            wSDDDeployment.setGlobalConfiguration((WSDDGlobalConfiguration)object);
        }

        void deploy(WSDDPort wSDDPort) {
            wSDDPort.addHandlerInfo(this._portHandlers._chain);
            wSDDPort.addRoles(this._portHandlers._chain.getRoles());
        }

        public int getModeClientServer() {
            return this._modeClientServer;
        }

        private ClassLoader getClassLoader() {
            return this._classLoader;
        }
    }

    private class WASTransport {
        private final int _modeClientServer;
        private String _protocol;
        private String _pivotClass;
        private WASHandlers _handlers;
        private WASParameters _parameters;

        WASTransport(String string, String string2, int n) {
            this._parameters = new WASParameters();
            this._protocol = string;
            this._modeClientServer = n;
            this._handlers = new WASHandlers(Handler.HANDLER_PARAM_CAT_TRANSPORT, string2, n);
        }

        void addParameters(transport transport2) {
            if (transport2 != null) {
                int n = transport2.getparameterCount();
                for (int i = 0; i < n; ++i) {
                    this._parameters.add(transport2.getParameter(i));
                }
            }
        }

        void addParameters(Map map) {
            if (map != null) {
                this._parameters.add(map);
            }
        }

        WASHandlers getHandlers() {
            return this._handlers;
        }

        Collection getRoles() {
            return this._handlers.getRoles();
        }

        void addHandler(WASHandler wASHandler) {
            this._handlers.add(wASHandler);
        }

        void addRole(String string) {
            this._handlers.addRole(string);
        }

        void addHandlers(WASHandlers wASHandlers) {
            this._handlers.addHandlers(wASHandlers);
        }

        void addRoles(Collection collection) {
            this._handlers.addRoles(collection);
        }

        void setPivot(String string) {
            this._pivotClass = string;
        }

        private WSDDTransport createWSDDTransport() {
            WSDDTransport wSDDTransport = new WSDDTransport(this._modeClientServer);
            wSDDTransport.setName(this._protocol);
            wSDDTransport.setParameters(this._parameters.getMap());
            wSDDTransport.setHandlerInfoChain(this._handlers._chain);
            if (this._pivotClass != null) {
                wSDDTransport.setPivotQName(QNameTable.createQName("http://websphere.ibm.com/webservices/wsdd/dispatchers/java", this._pivotClass));
            }
            return wSDDTransport;
        }

        public Map getMap() {
            return this._parameters.getMap();
        }
    }

    private class WASHandlers {
        private final String _name;
        private final String _role;
        final WSDDJAXRPCHandlerInfoChain _chain;

        WASHandlers(String string, String string2, int n) {
            this._chain = new WSDDJAXRPCHandlerInfoChain(n == 1, false);
            this._name = string;
            this._role = string2;
            WebServicesEngineConfigurationGenerator.this.manageLifeCycleOf(this._chain);
        }

        void add(WASHandler wASHandler) {
            if (wASHandler == null) {
                return;
            }
            WSDDJAXRPCHandlerInfo wSDDJAXRPCHandlerInfo = wASHandler.createWSDDJAXRPCHandlerInfo(this._name, this._role);
            if (wSDDJAXRPCHandlerInfo != null) {
                this._chain.addHandlerInfo(wSDDJAXRPCHandlerInfo);
            }
        }

        void addHandlers(WASHandlers wASHandlers) {
            if (wASHandlers != null) {
                this._chain.addHandlerInfoList(wASHandlers._chain.getHandlerInfoList());
            }
        }

        void addRole(String string) {
            this._chain.addRole(string);
        }

        void addRoles(Collection collection) {
            this._chain.addRoles(collection);
        }

        Collection getRoles() {
            return this._chain.getRoles();
        }
    }

    private final class WASHandler {
        private final String _name;
        private final String _javaclass;
        private final ClassLoader _classLoader;
        private final int _priority;
        private final WASParameters _params;
        private int _min;
        private int _max;
        private boolean _faultLocal = false;
        private boolean _autoResponse = true;
        private WASHeaders _headers;
        private boolean _canLoad;

        WASHandler(handler handler2, ClassLoader classLoader) {
            Object object;
            int n;
            this._name = handler2.getName();
            this._javaclass = handler2.getJavaclass();
            this._classLoader = classLoader;
            this._canLoad = true;
            this._params = new WASParameters();
            int n2 = handler2.getparameterCount();
            for (n = 0; n < n2; ++n) {
                this._params.add(handler2.getParameter(n));
            }
            n = 50000000;
            if (handler2.getPriority() != null) {
                try {
                    n = Integer.parseInt(handler2.getPriority());
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            this._priority = n;
            this._min = 0;
            this._max = 0;
            if (handler2.getPool() != null) {
                object = handler2.getPool();
                try {
                    this._min = Integer.parseInt(((pool)object).getMin());
                    this._max = Integer.parseInt(((pool)object).getMax());
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if ((object = handler2.getFault()) != null) {
                if (((String)object).equalsIgnoreCase("local")) {
                    this._faultLocal = true;
                } else if (((String)object).equalsIgnoreCase("upstream")) {
                    this._faultLocal = false;
                }
            }
            this._autoResponse = JavaUtils.isTrue(handler2.getAutoresponse(), true);
            QName qName = null;
            int n3 = handler2.getheaderCount();
            this._headers = new WASHeaders(n3);
            for (int i = 0; i < n3; ++i) {
                try {
                    header header2 = handler2.getHeader(i);
                    qName = new QName(header2.getNamespaceURI(), header2.getElementValue());
                    boolean bl = false;
                    if (header2.getProtect() != null) {
                        bl = header2.getProtect().equalsIgnoreCase("true");
                    }
                    this._headers.setHeader(i, qName, bl);
                    continue;
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.webservices.configuration.WebServicesEngineConfigurationGenerator$WASHandler", (String)"468", (Object)this);
                    Tr.warning((TraceComponent)_tc, (String)("Exception caught while processing header: " + qName.toString() + ".  The header has NOT been added to the handlerInfo"));
                }
            }
        }

        final String getName() {
            return this._name;
        }

        final String getJavaclass() {
            return this._javaclass;
        }

        final ClassLoader getClassLoader() {
            return this._classLoader;
        }

        final int getPriority() {
            return this._priority;
        }

        final QName[] getHeaders() {
            return this._headers.getHeaders();
        }

        final QName[] getProtectedHeaders() {
            return this._headers.getProtectedHeaders();
        }

        private WSDDJAXRPCHandlerInfo createWSDDJAXRPCHandlerInfo(String string, String string2) {
            WSDDJAXRPCHandlerInfo wSDDJAXRPCHandlerInfo = null;
            if (this._canLoad) {
                wSDDJAXRPCHandlerInfo = new WSDDJAXRPCHandlerInfo();
                wSDDJAXRPCHandlerInfo.setName(this.getName());
                wSDDJAXRPCHandlerInfo.setHandlerClassName(this.getJavaclass());
                ClassLoader classLoader = this.getClassLoader();
                wSDDJAXRPCHandlerInfo.setClassLoader(classLoader);
                if (_tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)_tc, (String)("Handler ClassLoader: " + classLoader.toString()));
                }
                wSDDJAXRPCHandlerInfo.setPriority(this.getPriority());
                wSDDJAXRPCHandlerInfo.setMinPoolSize(this._min);
                wSDDJAXRPCHandlerInfo.setMaxPoolSize(this._max);
                wSDDJAXRPCHandlerInfo.setFaultLocal(this._faultLocal);
                wSDDJAXRPCHandlerInfo.setAutoResponse(this._autoResponse);
                wSDDJAXRPCHandlerInfo.setHeaders(this._headers.getHeaders());
                wSDDJAXRPCHandlerInfo.setProtectedHeaders(this._headers.getProtectedHeaders());
                wSDDJAXRPCHandlerInfo.setHandlerMap(this._params.getMap());
                wSDDJAXRPCHandlerInfo.putHandlerMap(Handler.HANDLER_PARAM_CATEGORY, string);
                wSDDJAXRPCHandlerInfo.putHandlerMap(Handler.HANDLER_PARAM_ROLE, string2);
                ExtendedHandlerInfo extendedHandlerInfo = null;
                try {
                    extendedHandlerInfo = wSDDJAXRPCHandlerInfo.getHandlerInfo();
                    if (_tc.isDebugEnabled()) {
                        if (extendedHandlerInfo == null) {
                            Tr.debug((TraceComponent)_tc, (String)("Handler " + this.getName() + " disabled"));
                        } else {
                            Tr.debug((TraceComponent)_tc, (String)("Handler " + this.getName() + " loaded: " + this.getJavaclass()));
                        }
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {
                    Tr.warning((TraceComponent)_tc, (String)"warning.handler.not.verified", (Object)new Object[]{this.getJavaclass(), this.getName(), classNotFoundException});
                }
                catch (NoClassDefFoundError noClassDefFoundError) {
                    FFDCFilter.processException((Throwable)noClassDefFoundError, (String)"com.ibm.ws.webservices.configuration.WebServicesEngineConfigurationGenerator.createWSDDJAXRPCHandlerInfo", (String)"367", (Object)this);
                    Tr.warning((TraceComponent)_tc, (String)"warning.handler.not.verified", (Object)new Object[]{this.getJavaclass(), this.getName(), noClassDefFoundError});
                }
                if (extendedHandlerInfo == null) {
                    wSDDJAXRPCHandlerInfo = null;
                    this._canLoad = false;
                }
            }
            return wSDDJAXRPCHandlerInfo;
        }
    }

    private final class WASHeaders {
        private QName[] _headerNames;
        private boolean[] _protect;
        private QName[] _protectedHeaders = null;

        WASHeaders(int n) {
            this._headerNames = new QName[n];
            this._protect = new boolean[n];
        }

        public void setHeader(int n, QName qName, boolean bl) {
            this._protect[n] = bl;
            this._headerNames[n] = qName;
        }

        public QName[] getHeaders() {
            return this._headerNames;
        }

        public QName[] getProtectedHeaders() {
            if (this._protectedHeaders == null) {
                int n;
                int n2 = 0;
                for (n = 0; n < this._headerNames.length; ++n) {
                    n2 += this._protect[n] ? 1 : 0;
                }
                this._protectedHeaders = new QName[n2];
                n = 0;
                for (int i = 0; i < this._headerNames.length; ++i) {
                    if (!this._protect[i]) continue;
                    this._protectedHeaders[n++] = this._headerNames[i];
                }
            }
            return this._protectedHeaders;
        }

        public void setProtect(int n, boolean bl) {
            this._protect[n] = bl;
            this._protectedHeaders = null;
        }

        public boolean getProtect(int n) {
            return this._protect[n];
        }

        public void setName(int n, QName qName) {
            this._headerNames[n] = qName;
        }

        public QName getName(int n) {
            return this._headerNames[n];
        }
    }

    private class WASParameters {
        private HashMap map = new HashMap();

        private WASParameters() {
        }

        void add(parameter parameter2) {
            if (parameter2 != null) {
                String string = parameter2.getName();
                String string2 = parameter2.getValue();
                if (string != null && string.length() > 0 && string2 != null) {
                    if (_tc.isDebugEnabled() && this.map.containsKey(string)) {
                        Tr.debug((TraceComponent)_tc, (String)("WASParameters.add: The current value for parameter [" + string + "] of [" + this.map.get(string) + "] is about to be replaced with the value [" + string2 + "]"));
                    }
                    this.map.put(string, string2);
                }
            }
        }

        void add(Map map) {
            if (map != null) {
                this.map.putAll(map);
            }
        }

        Map getMap() {
            return this.map;
        }
    }
}

