/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.configuration;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.webservices.WebServicesService;
import com.ibm.ws.webservices.WebServicesServiceHome;
import com.ibm.ws.webservices.component.WSServerImpl;
import com.ibm.ws.webservices.engine.EngineConfiguration;
import com.ibm.ws.webservices.engine.EngineConfigurationFactory;
import com.ibm.ws.webservices.engine.configuration.DefaultEngineConfigurationFactory;
import com.ibm.ws.webservices.multiprotocol.AgnosticService;

public class ServerConfigurationFactory
implements EngineConfigurationFactory {
    private static final TraceComponent _tc = Tr.register((Class)ServerConfigurationFactory.class, (String)"WebServices", (String)"com.ibm.ws.webservices.resources.webservicesMessages");

    public static EngineConfigurationFactory newFactory(Object object) {
        WebServicesService webServicesService = WebServicesServiceHome.getWebServicesService();
        return webServicesService instanceof WSServerImpl && (webServicesService.isServerWebServiceEnabled() || webServicesService.isClientWebServiceEnabled()) ? new ServerConfigurationFactory() : null;
    }

    private ServerConfigurationFactory() {
    }

    public EngineConfiguration getClientEngineConfig() {
        if (_tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)_tc, (String)"Entering ServerConfigurationFactory::getClientEngineConfig()");
        }
        EngineConfiguration engineConfiguration = null;
        String string = AgnosticService.getWhichGlobalHandlersToUseOffThread();
        if (!"SYSTEM_ENGINE".equals(string) && !"APPLICATION_ENGINE".equals(string)) {
            if (_tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)_tc, (String)"com.ibm.ws.webservices.configuration.ServerConfigurationFactory.getClientEngineConfig(): Looking for 109 client configuration");
            }
            engineConfiguration = WebServicesServiceHome.getWebServicesService().getClientEngineConfig();
        }
        if (engineConfiguration == null) {
            if (_tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)_tc, (String)("ServerConfigurationFactory.getClientEngineConfig(): Using an unmanaged 101 client inside server.  Global handler usage setting = " + string));
            }
            EngineConfigurationFactory engineConfigurationFactory = DefaultEngineConfigurationFactory.newFactory(string);
            engineConfiguration = engineConfigurationFactory.getClientEngineConfig();
        }
        return engineConfiguration;
    }

    public EngineConfiguration getServerEngineConfig() {
        if (_tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)_tc, (String)"Entering ServerConfigurationFactory::getServerEngineConfig()");
        }
        return WebServicesServiceHome.getWebServicesService().getServerEngineConfig();
    }
}

