/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.component;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.commonarchive.CommonarchiveFactory;
import com.ibm.etools.commonarchive.impl.CommonarchiveFactoryImpl;
import com.ibm.etools.j2ee.commonarchivecore.Archive;
import com.ibm.etools.j2ee.commonarchivecore.helpers.ArchiveOptions;
import com.ibm.etools.j2ee.commonarchivecore.strategy.LoadStrategy;
import com.ibm.etools.webservice.wsbnd.WSBinding;
import com.ibm.etools.webservice.wsbnd.WSDescBinding;
import com.ibm.etools.webservice.wsdd.PortComponent;
import com.ibm.etools.webservice.wsdd.WebServiceDescription;
import com.ibm.etools.webservice.wsdd.WebServices;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.pmi.WebServicesPerf;
import com.ibm.ws.exception.ComponentDisabledException;
import com.ibm.ws.exception.ConfigurationError;
import com.ibm.ws.exception.ConfigurationWarning;
import com.ibm.ws.exception.RuntimeError;
import com.ibm.ws.exception.RuntimeWarning;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.runtime.component.ComponentImpl;
import com.ibm.ws.soap.container.SoapContainerService;
import com.ibm.ws.webservices.WSConstants;
import com.ibm.ws.webservices.WSModels;
import com.ibm.ws.webservices.WebServicesServiceHome;
import com.ibm.ws.webservices.WebServicesSystemService;
import com.ibm.ws.webservices.component.WSServerImpl;
import com.ibm.ws.webservices.engine.EngineConfiguration;
import com.ibm.ws.webservices.engine.dispatchers.java.JavaBeanDispatcher;
import com.ibm.ws.webservices.metadata.ClientEntityMetaData;
import com.ibm.ws.webservices.metadata.ServerPortMetaData;
import com.ibm.ws.webservices.metadata.SysServerModuleMetaData;
import com.ibm.ws.webservices.sysengine.SystemEngineRouter;
import com.ibm.ws.webservices.wsdl.mapping.MappingMetaData;
import com.ibm.ws.webservices.xml.wassysapp.systemApp;
import com.ibm.ws.webservices.xml.wassysapp.systemAppFactory;
import com.ibm.ws.webservices.xml.wassysapp.systemAppPort;
import com.ibm.wtp.internal.emf.xml.EMF2SAXRendererFactory;
import java.beans.beancontext.BeanContextServiceProvider;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.List;
import org.xml.sax.InputSource;

public class WSSysServerImpl
extends ComponentImpl
implements WebServicesSystemService {
    private static final TraceComponent _tc;
    private static WSSysServerImpl singleton;
    private boolean loadedConfig = false;
    private SoapContainerService soapContainerService = null;
    private static final String expectedProtocol = "file:";
    private static final String expectedJarExtension = ".jar";
    private static final String expectedJarSeperator = "!";
    private static final String expectedPathSeperator = "/";

    public static WSSysServerImpl getWSSysServerImpl() {
        return singleton;
    }

    public EngineConfiguration getClientEngineConfig() {
        return null;
    }

    public ClientEntityMetaData getClientEntityMetaData() {
        return null;
    }

    public WebServicesPerf getPMIServicesModule() {
        return null;
    }

    public EngineConfiguration getServerEngineConfig() {
        EngineConfiguration engineConfiguration = null;
        SysServerModuleMetaData sysServerModuleMetaData = this.getServerModuleMetaData();
        if (sysServerModuleMetaData == null) {
            if (_tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)_tc, (String)"com.ibm.ws.webservices.component.WSSysServerImpl.getServerEngineConfig(): ServerModuleMetaData is null");
            }
        } else {
            engineConfiguration = sysServerModuleMetaData.getConfiguration();
        }
        return engineConfiguration;
    }

    public boolean isClientWebServiceEnabled() {
        return false;
    }

    public boolean isRoleApplicableToService(int n) {
        return true;
    }

    public boolean isServerWebServiceEnabled() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize(Object object) throws ConfigurationWarning, ConfigurationError, ComponentDisabledException {
        if (_tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)_tc, (String)"initialize");
        }
        try {
            if (AdminServiceFactory.getAdminService().getProcessType().equals("DeploymentManager")) {
                if (_tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)_tc, (String)"Disabling component in DMGR process.");
                }
                throw new ComponentDisabledException();
            }
            this.addService(WebServicesSystemService.class, (BeanContextServiceProvider)((Object)this));
            WebServicesServiceHome.setWebServicesSystemService(this);
            singleton = this;
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (_tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)_tc, (String)"initialize");
            }
            throw throwable;
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)_tc, (String)"initialize");
        }
    }

    public void start() throws RuntimeWarning, RuntimeError {
        if (_tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)_tc, (String)"start");
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)_tc, (String)"start");
        }
    }

    public void stop() {
        if (_tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)_tc, (String)"stop");
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)_tc, (String)"stop");
        }
    }

    public void loadConfiguration() {
        if (this.loadedConfig) {
            return;
        }
        this.getSOAPContainerService();
        if (_tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)_tc, (String)"loadConfiguration");
        }
        ClassLoader classLoader = this.getClass().getClassLoader();
        Enumeration<URL> enumeration = null;
        try {
            enumeration = classLoader.getResources("META-INF/was-sysapp.xml");
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.webservices.component.WSSysServerImpl.loadConfiguration", (String)"247", (Object)this);
            Tr.error((TraceComponent)_tc, (String)"internal.error", (Object)iOException);
        }
        CommonarchiveFactory commonarchiveFactory = CommonarchiveFactoryImpl.getActiveFactory();
        EMF2SAXRendererFactory.INSTANCE.setValidating(false);
        while (enumeration != null && enumeration.hasMoreElements()) {
            ArchiveOptions archiveOptions;
            Object object;
            URL uRL = enumeration.nextElement();
            if (_tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)_tc, (String)("Processing sysapp config file: " + uRL.toString()));
            }
            LoadStrategy loadStrategy = null;
            Archive archive = null;
            try {
                object = WSSysServerImpl.absolutePathFromJarURL(uRL);
                if (_tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)_tc, (String)("About to crack open this jar: " + (String)object));
                }
                archiveOptions = new ArchiveOptions();
                archiveOptions.setIsReadOnly(true);
                archiveOptions.setUseJavaReflection(false);
                archiveOptions.setDiscriminateNestedArchives(false);
                archive = commonarchiveFactory.openArchive(archiveOptions, (String)object);
                loadStrategy = archive.getLoadStrategy();
            }
            catch (Exception exception) {
                Tr.error((TraceComponent)_tc, (String)"internal.error", (Object)exception);
            }
            if (loadStrategy == null) {
                Tr.error((TraceComponent)_tc, (String)"internal.error", (Object)("Can't create LoadStrategy for " + uRL));
                continue;
            }
            object = WSSysServerImpl.loadSysAppConfigXML(uRL);
            archiveOptions = WSServerImpl.loadWebServicesXML(loadStrategy, "META-INF/webservices.xml");
            if (archiveOptions == null) {
                Tr.error((TraceComponent)_tc, (String)"internal.error", (Object)"loadConfiguration: SysApp doesn't contain file META-INF/webservices.xml");
                continue;
            }
            WSBinding wSBinding = WSServerImpl.loadWebServicesBindingXML(loadStrategy, "META-INF/ibm-webservices-bnd.xmi");
            String string = WSSysServerImpl.absolutePathFromJarURL(uRL);
            String string2 = WSSysServerImpl.applicationName(string);
            SysServerModuleMetaData sysServerModuleMetaData = null;
            try {
                sysServerModuleMetaData = WSSysServerImpl.createSysAppServerMetaData(string2, (systemApp)object, (WebServices)archiveOptions, wSBinding, loadStrategy, string, this.getClass().getClassLoader());
            }
            catch (ClassNotFoundException classNotFoundException) {
                FFDCFilter.processException((Throwable)classNotFoundException, (String)"com.ibm.ws.webservices.component.WSSysServerImpl.loadConfiguration", (String)"346", (Object)this);
                Tr.error((TraceComponent)_tc, (String)"internal.error", (Object)classNotFoundException);
            }
            catch (IOException iOException) {
                FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.webservices.component.WSSysServerImpl.loadConfiguration", (String)"354", (Object)this);
                Tr.error((TraceComponent)_tc, (String)"internal.error", (Object)iOException);
            }
            if (sysServerModuleMetaData != null) {
                this.getSOAPContainerService().cacheMetaData(((systemApp)object).getSystemAppName(), sysServerModuleMetaData);
            } else {
                Tr.error((TraceComponent)_tc, (String)"internal.error", (Object)"loadConfiguration: serverModuleMetaData == null");
            }
            archive.close();
            loadStrategy = null;
        }
        if (enumeration != null) {
            this.getSOAPContainerService().registerRouter(new SystemEngineRouter());
        }
        this.loadedConfig = true;
        if (_tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)_tc, (String)"loadConfiguration");
        }
    }

    public SoapContainerService getSOAPContainerService() {
        if (this.soapContainerService == null) {
            this.soapContainerService = (SoapContainerService)this.getService(SoapContainerService.class);
            if (this.soapContainerService == null) {
                Tr.error((TraceComponent)_tc, (String)"internal.error", (Object)"com.ibm.ws.webservices.component.WSSysServerImpl.getSOAPContainerService: Could not get service for SoapContainerService.class");
            }
        }
        return this.soapContainerService;
    }

    static systemApp loadSysAppConfigXML(URL uRL) {
        if (_tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)_tc, (String)("About to load sysapp config xml file: " + uRL.toString()));
        }
        InputStream inputStream = null;
        systemApp systemApp2 = null;
        try {
            inputStream = uRL.openStream();
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.webservices.component.WSSysServerImpl.loadSysAppConfigXML", (String)"426");
            Tr.error((TraceComponent)_tc, (String)"internal.error", (Object)iOException);
        }
        if (inputStream != null) {
            systemAppFactory systemAppFactory2 = new systemAppFactory();
            systemAppFactory2.setPackageName("com.ibm.ws.webservices.xml.wassysapp");
            systemApp2 = (systemApp)systemAppFactory2.loadDocument("systemApp", new InputSource(inputStream));
        }
        return systemApp2;
    }

    static SysServerModuleMetaData createSysAppServerMetaData(String string, systemApp systemApp2, WebServices webServices, WSBinding wSBinding, LoadStrategy loadStrategy, String string2, ClassLoader classLoader) throws ClassNotFoundException, IOException {
        String string3 = string;
        String string4 = systemApp2.getSystemAppName();
        SysServerModuleMetaData sysServerModuleMetaData = new SysServerModuleMetaData(string3, string4);
        int n = webServices.getWebServiceDescriptions().size();
        for (int i = 0; i < n; ++i) {
            Object[] objectArray;
            WebServiceDescription webServiceDescription = (WebServiceDescription)webServices.getWebServiceDescriptions().get(i);
            MappingMetaData mappingMetaData = WSServerImpl.loadJavaWsdlMappingXML(loadStrategy, webServiceDescription.getJaxrpcMappingFile());
            if (mappingMetaData == null) {
                objectArray = new Object[]{webServiceDescription.getJaxrpcMappingFile(), webServiceDescription.getWebServiceDescriptionName(), "WEB-INF/webservices.xml", string4, string3};
                Tr.error((TraceComponent)_tc, (String)"mappingFile.not.found", (Object)objectArray);
                continue;
            }
            objectArray = webServiceDescription.getWsdlFile();
            WSDescBinding wSDescBinding = WSServerImpl.findWsDescBinding("META-INF/ibm-webservices-bnd.xmi", wSBinding, webServiceDescription);
            int n2 = webServiceDescription.getPortComponents().size();
            for (int j = 0; j < n2; ++j) {
                PortComponent portComponent = (PortComponent)webServiceDescription.getPortComponents().get(j);
                String string5 = portComponent.getPortComponentName();
                String string6 = portComponent.getServiceImplBean().getEServletLink().getServletLink();
                systemAppPort systemAppPort2 = WSSysServerImpl.findsysappport(string6, systemApp2);
                if (systemAppPort2 == null) {
                    Tr.warning((TraceComponent)_tc, (String)"warning.servlet.link.not.found", (Object)new Object[]{string6, string5});
                    continue;
                }
                String string7 = systemAppPort2.getServletClass();
                ServerPortMetaData serverPortMetaData = sysServerModuleMetaData.getPort(string5, true);
                serverPortMetaData.setServletName(systemAppPort2.getServletName());
                String string8 = systemAppPort2.getUrlPattern();
                if (string8 != null) {
                    serverPortMetaData.setURLPattern(string8, false);
                } else {
                    serverPortMetaData.setURLPattern("/services/" + string5, true);
                }
                if (_tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)_tc, (String)("System Application: :App(" + string3 + ")" + ":Mod(" + string4 + ")" + ":Service(" + string5 + ")" + ":ServiceName(" + serverPortMetaData.getWsddPort().getName() + ")"));
                }
                String string9 = WSServerImpl.buildWSDLPath(string2, (String)objectArray);
                WSServerImpl.setupWsddPort(serverPortMetaData.getWsddPort(), wSDescBinding, classLoader, string7, portComponent, WSServerImpl.createWSDDGen(mappingMetaData, string9, loadStrategy.getContainer().getInputStream((String)objectArray)));
                serverPortMetaData.getWsddPort().setDispatcherQName(WSConstants.QNAME_JAVARPC_DISPATCHER);
                JavaBeanDispatcher.setClassName(serverPortMetaData.getWsddPort(), string7);
                List list = WSServerImpl.getAllowedMethods(classLoader, portComponent.getServiceEndpointInterface());
                serverPortMetaData.getWsddPort().setAllowedMethods(list);
                serverPortMetaData.getWsddPort().validateDescriptors();
                if (!_tc.isDebugEnabled()) continue;
                serverPortMetaData.getWsddPort().dump();
            }
        }
        return sysServerModuleMetaData;
    }

    private static String absolutePathFromJarURL(URL uRL) {
        String string = uRL.getFile();
        if (_tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)_tc, (String)("absolutePathFromJarURL: application config file URL = " + uRL.toString()));
        }
        if (string.indexOf(expectedProtocol) == -1) {
            Tr.error((TraceComponent)_tc, (String)"internal.error", (Object)("absolutePathFromJarURL: Invalid protocol specified: " + string));
        }
        if (string.indexOf(".jar!") == -1) {
            Tr.error((TraceComponent)_tc, (String)"internal.error", (Object)("absolutePathFromJarURL: Invalid path specified: " + string));
        }
        int n = string.indexOf(expectedProtocol) + expectedProtocol.length();
        int n2 = string.indexOf(expectedJarSeperator);
        String string2 = string.substring(n, n2);
        if (_tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)_tc, (String)("absolutePathFromJarURL(sysAppConfigFileURL): Returning file path " + string2));
        }
        return string2;
    }

    private static String applicationName(String string) {
        String string2 = null;
        if (string != null) {
            int n = string.lastIndexOf(expectedPathSeperator) + 1;
            int n2 = string.lastIndexOf(expectedJarExtension);
            if (n > 0 && n2 > 0 && n < n2) {
                string2 = string.substring(n, n2);
            }
        }
        return string2;
    }

    private static systemAppPort findsysappport(String string, systemApp systemApp2) {
        for (int i = 0; i < systemApp2.getsystemAppPortCount(); ++i) {
            String string2 = systemApp2.getSystemAppPort(i).getServletName();
            if (string2 == null || !string2.equals(string)) continue;
            return systemApp2.getSystemAppPort(i);
        }
        return null;
    }

    private SysServerModuleMetaData getServerModuleMetaData() {
        return (SysServerModuleMetaData)this.getSOAPContainerService().getMetaData();
    }

    static {
        WSModels.init();
        _tc = Tr.register((Class)WSSysServerImpl.class, (String)"WebServices", (String)"com.ibm.ws.webservices.resources.webservicesMessages");
        singleton = null;
    }
}

