/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.rsadapter.spi;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.rsadapter.exceptions.TransactionException;
import javax.resource.ResourceException;

public class WSStateManager {
    public static final int NO_TRANSACTION_ACTIVE = 0;
    public static final int LOCAL_TRANSACTION_ACTIVE = 1;
    public static final int GLOBAL_TRANSACTION_ACTIVE = 2;
    public static final int TRANSACTION_FAIL = 3;
    public static final int TRANSACTION_ENDING = 4;
    public static final int TRANSACTION_HEURISTIC_END = 5;
    public static final int RECOVERY_IN_PROGRESS = 6;
    public static final int RRS_GLOBAL_TRANSACTION_ACTIVE = 7;
    public static final String[] transactions = new String[]{"NO_TRANSACTION_ACTIVE", "LOCAL_TRANSACTION_ACTIVE", "GLOBAL_TRANSACTION_ACTIVE", "TRANSACTION_FAIL", "TRANSACTION_ENDING", "TRANSACTION_HEURISTIC_END", "RECOVERY_IN_PROGRESS", "RRS_GLOBAL_TRANSACTION_ACTIVE", "INVALID_TX_STATE"};
    public static final int LT_BEGIN = 1;
    public static final int LT_COMMIT = 2;
    public static final int LT_ROLLBACK = 3;
    public static final int XA_START = 4;
    public static final int XA_END = 5;
    public static final int XA_END_FAIL = 6;
    public static final int XA_COMMIT = 7;
    public static final int XA_ROLLBACK = 8;
    public static final int XA_RECOVER = 9;
    public static final int XA_FORGET = 10;
    public static final int EXECUTE = 11;
    public static final int MC_CLEANUP = 12;
    public static final int HEURISTIC_END = 13;
    public static final int XA_READONLY = 14;
    public static final String[] actions = new String[]{"INVALID_ACTION", "LT_BEGIN", "LT_COMMIT", "LT_ROLLBACK", "XA_START", "XA_END", "XA_END_FAIL", "XA_COMMIT", "XA_ROLLBACK", "XA_RECOVER", "XA_FORGET", "EXECUTE", "MC_CLEANUP", "HEURISTIC_END", "INVALID_ACTION", "XA_READONLY"};
    int transtate = 0;
    private static final TraceComponent tc = Tr.register((Class)WSStateManager.class, (String)"RRA", (String)"IBMDataStoreAdapterNLS");

    private final void setState(int n, boolean bl) throws TransactionException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"setState", (Object)this.getStateAsString());
        }
        switch (n) {
            case 4: {
                if (this.transtate == 0) {
                    if (bl) {
                        return;
                    }
                    this.transtate = 2;
                    break;
                }
                throw new TransactionException(actions[n], transactions[this.transtate]);
            }
            case 5: {
                if (this.transtate == 2) {
                    if (bl) {
                        return;
                    }
                    this.transtate = 4;
                    break;
                }
                throw new TransactionException(actions[n], transactions[this.transtate]);
            }
            case 6: {
                if (this.transtate == 2 || this.transtate == 4) {
                    if (bl) {
                        return;
                    }
                    this.transtate = 3;
                    break;
                }
                throw new TransactionException(actions[n], transactions[this.transtate]);
            }
            case 7: 
            case 14: {
                if (this.transtate == 4 || this.transtate == 6) {
                    if (bl) {
                        return;
                    }
                    this.transtate = 0;
                    break;
                }
                throw new TransactionException(actions[n], transactions[this.transtate]);
            }
            case 8: {
                if (this.transtate == 4 || this.transtate == 3 || this.transtate == 6) {
                    if (bl) {
                        return;
                    }
                    if (this.transtate != 4 && this.transtate != 6) break;
                    this.transtate = 0;
                    break;
                }
                throw new TransactionException(actions[n], transactions[this.transtate]);
            }
            case 9: {
                this.transtate = 6;
                break;
            }
            case 10: {
                this.transtate = 0;
                break;
            }
            case 1: {
                if (this.transtate == 0) {
                    if (bl) {
                        return;
                    }
                    this.transtate = 1;
                    break;
                }
                throw new TransactionException(actions[n], transactions[this.transtate]);
            }
            case 2: 
            case 3: {
                if (this.transtate == 1) {
                    if (bl) {
                        return;
                    }
                    this.transtate = 0;
                    break;
                }
                throw new TransactionException(actions[n], transactions[this.transtate]);
            }
            case 11: {
                if (this.transtate == 1 || this.transtate == 2) {
                    if (!bl) break;
                    return;
                }
                throw new TransactionException(actions[n], transactions[this.transtate]);
            }
            case 12: {
                this.transtate = 0;
                break;
            }
            case 13: {
                this.transtate = 5;
                break;
            }
            default: {
                throw new TransactionException(actions[n], transactions[this.transtate]);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setState", (Object)this.getStateAsString());
        }
    }

    public final int getState() {
        return this.transtate;
    }

    public final void setState(int n) throws TransactionException {
        this.setState(n, false);
    }

    public final void setStateNoValidate(int n) {
        this.transtate = n;
    }

    public final ResourceException isValid(int n) {
        try {
            this.setState(n, true);
        }
        catch (TransactionException transactionException) {
            FFDCFilter.processException((Throwable)((Object)transactionException), (String)"com.ibm.ws.rsadapter.spi.WSStateManager.isValid", (String)"385", (Object)this);
            return transactionException;
        }
        return null;
    }

    public final String getStateAsString() {
        return transactions[this.transtate];
    }
}

