/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.rsadapter.spi;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.ce.cm.StaleConnectionException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.FFDCSelfIntrospectable;
import com.ibm.ws.rsadapter.AdapterUtil;
import com.ibm.ws.rsadapter.FFDCLogger;
import com.ibm.ws.rsadapter.exceptions.TransactionException;
import com.ibm.ws.rsadapter.spi.WSRdbManagedConnectionImpl;
import com.ibm.ws.rsadapter.spi.WSStateManager;
import java.io.Serializable;
import java.sql.SQLException;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

public class WSRdbXaResourceImpl
implements XAResource,
FFDCSelfIntrospectable {
    private final XAResource ivXaRes;
    private final WSRdbManagedConnectionImpl ivManagedConnection;
    private final WSStateManager ivStateManager;
    Xid ivXid;
    private final boolean detectMultithreadedAccess;
    private static final Class currClass = WSRdbXaResourceImpl.class;
    private static final TraceComponent tc = Tr.register((Class)currClass, (String)"RRA", (String)"IBMDataStoreAdapterNLS");
    private static final TraceComponent clientInfoTc = Tr.register((String)"WAS.clientinfopluslogging", (String)"WAS.clientinfopluslogging", (String)"IBMDataStoreAdapterNLS");
    private static TraceComponent tempTc;

    public WSRdbXaResourceImpl(XAResource xAResource, WSRdbManagedConnectionImpl wSRdbManagedConnectionImpl) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"<init>", (Object)new Object[]{xAResource, wSRdbManagedConnectionImpl});
        }
        this.ivXaRes = xAResource;
        this.ivManagedConnection = wSRdbManagedConnectionImpl;
        this.ivStateManager = wSRdbManagedConnectionImpl.stateMgr;
        this.detectMultithreadedAccess = this.ivManagedConnection.mcf.detectMultithreadedAccess;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"<init>", (Object)this);
        }
    }

    public void commit(Xid xid, boolean bl) throws XAException {
        Serializable serializable;
        Object object;
        if (tc.isEntryEnabled() || clientInfoTc.isEntryEnabled()) {
            tempTc = clientInfoTc.isEntryEnabled() ? clientInfoTc : tc;
            Tr.entry((TraceComponent)tempTc, (String)"commit", (Object)new Object[]{this, this.ivManagedConnection, AdapterUtil.toString(xid), bl ? "ONE PHASE" : "TWO PHASE"});
        }
        if (this.ivManagedConnection._mcStale) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"MC is stale throwing XAER_RMFAIL", (Object)this.ivManagedConnection);
            }
            Tr.error((TraceComponent)tc, (String)"INVALID_CONNECTION");
            throw new XAException(-7);
        }
        if (tc.isDebugEnabled()) {
            object = null;
            try {
                object = this.ivManagedConnection.mcf.getCorrelator(this.ivManagedConnection);
            }
            catch (SQLException sQLException) {
                Tr.debug((TraceComponent)tc, (String)"got an exception trying to get the correlator in commit, exception is: ", (Object)sQLException);
            }
            if (object != null) {
                serializable = new StringBuffer(200);
                ((StringBuffer)serializable).append("Correlator: DB2, ID: ");
                ((StringBuffer)serializable).append((String)object);
                if (xid != null) {
                    ((StringBuffer)serializable).append("Transaction ID : ");
                    ((StringBuffer)serializable).append(xid);
                }
                ((StringBuffer)serializable).append("COMMIT");
                Tr.debug((TraceComponent)tc, (String)((StringBuffer)serializable).toString());
            }
        }
        if (this.detectMultithreadedAccess) {
            this.ivManagedConnection.detectMultithreadedAccess();
        }
        this.ivManagedConnection.wasLazilyEnlisted = false;
        if (this.ivXid == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"XAResource.start was never issued; allowing commit for recovery.");
            }
            try {
                this.ivStateManager.setState(9);
            }
            catch (TransactionException transactionException) {
                FFDCFilter.processException((Throwable)((Object)transactionException), (String)"com.ibm.ws.rsadapter.spi.WSRdbXaResourceImpl.commit", (String)"120", (Object)this);
                serializable = AdapterUtil.createXAException("INVALID_TX_STATE", new Object[]{"XAResource.commit", this.ivManagedConnection.getTransactionStateAsString()}, -6);
                this.traceXAException((XAException)serializable, currClass);
                if (tc.isEntryEnabled() || clientInfoTc.isEntryEnabled()) {
                    tempTc = clientInfoTc.isEntryEnabled() ? clientInfoTc : tc;
                    Tr.exit((TraceComponent)tempTc, (String)"commit", (Object)serializable);
                }
                throw serializable;
            }
            this.ivXid = xid;
        } else if (!xid.equals(this.ivXid)) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Xid does not match.", (Object)new Object[]{"XAResource.start:  ", AdapterUtil.toString(this.ivXid), "XAResource.commit: ", AdapterUtil.toString(xid)});
            }
            object = AdapterUtil.createXAException("XID_MISMATCH", new Object[]{AdapterUtil.toString(this.ivXid), "commit", AdapterUtil.toString(xid)}, -4);
            if (tc.isEntryEnabled() || clientInfoTc.isEntryEnabled()) {
                tempTc = clientInfoTc.isEntryEnabled() ? clientInfoTc : tc;
                Tr.exit((TraceComponent)tempTc, (String)"commit", (Object)object);
            }
            throw object;
        }
        this.ivXid = null;
        try {
            this.ivXaRes.commit(xid, bl);
            this.ivStateManager.setState(7);
        }
        catch (TransactionException transactionException) {
            FFDCFilter.processException((Throwable)((Object)transactionException), (String)"com.ibm.ws.rsadapter.spi.WSRdbXaResourceImpl.commit", (String)"113", (Object)this);
            serializable = AdapterUtil.createXAException("INVALID_TX_STATE", new Object[]{"XAResource.commit", this.ivManagedConnection.getTransactionStateAsString()}, -6);
            this.traceXAException((XAException)serializable, currClass);
            if (tc.isEntryEnabled() || clientInfoTc.isEntryEnabled()) {
                tempTc = clientInfoTc.isEntryEnabled() ? clientInfoTc : tc;
                Tr.exit((TraceComponent)tempTc, (String)"commit", (Object)serializable);
            }
            throw serializable;
        }
        catch (XAException xAException) {
            FFDCFilter.processException((Throwable)xAException, (String)"com.ibm.ws.rsadapter.spi.WSRdbXaResourceImpl.commit", (String)"126", (Object)this);
            this.traceXAException(xAException, currClass);
            this.checkXAException(xAException);
            if (xAException.errorCode == 7 || xAException.errorCode == 8 || xAException.errorCode == 5 || xAException.errorCode == 6) {
                try {
                    this.ivStateManager.setState(13);
                }
                catch (TransactionException transactionException) {
                    FFDCFilter.processException((Throwable)((Object)transactionException), (String)"com.ibm.ws.rsadapter.spi.WSRdbXaResourceImpl.commit", (String)"142", (Object)this);
                    Tr.warning((TraceComponent)tc, (String)"DSA_INTERNAL_WARNING", (Object)new Object[]{"Exception setting the transaction state to WSStateManager.HEURISTIC_END from ", this.ivManagedConnection.getTransactionStateAsString(), transactionException});
                }
            }
            if (tc.isEntryEnabled() || clientInfoTc.isEntryEnabled()) {
                tempTc = clientInfoTc.isEntryEnabled() ? clientInfoTc : tc;
                Tr.exit((TraceComponent)tempTc, (String)"commit", (Object)xAException);
            }
            throw xAException;
        }
        if (tc.isDebugEnabled()) {
            object = null;
            try {
                object = this.ivManagedConnection.mcf.getCorrelator(this.ivManagedConnection);
            }
            catch (SQLException sQLException) {
                Tr.debug((TraceComponent)tc, (String)"got an exception trying to get the correlator in commit, exception is: ", (Object)sQLException);
            }
            if (object != null) {
                serializable = new StringBuffer(200);
                ((StringBuffer)serializable).append("Correlator: DB2, ID: ");
                ((StringBuffer)serializable).append((String)object);
                if (xid != null) {
                    ((StringBuffer)serializable).append("Transaction ID : ");
                    ((StringBuffer)serializable).append(xid);
                }
                ((StringBuffer)serializable).append("COMMIT");
                Tr.debug((TraceComponent)tc, (String)((StringBuffer)serializable).toString());
            }
        }
        if (tc.isEntryEnabled() || clientInfoTc.isEntryEnabled()) {
            tempTc = clientInfoTc.isEntryEnabled() ? clientInfoTc : tc;
            Tr.exit((TraceComponent)tempTc, (String)"commit");
        }
    }

    protected final void end() throws XAException {
        this.end(this.ivXid, 0x20000000);
    }

    public void end(Xid xid, int n) throws XAException {
        if (tc.isEntryEnabled() || clientInfoTc.isEntryEnabled()) {
            tempTc = clientInfoTc.isEntryEnabled() ? clientInfoTc : tc;
            Tr.entry((TraceComponent)tempTc, (String)"end", (Object)new Object[]{this, this.ivManagedConnection, AdapterUtil.toString(xid), AdapterUtil.getXAResourceEndFlagString(n)});
        }
        if (this.ivManagedConnection._mcStale) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"MC is stale throwing XAER_RMFAIL", (Object)this.ivManagedConnection);
            }
            Tr.error((TraceComponent)tc, (String)"INVALID_CONNECTION");
            throw new XAException(-7);
        }
        if (!xid.equals(this.ivXid)) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Xid does not match.", (Object)new Object[]{"XAResource.start: ", AdapterUtil.toString(this.ivXid), "XAResource.end:   ", AdapterUtil.toString(xid)});
            }
            XAException xAException = AdapterUtil.createXAException("XID_MISMATCH", new Object[]{AdapterUtil.toString(this.ivXid), "end", AdapterUtil.toString(xid)}, -4);
            if (tc.isEntryEnabled() || clientInfoTc.isEntryEnabled()) {
                tempTc = clientInfoTc.isEntryEnabled() ? clientInfoTc : tc;
                Tr.exit((TraceComponent)tempTc, (String)"end", (Object)xAException);
            }
            throw xAException;
        }
        try {
            this.ivStateManager.setState(5);
            this.ivXaRes.end(xid, n);
        }
        catch (TransactionException transactionException) {
            FFDCFilter.processException((Throwable)((Object)transactionException), (String)"com.ibm.ws.rsadapter.spi.WSRdbXaResourceImpl.end", (String)"228", (Object)this);
            Tr.error((TraceComponent)tc, (String)"INVALID_TX_STATE", (Object)new Object[]{"XAResource.end()", this.ivManagedConnection.getTransactionStateAsString()});
            try {
                this.ivXaRes.rollback(xid);
            }
            catch (XAException xAException) {
                FFDCFilter.processException((Throwable)xAException, (String)"com.ibm.ws.rsadapter.spi.WSRdbXaResourceImpl.end", (String)"236", (Object)this);
                this.traceXAException(xAException, currClass);
            }
            XAException xAException = AdapterUtil.createXAException("INVALID_TX_STATE", new Object[]{"XAResource.end", this.ivManagedConnection.getTransactionStateAsString()}, 100);
            this.traceXAException(xAException, currClass);
            if (tc.isDebugEnabled()) {
                String string = null;
                try {
                    string = this.ivManagedConnection.mcf.getCorrelator(this.ivManagedConnection);
                }
                catch (SQLException sQLException) {
                    Tr.debug((TraceComponent)tc, (String)"got an exception trying to get the correlator in rollback during xa end fails, exception is: ", (Object)sQLException);
                }
                if (string != null) {
                    StringBuffer stringBuffer = new StringBuffer(200);
                    stringBuffer.append("Correlator: DB2, ID: ");
                    stringBuffer.append(string);
                    if (xid != null) {
                        stringBuffer.append("Transaction ID : ");
                        stringBuffer.append(xid);
                    }
                    stringBuffer.append("ROLLBACK");
                    Tr.debug((TraceComponent)tc, (String)stringBuffer.toString());
                }
            }
            if (tc.isEntryEnabled() || clientInfoTc.isEntryEnabled()) {
                tempTc = clientInfoTc.isEntryEnabled() ? clientInfoTc : tc;
                Tr.exit((TraceComponent)tempTc, (String)"end", (Object)"Exception");
            }
            throw xAException;
        }
        catch (XAException xAException) {
            FFDCFilter.processException((Throwable)xAException, (String)"com.ibm.ws.rsadapter.spi.WSRdbXaResourceImpl.end", (String)"438", (Object)this);
            this.checkXAException(xAException);
            try {
                this.ivStateManager.setState(6);
            }
            catch (TransactionException transactionException) {
                Tr.warning((TraceComponent)tc, (String)"DSA_INTERNAL_ERROR", (Object)new Object[]{"Error setting the state to XA_END_FAIL from ", this.ivManagedConnection.getTransactionStateAsString(), transactionException});
            }
            this.traceXAException(xAException, currClass);
            if (tc.isEntryEnabled() || clientInfoTc.isEntryEnabled()) {
                tempTc = clientInfoTc.isEntryEnabled() ? clientInfoTc : tc;
                Tr.exit((TraceComponent)tempTc, (String)"end", (Object)xAException);
            }
            throw xAException;
        }
        if (tc.isEntryEnabled() || clientInfoTc.isEntryEnabled()) {
            tempTc = clientInfoTc.isEntryEnabled() ? clientInfoTc : tc;
            Tr.exit((TraceComponent)tempTc, (String)"end");
        }
    }

    public void forget(Xid xid) throws XAException {
        if (tc.isEntryEnabled() || clientInfoTc.isEntryEnabled()) {
            tempTc = clientInfoTc.isEntryEnabled() ? clientInfoTc : tc;
            Tr.entry((TraceComponent)tempTc, (String)"forget", (Object)new Object[]{this, this.ivManagedConnection, AdapterUtil.toString(xid)});
        }
        if (this.ivManagedConnection._mcStale) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"MC is stale throwing XAER_RMFAIL", (Object)this.ivManagedConnection);
            }
            Tr.error((TraceComponent)tc, (String)"INVALID_CONNECTION");
            throw new XAException(-7);
        }
        if (this.ivXid == null && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"XAResource.start was never issued; allowing to forget for recovery.");
        }
        if (!xid.equals(this.ivXid) && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Xid does not match.", (Object)new Object[]{"XAResource.start:  ", AdapterUtil.toString(this.ivXid), "XAResource.forget: ", AdapterUtil.toString(xid)});
        }
        try {
            this.ivXaRes.forget(xid);
            this.ivStateManager.setState(10);
        }
        catch (TransactionException transactionException) {
            FFDCFilter.processException((Throwable)((Object)transactionException), (String)"com.ibm.ws.rsadapter.spi.WSRdbXaResourceImpl.forget", (String)"284", (Object)this);
            Tr.error((TraceComponent)tc, (String)"INVALID_TX_STATE", (Object)new Object[]{"XAResource.forget()", this.ivManagedConnection.getTransactionStateAsString()});
            this.traceXAException(new XAException(105), currClass);
        }
        catch (XAException xAException) {
            FFDCFilter.processException((Throwable)xAException, (String)"com.ibm.ws.rsadapter.spi.WSRdbXaResourceImpl.forget", (String)"489", (Object)this);
            this.traceXAException(xAException, currClass);
            this.checkXAException(xAException);
            if (tc.isEntryEnabled() || clientInfoTc.isEntryEnabled()) {
                tempTc = clientInfoTc.isEntryEnabled() ? clientInfoTc : tc;
                Tr.exit((TraceComponent)tempTc, (String)"forget", (Object)xAException);
            }
            throw xAException;
        }
        if (tc.isEntryEnabled() || clientInfoTc.isEntryEnabled()) {
            tempTc = clientInfoTc.isEntryEnabled() ? clientInfoTc : tc;
            Tr.exit((TraceComponent)tempTc, (String)"forget");
        }
    }

    public final int getTransactionTimeout() throws XAException {
        if (this.ivManagedConnection._mcStale) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"MC is stale throwing XAER_RMFAIL", (Object)this.ivManagedConnection);
            }
            Tr.error((TraceComponent)tc, (String)"INVALID_CONNECTION");
            throw new XAException(-7);
        }
        return this.ivXaRes.getTransactionTimeout();
    }

    public final String[] introspectSelf() {
        return this.ivManagedConnection.introspectSelf();
    }

    void introspectThisClassOnly(FFDCLogger fFDCLogger) {
        fFDCLogger.createFFDCHeader(this);
        fFDCLogger.append("ManagedConnection:", this.ivManagedConnection);
        fFDCLogger.append("Underlying XAResource Object: " + AdapterUtil.toString(this.ivXaRes), this.ivXaRes);
        fFDCLogger.append("Xid: ", AdapterUtil.toString(this.ivXid));
        fFDCLogger.append("Detection of multithreaded access is:", this.detectMultithreadedAccess ? "ENABLED" : "DISABLED");
    }

    public final boolean isSameRM(XAResource xAResource) throws XAException {
        WSRdbXaResourceImpl wSRdbXaResourceImpl;
        boolean bl = false;
        try {
            wSRdbXaResourceImpl = (WSRdbXaResourceImpl)xAResource;
        }
        catch (ClassCastException classCastException) {
            Tr.debug((TraceComponent)tc, (String)"The Input XAResource is not the same type as the current XAResource", (Object)xAResource);
            return bl;
        }
        bl = this.ivXaRes.isSameRM(wSRdbXaResourceImpl.ivXaRes);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"isSameRM?", (Object)new Object[]{xAResource, bl ? Boolean.TRUE : Boolean.FALSE});
        }
        return bl;
    }

    public int prepare(Xid xid) throws XAException {
        int n;
        block14: {
            if (tc.isEntryEnabled() || clientInfoTc.isEntryEnabled()) {
                tempTc = clientInfoTc.isEntryEnabled() ? clientInfoTc : tc;
                Tr.entry((TraceComponent)tempTc, (String)"prepare", (Object)new Object[]{this, this.ivManagedConnection, AdapterUtil.toString(xid)});
            }
            if (this.ivManagedConnection._mcStale) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"MC is stale throwing XAER_RMFAIL", (Object)this.ivManagedConnection);
                }
                Tr.error((TraceComponent)tc, (String)"INVALID_CONNECTION");
                throw new XAException(-7);
            }
            if (!xid.equals(this.ivXid)) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Xid does not match.", (Object)new Object[]{"XAResource.start:   ", AdapterUtil.toString(this.ivXid), "XAResource.prepare: ", AdapterUtil.toString(xid)});
                }
                XAException xAException = AdapterUtil.createXAException("XID_MISMATCH", new Object[]{AdapterUtil.toString(this.ivXid), "prepare", AdapterUtil.toString(xid)}, -4);
                if (tc.isEntryEnabled() || clientInfoTc.isEntryEnabled()) {
                    tempTc = clientInfoTc.isEntryEnabled() ? clientInfoTc : tc;
                    Tr.exit((TraceComponent)tempTc, (String)"prepare", (Object)xAException);
                }
                throw xAException;
            }
            try {
                n = this.ivXaRes.prepare(xid);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"xa.prepare() status:", (Object)new Object[]{AdapterUtil.getXAResourceVoteString(n), AdapterUtil.toString(xid)});
                }
                if (n != 3) break block14;
                try {
                    this.ivManagedConnection.wasLazilyEnlisted = false;
                    this.ivStateManager.setState(14);
                }
                catch (TransactionException transactionException) {
                    FFDCFilter.processException((Throwable)((Object)transactionException), (String)"com.ibm.ws.rsadapter.spi.WSRdbXaResourceImpl.prepare", (String)"373", (Object)this);
                    XAException xAException = AdapterUtil.createXAException("INVALID_TX_STATE", new Object[]{"XAResource.prepare", this.ivManagedConnection.getTransactionStateAsString()}, 105);
                    this.traceXAException(xAException, currClass);
                    if (tc.isEntryEnabled() || clientInfoTc.isEntryEnabled()) {
                        tempTc = clientInfoTc.isEntryEnabled() ? clientInfoTc : tc;
                        Tr.exit((TraceComponent)tempTc, (String)"prepare", (Object)xAException);
                    }
                    throw xAException;
                }
            }
            catch (XAException xAException) {
                FFDCFilter.processException((Throwable)xAException, (String)"com.ibm.ws.rsadapter.spi.WSRdbXaResourceImpl.prepare", (String)"386", (Object)this);
                this.traceXAException(xAException, currClass);
                this.checkXAException(xAException);
                if (tc.isEntryEnabled() || clientInfoTc.isEntryEnabled()) {
                    tempTc = clientInfoTc.isEntryEnabled() ? clientInfoTc : tc;
                    Tr.exit((TraceComponent)tempTc, (String)"prepare", (Object)"Exception");
                }
                throw xAException;
            }
        }
        if (tc.isEntryEnabled() || clientInfoTc.isEntryEnabled()) {
            tempTc = clientInfoTc.isEntryEnabled() ? clientInfoTc : tc;
            Tr.exit((TraceComponent)tempTc, (String)"prepare", (Object)new Integer(n));
        }
        return n;
    }

    public Xid[] recover(int n) throws XAException {
        if (tc.isEntryEnabled() || clientInfoTc.isEntryEnabled()) {
            tempTc = clientInfoTc.isEntryEnabled() ? clientInfoTc : tc;
            Tr.entry((TraceComponent)tempTc, (String)"recover", (Object)new Object[]{this, this.ivManagedConnection, AdapterUtil.getXAResourceRecoverFlagString(n)});
        }
        if (this.ivManagedConnection._mcStale) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"MC is stale throwing XAER_RMFAIL", (Object)this.ivManagedConnection);
            }
            Tr.error((TraceComponent)tc, (String)"INVALID_CONNECTION");
            throw new XAException(-7);
        }
        Xid[] xidArray = null;
        try {
            xidArray = this.ivXaRes.recover(n);
            if (xidArray == null || xidArray.length == 0) {
                if (tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)"No oustanding transactions to recover.  Transaction state does not change.");
                }
            } else {
                this.ivStateManager.setState(9);
                if (tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)("Outstanding transactions to recover.  Transaction state is changing to " + this.ivManagedConnection.getTransactionStateAsString()));
                }
            }
        }
        catch (TransactionException transactionException) {
            FFDCFilter.processException((Throwable)((Object)transactionException), (String)"com.ibm.ws.rsadapter.spi.WSRdbXaResourceImpl.recover", (String)"438", (Object)this);
            Tr.warning((TraceComponent)tc, (String)"DSA_INTERNAL_WARNING", (Object)new Object[]{"Exception setting the transaction state to WSStateManager.XA_RECOVER from ", this.ivManagedConnection.getTransactionStateAsString(), transactionException});
        }
        catch (XAException xAException) {
            FFDCFilter.processException((Throwable)xAException, (String)"com.ibm.ws.rsadapter.spi.WSRdbXaResourceImpl.recover", (String)"444", (Object)this);
            this.traceXAException(xAException, currClass);
            this.checkXAException(xAException);
            if (tc.isEntryEnabled() || clientInfoTc.isEntryEnabled()) {
                tempTc = clientInfoTc.isEntryEnabled() ? clientInfoTc : tc;
                Tr.exit((TraceComponent)tempTc, (String)"recover", (Object)"Exception");
            }
            throw xAException;
        }
        if (tc.isEntryEnabled() || clientInfoTc.isEntryEnabled()) {
            tempTc = clientInfoTc.isEntryEnabled() ? clientInfoTc : tc;
            Tr.exit((TraceComponent)tempTc, (String)"recover", (Object)xidArray);
        }
        return xidArray;
    }

    protected final void rollback() throws XAException {
        this.rollback(this.ivXid);
    }

    public void rollback(Xid xid) throws XAException {
        Serializable serializable;
        Serializable serializable2;
        block29: {
            if (tc.isEntryEnabled() || clientInfoTc.isEntryEnabled()) {
                tempTc = clientInfoTc.isEntryEnabled() ? clientInfoTc : tc;
                Tr.entry((TraceComponent)tempTc, (String)"rollback", (Object)new Object[]{this, this.ivManagedConnection, AdapterUtil.toString(xid)});
            }
            this.ivManagedConnection.wasLazilyEnlisted = false;
            if (this.ivManagedConnection._mcStale) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"MC is stale throwing XAER_RMFAIL", (Object)this.ivManagedConnection);
                }
                Tr.error((TraceComponent)tc, (String)"INVALID_CONNECTION");
                throw new XAException(-7);
            }
            if (this.ivXid == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"XAResource.start was never issued; allowing rollback for recovery.");
                }
                try {
                    this.ivStateManager.setState(9);
                }
                catch (TransactionException transactionException) {
                    FFDCFilter.processException((Throwable)((Object)transactionException), (String)"com.ibm.ws.rsadapter.spi.WSRdbXaResourceImpl.rollback", (String)"614", (Object)this);
                    XAException xAException = AdapterUtil.createXAException("INVALID_TX_STATE", new Object[]{"XAResource.rollback", this.ivManagedConnection.getTransactionStateAsString()}, -6);
                    this.traceXAException(xAException, currClass);
                    if (tc.isEntryEnabled() || clientInfoTc.isEntryEnabled()) {
                        tempTc = clientInfoTc.isEntryEnabled() ? clientInfoTc : tc;
                        Tr.exit((TraceComponent)tempTc, (String)"rollback", (Object)xAException);
                    }
                    throw xAException;
                }
                this.ivXid = xid;
            } else if (!xid.equals(this.ivXid)) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Xid does not match.", (Object)new Object[]{"XAResource.start:    ", AdapterUtil.toString(this.ivXid), "XAResource.rollback: ", AdapterUtil.toString(xid)});
                }
                XAException xAException = AdapterUtil.createXAException("XID_MISMATCH", new Object[]{AdapterUtil.toString(this.ivXid), "rollback", AdapterUtil.toString(xid)}, -4);
                if (tc.isEntryEnabled() || clientInfoTc.isEntryEnabled()) {
                    tempTc = clientInfoTc.isEntryEnabled() ? clientInfoTc : tc;
                    Tr.exit((TraceComponent)tempTc, (String)"rollback", (Object)xAException);
                }
                throw xAException;
            }
            boolean bl = true;
            serializable2 = null;
            try {
                this.ivXaRes.rollback(xid);
            }
            catch (XAException xAException) {
                FFDCFilter.processException((Throwable)xAException, (String)"com.ibm.ws.rsadapter.spi.WSRdbXaResourceImpl.rollback", (String)"524", (Object)this);
                this.traceXAException(xAException, currClass);
                this.checkXAException(xAException);
                if (xAException.errorCode == 7 || xAException.errorCode == 8 || xAException.errorCode == 5 || xAException.errorCode == 6) {
                    bl = false;
                    try {
                        this.ivStateManager.setState(13);
                    }
                    catch (TransactionException transactionException) {
                        FFDCFilter.processException((Throwable)((Object)transactionException), (String)"com.ibm.ws.rsadapter.spi.WSRdbXaResourceImpl.rollback", (String)"540", (Object)this);
                        Tr.warning((TraceComponent)tc, (String)"DSA_INTERNAL_WARNING", (Object)new Object[]{"Exception setting the transaction state to WSStateManager.HEURISTIC_END from ", this.ivManagedConnection.getTransactionStateAsString(), transactionException});
                    }
                }
                serializable2 = xAException;
            }
            if (bl) {
                try {
                    this.ivStateManager.setState(8);
                }
                catch (TransactionException transactionException) {
                    FFDCFilter.processException((Throwable)((Object)transactionException), (String)"com.ibm.ws.rsadapter.spi.WSRdbXaResourceImpl.rollback", (String)"510", (Object)this);
                    Tr.error((TraceComponent)tc, (String)"INVALID_TX_STATE", (Object)new Object[]{"XAResource.rollback()", this.ivManagedConnection.getTransactionStateAsString()});
                    serializable = AdapterUtil.createXAException("INVALID_TX_STATE", new Object[]{"XAResource.rollback", this.ivManagedConnection.getTransactionStateAsString()}, -6);
                    this.traceXAException((XAException)serializable, currClass);
                    if (serializable2 != null) break block29;
                    serializable2 = serializable;
                }
            }
        }
        this.ivXid = null;
        if (tc.isDebugEnabled()) {
            String string = null;
            try {
                string = this.ivManagedConnection.mcf.getCorrelator(this.ivManagedConnection);
            }
            catch (SQLException sQLException) {
                Tr.debug((TraceComponent)tc, (String)"got an exception trying to get the correlator in rollback, exception is: ", (Object)sQLException);
            }
            if (string != null) {
                serializable = new StringBuffer(200);
                serializable.append("Correlator: DB2, ID: ");
                serializable.append(string);
                if (xid != null) {
                    serializable.append("Transaction ID : ");
                    serializable.append(xid);
                }
                serializable.append(" ROLLBACK");
                Tr.debug((TraceComponent)tc, (String)serializable.toString());
            }
        }
        if (tc.isEntryEnabled() || clientInfoTc.isEntryEnabled()) {
            tempTc = clientInfoTc.isEntryEnabled() ? clientInfoTc : tc;
            if (serializable2 == null) {
                Tr.exit((TraceComponent)tempTc, (String)"rollback");
            } else {
                Tr.exit((TraceComponent)tempTc, (String)"rollback", serializable2);
            }
        }
        if (serializable2 != null) {
            throw serializable2;
        }
    }

    public final boolean setTransactionTimeout(int n) throws XAException {
        if (tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)"setTransactionTimeout", (Object)new Integer(n));
        }
        if (this.ivManagedConnection._mcStale) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"MC is stale throwing XAER_RMFAIL", (Object)this.ivManagedConnection);
            }
            Tr.error((TraceComponent)tc, (String)"INVALID_CONNECTION");
            throw new XAException(-7);
        }
        return this.ivXaRes.setTransactionTimeout(n);
    }

    public void start(Xid xid, int n) throws XAException {
        if (tc.isEntryEnabled() || clientInfoTc.isEntryEnabled()) {
            tempTc = clientInfoTc.isEntryEnabled() ? clientInfoTc : tc;
            Tr.entry((TraceComponent)tempTc, (String)"start", (Object)new Object[]{this, this.ivManagedConnection, AdapterUtil.toString(xid), AdapterUtil.getXAResourceStartFlagString(n)});
        }
        if (this.ivManagedConnection._mcStale) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"MC is stale throwing XAER_RMFAIL", (Object)this.ivManagedConnection);
            }
            Tr.error((TraceComponent)tc, (String)"INVALID_CONNECTION");
            throw new XAException(-7);
        }
        if (this.detectMultithreadedAccess) {
            this.ivManagedConnection.detectMultithreadedAccess();
        }
        this.ivXid = xid;
        try {
            if (this.ivManagedConnection.mcf.transactionBranchesLooselyCoupled) {
                n = this.ivManagedConnection.mcf.getDataStoreHelper().modifyXAFlag(n);
            }
            this.ivXaRes.start(xid, n);
            this.ivStateManager.setState(4);
        }
        catch (TransactionException transactionException) {
            FFDCFilter.processException((Throwable)((Object)transactionException), (String)"com.ibm.ws.rsadapter.spi.WSRdbXaResourceImpl.start", (String)"615", (Object)this);
            Tr.error((TraceComponent)tc, (String)"INVALID_TX_STATE", (Object)new Object[]{"XAResource.start()", this.ivManagedConnection.getTransactionStateAsString()});
            try {
                this.ivXaRes.end(xid, 0);
                this.ivXaRes.rollback(xid);
            }
            catch (XAException xAException) {
                FFDCFilter.processException((Throwable)xAException, (String)"com.ibm.ws.rsadapter.spi.WSRdbXaResourceImpl.start", (String)"624", (Object)this);
                this.traceXAException(xAException, currClass);
            }
            XAException xAException = AdapterUtil.createXAException("INVALID_TX_STATE", new Object[]{"XAResource.start", this.ivManagedConnection.getTransactionStateAsString()}, 105);
            this.traceXAException(xAException, currClass);
            if (tc.isEntryEnabled() || clientInfoTc.isEntryEnabled()) {
                tempTc = clientInfoTc.isEntryEnabled() ? clientInfoTc : tc;
                Tr.exit((TraceComponent)tempTc, (String)"start", (Object)"Exception");
            }
            throw xAException;
        }
        catch (XAException xAException) {
            FFDCFilter.processException((Throwable)xAException, (String)"com.ibm.ws.rsadapter.spi.WSRdbXaResourceImpl.start", (String)"639", (Object)this);
            this.traceXAException(xAException, currClass);
            this.checkXAException(xAException);
            if (tc.isEntryEnabled() || clientInfoTc.isEntryEnabled()) {
                tempTc = clientInfoTc.isEntryEnabled() ? clientInfoTc : tc;
                Tr.exit((TraceComponent)tempTc, (String)"start", (Object)"Exception");
            }
            throw xAException;
        }
        if (tc.isDebugEnabled()) {
            String string = null;
            try {
                string = this.ivManagedConnection.mcf.getCorrelator(this.ivManagedConnection);
            }
            catch (SQLException sQLException) {
                Tr.debug((TraceComponent)tc, (String)"got an exception trying to get the correlator in rollback, exception is: ", (Object)sQLException);
            }
            if (string != null) {
                StringBuffer stringBuffer = new StringBuffer(200);
                stringBuffer.append("Correlator: DB2, ID: ");
                stringBuffer.append(string);
                if (xid != null) {
                    stringBuffer.append("Transaction ID : ");
                    stringBuffer.append(xid);
                }
                stringBuffer.append(" BEGIN");
                Tr.debug((TraceComponent)tc, (String)stringBuffer.toString());
            }
        }
        if (tc.isEntryEnabled() || clientInfoTc.isEntryEnabled()) {
            tempTc = clientInfoTc.isEntryEnabled() ? clientInfoTc : tc;
            Tr.exit((TraceComponent)tempTc, (String)"start");
        }
    }

    public final XAException traceXAException(XAException xAException, Class clazz) {
        String string = this.ivManagedConnection.mcf.dataStoreHelper.getXAExceptionContents(xAException);
        Tr.error((TraceComponent)tc, (String)"DISPLAY_XAEX_CONTENT", (Object)string);
        Tr.error((TraceComponent)tc, (String)"THROW_XAEXCEPTION", (Object)new Object[]{AdapterUtil.getXAExceptionCodeString(xAException.errorCode), xAException.getMessage()});
        return xAException;
    }

    private void checkXAException(XAException xAException) {
        boolean bl = false;
        switch (xAException.errorCode) {
            case -7: {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"XAER_RMFAIL connection error occurred");
                }
                bl = true;
                break;
            }
            default: {
                Throwable throwable = xAException.getCause();
                if (throwable == null || !(throwable instanceof SQLException) || !(this.ivManagedConnection.mcf.dataStoreHelper.mapException((SQLException)throwable) instanceof StaleConnectionException)) break;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Stale connection error occurred");
                }
                bl = true;
            }
        }
        if (bl) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("process connection error occurred event for XAResource " + this));
            }
            try {
                this.ivManagedConnection.processConnectionErrorOccurredEvent(null, xAException);
            }
            catch (NullPointerException nullPointerException) {
                if (tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)"Handle CLOSED or INACTIVE. Not sending CONNECTION_ERROR_OCCURRED. (caller, mc)", (Object)new Object[]{this, this.ivManagedConnection});
                }
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("XAException was not a connection error for XAResource " + this));
        }
    }
}

