/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.rsadapter.spi;

import com.ibm.ejs.j2c.ConnectionFactoryRefBuilder;
import com.ibm.ejs.j2c.DataSourceMBean;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.ce.cm.StaleConnectionException;
import com.ibm.websphere.pmi.J2CPerf;
import com.ibm.websphere.rsadapter.DataStoreHelper;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.FFDCSelfIntrospectable;
import com.ibm.ws.rsadapter.AdapterUtil;
import com.ibm.ws.rsadapter.FFDCLogger;
import com.ibm.ws.rsadapter.exceptions.DataStoreAdapterException;
import com.ibm.ws.rsadapter.jdbc.WSJdbcDataSource;
import com.ibm.ws.rsadapter.spi.InternalDataStoreHelper;
import com.ibm.ws.rsadapter.spi.LocationRestrictedFunction;
import com.ibm.ws.rsadapter.spi.RestrictedClientFunction;
import com.ibm.ws.rsadapter.spi.WSConnectionRequestInfoImpl;
import com.ibm.ws.rsadapter.spi.WSDefaultConnectionManagerImpl;
import com.ibm.ws.rsadapter.spi.WSManagedConnectionFactory;
import com.ibm.ws.rsadapter.spi.WSRdbDataSource;
import com.ibm.ws.rsadapter.spi.WSRdbManagedConnectionImpl;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.PrintWriter;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Properties;
import java.util.Set;
import javax.resource.NotSupportedException;
import javax.resource.ResourceException;
import javax.resource.cci.ConnectionFactory;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionFactory;
import javax.resource.spi.ResourceAdapter;
import javax.resource.spi.ResourceAdapterAssociation;
import javax.resource.spi.security.GenericCredential;
import javax.resource.spi.security.PasswordCredential;
import javax.security.auth.Subject;
import javax.sql.DataSource;
import javax.sql.PooledConnection;
import org.ietf.jgss.GSSCredential;

public class WSManagedConnectionFactoryImpl
implements WSManagedConnectionFactory,
ResourceAdapterAssociation,
Serializable,
DataSourceMBean,
FFDCSelfIntrospectable {
    private static final long serialVersionUID = -56589160441993572L;
    private transient String description;
    private transient int statementCacheSize;
    boolean dbFailOverEnabled = false;
    int connectionRetriesDuringDBFailover = 100;
    long connRetryDurationDuringDBFailover = 3000L;
    private Integer connectionFactoryType;
    private transient Properties dataSourceProperties;
    private ResourceAdapter resourceAdapter;
    private WSDefaultConnectionManagerImpl defaultConnectionManager = new WSDefaultConnectionManagerImpl();
    private WSRdbDataSource dataSource;
    transient DataStoreHelper dataStoreHelper;
    transient InternalDataStoreHelper internalHelper;
    private transient LinkedList propertyListeners;
    private transient String databaseType;
    transient boolean disableBackendIdchecking;
    boolean resetConnectionByBackendDatabase;
    boolean reauthEnabled;
    transient int hashCode;
    transient PrintWriter logWriter;
    transient J2CPerf pmi;
    public boolean jmsOnePhaseOptimization;
    boolean disableWASConnectionPooling;
    transient boolean detectMultithreadedAccess;
    transient String preTestSQLString = "select 1 from dual";
    public transient boolean detectedMultithreadedAccess;
    private static final Class currClass = WSManagedConnectionFactoryImpl.class;
    private static TraceComponent tc = Tr.register((Class)currClass, (String)"RRA", (String)"IBMDataStoreAdapterNLS");
    boolean loggingEnabled;
    private String jndiName = "";
    protected transient ConnectionManager connMgr = null;
    transient boolean transactionBranchesLooselyCoupled;
    transient long fatalErrorCount;
    transient boolean validateAfterConnectionError = true;
    public static LocationRestrictedFunction locationRestrictedFunction;

    public WSManagedConnectionFactoryImpl() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"<init>");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"<init>", (Object)this);
        }
    }

    public int configureDataSource(String string, Object[] objectArray, Class[] classArray, int n) throws SQLException {
        return this.dataSource.configure(string, objectArray, classArray, n);
    }

    public boolean isReauthenticationEnabled() {
        return this.reauthEnabled;
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.propertyListeners == null) {
            this.propertyListeners = new LinkedList();
        }
        this.propertyListeners.add(propertyChangeListener);
    }

    final void adjustHashCode(Object object, Object object2) {
        this.hashCode += (object2 == null ? 0 : object2.hashCode()) - (object == null ? 0 : object.hashCode());
    }

    public final Object createConnectionFactory(ConnectionManager connectionManager) throws ResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"createConnectionFactory", (Object)connectionManager);
        }
        this.connMgr = connectionManager;
        Object object = this.connectionFactoryType == null || this.connectionFactoryType.equals(ConnectionFactoryRefBuilder.FACTORY_WSJdbcDataSource) ? new WSJdbcDataSource(this, connectionManager) : locationRestrictedFunction.createCCIConnectionFactory(this, connectionManager);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"createConnectionFactory", (Object)object);
        }
        return object;
    }

    public final Object createConnectionFactory() throws ResourceException {
        return this.createConnectionFactory(this.defaultConnectionManager);
    }

    public final Object createConnectionFactory(ConnectionManager connectionManager, Integer n) throws ResourceException {
        this.connMgr = connectionManager;
        this.setConnectionFactoryType(n);
        return this.createConnectionFactory(connectionManager);
    }

    public ManagedConnection createManagedConnection(Subject subject, ConnectionRequestInfo connectionRequestInfo) throws ResourceException {
        Object object;
        String string;
        String string2;
        WSConnectionRequestInfoImpl wSConnectionRequestInfoImpl;
        PooledConnection pooledConnection;
        Object var4_4;
        boolean bl;
        block45: {
            Object object2;
            Object object3;
            Object object4;
            Object object5;
            Object object6;
            block46: {
                block44: {
                    bl = false;
                    var4_4 = null;
                    if (tc.isEntryEnabled()) {
                        Tr.entry((TraceComponent)tc, (String)"createManagedConnection", (Object)new Object[]{subject == null ? null : "subject not null", AdapterUtil.toString(connectionRequestInfo)});
                    }
                    pooledConnection = null;
                    wSConnectionRequestInfoImpl = connectionRequestInfo == null ? new WSConnectionRequestInfoImpl() : (WSConnectionRequestInfoImpl)connectionRequestInfo;
                    string2 = null;
                    string = null;
                    if (subject != null) break block44;
                    string = wSConnectionRequestInfoImpl.getPassword();
                    string2 = wSConnectionRequestInfoImpl.getUserName();
                    if (!tc.isEventEnabled()) break block45;
                    if (string2 == null) {
                        Tr.event((TraceComponent)tc, (String)"Using DataSource default user/password for authentication");
                    } else {
                        Tr.event((TraceComponent)tc, (String)"Using ConnectionRequestInfo for authentication");
                    }
                    break block45;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Subject found.  Will try to use either PasswordCredentials or GenericCredentials ");
                }
                string2 = null;
                string = null;
                object = this.getThreadIdentitySupport();
                boolean bl2 = false;
                if (((String)object).equals("ALLOWED") || ((String)object).equals("REQUIRED")) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"The JDBC Provider supports the use of Thread Identity for authentication.");
                    }
                    object6 = subject;
                    object5 = null;
                    if (System.getSecurityManager() != null) {
                        object4 = new PrivilegedExceptionAction((Subject)object6){
                            private final /* synthetic */ Subject val$subj;
                            {
                                this.val$subj = subject;
                            }

                            public Object run() throws Exception {
                                return this.val$subj.getPrivateCredentials(class$javax$resource$spi$security$GenericCredential == null ? (class$javax$resource$spi$security$GenericCredential = WSManagedConnectionFactoryImpl.class$("javax.resource.spi.security.GenericCredential")) : class$javax$resource$spi$security$GenericCredential);
                            }
                        };
                        try {
                            object5 = (Set)AccessController.doPrivileged(object4);
                        }
                        catch (PrivilegedActionException privilegedActionException) {
                            FFDCFilter.processException((Throwable)privilegedActionException, (String)"com.ibm.ws.rsadapter.spi.WSManagedConnectionFactoryImpl", (String)"826", (Object)this);
                            Exception exception = privilegedActionException.getException();
                            if (tc.isEntryEnabled()) {
                                Tr.exit((TraceComponent)tc, (String)"createManagedConnection with exception", (Object)exception);
                            }
                            throw (ResourceException)((Object)exception);
                        }
                    } else {
                        object5 = ((Subject)object6).getPrivateCredentials(GenericCredential.class);
                    }
                    object4 = object5.iterator();
                    object3 = new PrivilegedExceptionAction((Iterator)object4){
                        private final /* synthetic */ Iterator val$iterator;
                        {
                            this.val$iterator = iterator;
                        }

                        public Object run() throws Exception {
                            return this.val$iterator.next();
                        }
                    };
                    object2 = null;
                    while (object4.hasNext()) {
                        if (System.getSecurityManager() != null) {
                            try {
                                object2 = (GenericCredential)AccessController.doPrivileged(object3);
                            }
                            catch (PrivilegedActionException privilegedActionException) {
                                if (tc.isEntryEnabled()) {
                                    Tr.exit((TraceComponent)tc, (String)"createManagedConnection", (Object)"Exception");
                                }
                                String string3 = "Error validating credentials.";
                                DataStoreAdapterException dataStoreAdapterException = AdapterUtil.createDataStoreAdapterException("WS_INTERNAL_ERROR", new Object[]{string3, privilegedActionException.getException()}, privilegedActionException.getException(), currClass);
                                FFDCFilter.processException((Throwable)((Object)dataStoreAdapterException), (String)"com.ibm.ws.rsadapter.spi.WSManagedConnectionFactoryImpl.createManagedConnection", (String)"644", (Object)this, (Object[])new Object[]{string3, " Possible components: Security"});
                                throw dataStoreAdapterException;
                            }
                        } else {
                            object2 = (GenericCredential)object4.next();
                        }
                        if (!object2.getMechType().equals("oid:1.3.18.0.2.30.1")) continue;
                        bl2 = true;
                        break;
                    }
                    if (!bl2 && ((String)object).equals("REQUIRED")) {
                        String string4 = "createManagedConnection() error: Jdbc Provider requires ThreadIdentitySupport, but no UTOKEN generic credential was found.";
                        DataStoreAdapterException dataStoreAdapterException = AdapterUtil.createDataStoreAdapterException("WS_INTERNAL_ERROR", string4, null, currClass);
                        throw dataStoreAdapterException;
                    }
                }
                if (!bl2) break block46;
                string2 = null;
                string = null;
                if (!tc.isEventEnabled()) break block45;
                Tr.event((TraceComponent)tc, (String)"Using thread identity for authentication by the JDBC Provider's DataSource.");
                break block45;
            }
            object6 = subject.getPrivateCredentials().iterator();
            object5 = new PrivilegedExceptionAction((Iterator)object6){
                private final /* synthetic */ Iterator val$iter;
                {
                    this.val$iter = iterator;
                }

                public Object run() throws Exception {
                    return this.val$iter.next();
                }
            };
            while (object6.hasNext()) {
                if (System.getSecurityManager() != null) {
                    try {
                        var4_4 = AccessController.doPrivileged(object5);
                    }
                    catch (PrivilegedActionException privilegedActionException) {
                        FFDCFilter.processException((Throwable)privilegedActionException.getException(), (String)(this.getClass().getName() + ".createManagedConnection"), (String)"335", (Object)this);
                        if (tc.isEntryEnabled()) {
                            Tr.exit((TraceComponent)tc, (String)"createManagedConnection", (Object)"Exception");
                        }
                        object2 = "Error validating credentials.";
                        DataStoreAdapterException dataStoreAdapterException = AdapterUtil.createDataStoreAdapterException("WS_INTERNAL_ERROR", new Object[]{object2, privilegedActionException.getException()}, privilegedActionException.getException(), currClass);
                        FFDCFilter.processException((Throwable)((Object)dataStoreAdapterException), (String)(this.getClass().getName() + ".createManagedConnection"), (String)"754", (Object)this, (Object[])new Object[]{object2, " Possible components: Security"});
                        throw dataStoreAdapterException;
                    }
                } else {
                    var4_4 = object6.next();
                }
                if (var4_4 instanceof PasswordCredential) {
                    object4 = var4_4;
                    if (!object4.getManagedConnectionFactory().equals(this)) continue;
                    if (tc.isEventEnabled()) {
                        Tr.event((TraceComponent)tc, (String)"Using PasswordCredentials for authentication");
                    }
                    string2 = object4.getUserName();
                    object3 = object4.getPassword();
                    string = object3 == null ? null : new String((char[])object3);
                    break;
                }
                if (!(var4_4 instanceof GSSCredential)) continue;
                bl = true;
                if (tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)"Using GenericCredentials for authentication");
                }
                pooledConnection = this.internalHelper.getPooledConnection(var4_4, this.dataSource, wSConnectionRequestInfoImpl.ivConfigID);
                break;
            }
        }
        object = null;
        WSRdbManagedConnectionImpl wSRdbManagedConnectionImpl = null;
        try {
            if (pooledConnection == null) {
                pooledConnection = this.dataSource.getPooledConnection(string2, string, wSConnectionRequestInfoImpl.ivConfigID);
            }
            object = this.dataSource.getConnection(pooledConnection);
            if (this.dbFailOverEnabled) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"db failover is enabled, now validating conn");
                }
                this.validateConnection((Connection)object);
            }
            wSRdbManagedConnectionImpl = new WSRdbManagedConnectionImpl(this, pooledConnection, (Connection)object, subject, wSConnectionRequestInfoImpl, this.statementCacheSize, this.databaseType);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"createManagedConnection", (Object)wSRdbManagedConnectionImpl);
            }
            return wSRdbManagedConnectionImpl;
        }
        catch (ResourceException resourceException) {
            if (this.dbFailOverEnabled) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"validating failed closing connection and getting new one to revalidate");
                }
                try {
                    if (object != null) {
                        object.close();
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                try {
                    if (pooledConnection != null) {
                        pooledConnection.close();
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"done closing, now try to get a good connection");
                }
                object = this.getGoodConnection(pooledConnection, string2, string, wSConnectionRequestInfoImpl.ivConfigID, bl, var4_4);
                wSRdbManagedConnectionImpl = new WSRdbManagedConnectionImpl(this, pooledConnection, (Connection)object, subject, wSConnectionRequestInfoImpl, this.statementCacheSize, this.databaseType);
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"createManagedConnection in retry mode", (Object)wSRdbManagedConnectionImpl);
                }
                return wSRdbManagedConnectionImpl;
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"createManagedConnection", (Object)((Object)resourceException));
            }
            throw resourceException;
        }
    }

    public final boolean equals(Object object) {
        boolean bl;
        boolean bl2 = bl = this == object || object != null && this.hashCode == object.hashCode() && this.fullCompare(object);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"equals?", (Object)new Object[]{this, object, bl ? Boolean.TRUE : Boolean.FALSE});
        }
        return bl;
    }

    public boolean equals(WSManagedConnectionFactoryImpl wSManagedConnectionFactoryImpl, int n, int n2) {
        boolean bl;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"equals", (Object)new Object[]{"Configuration #" + n + " of " + this, "Configuration #" + n2 + " of " + wSManagedConnectionFactoryImpl});
        }
        boolean bl2 = WSManagedConnectionFactoryImpl.match(this.dataSourceProperties, wSManagedConnectionFactoryImpl.dataSourceProperties) && (this.dataSource == null ? wSManagedConnectionFactoryImpl.dataSource == null : this.dataSource.equals(wSManagedConnectionFactoryImpl.dataSource, n, n2)) ? true : (bl = false);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"equals", (Object)(bl ? Boolean.TRUE : Boolean.FALSE));
        }
        return bl;
    }

    private synchronized void firePropertyChangeEvent(String string, Object object, Object object2) {
        if (tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)"ManagedConnectionFactory property changed:", (Object)new Object[]{this, string, string.equalsIgnoreCase("password") ? "******" : object, string.equalsIgnoreCase("password") ? "******" : object2});
        }
        if (this.propertyListeners == null) {
            return;
        }
        PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(this, string, object, object2);
        Iterator iterator = this.propertyListeners.iterator();
        while (iterator.hasNext()) {
            ((PropertyChangeListener)iterator.next()).propertyChange(propertyChangeEvent);
        }
    }

    private boolean fullCompare(Object object) {
        try {
            WSManagedConnectionFactoryImpl wSManagedConnectionFactoryImpl = (WSManagedConnectionFactoryImpl)object;
            return WSManagedConnectionFactoryImpl.match(this.dataSourceProperties, wSManagedConnectionFactoryImpl.dataSourceProperties) && WSManagedConnectionFactoryImpl.match(this.dataSource, wSManagedConnectionFactoryImpl.dataSource);
        }
        catch (Exception exception) {
            return false;
        }
    }

    public Set getInvalidConnections(Set set) throws ResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getInvalidConnections", (Object)new Object[]{this, set});
        }
        HashSet<WSRdbManagedConnectionImpl> hashSet = new HashSet<WSRdbManagedConnectionImpl>();
        Object var3_3 = null;
        WSRdbManagedConnectionImpl wSRdbManagedConnectionImpl = null;
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            try {
                wSRdbManagedConnectionImpl = (WSRdbManagedConnectionImpl)iterator.next();
                wSRdbManagedConnectionImpl.preTestConnection(false);
            }
            catch (ResourceException resourceException) {
                if (tc.isDebugEnabled()) {
                    SQLException sQLException = (SQLException)resourceException.getLinkedException();
                    Tr.debug((TraceComponent)tc, (String)"Found a bad connection.", (Object)new Object[]{wSRdbManagedConnectionImpl, "SQL State:  " + sQLException.getSQLState(), "Error Code: " + sQLException.getErrorCode(), sQLException.getMessage()});
                }
                hashSet.add(wSRdbManagedConnectionImpl);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getInvalidConnections", hashSet);
        }
        return hashSet;
    }

    public final ResourceAdapter getResourceAdapter() {
        return this.resourceAdapter;
    }

    public final Boolean getRRSTransactional() {
        return this.internalHelper.getRRSTransactional();
    }

    public final String getThreadIdentitySupport() {
        return this.internalHelper.getThreadIdentitySupport();
    }

    public final Boolean getThreadSecurity() {
        return this.internalHelper.getThreadSecurity();
    }

    public Object getUnderlyingDataSource(long l, int n) {
        if (29497789L != l) {
            throw new IllegalArgumentException();
        }
        return n == 0 ? this.dataSource.dataSource : this.dataSource.dcm.getDataSource(n);
    }

    public final int hashCode() {
        return this.hashCode;
    }

    private static final boolean match(Object object, Object object2) {
        return object == object2 || object != null && object.equals(object2);
    }

    public ManagedConnection matchManagedConnections(Set set, Subject subject, ConnectionRequestInfo connectionRequestInfo) throws ResourceException {
        Object object;
        if (tc.isEntryEnabled()) {
            object = null;
            object = subject == null ? "null" : "not null";
            Tr.entry((TraceComponent)tc, (String)"matchManagedConnections", (Object)new Object[]{set == null ? null : new Integer(set.size()), object, connectionRequestInfo});
        }
        if (this.disableWASConnectionPooling) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"WAS connection pooling is disabled, throwing a NotSupportedException");
            }
            throw new NotSupportedException();
        }
        if (set == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"matchManagedConnections", null);
            }
            return null;
        }
        try {
            object = (WSConnectionRequestInfoImpl)connectionRequestInfo;
        }
        catch (ClassCastException classCastException) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"matchManagedConnections", null);
            }
            return null;
        }
        WSRdbManagedConnectionImpl wSRdbManagedConnectionImpl = null;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"the size of the set should be 1, and it is", (Object)new Integer(set.size()));
        }
        Iterator iterator = set.iterator();
        WSRdbManagedConnectionImpl wSRdbManagedConnectionImpl2 = (WSRdbManagedConnectionImpl)iterator.next();
        if (wSRdbManagedConnectionImpl2._claimedVictim && ((WSConnectionRequestInfoImpl)object).isReconfigurable(wSRdbManagedConnectionImpl2.getCRI(), true)) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"mc is claimedVictim matched", (Object)wSRdbManagedConnectionImpl2);
            }
            wSRdbManagedConnectionImpl = wSRdbManagedConnectionImpl2;
        } else if (subject == null) {
            if (wSRdbManagedConnectionImpl2.getSubject() == null && ((WSConnectionRequestInfoImpl)object).isReconfigurable(wSRdbManagedConnectionImpl2.getCRI(), false)) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"mc matched", (Object)wSRdbManagedConnectionImpl2);
                }
                wSRdbManagedConnectionImpl = wSRdbManagedConnectionImpl2;
            }
        } else {
            Subject subject2 = wSRdbManagedConnectionImpl2.getSubject();
            if (subject2 != null) {
                Equals equals = new Equals();
                equals.setSubjects(subject, subject2);
                if (((Boolean)com.ibm.ws.security.util.AccessController.doPrivileged((PrivilegedAction)equals)).booleanValue() && ((WSConnectionRequestInfoImpl)object).isReconfigurable(wSRdbManagedConnectionImpl2.getCRI(), false)) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"mc matched", (Object)wSRdbManagedConnectionImpl2);
                    }
                    wSRdbManagedConnectionImpl = wSRdbManagedConnectionImpl2;
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"matchManagedConnections", (Object)wSRdbManagedConnectionImpl);
        }
        return wSRdbManagedConnectionImpl;
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.propertyListeners != null) {
            this.propertyListeners.remove(propertyChangeListener);
        }
    }

    private void resetHashCode() {
        this.hashCode = this.dataSourceProperties == null ? 0 : this.dataSourceProperties.hashCode();
    }

    public final void setAgedTimeout(int n) {
        Tr.warning((TraceComponent)tc, (String)"METHOD_UNSUPPORTED", (Object)new Object[]{"setAgedTimeout", ManagedConnectionFactory.class});
    }

    public final void setConnectionTimeout(int n) {
        Tr.warning((TraceComponent)tc, (String)"METHOD_UNSUPPORTED", (Object)new Object[]{"setConnectionTimeout", ManagedConnectionFactory.class});
    }

    public final void setDescription(String string) {
        this.description = string;
    }

    public final void setInactiveConnectionSupport(Boolean bl) {
    }

    public final void setLogWriter(PrintWriter printWriter) throws ResourceException {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"setLogWriter on the mcf is a no-op when calling this method");
        }
    }

    final void reallySetLogWriter(final PrintWriter printWriter) throws ResourceException {
        if (this.dataSource != null) {
            final WSRdbDataSource wSRdbDataSource = this.dataSource;
            try {
                com.ibm.ws.security.util.AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        wSRdbDataSource.setLogWriter(printWriter);
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                FFDCFilter.processException((Throwable)privilegedActionException, (String)"com.ibm.ws.rsadapter.spi.WSManagedConnectionFactoryImpl.setLogWriter", (String)"593", (Object)this);
                throw (ResourceException)((Object)privilegedActionException.getException());
            }
        }
        this.logWriter = printWriter;
    }

    public final void setMaxConnections(int n) {
        Tr.warning((TraceComponent)tc, (String)"METHOD_UNSUPPORTED", (Object)new Object[]{"setMaxConnections", ManagedConnectionFactory.class});
    }

    public final void setMinConnections(int n) {
        Tr.warning((TraceComponent)tc, (String)"METHOD_UNSUPPORTED", (Object)new Object[]{"setMinConnections", ManagedConnectionFactory.class});
    }

    public final void setPurgePolicy(String string) {
        Tr.warning((TraceComponent)tc, (String)"METHOD_UNSUPPORTED", (Object)new Object[]{"setPurgePolicy", ManagedConnectionFactory.class});
    }

    public final void setReapTime(int n) {
        Tr.warning((TraceComponent)tc, (String)"METHOD_UNSUPPORTED", (Object)new Object[]{"setReapTime", ManagedConnectionFactory.class});
    }

    public final void setResourceAdapter(ResourceAdapter resourceAdapter) throws ResourceException {
        this.resourceAdapter = resourceAdapter;
    }

    public final void setUnusedTimeout(int n) {
        Tr.warning((TraceComponent)tc, (String)"METHOD_UNSUPPORTED", (Object)new Object[]{"setUnusedTimeout", ManagedConnectionFactory.class});
    }

    public void setDataSourceProperties(Properties properties) throws ResourceException {
        if (tc.isEntryEnabled()) {
            String string = (String)properties.remove("password");
            Tr.entry((TraceComponent)tc, (String)"setDataSourceProperties", (Object)properties);
            if (string != null) {
                properties.setProperty("password", string);
            }
        }
        this.dataSourceProperties = (Properties)properties.clone();
        this.dataSource = new WSRdbDataSource(this.dataSourceProperties, this);
        this.dataStoreHelper = this.dataSource.dataStoreHelper;
        this.resetHashCode();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setDataSourceProperties");
        }
    }

    public String getDataSourceName() {
        String string = null;
        if (this.dataSourceProperties != null) {
            string = this.dataSourceProperties.getProperty("dataSourceName");
        }
        if (string == null) {
            string = "ManagedConnectionFactory " + Integer.toHexString(super.hashCode());
        }
        return string;
    }

    public void setConnectionFactoryType(Integer n) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"setConnectionFactoryType", (Object)AdapterUtil.getConnectionFactoryInterfaceName(n));
        }
        if (WSManagedConnectionFactoryImpl.match(n, this.connectionFactoryType)) {
            return;
        }
        if (this.propertyListeners == null) {
            this.connectionFactoryType = n;
        } else {
            this.connectionFactoryType = n;
            this.firePropertyChangeEvent("ConnectionFactoryType", this.connectionFactoryType, this.connectionFactoryType);
        }
    }

    final void setStatementCacheSize(int n) {
        this.statementCacheSize = n;
    }

    public final void setTransactionResourceRegistration(String string) {
    }

    public final int getStatementCacheSize() {
        return this.statementCacheSize;
    }

    public String[] introspectSelf() {
        FFDCLogger fFDCLogger = new FFDCLogger(this);
        fFDCLogger.append("Detection of multithreaded access is", this.detectMultithreadedAccess ? "ENABLED" : "DISABLED");
        if (this.detectMultithreadedAccess) {
            fFDCLogger.append("Multithreaded access was detected?", this.detectedMultithreadedAccess ? Boolean.TRUE : Boolean.FALSE);
        }
        fFDCLogger.append("Resource Adapter:", this.resourceAdapter);
        fFDCLogger.append("Hash Code:", this.hashCode + " (0x" + Integer.toHexString(this.hashCode) + ')');
        fFDCLogger.append("DataSource properties:", AdapterUtil.hidePassword(this.dataSourceProperties));
        fFDCLogger.append("Database Type:", this.databaseType);
        fFDCLogger.append("DataStoreHelper:", this.dataStoreHelper);
        fFDCLogger.append("Description:", this.description);
        fFDCLogger.append("InternalDataStoreHelper:", this.internalHelper);
        fFDCLogger.append("Log Writer:", this.logWriter);
        fFDCLogger.append("Performance Monitoring Instrumentation:", this.pmi);
        fFDCLogger.append("Statement Cache Size (maximum):", new Integer(this.statementCacheSize));
        fFDCLogger.append("Transaction Branches are set to be Loosely Coupled: ", new Boolean(this.transactionBranchesLooselyCoupled));
        fFDCLogger.append("Counter of fatal connection errors on ManagedConnections created by this MCF:", new Long(this.fatalErrorCount));
        fFDCLogger.append("Validate existing connections on cleanup after a fatal connection error is detected?", this.validateAfterConnectionError ? Boolean.TRUE : Boolean.FALSE);
        fFDCLogger.append("ResetConnectionByBackendDatabase: ", new Boolean(this.resetConnectionByBackendDatabase));
        fFDCLogger.append("Backend id checking is: ", new Boolean(!this.disableBackendIdchecking));
        fFDCLogger.append("JMSOnePhaseOptimization: ", new Boolean(this.jmsOnePhaseOptimization));
        fFDCLogger.append("Reauthentication: ", new Boolean(this.reauthEnabled));
        fFDCLogger.append("dbFailOverEnabled: ", new Boolean(this.dbFailOverEnabled));
        fFDCLogger.append("connectionRetriesDuringDBFailover: ", new Integer(this.connectionRetriesDuringDBFailover));
        fFDCLogger.append("connRetryDurationDuringDBFailover: ", new Long(this.connRetryDurationDuringDBFailover));
        String string = this.connectionFactoryType == null ? null : (this.connectionFactoryType.equals(ConnectionFactoryRefBuilder.FACTORY_WSJdbcDataSource) ? WSJdbcDataSource.class.getName() : (this.connectionFactoryType.equals(ConnectionFactoryRefBuilder.FACTORY_WSRdbConnectionFactory) ? "com.ibm.ws.rsadapter.cci.WSRdbConnectionFactoryImpl" : "com.ibm.ws.rsadapter.cci.RdbConnectionFactoryImpl"));
        fFDCLogger.append("Connection Factory Type:", string);
        fFDCLogger.append("Listing PropertyChangeListeners:");
        try {
            Iterator iterator = this.propertyListeners.iterator();
            while (iterator.hasNext()) {
                fFDCLogger.indent(iterator.next());
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        fFDCLogger.eoln();
        fFDCLogger.introspect("WSRdbDataSource Wrapper", this.dataSource);
        return fFDCLogger.toStringArray();
    }

    public final PrintWriter getLogWriter() throws ResourceException {
        if (this.dataSource == null) {
            return this.logWriter;
        }
        return this.dataSource.getLogWriter();
    }

    public final PrintWriter getLogWriter(int n) throws SQLException {
        return this.dataSource == null ? this.logWriter : this.dataSource.getLogWriter(n);
    }

    public final J2CPerf getPMI() {
        return this.pmi;
    }

    public int getLoginTimeout() {
        if (this.dataSource == null) {
            return 0;
        }
        String string = this.getDataSourceProperties().getProperty("loginTimeout");
        return string == null ? 0 : Integer.parseInt(string);
    }

    public final int getLoginTimeout(int n) throws SQLException {
        return this.dataSource == null ? 0 : this.dataSource.getLoginTimeout(n);
    }

    public final String getDescription() {
        return this.description;
    }

    public final Class getConnectionFactoryClass() {
        Class clazz = this.connectionFactoryType == ConnectionFactoryRefBuilder.FACTORY_WSRdbConnectionFactory ? ConnectionFactory.class : DataSource.class;
        return clazz;
    }

    public final Integer getConnectionFactoryType() {
        return this.connectionFactoryType;
    }

    public final Properties getDataSourceProperties() {
        return this.dataSource.getDataSourceProperties();
    }

    public final DataStoreHelper getDataStoreHelper() {
        return this.dataStoreHelper;
    }

    public InternalDataStoreHelper getInternalDataStoreHelper() {
        return this.internalHelper;
    }

    public final Class getDataStoreHelperClass() {
        return this.dataStoreHelper.getClass();
    }

    protected final void setDatabaseType(String string) {
        this.databaseType = string;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Database type is " + string));
        }
    }

    public final Object[] call(String string, Object[] objectArray, Class[] classArray, int n) throws SQLException {
        return this.call(string, objectArray, classArray, n, null);
    }

    public final Object[] call(String string, Object[] objectArray, Class[] classArray, int n, String string2) throws SQLException {
        return this.dataSource.call(string, objectArray, classArray, n, string2);
    }

    public final boolean isJTAEnabled() {
        return this.dataSource.isJTAEnabled();
    }

    public void setUserName(String string) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("set user = " + string));
        }
        string = string.trim();
        if (this.propertyListeners == null) {
            this.adjustHashCode(this.dataSource.setUserName(string), string);
        } else {
            Object object = this.dataSource.setUserName(string);
            if (!WSManagedConnectionFactoryImpl.match(object, string)) {
                this.adjustHashCode(object, string);
                this.firePropertyChangeEvent("UserName", object, string);
            }
        }
    }

    public void setPassword(String string) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"set password = ******");
        }
        string = string.trim();
        if (this.propertyListeners == null) {
            this.adjustHashCode(this.dataSource.setPassword(string), string);
        } else {
            Object object = this.dataSource.setPassword(string);
            if (!WSManagedConnectionFactoryImpl.match(object, string)) {
                this.adjustHashCode(object, string);
                this.firePropertyChangeEvent("Password", "******", "******");
            }
        }
    }

    public void setPmiData(String string, J2CPerf j2CPerf) {
        this.jndiName = string;
        this.pmi = j2CPerf;
    }

    public String getCorrelator(WSRdbManagedConnectionImpl wSRdbManagedConnectionImpl) throws SQLException {
        return this.internalHelper.getCorrelator(wSRdbManagedConnectionImpl);
    }

    public final boolean isBackEndIdCheckingDisabled() {
        return this.disableBackendIdchecking;
    }

    public ConnectionManager getConnMgr(int n) {
        if (29497789 != n) {
            throw new IllegalArgumentException();
        }
        return this.connMgr;
    }

    public String getJndiName() {
        return this.jndiName;
    }

    private Connection getGoodConnection(PooledConnection pooledConnection, String string, String string2, int n, boolean bl, Object object) throws ResourceException {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"getGoodConnection(PooledConnection, String, String, int ,boolean, Object)", (Object)new Object[]{pooledConnection, string, "******", new Integer(n), new Boolean(bl), object});
        }
        int n2 = this.connectionRetriesDuringDBFailover;
        Connection connection = null;
        ResourceException resourceException = null;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getGoodConnection about to go in loop" + n2));
        }
        while (n2-- > 0) {
            try {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("getGoodConnection in loop#:" + n2));
                }
                if (!bl) {
                    pooledConnection = this.dataSource.getPooledConnection(string, string2, n);
                } else {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"using kerberos to get a connection");
                    }
                    pooledConnection = this.internalHelper.getPooledConnection((GSSCredential)object, this.dataSource, n);
                }
                connection = this.dataSource.getConnection(pooledConnection);
                this.validateConnection(connection);
                return connection;
            }
            catch (ResourceException resourceException2) {
                resourceException = resourceException2;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("pretest failed, closing to retrying number:" + this.connectionRetriesDuringDBFailover));
                }
                try {
                    if (connection != null) {
                        connection.close();
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                try {
                    if (pooledConnection != null) {
                        pooledConnection.close();
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("sleeping for (ms):" + this.connRetryDurationDuringDBFailover));
                }
                try {
                    Thread.sleep(this.connRetryDurationDuringDBFailover);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Couldn't get good connection, throwing rEX: " + (Object)((Object)resourceException)));
        }
        throw resourceException;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void validateConnection(Connection connection) throws ResourceException {
        block18: {
            Statement statement;
            block17: {
                if (tc.isEntryEnabled()) {
                    Tr.entry((TraceComponent)tc, (String)"validateConnection (conn, pretestString)", (Object)new Object[]{connection, this.preTestSQLString});
                }
                statement = null;
                statement = connection.createStatement();
                statement.execute(this.preTestSQLString);
                statement.close();
                statement = null;
                connection.clearWarnings();
                if (!tc.isEntryEnabled()) break block17;
                Tr.exit((TraceComponent)tc, (String)"validateConnection successful");
            }
            Object var6_3 = null;
            try {
                if (statement != null) {
                    statement.close();
                }
                break block18;
            }
            catch (Throwable throwable) {}
            break block18;
            {
                catch (SQLException sQLException) {
                    SQLException sQLException2 = this.dataStoreHelper.mapException(sQLException);
                    if (sQLException2 instanceof StaleConnectionException) {
                        if (tc.isEntryEnabled()) {
                            Tr.exit((TraceComponent)tc, (String)"validateConnection failed with SCE", (Object)sQLException2);
                        }
                        throw new DataStoreAdapterException("DSA_ERROR", sQLException2, currClass);
                    }
                    try {
                        connection.clearWarnings();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    if (tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"validateConnection Passed but with non-SCE", (Object)sQLException2);
                    }
                    Object var6_4 = null;
                    try {
                        if (statement != null) {
                            statement.close();
                        }
                        break block18;
                    }
                    catch (Throwable throwable) {}
                }
            }
            catch (Throwable throwable) {
                Object var6_5 = null;
                try {
                    if (statement != null) {
                        statement.close();
                    }
                }
                catch (Throwable throwable2) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    static {
        try {
            locationRestrictedFunction = (LocationRestrictedFunction)((Constructor)com.ibm.ws.security.util.AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                    if (classLoader == null) {
                        classLoader = ClassLoader.getSystemClassLoader();
                    }
                    return classLoader.loadClass("com.ibm.ws.rsadapter.spi.RestrictedServerFunction").getConstructor(null);
                }
            })).newInstance(null);
        }
        catch (PrivilegedActionException privilegedActionException) {
            Throwable throwable = privilegedActionException.getCause();
            if (throwable instanceof ClassNotFoundException) {
                locationRestrictedFunction = new RestrictedClientFunction();
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"ManagedConnectionFactory is being initialized on the client. Server class was not found:", (Object)throwable.getMessage());
                }
            }
            FFDCFilter.processException((Throwable)throwable, (String)(currClass.getName() + ".<cinit>"), (String)"295");
            throw new ExceptionInInitializerError(throwable);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            locationRestrictedFunction = new RestrictedClientFunction();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"ManagedConnectionFactory is being initialized on the client. Server class was not found:", (Object)noClassDefFoundError.getMessage());
            }
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getCause();
            FFDCFilter.processException((Throwable)throwable, (String)(currClass.getName() + ".<cinit>"), (String)"314");
            throw new ExceptionInInitializerError(throwable);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)(currClass.getName() + ".<cinit>"), (String)"320");
            throw new ExceptionInInitializerError(exception);
        }
    }

    class Equals
    implements PrivilegedAction {
        Subject _s1;
        Subject _s2;

        Equals() {
        }

        public final void setSubjects(Subject subject, Subject subject2) {
            this._s1 = subject;
            this._s2 = subject2;
        }

        public Object run() {
            boolean bl = false;
            if (this.checkPrivateCredentials(this._s2.getPrivateCredentials())) {
                bl = this.checkPublicCredentials(this._s2.getPublicCredentials());
            }
            return new Boolean(bl);
        }

        private boolean checkPublicCredentials(Set set) {
            boolean bl = false;
            if (this._s1.getPublicCredentials() != set) {
                if (this._s1.getPublicCredentials() != null && set != null) {
                    bl = ((Object)this._s1.getPublicCredentials()).equals(set);
                }
            } else {
                bl = true;
            }
            return bl;
        }

        private boolean checkPrivateCredentials(Set set) {
            boolean bl = false;
            if (this._s1.getPrivateCredentials() != set) {
                if (this._s1.getPrivateCredentials() != null && set != null) {
                    bl = ((Object)this._s1.getPrivateCredentials()).equals(set);
                }
            } else {
                bl = true;
            }
            return bl;
        }
    }
}

