/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.rsadapter.spi;

import com.ibm.ejs.ras.RasHelper;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.rsadapter.AdapterUtil;
import com.ibm.ws.rsadapter.spi.InternalOracleDataStoreHelper;
import com.ibm.ws.rsadapter.spi.WSRdbManagedConnectionImpl;
import com.ibm.ws.security.util.AccessController;
import java.io.IOException;
import java.io.PrintWriter;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.sql.SQLException;
import java.util.Properties;
import java.util.logging.FileHandler;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import java.util.logging.XMLFormatter;
import javax.resource.ResourceException;
import oracle.jdbc.driver.OracleConnection;
import oracle.jdbc.driver.OracleLog;

public class InternalOracle10gDataStoreHelper
extends InternalOracleDataStoreHelper {
    private static TraceComponent tc = Tr.register((Class)InternalOracle10gDataStoreHelper.class, (String)"RRA", (String)"IBMDataStoreAdapterNLS");
    private transient Class currClass = InternalOracle10gDataStoreHelper.class;
    private String[] matrix = new String[4];

    public void setProperties(Properties properties) throws ResourceException {
        super.setProperties(properties);
        int n = 0;
        int n2 = 1;
        String string = null;
        Logger logger = null;
        Formatter formatter = null;
        FileHandler fileHandler = null;
        String string2 = "oracle.jdbc.driver";
        String string3 = "INFO";
        String string4 = "SimpleFormat";
        String string5 = null;
        if (properties != null) {
            string5 = properties.getProperty("oracleLogPackageName");
            if (string5 != null && !string5.equals("")) {
                string2 = string5;
            }
            if ((string5 = properties.getProperty("oracleLogFileName")) != null && !string5.equals("")) {
                string = string5;
            }
            if (oraTc.isDebugEnabled()) {
                Tr.debug((TraceComponent)oraTc, (String)"DSConfigurationHelper.ORACLELOG_PACKAGENAME is: ", (Object)string2);
                Tr.debug((TraceComponent)oraTc, (String)"DSConfigurationHelper.ORACLELOG_FILENAME is:  ", (Object)string);
            }
            logger = Logger.getLogger(string2);
            if (string != null && !string.equals("")) {
                string5 = properties.getProperty("oracleLogTraceLevel");
                if (string5 != null && !string5.equals("")) {
                    string3 = string5;
                }
                if ((string5 = properties.getProperty("oracleLogFormat")) != null && !string5.equals("")) {
                    string4 = string5;
                }
                if (string4 != null && (string4.charAt(0) == 'S' || string4.charAt(0) == 's')) {
                    if (oraTc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)oraTc, (String)"SimpleFormatter is used");
                    }
                    formatter = new SimpleFormatter();
                } else {
                    if (oraTc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)oraTc, (String)"XMLFormatter is used");
                    }
                    formatter = new XMLFormatter();
                }
                string5 = properties.getProperty("oracleLogFileSizeLimit");
                if (string5 != null && !string5.equals("")) {
                    n = Integer.parseInt(string5);
                }
                if ((string5 = properties.getProperty("oracleLogFileCount")) != null && !string5.equals("")) {
                    n2 = Integer.parseInt(string5);
                }
                if (oraTc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)oraTc, (String)("DSConfigurationHelper.ORACLELOG_FILE_COUNT is: " + n2));
                    Tr.debug((TraceComponent)oraTc, (String)("DSConfigurationHelper.ORACLELOG_FILE_SIZE_LIMIT is: " + n));
                    Tr.debug((TraceComponent)oraTc, (String)"DSConfigurationHelper.ORACLELOG_FORMAT is: ", (Object)string4);
                    Tr.debug((TraceComponent)oraTc, (String)"DSConfigurationHelper.ORACLELOG_TRACELEVEL is: ", (Object)string3);
                }
                try {
                    fileHandler = new FileHandler(string + "%g.%u", n, n2);
                    fileHandler.setFormatter(formatter);
                    fileHandler.setLevel(Level.ALL);
                    logger.setLevel(AdapterUtil.getLevelBasedOnName(string3));
                    logger.setUseParentHandlers(false);
                    logger.addHandler(fileHandler);
                }
                catch (IOException iOException) {
                    Tr.warning((TraceComponent)oraTc, (String)"ORACLE_TRACE_WARNING", (Object)new Object[]{string, iOException});
                }
            } else if (oraTc.isDebugEnabled()) {
                Tr.debug((TraceComponent)oraTc, (String)"Oracle trace file is not set, Oracle logging/tracing will be mergned with WAS logging based on WAS logging settings");
            }
        }
    }

    public void disableJdbcLogging(WSRdbManagedConnectionImpl wSRdbManagedConnectionImpl) throws ResourceException {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Disabling loggin on Oracle10g and later");
        }
        try {
            AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    OracleLog.setTrace((boolean)false);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            FFDCFilter.processException((Throwable)privilegedActionException.getException(), (String)"com.ibm.ws.rsadapter.spi.InternalOracleDataStoreHelper.enableJdbcLogging", (String)"236", (Object)this);
            Tr.debug((TraceComponent)oraTc, (String)"InternalOracleDataStoreHelper.enableJdbcLogging failed to enable trace in Oracle, execution will continue: ", (Object)privilegedActionException.getException());
        }
        wSRdbManagedConnectionImpl.mcf.loggingEnabled = false;
    }

    public void enableJdbcLogging(WSRdbManagedConnectionImpl wSRdbManagedConnectionImpl) throws ResourceException {
        Tr.debug((TraceComponent)oraTc, (String)"Enabling logging on Oracle10g and later");
        try {
            AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    OracleLog.setTrace((boolean)true);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            FFDCFilter.processException((Throwable)privilegedActionException.getException(), (String)"com.ibm.ws.rsadapter.spi.InternalOracleDataStoreHelper.enableJdbcLogging", (String)"236", (Object)this);
            Tr.debug((TraceComponent)oraTc, (String)"InternalOracleDataStoreHelper.enableJdbcLogging failed to enable trace in Oracle, execution will continue: ", (Object)privilegedActionException.getException());
        }
        wSRdbManagedConnectionImpl.mcf.loggingEnabled = true;
    }

    public PrintWriter getPrintWriter() throws ResourceException {
        return null;
    }

    public void doConnectionCleanupOnWrapper(WSRdbManagedConnectionImpl wSRdbManagedConnectionImpl) throws SQLException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setClientInformation(Properties properties, WSRdbManagedConnectionImpl wSRdbManagedConnectionImpl, boolean bl) throws SQLException {
        StringBuffer stringBuffer = null;
        String string = null;
        OracleConnection oracleConnection = (OracleConnection)wSRdbManagedConnectionImpl.sqlConn;
        if (tc.isDebugEnabled() || clientInfoPlusTc.isDebugEnabled()) {
            TraceComponent traceComponent = clientInfoPlusTc.isDebugEnabled() ? clientInfoPlusTc : tc;
            Tr.debug((TraceComponent)traceComponent, (String)"setClientInformation(Properties props,WSRdbManagedConnectionImpl mc, boolean explicitCall) with sqlConn", (Object)new Object[]{properties, wSRdbManagedConnectionImpl, new Boolean(bl), wSRdbManagedConnectionImpl.sqlConn});
        }
        if (bl) {
            string = properties.getProperty("CLIENT_ID");
            wSRdbManagedConnectionImpl.clientInfoExplicitlySet = true;
        }
        if (clientInfoTc.isDebugEnabled() || clientInfoPlusTc.isDebugEnabled()) {
            stringBuffer = new StringBuffer(64);
            stringBuffer.append(RasHelper.getThreadId()).append('_').append(wSRdbManagedConnectionImpl.toString());
            if (string != null) {
                stringBuffer.append('_').append(string);
            }
            wSRdbManagedConnectionImpl.clientInfoImplicitlySet = true;
            string = stringBuffer.toString();
        }
        if (string != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"The clientInfo string is:", (Object)string);
            }
            wSRdbManagedConnectionImpl.holdCurrentClientInfo(string, null, null, null);
            this.matrix[1] = string;
            if (wSRdbManagedConnectionImpl.pmi != null) {
                try {
                    wSRdbManagedConnectionImpl.pmi.jdbcOperationStarted();
                    oracleConnection.setEndToEndMetrics(this.matrix, (short)0);
                }
                finally {
                    wSRdbManagedConnectionImpl.pmi.jdbcOperationCompleted();
                }
            } else {
                oracleConnection.setEndToEndMetrics(this.matrix, (short)0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setClientInformationArray(String[] stringArray, WSRdbManagedConnectionImpl wSRdbManagedConnectionImpl, boolean bl) throws SQLException {
        OracleConnection oracleConnection = (OracleConnection)wSRdbManagedConnectionImpl.sqlConn;
        if (bl) {
            wSRdbManagedConnectionImpl.clientInfoExplicitlySet = true;
        } else {
            wSRdbManagedConnectionImpl.clientInfoImplicitlySet = true;
        }
        this.matrix[1] = stringArray[0];
        if (wSRdbManagedConnectionImpl.pmi != null) {
            try {
                wSRdbManagedConnectionImpl.pmi.jdbcOperationStarted();
                oracleConnection.setEndToEndMetrics(this.matrix, (short)0);
            }
            finally {
                wSRdbManagedConnectionImpl.pmi.jdbcOperationCompleted();
            }
        } else {
            oracleConnection.setEndToEndMetrics(this.matrix, (short)0);
        }
    }

    public void resetClientInformation(WSRdbManagedConnectionImpl wSRdbManagedConnectionImpl) throws SQLException {
        if ((wSRdbManagedConnectionImpl.clientInfoExplicitlySet || wSRdbManagedConnectionImpl.clientInfoImplicitlySet) && !clientInfoTc.isDebugEnabled() && !clientInfoPlusTc.isDebugEnabled()) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"resetClientInformation is called on: ", (Object)wSRdbManagedConnectionImpl);
            }
            OracleConnection oracleConnection = (OracleConnection)wSRdbManagedConnectionImpl.sqlConn;
            this.matrix[1] = null;
            oracleConnection.setEndToEndMetrics(this.matrix, (short)0);
            wSRdbManagedConnectionImpl.clientInfoExplicitlySet = false;
            wSRdbManagedConnectionImpl.clientInfoImplicitlySet = false;
        }
    }
}

