/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.rsadapter.spi;

import com.ibm.db2.jcc.DB2Connection;
import com.ibm.db2.jcc.DB2ConnectionPoolDataSource;
import com.ibm.db2.jcc.DB2SystemMonitor;
import com.ibm.ejs.cm.logger.TraceWriter;
import com.ibm.ejs.ras.RasHelper;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.csi.J2EEName;
import com.ibm.websphere.rsadapter.Reassociateable;
import com.ibm.websphere.rsadapter.WSSystemMonitor;
import com.ibm.websphere.security.WSSecurityHelper;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.rsadapter.AdapterUtil;
import com.ibm.ws.rsadapter.exceptions.DataStoreAdapterException;
import com.ibm.ws.rsadapter.jdbc.WSJccConnection;
import com.ibm.ws.rsadapter.jdbc.WSJccSQLJConnection;
import com.ibm.ws.rsadapter.jdbc.WSJdbcUtil;
import com.ibm.ws.rsadapter.spi.InternalDB2DataStoreHelper;
import com.ibm.ws.rsadapter.spi.InternalDataStoreHelper;
import com.ibm.ws.rsadapter.spi.WSRdbDataSource;
import com.ibm.ws.rsadapter.spi.WSRdbManagedConnectionImpl;
import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.threadContext.ComponentMetaDataAccessorImpl;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import javax.resource.ResourceException;
import javax.sql.PooledConnection;
import org.ietf.jgss.GSSCredential;
import sqlj.runtime.ref.DefaultContext;

public class InternalDB2UniversalDataStoreHelper
extends InternalDB2DataStoreHelper {
    private static TraceComponent tc = Tr.register((Class)InternalDB2UniversalDataStoreHelper.class, (String)"RRA", (String)"IBMDataStoreAdapterNLS");
    private static TraceComponent clientInfoTc = Tr.register((String)"WAS.clientinfo", (String)"WAS.clientinfo", (String)"IBMDataStoreAdapterNLS");
    private static TraceComponent clientInfoPlusTc = Tr.register((String)"WAS.clientinfopluslogging", (String)"WAS.clientinfopluslogging", (String)"IBMDataStoreAdapterNLS");
    private static TraceComponent tempTc;
    private int driverType = 0;
    private transient PrintWriter db2UPw;
    private transient String traceFile;
    private static final int DEFAULTTRACELEVEL = 49;
    private transient int configuredTraceLevel = 49;
    private transient Class currClass = InternalDB2UniversalDataStoreHelper.class;

    public void setProperties(Properties properties) throws ResourceException {
        String string;
        super.setProperties(properties);
        this.isRRSTransaction = false;
        this.threadIdentitySupport = "NOTALLOWED";
        this.threadSecurity = false;
        String string2 = null;
        boolean bl = false;
        if (properties != null) {
            string2 = properties.getProperty("driverType");
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("internalDB2UniversalDataStoreHelper.setProperties():  driverType property = " + string2));
            }
            if (string2 != null) {
                this.driverType = new Integer(string2);
                if (this.driverType == 2 || this.driverType == 4) {
                    bl = true;
                }
            }
        }
        if (!bl) {
            throw new ResourceException("Required driverType property was not specifed or is invalid. The driverType property is " + string2);
        }
        if (this.localZOS && this.driverType == 2) {
            string = properties.getProperty("dataSourceClass");
            if (string.equals("com.ibm.db2.jcc.DB2XADataSource")) {
                throw new ResourceException("DB2ZOS_TYPE2_ERROR");
            }
            if (string.equals("com.ibm.db2.jcc.DB2ConnectionPoolDataSource")) {
                this.isRRSTransaction = true;
                this.threadIdentitySupport = "ALLOWED";
                this.threadSecurity = true;
                Tr.info((TraceComponent)tc, (String)"DB2ZOS_CONFIG_INFO");
            }
        }
        if (properties != null) {
            string = properties.getProperty("traceLevel");
            if (string != null && !string.equals("")) {
                this.configuredTraceLevel = Integer.parseInt(string);
                if (db2Tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)db2Tc, (String)"traceLevel is set to ", (Object)new Integer(this.configuredTraceLevel));
                }
            } else if (db2Tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)db2Tc, (String)"traceLevel is not set, using WAS default: TRACE_CONNECTION_CALLS | TRACE_DRIVER_CONFIGURATION | TRACE_CONNECTS");
            }
            this.traceFile = properties.getProperty("traceFile");
        }
        if (this.traceFile != null && !this.traceFile.equals("")) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"DB2 JDBC trace was configured to go to a file, Thus no integration with WAS trace.  File name is: ", (Object)this.traceFile);
            }
            try {
                this.db2UPw = new PrintWriter(new FileOutputStream(this.traceFile), true);
            }
            catch (IOException iOException) {
                Tr.error((TraceComponent)tc, (String)"DB2_FILE_OUTSTREAM_ERROR", (Object)this.traceFile);
            }
        } else {
            this.db2UPw = new PrintWriter((Writer)new TraceWriter(db2Tc), true);
        }
    }

    public void closeDefaultContext(Object object) throws ResourceException {
        try {
            DefaultContext defaultContext = (DefaultContext)object;
            defaultContext.close();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)(this.getClass().getName() + ".closeDefaultContext"), (String)"233", (Object)this);
            throw new DataStoreAdapterException("DSA_ERROR", this.externalHelper.mapException(sQLException), this.getClass());
        }
    }

    public String getCorrelator(WSRdbManagedConnectionImpl wSRdbManagedConnectionImpl) throws SQLException {
        try {
            return ((DB2Connection)wSRdbManagedConnectionImpl.sqlConn).getDB2Correlator();
        }
        catch (NullPointerException nullPointerException) {
            Tr.warning((TraceComponent)tc, (String)"DSA_GENERIC_MSG", (Object)new Object[]{"getDB2Correlator()", nullPointerException, "method not supported on DB2 driver being used"});
            return null;
        }
        catch (NoSuchMethodError noSuchMethodError) {
            Tr.warning((TraceComponent)tc, (String)"DSA_GENERIC_MSG", (Object)new Object[]{"getDB2Correlator()", noSuchMethodError, "method not supported on DB2 driver being used"});
            return null;
        }
        catch (SQLException sQLException) {
            AdapterUtil.mapSQLException(sQLException, wSRdbManagedConnectionImpl);
            Tr.warning((TraceComponent)tc, (String)"DSA_GENERIC_MSG", (Object)new Object[]{"getDB2Correlator()", sQLException, "method not supported on DB2 driver being used"});
            return null;
        }
    }

    public void setEwlmCorrelator(byte[] byArray, WSRdbManagedConnectionImpl wSRdbManagedConnectionImpl) throws ResourceException {
        try {
            if (byArray != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"setEwlmCorrelator: ", (Object)byArray);
                }
                ((DB2Connection)wSRdbManagedConnectionImpl.sqlConn).setDB2eWLMCorrelator(byArray);
            }
        }
        catch (SQLException sQLException) {
            AdapterUtil.mapSQLException(sQLException, wSRdbManagedConnectionImpl);
            Tr.warning((TraceComponent)tc, (String)"DSA_GENERIC_MSG", (Object)new Object[]{"setDB2eWLMCorrelator()", sQLException, "method not supported on DB2 driver being used"});
        }
        catch (NoSuchMethodError noSuchMethodError) {
            Tr.warning((TraceComponent)tc, (String)"DSA_GENERIC_MSG", (Object)new Object[]{"setDB2eWLMCorrelator()", noSuchMethodError, "method not supported on DB2 driver being used"});
        }
        catch (NullPointerException nullPointerException) {
            Tr.warning((TraceComponent)tc, (String)"DSA_GENERIC_MSG", (Object)new Object[]{"setDB2eWLMCorrelator()", nullPointerException, "method not supported on DB2 driver being used"});
        }
    }

    public Reassociateable createJDBCConnectionWrapper(WSRdbManagedConnectionImpl wSRdbManagedConnectionImpl) throws ResourceException {
        return new WSJccSQLJConnection(wSRdbManagedConnectionImpl, wSRdbManagedConnectionImpl.sqlConn, WSRdbManagedConnectionImpl.key, wSRdbManagedConnectionImpl.threadID);
    }

    public boolean shouldTraceBeEnabled(WSRdbManagedConnectionImpl wSRdbManagedConnectionImpl) {
        return db2Tc.isDebugEnabled() && !wSRdbManagedConnectionImpl.loggingEnabled;
    }

    public boolean shouldTraceBeDisabled(WSRdbManagedConnectionImpl wSRdbManagedConnectionImpl) {
        return !db2Tc.isDebugEnabled() && wSRdbManagedConnectionImpl.loggingEnabled;
    }

    public void disableJdbcLogging(WSRdbManagedConnectionImpl wSRdbManagedConnectionImpl) throws ResourceException {
        Tr.debug((TraceComponent)db2Tc, (String)"Disabling logging on connection: ", (Object)wSRdbManagedConnectionImpl.sqlConn);
        try {
            ((DB2Connection)wSRdbManagedConnectionImpl.sqlConn).setJCCLogWriter(null);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.spi.InternalDB2UniversalDataStoreHelper.disableJdbcLogging", (String)"402", (Object)this);
            throw AdapterUtil.translateSQLException(sQLException, wSRdbManagedConnectionImpl, true, this.currClass);
        }
        wSRdbManagedConnectionImpl.loggingEnabled = false;
    }

    public void enableJdbcLogging(WSRdbManagedConnectionImpl wSRdbManagedConnectionImpl) throws ResourceException {
        PrintWriter printWriter = this.getPrintWriter();
        Tr.debug((TraceComponent)db2Tc, (String)"Setting printWriter on connection and with level: ", (Object)new Object[]{printWriter, wSRdbManagedConnectionImpl.sqlConn, new Integer(this.configuredTraceLevel)});
        try {
            ((DB2Connection)wSRdbManagedConnectionImpl.sqlConn).setJCCLogWriter(printWriter, this.configuredTraceLevel);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.spi.InternalDB2UniversalDataStoreHelper.enableJdbcLogging", (String)"419", (Object)this);
            throw AdapterUtil.translateSQLException(sQLException, wSRdbManagedConnectionImpl, true, this.currClass);
        }
        wSRdbManagedConnectionImpl.loggingEnabled = true;
    }

    public PrintWriter getPrintWriter() throws ResourceException {
        if (this.db2UPw == null) {
            this.db2UPw = this.externalHelper.getPrintWriter();
            if (this.db2UPw != null) {
                Tr.debug((TraceComponent)db2Tc, (String)"user supplied own printWriter in the datastore helper, will use provided one", (Object)this.db2UPw);
            } else {
                this.db2UPw = new PrintWriter((Writer)new TraceWriter(db2Tc), true);
            }
        }
        Tr.debug((TraceComponent)db2Tc, (String)"returning", (Object)this.db2UPw);
        return this.db2UPw;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setClientInformation(Properties properties, WSRdbManagedConnectionImpl wSRdbManagedConnectionImpl, boolean bl) throws SQLException {
        String string = " ";
        String string2 = " ";
        String string3 = " ";
        String string4 = " ";
        if (tc.isDebugEnabled() || clientInfoPlusTc.isDebugEnabled()) {
            tempTc = clientInfoPlusTc.isDebugEnabled() ? clientInfoPlusTc : tc;
            Tr.debug((TraceComponent)tempTc, (String)"setClientInformation(Properties props,WSRdbManagedConnectionImpl mc, boolean explicitCall) with sqlConn", (Object)new Object[]{properties, wSRdbManagedConnectionImpl, new Boolean(bl), wSRdbManagedConnectionImpl.sqlConn});
        }
        if (bl) {
            string2 = properties.getProperty("CLIENT_ACCOUNTING_INFO");
            if (string2 == null || string2.equals("")) {
                string2 = " ";
            }
            if ((string3 = properties.getProperty("CLIENT_LOCATION")) == null || string3.equals("")) {
                string3 = " ";
            }
            if ((string4 = properties.getProperty("CLIENT_ID")) == null || string4.equals("")) {
                string4 = " ";
            }
            if ((string = properties.getProperty("CLIENT_APPLICATION_NAME")) == null || string.equals("")) {
                string = " ";
            }
            wSRdbManagedConnectionImpl.clientInfoExplicitlySet = true;
        }
        if (clientInfoTc.isDebugEnabled() || clientInfoPlusTc.isDebugEnabled()) {
            if (string.equals(" ")) {
                try {
                    J2EEName j2EEName = ComponentMetaDataAccessorImpl.getComponentMetaDataAccessor().getComponentMetaData().getJ2EEName();
                    string = j2EEName == null ? "NON-J2EE application" : j2EEName.getApplication();
                }
                catch (NullPointerException nullPointerException) {
                    string = "NON-J2EE application";
                }
            }
            if (WSSecurityHelper.isServerSecurityEnabled()) {
                if (string4 == " ") {
                    string4 = WSSecurityHelper.getFirstCaller();
                }
                if (string3.equals(" ")) {
                    string3 = WSSecurityHelper.getFirstServer();
                }
            }
            StringBuffer stringBuffer = new StringBuffer(100);
            stringBuffer.append(RasHelper.getThreadId());
            stringBuffer.append('_');
            stringBuffer.append(wSRdbManagedConnectionImpl.toString());
            if (!string2.equals(" ")) {
                stringBuffer.append('_');
                stringBuffer.append(string2);
            }
            string2 = stringBuffer.toString();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"The accountInfo new String is:", (Object)string2);
            }
            wSRdbManagedConnectionImpl.clientInfoImplicitlySet = true;
        }
        if (!wSRdbManagedConnectionImpl.clientInfoExplicitlySet) {
            if (!wSRdbManagedConnectionImpl.clientInfoImplicitlySet) return;
        }
        wSRdbManagedConnectionImpl.holdCurrentClientInfo(string4, string3, string, string2);
        DB2Connection dB2Connection = (DB2Connection)wSRdbManagedConnectionImpl.sqlConn;
        try {
            try {
                if (wSRdbManagedConnectionImpl.pmi != null) {
                    wSRdbManagedConnectionImpl.pmi.jdbcOperationStarted();
                    dB2Connection.setDB2ClientWorkstation(string3);
                    dB2Connection.setDB2ClientUser(string4);
                    dB2Connection.setDB2ClientApplicationInformation(string);
                    dB2Connection.setDB2ClientAccountingInformation(string2);
                }
                dB2Connection.setDB2ClientWorkstation(string3);
                dB2Connection.setDB2ClientUser(string4);
                dB2Connection.setDB2ClientApplicationInformation(string);
                dB2Connection.setDB2ClientAccountingInformation(string2);
            }
            catch (SQLException sQLException) {
                FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.spi.InternalDB2UniversalDataStoreHelper.setClientInformation", (String)"567", (Object)this);
                if (!tc.isDebugEnabled()) throw AdapterUtil.mapSQLException(sQLException, wSRdbManagedConnectionImpl);
                Tr.debug((TraceComponent)tc, (String)"setClientInformation - Exception", (Object)sQLException);
                throw AdapterUtil.mapSQLException(sQLException, wSRdbManagedConnectionImpl);
            }
            Object var12_13 = null;
            if (wSRdbManagedConnectionImpl.pmi == null) return;
        }
        catch (Throwable throwable) {
            Object var12_14 = null;
            if (wSRdbManagedConnectionImpl.pmi == null) throw throwable;
            wSRdbManagedConnectionImpl.pmi.jdbcOperationCompleted();
            throw throwable;
        }
        wSRdbManagedConnectionImpl.pmi.jdbcOperationCompleted();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setClientInformationArray(String[] stringArray, WSRdbManagedConnectionImpl wSRdbManagedConnectionImpl, boolean bl) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"setClientInformationArray (String[] clientInfoArray, WSRdbManagedConnectionImpl mc, boolean explicitCall)", (Object)new Object[]{stringArray, wSRdbManagedConnectionImpl, new Boolean(bl)});
        }
        if (bl) {
            wSRdbManagedConnectionImpl.clientInfoExplicitlySet = true;
        } else {
            wSRdbManagedConnectionImpl.clientInfoImplicitlySet = true;
        }
        DB2Connection dB2Connection = (DB2Connection)wSRdbManagedConnectionImpl.sqlConn;
        try {
            try {
                if (wSRdbManagedConnectionImpl.pmi != null) {
                    wSRdbManagedConnectionImpl.pmi.jdbcOperationStarted();
                    dB2Connection.setDB2ClientUser(stringArray[0]);
                    dB2Connection.setDB2ClientWorkstation(stringArray[1]);
                    dB2Connection.setDB2ClientApplicationInformation(stringArray[2]);
                    dB2Connection.setDB2ClientAccountingInformation(stringArray[3]);
                }
                dB2Connection.setDB2ClientUser(stringArray[0]);
                dB2Connection.setDB2ClientWorkstation(stringArray[1]);
                dB2Connection.setDB2ClientApplicationInformation(stringArray[2]);
                dB2Connection.setDB2ClientAccountingInformation(stringArray[3]);
            }
            catch (SQLException sQLException) {
                FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.spi.InternalDB2UniversalDataStoreHelper.setClientInformationArray", (String)"611", (Object)this);
                if (!tc.isDebugEnabled()) throw AdapterUtil.mapSQLException(sQLException, wSRdbManagedConnectionImpl);
                Tr.debug((TraceComponent)tc, (String)"setClientInformationArray - Exception", (Object)sQLException);
                throw AdapterUtil.mapSQLException(sQLException, wSRdbManagedConnectionImpl);
            }
            Object var7_5 = null;
            if (wSRdbManagedConnectionImpl.pmi == null) return;
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            if (wSRdbManagedConnectionImpl.pmi == null) throw throwable;
            wSRdbManagedConnectionImpl.pmi.jdbcOperationCompleted();
            throw throwable;
        }
        wSRdbManagedConnectionImpl.pmi.jdbcOperationCompleted();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void resetClientInformation(WSRdbManagedConnectionImpl wSRdbManagedConnectionImpl) throws SQLException {
        if (!wSRdbManagedConnectionImpl.clientInfoExplicitlySet) {
            if (!wSRdbManagedConnectionImpl.clientInfoImplicitlySet) return;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"resetClientInformation is called on: ", (Object)wSRdbManagedConnectionImpl);
        }
        DB2Connection dB2Connection = (DB2Connection)wSRdbManagedConnectionImpl.sqlConn;
        try {
            try {
                if (wSRdbManagedConnectionImpl.pmi != null) {
                    wSRdbManagedConnectionImpl.pmi.jdbcOperationStarted();
                    dB2Connection.setDB2ClientApplicationInformation(" ");
                    dB2Connection.setDB2ClientAccountingInformation(" ");
                    dB2Connection.setDB2ClientWorkstation(" ");
                    dB2Connection.setDB2ClientUser(" ");
                } else {
                    dB2Connection.setDB2ClientApplicationInformation(" ");
                    dB2Connection.setDB2ClientAccountingInformation(" ");
                    dB2Connection.setDB2ClientWorkstation(" ");
                    dB2Connection.setDB2ClientUser(" ");
                }
                wSRdbManagedConnectionImpl.clientInfoExplicitlySet = false;
                wSRdbManagedConnectionImpl.clientInfoImplicitlySet = false;
            }
            catch (SQLException sQLException) {
                FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.spi.InternalDB2UniversalDataStoreHelper.resetClientInformation", (String)"677", (Object)this);
                if (!tc.isDebugEnabled()) throw AdapterUtil.mapSQLException(sQLException, wSRdbManagedConnectionImpl);
                Tr.debug((TraceComponent)tc, (String)"resetClientInformation -- Exception", (Object)sQLException);
                throw AdapterUtil.mapSQLException(sQLException, wSRdbManagedConnectionImpl);
            }
            Object var5_3 = null;
            if (wSRdbManagedConnectionImpl.pmi == null) return;
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            if (wSRdbManagedConnectionImpl.pmi == null) throw throwable;
            wSRdbManagedConnectionImpl.pmi.jdbcOperationCompleted();
            throw throwable;
        }
        wSRdbManagedConnectionImpl.pmi.jdbcOperationCompleted();
    }

    public boolean resetConnection(WSRdbManagedConnectionImpl wSRdbManagedConnectionImpl) throws SQLException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"resetConnection:", (Object)wSRdbManagedConnectionImpl.sqlConn);
        }
        boolean bl = false;
        try {
            ((DB2Connection)wSRdbManagedConnectionImpl.sqlConn).resetDB2Connection();
            bl = true;
        }
        catch (SQLException sQLException) {
            AdapterUtil.mapSQLException(sQLException, wSRdbManagedConnectionImpl);
            Tr.warning((TraceComponent)tc, (String)"DSA_GENERIC_MSG", (Object)new Object[]{"resetDB2Connection()", sQLException, "method not supported on DB2 driver being used"});
        }
        catch (NoSuchMethodError noSuchMethodError) {
            bl = false;
            Tr.warning((TraceComponent)tc, (String)"DSA_GENERIC_MSG", (Object)new Object[]{"resetConnection()", noSuchMethodError, "method not supported on DB2 driver being used"});
        }
        catch (NullPointerException nullPointerException) {
            bl = false;
            Tr.warning((TraceComponent)tc, (String)"DSA_GENERIC_MSG", (Object)new Object[]{"resetConnection()", nullPointerException, "method not supported on DB2 driver being used"});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"resetConnection: ", (Object)new Boolean(bl));
        }
        return bl;
    }

    public PooledConnection getPooledConnection(final GSSCredential gSSCredential, WSRdbDataSource wSRdbDataSource, int n) throws ResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getPooledConnection (GSSCredential)");
        }
        PooledConnection pooledConnection = null;
        if (wSRdbDataSource.isJTAEnabled()) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"XADatasource is used which doesn't support kerberos getPooledConnection(GSSCredential)");
            }
            return null;
        }
        final Object object = n == 0 ? wSRdbDataSource.dataSource : wSRdbDataSource.dcm.getDataSource(n);
        try {
            pooledConnection = (PooledConnection)AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return ((DB2ConnectionPoolDataSource)object).getPooledConnection((Object)gSSCredential);
                }
            });
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getPooledConnection() returning: ", (Object)AdapterUtil.toString(pooledConnection));
            }
            return pooledConnection;
        }
        catch (PrivilegedActionException privilegedActionException) {
            FFDCFilter.processException((Throwable)privilegedActionException.getException(), (String)"com.ibm.ws.rsadapter.InternalDB2UniversalDataStoreHelper.getPooledConnection", (String)"628");
            DataStoreAdapterException dataStoreAdapterException = AdapterUtil.createDataStoreAdapterException("JAVAX_CONN_ERR", "PooledConnection", privilegedActionException.getException(), InternalDB2UniversalDataStoreHelper.class);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getPooledConnection", (Object)"Exception");
            }
            throw dataStoreAdapterException;
        }
        catch (NoSuchMethodError noSuchMethodError) {
            Tr.info((TraceComponent)tc, (String)"KERBEROS_METHOD_NOT_SUPPORTED_INFO");
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getPooledConnection() returning: ", null);
            }
            return null;
        }
    }

    public WSSystemMonitor getSystemMonitor(WSRdbManagedConnectionImpl wSRdbManagedConnectionImpl) throws SQLException {
        try {
            DB2SystemMonitor dB2SystemMonitor = ((DB2Connection)wSRdbManagedConnectionImpl.sqlConn).getDB2SystemMonitor();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"getSystemMonitor: returning: ", (Object)dB2SystemMonitor);
            }
            if (dB2SystemMonitor == null) {
                return null;
            }
            return new WSSystemMonitor((Object)dB2SystemMonitor, (InternalDataStoreHelper)this, wSRdbManagedConnectionImpl);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.spi.InternalDB2UniversalDataStoreHelper.getSystemMonitor", (String)"674", (Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"getSystemMonitor -Exception", (Object)sQLException);
            }
            throw AdapterUtil.mapSQLException(sQLException, wSRdbManagedConnectionImpl);
        }
    }

    public void enableSystemMonitor(Object object, boolean bl, WSRdbManagedConnectionImpl wSRdbManagedConnectionImpl) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"enableSystemMonitor");
        }
        try {
            ((DB2SystemMonitor)object).enable(bl);
        }
        catch (SQLException sQLException) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"enableSystemMonitor -Exception", (Object)sQLException);
            }
            throw AdapterUtil.mapSQLException(sQLException, wSRdbManagedConnectionImpl);
        }
    }

    public void startSystemMonitor(Object object, int n, WSRdbManagedConnectionImpl wSRdbManagedConnectionImpl) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"startSystemMonitor", (Object)new Integer(n));
        }
        try {
            ((DB2SystemMonitor)object).start(n == 1 ? 2 : 1);
        }
        catch (SQLException sQLException) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"startSystemMonitor -Exception", (Object)sQLException);
            }
            throw AdapterUtil.mapSQLException(sQLException, wSRdbManagedConnectionImpl);
        }
    }

    public void stopSystemMonitor(Object object, WSRdbManagedConnectionImpl wSRdbManagedConnectionImpl) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"stopSystemMonitor");
        }
        try {
            ((DB2SystemMonitor)object).stop();
        }
        catch (SQLException sQLException) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"stopSystemMonitor -Exception", (Object)sQLException);
            }
            throw AdapterUtil.mapSQLException(sQLException, wSRdbManagedConnectionImpl);
        }
    }

    public long getServerTimeMicros(Object object, WSRdbManagedConnectionImpl wSRdbManagedConnectionImpl) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"getServerTimeMicros");
        }
        try {
            return ((DB2SystemMonitor)object).getServerTimeMicros();
        }
        catch (SQLException sQLException) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"getServerTimeMicros -Exception", (Object)sQLException);
            }
            throw AdapterUtil.mapSQLException(sQLException, wSRdbManagedConnectionImpl);
        }
    }

    public long getNetworkIOTimeMicros(Object object, WSRdbManagedConnectionImpl wSRdbManagedConnectionImpl) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"getNetworkIOTimeMicros");
        }
        try {
            return ((DB2SystemMonitor)object).getNetworkIOTimeMicros();
        }
        catch (SQLException sQLException) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"getNetworkIOTimeMicros -Exception", (Object)sQLException);
            }
            throw AdapterUtil.mapSQLException(sQLException, wSRdbManagedConnectionImpl);
        }
    }

    public long getCoreDriverTimeMicros(Object object, WSRdbManagedConnectionImpl wSRdbManagedConnectionImpl) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"getCoreDriverTimeMicros");
        }
        try {
            return ((DB2SystemMonitor)object).getCoreDriverTimeMicros();
        }
        catch (SQLException sQLException) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"getCoreDriverTimeMicros -Exception", (Object)sQLException);
            }
            throw AdapterUtil.mapSQLException(sQLException, wSRdbManagedConnectionImpl);
        }
    }

    public long getApplicationTimeMillis(Object object, WSRdbManagedConnectionImpl wSRdbManagedConnectionImpl) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"getApplicationTimeMillis");
        }
        try {
            return ((DB2SystemMonitor)object).getApplicationTimeMillis();
        }
        catch (SQLException sQLException) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"getApplicationTimeMillis -Exception", (Object)sQLException);
            }
            throw AdapterUtil.mapSQLException(sQLException, wSRdbManagedConnectionImpl);
        }
    }

    public boolean isIsolationLevelSwitchingSupport() {
        return true;
    }

    public Object getSQLJContext(WSRdbManagedConnectionImpl wSRdbManagedConnectionImpl) throws SQLException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getSQLJContext", (Object)this);
        }
        DefaultContext defaultContext = null;
        try {
            if (wSRdbManagedConnectionImpl.cachedConnection == null) {
                wSRdbManagedConnectionImpl.cachedConnection = (WSJccConnection)this.createJDBCConnectionWrapper(wSRdbManagedConnectionImpl);
                ((WSJccConnection)((Object)wSRdbManagedConnectionImpl.cachedConnection)).initialize(wSRdbManagedConnectionImpl.mcf.connMgr, WSRdbManagedConnectionImpl.key);
                ((WSJccConnection)((Object)wSRdbManagedConnectionImpl.cachedConnection)).setCurrentAutoCommit(wSRdbManagedConnectionImpl.currentAutoCommit);
            }
        }
        catch (ResourceException resourceException) {
            FFDCFilter.processException((Throwable)resourceException, (String)"com.ibm.ws.rsadapter.spi.InternalDB2UniversalDataStoreHelper.getSQLJContext", (String)"550", (Object)this);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getSQLJContext - failed trying to create SQLJ ConnectionContext, throwing exception");
            }
            throw AdapterUtil.toSQLException(resourceException);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.spi.InternalDB2UniversalDataStoreHelper.getSQLJContext", (String)"1009", (Object)this);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getSQLJContext - failed trying to create SQLJ ConnectionContext, throwing exception");
            }
            throw WSJdbcUtil.mapException((WSJccConnection)((Object)wSRdbManagedConnectionImpl.cachedConnection), sQLException);
        }
        try {
            defaultContext = new DefaultContext(wSRdbManagedConnectionImpl.cachedConnection);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.spi.InternalDB2UniversalDataStoreHelper.getSQLJContext", (String)"549", (Object)this);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getSQLJContext - failed trying to create SQLJ ConnectionContext, throwing exception");
            }
            throw WSJdbcUtil.mapException((WSJccConnection)((Object)wSRdbManagedConnectionImpl.cachedConnection), sQLException);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getSQLJContext", (Object)defaultContext);
        }
        return defaultContext;
    }

    public Object getDefaultContext(Connection connection) throws SQLException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getDefaultContext", (Object)this);
        }
        DefaultContext defaultContext = null;
        try {
            defaultContext = new DefaultContext(connection);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.spi.InternalDB2UniversalDataStoreHelper.getDefaultContext", (String)"549", (Object)this);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getDefaultContext - failed trying to create Default ConnectionContext, throwing exception");
            }
            throw sQLException;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getDefaultContext", (Object)defaultContext);
        }
        return defaultContext;
    }

    public void setCurrentAutoCommit(Connection connection, boolean bl) {
        WSJccConnection wSJccConnection = (WSJccConnection)((Object)connection);
        wSJccConnection.setCurrentAutoCommit(bl);
    }

    public void setCurrentTransactionIsolation(Connection connection, int n) {
        WSJccConnection wSJccConnection = (WSJccConnection)((Object)connection);
        wSJccConnection.setCurrentTransactionIsolation(n);
    }

    public void processLastHandleClosed(Connection connection, boolean bl, boolean bl2) throws SQLException {
    }

    public void doConnectionCleanupOnWrapper(WSRdbManagedConnectionImpl wSRdbManagedConnectionImpl) throws SQLException {
        if (this.localZOS && this.driverType == 2) {
            this.resetUOWBoundary(wSRdbManagedConnectionImpl.sqlConn);
        }
    }

    private void resetUOWBoundary(Connection connection) throws SQLException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"resetUOWBoundary");
        }
        if (!private_disableResetUOW) {
            boolean bl = true;
            if (this.localZOS && this.driverType == 2 && supportsUOWDetection) {
                try {
                    DB2Connection dB2Connection = (DB2Connection)connection;
                    if (!dB2Connection.isInDB2UnitOfWork()) {
                        bl = false;
                    }
                }
                catch (NoSuchMethodError noSuchMethodError) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"JCC Driver version does not support isInUnitOfWork method");
                    }
                    supportsUOWDetection = false;
                }
            }
            if (bl) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Issuing rollback to reset UOW boundary");
                }
                connection.rollback();
            } else if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Connection already on UOW boundary; skip rollback");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"resetUOWBoundary");
        }
    }

    public Properties validateConfiguration(Properties properties, String string) {
        String string2;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"validateConfiguration", (Object)properties);
        }
        if (string.equals("com.ibm.db2.jcc.DB2XADataSource") && (string2 = (String)properties.setProperty("retrieveMessagesFromServerOnGetMessage", "false")) != null && Boolean.valueOf(string2).booleanValue()) {
            Tr.info((TraceComponent)tc, (String)"DB2_GETMSG_CONFIG_INFO_DSRA7021");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"validateConfiguration", (Object)properties);
        }
        return properties;
    }
}

