/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.rsadapter.spi;

import com.ibm.db2.jcc.DB2Connection;
import com.ibm.ejs.cm.logger.TraceWriter;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.rsadapter.AdapterUtil;
import com.ibm.ws.rsadapter.spi.InternalCloudscapeDataStoreHelper;
import com.ibm.ws.rsadapter.spi.WSRdbManagedConnectionImpl;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.sql.SQLException;
import java.util.Properties;
import javax.resource.ResourceException;

public class InternalCloudscapeNetworkServerDataStoreHelper
extends InternalCloudscapeDataStoreHelper {
    private transient TraceComponent tc = Tr.register((Class)InternalCloudscapeNetworkServerDataStoreHelper.class, (String)"RRA", (String)"IBMDataStoreAdapterNLS");
    private static final Class currClass = InternalCloudscapeNetworkServerDataStoreHelper.class;
    private transient PrintWriter db2jNSPw;
    private transient String traceFile;
    private transient int configuredTraceLevel = 49;

    public void setProperties(Properties properties) throws ResourceException {
        super.setProperties(properties);
        if (properties != null) {
            String string = properties.getProperty("traceLevel");
            if (string != null && !string.equals("")) {
                this.configuredTraceLevel = Integer.parseInt(string);
                if (db2jTc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)db2jTc, (String)"traceLevel is set to ", (Object)new Integer(this.configuredTraceLevel));
                }
            } else if (db2jTc.isDebugEnabled()) {
                Tr.debug((TraceComponent)db2jTc, (String)"traceLevel is not set, using WAS default: TRACE_CONNECTION_CALLS | TRACE_DRIVER_CONFIGURATION | TRACE_CONNECTS");
            }
            this.traceFile = properties.getProperty("traceFile");
        }
        if (this.traceFile != null && !this.traceFile.equals("")) {
            if (this.tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)this.tc, (String)"Cloudscape network server JDBC trace was configured to go to a file, Thus no integration with WAS trace.  File name is: ", (Object)this.traceFile);
            }
            try {
                this.db2jNSPw = new PrintWriter(new FileOutputStream(this.traceFile), true);
            }
            catch (IOException iOException) {
                Tr.error((TraceComponent)this.tc, (String)"DB2_FILE_OUTSTREAM_ERROR", (Object)this.traceFile);
            }
        } else {
            this.db2jNSPw = new PrintWriter((Writer)new TraceWriter(db2jTc), true);
        }
    }

    public boolean shouldTraceBeEnabled(WSRdbManagedConnectionImpl wSRdbManagedConnectionImpl) {
        return db2jTc.isDebugEnabled() && !wSRdbManagedConnectionImpl.loggingEnabled;
    }

    public boolean shouldTraceBeDisabled(WSRdbManagedConnectionImpl wSRdbManagedConnectionImpl) {
        return !db2jTc.isDebugEnabled() && wSRdbManagedConnectionImpl.loggingEnabled;
    }

    public void disableJdbcLogging(WSRdbManagedConnectionImpl wSRdbManagedConnectionImpl) throws ResourceException {
        Tr.debug((TraceComponent)db2jTc, (String)"Disabling logging on connection: ", (Object)wSRdbManagedConnectionImpl.sqlConn);
        try {
            ((DB2Connection)wSRdbManagedConnectionImpl.sqlConn).setJCCLogWriter(null);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.spi.InternalCloudscapeNetworkServerDataStoreHelper.disableJdbcLogging", (String)"159", (Object)this);
            throw AdapterUtil.translateSQLException(sQLException, wSRdbManagedConnectionImpl, true, currClass);
        }
        wSRdbManagedConnectionImpl.loggingEnabled = false;
    }

    public void enableJdbcLogging(WSRdbManagedConnectionImpl wSRdbManagedConnectionImpl) throws ResourceException {
        PrintWriter printWriter = this.getPrintWriter();
        Tr.debug((TraceComponent)db2jTc, (String)"Enabling jdbc logging: Setting printWriter on connection and with level: ", (Object)new Object[]{printWriter, wSRdbManagedConnectionImpl.sqlConn, new Integer(this.configuredTraceLevel)});
        try {
            ((DB2Connection)wSRdbManagedConnectionImpl.sqlConn).setJCCLogWriter(printWriter, this.configuredTraceLevel);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.spi.InternalCloudscapeNetworkServerDataStoreHelper.enableJdbcLogging", (String)"184", (Object)this);
            throw AdapterUtil.translateSQLException(sQLException, wSRdbManagedConnectionImpl, true, currClass);
        }
        wSRdbManagedConnectionImpl.loggingEnabled = true;
    }

    public PrintWriter getPrintWriter() throws ResourceException {
        if (this.db2jNSPw == null) {
            this.db2jNSPw = this.externalHelper.getPrintWriter();
            if (this.db2jNSPw != null) {
                Tr.debug((TraceComponent)db2jTc, (String)"user supplied own printWriter in the datastore helper, will use provided one", (Object)this.db2jNSPw);
            } else {
                this.db2jNSPw = new PrintWriter((Writer)new TraceWriter(db2jTc), true);
            }
        }
        Tr.debug((TraceComponent)db2jTc, (String)"returning", (Object)this.db2jNSPw);
        return this.db2jNSPw;
    }

    public Properties validateConfiguration(Properties properties, String string) {
        String string2;
        if (this.tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)this.tc, (String)"validateConfiguration", (Object)properties);
        }
        if ((string2 = (String)properties.setProperty("driverType", "4")) != null && Integer.parseInt(string2) != 4) {
            Tr.warning((TraceComponent)this.tc, (String)"CLOUDSCAPE_CONFIG_WARNING");
        }
        if (this.tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)this.tc, (String)"validateConfiguration", (Object)properties);
        }
        return properties;
    }
}

