/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.rsadapter.jdbc;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.ce.cm.ObjectClosedException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.rsadapter.AdapterUtil;
import com.ibm.ws.rsadapter.FFDCLogger;
import com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData;
import com.ibm.ws.rsadapter.jdbc.WSJdbcObject;
import com.ibm.ws.rsadapter.jdbc.WSJdbcUtil;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;

public class WSJdbcResultSet
extends WSJdbcObject
implements ResultSet {
    private static final TraceComponent tc = Tr.register((Class)WSJdbcResultSet.class, (String)"RRA", (String)"IBMDataStoreAdapterNLS");
    ResultSet rsetImpl;

    WSJdbcResultSet() {
    }

    WSJdbcResultSet(ResultSet resultSet, WSJdbcObject wSJdbcObject) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"<init>", (Object)new Object[]{AdapterUtil.toString(resultSet), wSJdbcObject});
        }
        this.rsetImpl = resultSet;
        this.parentWrapper = wSJdbcObject;
        this.pmi = this.parentWrapper.pmi;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"<init>", (Object)this);
        }
    }

    public boolean absolute(int n) throws SQLException {
        try {
            return this.rsetImpl.absolute(n);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.absolute", (String)"93", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void afterLast() throws SQLException {
        try {
            this.rsetImpl.afterLast();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.afterLast", (String)"118", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void beforeFirst() throws SQLException {
        try {
            this.rsetImpl.beforeFirst();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.beforeFirst", (String)"144", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelRowUpdates() throws SQLException {
        block8: {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"cancelRowUpdates", (Object)this);
            }
            try {
                this.parentWrapper.parentWrapper.beginTransactionIfNecessary();
                if (this.pmi == null) {
                    this.rsetImpl.cancelRowUpdates();
                    break block8;
                }
                try {
                    this.pmi.jdbcOperationStarted();
                    this.rsetImpl.cancelRowUpdates();
                }
                finally {
                    this.pmi.jdbcOperationCompleted();
                }
            }
            catch (SQLException sQLException) {
                FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.cancelRowUpdates", (String)"183", (Object)this);
                throw WSJdbcUtil.mapException(this, sQLException);
            }
            catch (NullPointerException nullPointerException) {
                throw this.runtimeXIfNotClosed(nullPointerException);
            }
        }
    }

    public void clearWarnings() throws SQLException {
        try {
            this.rsetImpl.clearWarnings();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.clearWarnings", (String)"208", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    SQLException closeWrapper(boolean bl) {
        if (this.parentWrapper.childWrapper == this) {
            this.parentWrapper.childWrapper = null;
        } else {
            this.parentWrapper.childWrappers.remove(this);
        }
        if (bl) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"closeWrapper skipping close of ResultSet implementation object");
            }
        } else {
            try {
                this.rsetImpl.close();
            }
            catch (SQLException sQLException) {
                FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.closeWrapper", (String)"246", (Object)this);
                this.rsetImpl = null;
                return WSJdbcUtil.mapException(this, sQLException);
            }
        }
        this.rsetImpl = null;
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteRow() throws SQLException {
        block8: {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"deleteRow", (Object)this);
            }
            try {
                this.parentWrapper.parentWrapper.beginTransactionIfNecessary();
                if (this.pmi == null) {
                    this.rsetImpl.deleteRow();
                    break block8;
                }
                try {
                    this.pmi.jdbcOperationStarted();
                    this.rsetImpl.deleteRow();
                }
                finally {
                    this.pmi.jdbcOperationCompleted();
                }
            }
            catch (SQLException sQLException) {
                FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.deleteRow", (String)"355", (Object)this);
                throw WSJdbcUtil.mapException(this, sQLException);
            }
            catch (NullPointerException nullPointerException) {
                throw this.runtimeXIfNotClosed(nullPointerException);
            }
        }
    }

    public int findColumn(String string) throws SQLException {
        try {
            return this.rsetImpl.findColumn(string);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.findColumn", (String)"384", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public boolean first() throws SQLException {
        try {
            return this.rsetImpl.first();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.first", (String)"411", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public Array getArray(int n) throws SQLException {
        try {
            return this.rsetImpl.getArray(n);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.getArray", (String)"438", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public Array getArray(String string) throws SQLException {
        try {
            return this.rsetImpl.getArray(string);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.getArray", (String)"465", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public InputStream getAsciiStream(int n) throws SQLException {
        try {
            return this.rsetImpl.getAsciiStream(n);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.getAsciiStream", (String)"501", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public InputStream getAsciiStream(String string) throws SQLException {
        try {
            return this.rsetImpl.getAsciiStream(string);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.getAsciiStream", (String)"537", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public BigDecimal getBigDecimal(int n) throws SQLException {
        try {
            return this.rsetImpl.getBigDecimal(n);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.getBigDecimal", (String)"566", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public BigDecimal getBigDecimal(int n, int n2) throws SQLException {
        try {
            return this.rsetImpl.getBigDecimal(n, n2);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.getBigDecimal", (String)"596", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public BigDecimal getBigDecimal(String string) throws SQLException {
        try {
            return this.rsetImpl.getBigDecimal(string);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.getBigDecimal", (String)"625", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public BigDecimal getBigDecimal(String string, int n) throws SQLException {
        try {
            return this.rsetImpl.getBigDecimal(string, n);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.getBigDecimal", (String)"656", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public InputStream getBinaryStream(int n) throws SQLException {
        try {
            return this.rsetImpl.getBinaryStream(n);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.getBinaryStream", (String)"691", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public InputStream getBinaryStream(String string) throws SQLException {
        try {
            return this.rsetImpl.getBinaryStream(string);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.getBinaryStream", (String)"727", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public Blob getBlob(int n) throws SQLException {
        try {
            return this.rsetImpl.getBlob(n);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.getBlob", (String)"754", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public boolean getBoolean(int n) throws SQLException {
        try {
            return this.rsetImpl.getBoolean(n);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.getBoolean", (String)"784", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public boolean getBoolean(String string) throws SQLException {
        try {
            return this.rsetImpl.getBoolean(string);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.getBoolean", (String)"813", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public byte getByte(int n) throws SQLException {
        try {
            return this.rsetImpl.getByte(n);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.getByte", (String)"842", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public byte getByte(String string) throws SQLException {
        try {
            return this.rsetImpl.getByte(string);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.getByte", (String)"871", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public byte[] getBytes(int n) throws SQLException {
        try {
            return this.rsetImpl.getBytes(n);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.getBytes", (String)"901", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public byte[] getBytes(String string) throws SQLException {
        try {
            return this.rsetImpl.getBytes(string);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.getBytes", (String)"931", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public Blob getBlob(String string) throws SQLException {
        try {
            return this.rsetImpl.getBlob(string);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.getBlob", (String)"958", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public Reader getCharacterStream(int n) throws SQLException {
        try {
            return this.rsetImpl.getCharacterStream(n);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.getCharacterStream", (String)"983", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public Reader getCharacterStream(String string) throws SQLException {
        try {
            return this.rsetImpl.getCharacterStream(string);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.getCharacterStream", (String)"1010", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public Clob getClob(int n) throws SQLException {
        try {
            return this.rsetImpl.getClob(n);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.getClob", (String)"1037", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public Clob getClob(String string) throws SQLException {
        try {
            return this.rsetImpl.getClob(string);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.getClob", (String)"1064", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public int getConcurrency() throws SQLException {
        try {
            return this.rsetImpl.getConcurrency();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.getConcurrency", (String)"1092", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    final WSJdbcObject getConnectionWrapper() {
        return this.parentWrapper.parentWrapper;
    }

    public String getCursorName() throws SQLException {
        try {
            return this.rsetImpl.getCursorName();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.getCursorName", (String)"1129", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public Date getDate(int n) throws SQLException {
        try {
            return this.rsetImpl.getDate(n);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.getDate", (String)"1158", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public Date getDate(int n, Calendar calendar) throws SQLException {
        try {
            return this.rsetImpl.getDate(n, calendar);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.getDate", (String)"1190", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public Date getDate(String string) throws SQLException {
        try {
            return this.rsetImpl.getDate(string);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.getDate", (String)"1219", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public Date getDate(String string, Calendar calendar) throws SQLException {
        try {
            return this.rsetImpl.getDate(string, calendar);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.getDate", (String)"1251", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public double getDouble(int n) throws SQLException {
        try {
            return this.rsetImpl.getDouble(n);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.getDouble", (String)"1280", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public double getDouble(String string) throws SQLException {
        try {
            return this.rsetImpl.getDouble(string);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.getDouble", (String)"1309", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public int getFetchDirection() throws SQLException {
        try {
            return this.rsetImpl.getFetchDirection();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.getFetchDirection", (String)"1336", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public int getFetchSize() throws SQLException {
        try {
            return this.rsetImpl.getFetchSize();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.getFetchSize", (String)"1363", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public float getFloat(int n) throws SQLException {
        try {
            return this.rsetImpl.getFloat(n);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.getFloat", (String)"1392", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public float getFloat(String string) throws SQLException {
        try {
            return this.rsetImpl.getFloat(string);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.getFloat", (String)"1422", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public int getInt(int n) throws SQLException {
        try {
            return this.rsetImpl.getInt(n);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.getInt", (String)"1451", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public int getInt(String string) throws SQLException {
        try {
            return this.rsetImpl.getInt(string);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.getInt", (String)"1480", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    final Object getJDBCImplObject() {
        return this.rsetImpl;
    }

    public long getLong(int n) throws SQLException {
        try {
            return this.rsetImpl.getLong(n);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.getLong", (String)"1509", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public long getLong(String string) throws SQLException {
        try {
            return this.rsetImpl.getLong(string);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.getLong", (String)"1538", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getMetaData", (Object)this);
        }
        ResultSetMetaData resultSetMetaData = null;
        try {
            resultSetMetaData = this.rsetImpl.getMetaData();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.getMetaData", (String)"1579", (Object)this);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getMetaData", (Object)"Exception");
            }
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getMetaData", (Object)"Exception");
            }
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getMetaData", (Object)resultSetMetaData);
        }
        return resultSetMetaData;
    }

    public Object getObject(int n) throws SQLException {
        try {
            return this.rsetImpl.getObject(n);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.getObject", (String)"1617", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public Object getObject(int n, Map map) throws SQLException {
        try {
            return this.rsetImpl.getObject(n, map);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.getObject", (String)"1646", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public Object getObject(String string) throws SQLException {
        try {
            return this.rsetImpl.getObject(string);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.getObject", (String)"1684", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public Object getObject(String string, Map map) throws SQLException {
        try {
            return this.rsetImpl.getObject(string, map);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.getObject", (String)"1713", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public Ref getRef(int n) throws SQLException {
        try {
            return this.rsetImpl.getRef(n);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.getRef", (String)"1740", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public Ref getRef(String string) throws SQLException {
        try {
            return this.rsetImpl.getRef(string);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.getRef", (String)"1767", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public int getRow() throws SQLException {
        try {
            return this.rsetImpl.getRow();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.getRow", (String)"1808", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public short getShort(int n) throws SQLException {
        try {
            return this.rsetImpl.getShort(n);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.getShort", (String)"1837", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public short getShort(String string) throws SQLException {
        try {
            return this.rsetImpl.getShort(string);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.getShort", (String)"1866", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public Statement getStatement() throws SQLException {
        if (this.parentWrapper instanceof WSJdbcDatabaseMetaData) {
            return null;
        }
        Statement statement = (Statement)((Object)this.parentWrapper);
        if (this.state == 2 || statement == null) {
            throw new ObjectClosedException(AdapterUtil.getNLSMessage("OBJECT_CLOSED", "ResultSet"));
        }
        return statement;
    }

    public String getString(int n) throws SQLException {
        try {
            return this.rsetImpl.getString(n);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.getString", (String)"1926", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public String getString(String string) throws SQLException {
        try {
            return this.rsetImpl.getString(string);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.getString", (String)"1955", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public Time getTime(int n) throws SQLException {
        try {
            return this.rsetImpl.getTime(n);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.getTime", (String)"1984", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public Time getTime(int n, Calendar calendar) throws SQLException {
        try {
            return this.rsetImpl.getTime(n, calendar);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.getTime", (String)"2016", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public Time getTime(String string) throws SQLException {
        try {
            return this.rsetImpl.getTime(string);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.getTime", (String)"2045", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public Time getTime(String string, Calendar calendar) throws SQLException {
        try {
            return this.rsetImpl.getTime(string, calendar);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.getTime", (String)"2077", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public Timestamp getTimestamp(int n) throws SQLException {
        try {
            return this.rsetImpl.getTimestamp(n);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.getTimestamp", (String)"2106", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public Timestamp getTimestamp(int n, Calendar calendar) throws SQLException {
        try {
            return this.rsetImpl.getTimestamp(n, calendar);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.getTimestamp", (String)"2138", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public Timestamp getTimestamp(String string) throws SQLException {
        try {
            return this.rsetImpl.getTimestamp(string);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.getTimestamp", (String)"2167", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public Timestamp getTimestamp(String string, Calendar calendar) throws SQLException {
        try {
            return this.rsetImpl.getTimestamp(string, calendar);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.getTimestamp", (String)"2199", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    final TraceComponent getTracer() {
        return tc;
    }

    public int getType() throws SQLException {
        try {
            return this.rsetImpl.getType();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.getType", (String)"2235", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public InputStream getUnicodeStream(int n) throws SQLException {
        try {
            return this.rsetImpl.getUnicodeStream(n);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.getUnicodeStream", (String)"2273", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public InputStream getUnicodeStream(String string) throws SQLException {
        try {
            return this.rsetImpl.getUnicodeStream(string);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.getUnicodeStream", (String)"2312", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public SQLWarning getWarnings() throws SQLException {
        try {
            return this.rsetImpl.getWarnings();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.getWarnings", (String)"2345", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertRow() throws SQLException {
        block8: {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"insertRow", (Object)this);
            }
            try {
                this.parentWrapper.parentWrapper.beginTransactionIfNecessary();
                if (this.pmi == null) {
                    this.rsetImpl.insertRow();
                    break block8;
                }
                try {
                    this.pmi.jdbcOperationStarted();
                    this.rsetImpl.insertRow();
                }
                finally {
                    this.pmi.jdbcOperationCompleted();
                }
            }
            catch (SQLException sQLException) {
                FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.insertRow", (String)"2398", (Object)this);
                throw WSJdbcUtil.mapException(this, sQLException);
            }
            catch (NullPointerException nullPointerException) {
                throw this.runtimeXIfNotClosed(nullPointerException);
            }
        }
    }

    void introspectWrapperSpecificInfo(FFDCLogger fFDCLogger) {
        fFDCLogger.append("Underlying ResultSet: " + AdapterUtil.toString(this.rsetImpl), this.rsetImpl);
    }

    public boolean isAfterLast() throws SQLException {
        try {
            return this.rsetImpl.isAfterLast();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.isAfterLast", (String)"2425", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public boolean isBeforeFirst() throws SQLException {
        try {
            return this.rsetImpl.isBeforeFirst();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.isBeforeFirst", (String)"2452", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public boolean isFirst() throws SQLException {
        try {
            return this.rsetImpl.isFirst();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.isFirst", (String)"2479", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public boolean isLast() throws SQLException {
        try {
            return this.rsetImpl.isLast();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.isLast", (String)"2508", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public boolean last() throws SQLException {
        try {
            return this.rsetImpl.last();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.last", (String)"2535", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void moveToCurrentRow() throws SQLException {
        try {
            this.rsetImpl.moveToCurrentRow();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.moveToCurrentRow", (String)"2561", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void moveToInsertRow() throws SQLException {
        try {
            this.rsetImpl.moveToInsertRow();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.moveToInsertRow", (String)"2592", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public boolean next() throws SQLException {
        try {
            return this.rsetImpl.next();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.next", (String)"2624", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public boolean previous() throws SQLException {
        try {
            return this.rsetImpl.previous();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.previous", (String)"2654", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshRow() throws SQLException {
        block8: {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"refreshRow", (Object)this);
            }
            try {
                this.parentWrapper.parentWrapper.beginTransactionIfNecessary();
                if (this.pmi == null) {
                    this.rsetImpl.refreshRow();
                    break block8;
                }
                try {
                    this.pmi.jdbcOperationStarted();
                    this.rsetImpl.refreshRow();
                }
                finally {
                    this.pmi.jdbcOperationCompleted();
                }
            }
            catch (SQLException sQLException) {
                FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.refreshRow", (String)"2714", (Object)this);
                throw WSJdbcUtil.mapException(this, sQLException);
            }
            catch (NullPointerException nullPointerException) {
                throw this.runtimeXIfNotClosed(nullPointerException);
            }
        }
    }

    public boolean relative(int n) throws SQLException {
        try {
            return this.rsetImpl.relative(n);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.relative", (String)"2748", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public boolean rowDeleted() throws SQLException {
        try {
            return this.rsetImpl.rowDeleted();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.rowDeleted", (String)"2777", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public boolean rowInserted() throws SQLException {
        try {
            return this.rsetImpl.rowInserted();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.rowInserted", (String)"2805", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public boolean rowUpdated() throws SQLException {
        try {
            return this.rsetImpl.rowUpdated();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.rowUpdated", (String)"2833", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    final RuntimeException runtimeXIfNotClosed(RuntimeException runtimeException) throws SQLException {
        if (this.state == 2) {
            throw new ObjectClosedException(AdapterUtil.getNLSMessage("OBJECT_CLOSED", "ResultSet"));
        }
        return runtimeException;
    }

    public void setFetchDirection(int n) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"setFetchDirection", (Object)new Object[]{this, AdapterUtil.getFetchDirectionString(n)});
        }
        try {
            this.rsetImpl.setFetchDirection(n);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.setFetchDirection", (String)"2860", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void setFetchSize(int n) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"setFetchSize", (Object)new Object[]{this, new Integer(n)});
        }
        try {
            this.rsetImpl.setFetchSize(n);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.setFetchSize", (String)"2891", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void updateAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        try {
            this.rsetImpl.updateAsciiStream(n, inputStream, n2);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.updateAsciiStream", (String)"2922", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void updateAsciiStream(String string, InputStream inputStream, int n) throws SQLException {
        try {
            this.rsetImpl.updateAsciiStream(string, inputStream, n);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.updateAsciiStream", (String)"2953", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void updateBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        try {
            this.rsetImpl.updateBigDecimal(n, bigDecimal);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.updateBigDecimal", (String)"2983", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void updateBigDecimal(String string, BigDecimal bigDecimal) throws SQLException {
        try {
            this.rsetImpl.updateBigDecimal(string, bigDecimal);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.updateBigDecimal", (String)"3013", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void updateBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        try {
            this.rsetImpl.updateBinaryStream(n, inputStream, n2);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.updateBinaryStream", (String)"3044", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void updateBinaryStream(String string, InputStream inputStream, int n) throws SQLException {
        try {
            this.rsetImpl.updateBinaryStream(string, inputStream, n);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.updateBinaryStream", (String)"3075", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void updateBoolean(int n, boolean bl) throws SQLException {
        try {
            this.rsetImpl.updateBoolean(n, bl);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.updateBoolean", (String)"3105", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void updateBoolean(String string, boolean bl) throws SQLException {
        try {
            this.rsetImpl.updateBoolean(string, bl);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.updateBoolean", (String)"3135", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void updateByte(int n, byte by) throws SQLException {
        try {
            this.rsetImpl.updateByte(n, by);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.updateByte", (String)"3165", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void updateByte(String string, byte by) throws SQLException {
        try {
            this.rsetImpl.updateByte(string, by);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.updateByte", (String)"3195", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void updateBytes(int n, byte[] byArray) throws SQLException {
        try {
            this.rsetImpl.updateBytes(n, byArray);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.updateBytes", (String)"3225", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void updateBytes(String string, byte[] byArray) throws SQLException {
        try {
            this.rsetImpl.updateBytes(string, byArray);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.updateBytes", (String)"3255", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void updateCharacterStream(int n, Reader reader, int n2) throws SQLException {
        try {
            this.rsetImpl.updateCharacterStream(n, reader, n2);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.updateCharacterStream", (String)"3286", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void updateCharacterStream(String string, Reader reader, int n) throws SQLException {
        try {
            this.rsetImpl.updateCharacterStream(string, reader, n);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.updateCharacterStream", (String)"3317", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void updateDate(int n, Date date) throws SQLException {
        try {
            this.rsetImpl.updateDate(n, date);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.updateDate", (String)"3347", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void updateDate(String string, Date date) throws SQLException {
        try {
            this.rsetImpl.updateDate(string, date);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.updateDate", (String)"3377", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void updateDouble(int n, double d) throws SQLException {
        try {
            this.rsetImpl.updateDouble(n, d);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.updateDouble", (String)"3407", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void updateDouble(String string, double d) throws SQLException {
        try {
            this.rsetImpl.updateDouble(string, d);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.updateDouble", (String)"3437", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void updateFloat(int n, float f) throws SQLException {
        try {
            this.rsetImpl.updateFloat(n, f);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.updateFloat", (String)"3467", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void updateFloat(String string, float f) throws SQLException {
        try {
            this.rsetImpl.updateFloat(string, f);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.updateFloat", (String)"3497", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void updateInt(int n, int n2) throws SQLException {
        try {
            this.rsetImpl.updateInt(n, n2);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.updateInt", (String)"3527", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void updateInt(String string, int n) throws SQLException {
        try {
            this.rsetImpl.updateInt(string, n);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.updateInt", (String)"3557", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void updateLong(int n, long l) throws SQLException {
        try {
            this.rsetImpl.updateLong(n, l);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.updateLong", (String)"3587", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void updateLong(String string, long l) throws SQLException {
        try {
            this.rsetImpl.updateLong(string, l);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.updateLong", (String)"3617", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void updateNull(int n) throws SQLException {
        try {
            this.rsetImpl.updateNull(n);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.updateNull", (String)"3646", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void updateNull(String string) throws SQLException {
        try {
            this.rsetImpl.updateNull(string);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.updateNull", (String)"3675", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void updateObject(int n, Object object) throws SQLException {
        try {
            this.rsetImpl.updateObject(n, object);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.updateObject", (String)"3705", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void updateObject(int n, Object object, int n2) throws SQLException {
        try {
            this.rsetImpl.updateObject(n, object, n2);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.updateObject", (String)"3737", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void updateObject(String string, Object object) throws SQLException {
        try {
            this.rsetImpl.updateObject(string, object);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.updateObject", (String)"3767", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void updateObject(String string, Object object, int n) throws SQLException {
        try {
            this.rsetImpl.updateObject(string, object, n);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.updateObject", (String)"3799", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateRow() throws SQLException {
        block8: {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"updateRow", (Object)this);
            }
            try {
                this.parentWrapper.parentWrapper.beginTransactionIfNecessary();
                if (this.pmi == null) {
                    this.rsetImpl.updateRow();
                    break block8;
                }
                try {
                    this.pmi.jdbcOperationStarted();
                    this.rsetImpl.updateRow();
                }
                finally {
                    this.pmi.jdbcOperationCompleted();
                }
            }
            catch (SQLException sQLException) {
                FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.updateRow", (String)"3851", (Object)this);
                throw WSJdbcUtil.mapException(this, sQLException);
            }
            catch (NullPointerException nullPointerException) {
                throw this.runtimeXIfNotClosed(nullPointerException);
            }
        }
    }

    public void updateShort(int n, short s) throws SQLException {
        try {
            this.rsetImpl.updateShort(n, s);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.updateShort", (String)"3881", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void updateShort(String string, short s) throws SQLException {
        try {
            this.rsetImpl.updateShort(string, s);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.updateShort", (String)"3911", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void updateString(int n, String string) throws SQLException {
        try {
            this.rsetImpl.updateString(n, string);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.updateString", (String)"3941", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void updateString(String string, String string2) throws SQLException {
        try {
            this.rsetImpl.updateString(string, string2);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.updateString", (String)"3971", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void updateTime(int n, Time time) throws SQLException {
        try {
            this.rsetImpl.updateTime(n, time);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.updateTime", (String)"4001", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void updateTime(String string, Time time) throws SQLException {
        try {
            this.rsetImpl.updateTime(string, time);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.updateTime", (String)"4031", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void updateTimestamp(int n, Timestamp timestamp) throws SQLException {
        try {
            this.rsetImpl.updateTimestamp(n, timestamp);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.updateTimestamp", (String)"4061", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void updateTimestamp(String string, Timestamp timestamp) throws SQLException {
        try {
            this.rsetImpl.updateTimestamp(string, timestamp);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.updateTimestamp", (String)"4091", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public boolean wasNull() throws SQLException {
        try {
            return this.rsetImpl.wasNull();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.wasNull", (String)"4119", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public URL getURL(int n) throws SQLException {
        try {
            return this.rsetImpl.getURL(n);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.getURL", (String)"3935", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public URL getURL(String string) throws SQLException {
        try {
            return this.rsetImpl.getURL(string);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.getURL", (String)"3964", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void updateArray(int n, Array array) throws SQLException {
        try {
            this.rsetImpl.updateArray(n, array);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.updateArray", (String)"3993", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void updateArray(String string, Array array) throws SQLException {
        try {
            this.rsetImpl.updateArray(string, array);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.updateArray", (String)"4009", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void updateBlob(int n, Blob blob) throws SQLException {
        try {
            this.rsetImpl.updateBlob(n, blob);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.updateBlob", (String)"4038", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void updateBlob(String string, Blob blob) throws SQLException {
        try {
            this.rsetImpl.updateBlob(string, blob);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.updateBlob", (String)"4066", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void updateClob(int n, Clob clob) throws SQLException {
        try {
            this.rsetImpl.updateClob(n, clob);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.updateClob", (String)"4094", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void updateClob(String string, Clob clob) throws SQLException {
        try {
            this.rsetImpl.updateClob(string, clob);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.updateClob", (String)"4123", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void updateRef(int n, Ref ref) throws SQLException {
        try {
            this.rsetImpl.updateRef(n, ref);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.updateRef", (String)"4152", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void updateRef(String string, Ref ref) throws SQLException {
        try {
            this.rsetImpl.updateRef(string, ref);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.updateRef", (String)"4180", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }
}

