/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.rsadapter.jdbc;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.pmi.J2CPerf;
import com.ibm.websphere.rsadapter.HandleStates;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.FFDCSelfIntrospectable;
import com.ibm.ws.rsadapter.FFDCLogger;
import java.sql.SQLException;
import java.util.ArrayList;

public abstract class WSJdbcObject
implements HandleStates,
FFDCSelfIntrospectable {
    int state = 0;
    WSJdbcObject parentWrapper;
    WSJdbcObject childWrapper;
    ArrayList childWrappers;
    J2CPerf pmi;

    void beginTransactionIfNecessary() throws SQLException {
        this.getConnectionWrapper().beginTransactionIfNecessary();
    }

    public void close() throws SQLException {
        this.close(false);
    }

    protected void close(boolean bl) throws SQLException {
        TraceComponent traceComponent = this.getTracer();
        if (traceComponent.isEntryEnabled()) {
            Tr.entry((TraceComponent)traceComponent, (String)"close", (Object)this);
        }
        if (this.state == 2) {
            if (traceComponent.isEventEnabled()) {
                Tr.event((TraceComponent)traceComponent, (String)"Already closed.");
            }
            if (traceComponent.isEntryEnabled()) {
                Tr.exit((TraceComponent)traceComponent, (String)"close");
            }
            return;
        }
        this.state = 2;
        if (traceComponent.isEventEnabled()) {
            Tr.event((TraceComponent)traceComponent, (String)("state --> " + this.getStateString()));
        }
        this.closeChildWrappers();
        SQLException sQLException = this.closeWrapper(bl);
        this.parentWrapper = null;
        this.childWrappers = null;
        this.pmi = null;
        if (sQLException == null) {
            if (traceComponent.isEntryEnabled()) {
                Tr.exit((TraceComponent)traceComponent, (String)"close");
            }
        } else {
            if (traceComponent.isEntryEnabled()) {
                Tr.exit((TraceComponent)traceComponent, (String)"close", (Object)sQLException);
            }
            throw sQLException;
        }
    }

    final void closeChildWrappers() {
        if (this.childWrappers != null && !this.childWrappers.isEmpty()) {
            WSJdbcObject wSJdbcObject = null;
            int n = this.childWrappers.size();
            while (n > 0) {
                try {
                    wSJdbcObject = (WSJdbcObject)this.childWrappers.get(--n);
                    wSJdbcObject.close();
                }
                catch (SQLException sQLException) {
                    FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcObject.closeChildWrappers", (String)"554", (Object)this);
                    Tr.warning((TraceComponent)this.getTracer(), (String)"ERR_CLOSING_CHILD", (Object)new Object[]{wSJdbcObject, sQLException});
                }
            }
        }
        if (this.childWrapper != null) {
            try {
                this.childWrapper.close();
            }
            catch (SQLException sQLException) {
                FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcObject.closeChildWrappers", (String)"573", (Object)this);
                Tr.warning((TraceComponent)this.getTracer(), (String)"ERR_CLOSING_CHILD", (Object)new Object[]{this.childWrapper, sQLException});
            }
        }
    }

    abstract SQLException closeWrapper(boolean var1);

    abstract WSJdbcObject getConnectionWrapper();

    abstract Object getJDBCImplObject();

    public final int getState() {
        return this.state;
    }

    public final String getStateString() {
        return STATE_STRINGS[this.state];
    }

    abstract TraceComponent getTracer();

    void introspectAll(FFDCLogger fFDCLogger) {
        int n;
        fFDCLogger.append(this.toString());
        this.introspectWrapperSpecificInfo(fFDCLogger);
        fFDCLogger.append("Wrapper State: ", this.getStateString());
        fFDCLogger.append("Parent wrapper:", this.parentWrapper);
        fFDCLogger.append("Child wrappers:");
        fFDCLogger.indent(this.childWrapper);
        if (this.childWrappers != null) {
            try {
                for (n = 0; n < this.childWrappers.size(); ++n) {
                    fFDCLogger.indent(this.childWrappers.get(n));
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        fFDCLogger.eoln();
        fFDCLogger.append("Performance Monitoring Instrumentation:", this.pmi);
        if (this.childWrapper != null) {
            try {
                fFDCLogger.append("____________________________________________________________");
                fFDCLogger.append("Child Wrapper");
                this.childWrapper.introspectAll(fFDCLogger);
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        if (this.childWrappers != null) {
            try {
                for (n = 0; n < this.childWrappers.size(); ++n) {
                    fFDCLogger.append("____________________________________________________________");
                    fFDCLogger.append("Child Wrapper #" + (n + 1));
                    ((WSJdbcObject)this.childWrappers.get(n)).introspectAll(fFDCLogger);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public String[] introspectSelf() {
        FFDCLogger fFDCLogger = new FFDCLogger(500, this);
        WSJdbcObject wSJdbcObject = null;
        try {
            wSJdbcObject = this.getConnectionWrapper();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        if (wSJdbcObject == null || wSJdbcObject == this) {
            this.introspectAll(fFDCLogger);
        } else {
            fFDCLogger.append("Displaying FFDC information for wrapper hierarchy,");
            fFDCLogger.append("beginning from the Connection...");
            fFDCLogger.append(wSJdbcObject.introspectSelf());
        }
        return fFDCLogger.toStringArray();
    }

    void introspectWrapperSpecificInfo(FFDCLogger fFDCLogger) {
    }

    abstract RuntimeException runtimeXIfNotClosed(RuntimeException var1) throws SQLException;
}

