/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.rsadapter.jdbc;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.rsadapter.AdapterUtil;
import com.ibm.ws.rsadapter.jdbc.WSJdbcConnection;
import com.ibm.ws.rsadapter.jdbc.WSJdbcPreparedStatement;
import com.ibm.ws.rsadapter.jdbc.WSJdbcUtil;
import com.ibm.ws.rsadapter.spi.StatementCacheKey;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;

public class WSJdbcCallableStatement
extends WSJdbcPreparedStatement
implements CallableStatement {
    private static final TraceComponent tc = Tr.register((Class)WSJdbcCallableStatement.class, (String)"RRA", (String)"IBMDataStoreAdapterNLS");
    CallableStatement cstmtImpl;

    WSJdbcCallableStatement() {
    }

    WSJdbcCallableStatement(CallableStatement callableStatement, WSJdbcConnection wSJdbcConnection, int n) throws SQLException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"<init>", (Object)new Object[]{AdapterUtil.toString(callableStatement), wSJdbcConnection, AdapterUtil.getCursorHoldabilityString(n)});
        }
        this.cstmtImpl = callableStatement;
        this.pstmtImpl = this.cstmtImpl;
        this.stmtImpl = this.cstmtImpl;
        this.parentWrapper = wSJdbcConnection;
        this.pmi = wSJdbcConnection.pmi;
        this.holdability = n;
        try {
            this.currentFetchSize = this.cstmtImpl.getFetchSize();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcCallableStatement.<init>", (String)"66", (Object)this);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"<init>", (Object)"Exception");
            }
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("current fetchSize is " + this.currentFetchSize));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"<init>", (Object)this);
        }
    }

    WSJdbcCallableStatement(CallableStatement callableStatement, WSJdbcConnection wSJdbcConnection, int n, StatementCacheKey statementCacheKey) throws SQLException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"<init>", (Object)new Object[]{AdapterUtil.toString(callableStatement), wSJdbcConnection, AdapterUtil.getCursorHoldabilityString(n), statementCacheKey});
        }
        this.cstmtImpl = callableStatement;
        this.pstmtImpl = this.cstmtImpl;
        this.stmtImpl = this.cstmtImpl;
        this.parentWrapper = wSJdbcConnection;
        this.pmi = wSJdbcConnection.pmi;
        this.key = statementCacheKey;
        this.holdability = n;
        try {
            this.currentFetchSize = this.cstmtImpl.getFetchSize();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcCallableStatement.<init>", (String)"111", (Object)this);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"<init>", (Object)"Exception");
            }
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("current fetchSize is " + this.currentFetchSize));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"<init>", (Object)this);
        }
    }

    SQLException closeWrapper(boolean bl) {
        this.cstmtImpl = null;
        return super.closeWrapper(bl);
    }

    public Array getArray(int n) throws SQLException {
        try {
            return this.cstmtImpl.getArray(n);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcCallableStatement.getArray", (String)"86", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public BigDecimal getBigDecimal(int n) throws SQLException {
        try {
            return this.cstmtImpl.getBigDecimal(n);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcCallableStatement.getBigDecimal", (String)"106", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public BigDecimal getBigDecimal(int n, int n2) throws SQLException {
        try {
            return this.cstmtImpl.getBigDecimal(n, n2);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcCallableStatement.getBigDecimal", (String)"126", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public Blob getBlob(int n) throws SQLException {
        try {
            return this.cstmtImpl.getBlob(n);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcCallableStatement.getBlob", (String)"146", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public boolean getBoolean(int n) throws SQLException {
        try {
            return this.cstmtImpl.getBoolean(n);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcCallableStatement.getBoolean", (String)"166", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public byte getByte(int n) throws SQLException {
        try {
            return this.cstmtImpl.getByte(n);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcCallableStatement.getByte", (String)"186", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public byte[] getBytes(int n) throws SQLException {
        try {
            return this.cstmtImpl.getBytes(n);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcCallableStatement.getBytes", (String)"206", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public Clob getClob(int n) throws SQLException {
        try {
            return this.cstmtImpl.getClob(n);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcCallableStatement.getClob", (String)"226", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public Date getDate(int n) throws SQLException {
        try {
            return this.cstmtImpl.getDate(n);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcCallableStatement.getDate", (String)"246", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public Date getDate(int n, Calendar calendar) throws SQLException {
        try {
            return this.cstmtImpl.getDate(n, calendar);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcCallableStatement.getDate", (String)"266", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public double getDouble(int n) throws SQLException {
        try {
            return this.cstmtImpl.getDouble(n);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcCallableStatement.getDouble", (String)"286", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public float getFloat(int n) throws SQLException {
        try {
            return this.cstmtImpl.getFloat(n);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcCallableStatement.getFloat", (String)"306", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public int getInt(int n) throws SQLException {
        try {
            return this.cstmtImpl.getInt(n);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcCallableStatement.getInt", (String)"326", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public long getLong(int n) throws SQLException {
        try {
            return this.cstmtImpl.getLong(n);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcCallableStatement.getLong", (String)"346", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public Object getObject(int n) throws SQLException {
        try {
            return this.cstmtImpl.getObject(n);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcCallableStatement.getObject", (String)"366", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public Object getObject(int n, Map map) throws SQLException {
        try {
            return this.cstmtImpl.getObject(n, map);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcCallableStatement.getObject", (String)"386", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public Ref getRef(int n) throws SQLException {
        try {
            return this.cstmtImpl.getRef(n);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcCallableStatement.getRef", (String)"406", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public short getShort(int n) throws SQLException {
        try {
            return this.cstmtImpl.getShort(n);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcCallableStatement.getShort", (String)"426", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public String getString(int n) throws SQLException {
        try {
            return this.cstmtImpl.getString(n);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcCallableStatement.getString", (String)"446", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public Time getTime(int n) throws SQLException {
        try {
            return this.cstmtImpl.getTime(n);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcCallableStatement.getTime", (String)"466", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public Time getTime(int n, Calendar calendar) throws SQLException {
        try {
            return this.cstmtImpl.getTime(n, calendar);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcCallableStatement.getTime", (String)"486", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public Timestamp getTimestamp(int n) throws SQLException {
        try {
            return this.cstmtImpl.getTimestamp(n);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcCallableStatement.getTimestamp", (String)"506", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public Timestamp getTimestamp(int n, Calendar calendar) throws SQLException {
        try {
            return this.cstmtImpl.getTimestamp(n, calendar);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcCallableStatement.getTimestamp", (String)"526", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    final TraceComponent getTracer() {
        return tc;
    }

    public void registerOutParameter(int n, int n2) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"registerOutParameter", (Object)new Object[]{this, new Integer(n), AdapterUtil.getSQLTypeString(n2)});
        }
        try {
            this.cstmtImpl.registerOutParameter(n, n2);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcCallableStatement.registerOutParameter", (String)"555", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void registerOutParameter(int n, int n2, int n3) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"registerOutParameter", (Object)new Object[]{this, new Integer(n), AdapterUtil.getSQLTypeString(n2), new Integer(n3)});
        }
        try {
            this.cstmtImpl.registerOutParameter(n, n2, n3);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcCallableStatement.registerOutParameter", (String)"576", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void registerOutParameter(int n, int n2, String string) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"registerOutParameter", (Object)new Object[]{this, new Integer(n), AdapterUtil.getSQLTypeString(n2), string});
        }
        try {
            this.cstmtImpl.registerOutParameter(n, n2, string);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcCallableStatement.registerOutParameter", (String)"597", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public boolean wasNull() throws SQLException {
        try {
            return this.cstmtImpl.wasNull();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcCallableStatement.wasNull", (String)"617", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void registerOutParameter(String string, int n) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"registerOutParameter", (Object)new Object[]{string, AdapterUtil.getSQLTypeString(n)});
        }
        try {
            this.cstmtImpl.registerOutParameter(string, n);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcCallableStatement.registerOutParameter(String, int)", (String)"721", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void registerOutParameter(String string, int n, int n2) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"registerOutParameter", (Object)new Object[]{string, AdapterUtil.getSQLTypeString(n), new Integer(n2)});
        }
        try {
            this.cstmtImpl.registerOutParameter(string, n, n2);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcCallableStatement.registerOutParameter(String, int, int)", (String)"744", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void registerOutParameter(String string, int n, String string2) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"registerOutParameter", (Object)new Object[]{string, AdapterUtil.getSQLTypeString(n), string2});
        }
        try {
            this.cstmtImpl.registerOutParameter(string, n, string2);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcCallableStatement.registerOutParameter(String, int, String)", (String)"766", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void setURL(String string, URL uRL) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("setURL #" + string));
        }
        try {
            this.cstmtImpl.setURL(string, uRL);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcCallableStatement.setURL(String, URL)", (String)"783", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void setNull(String string, int n) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("setNull #" + string), (Object)AdapterUtil.getSQLTypeString(n));
        }
        try {
            this.cstmtImpl.setNull(string, n);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcCallableStatement.setNull(String, int)", (String)"804", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void setBoolean(String string, boolean bl) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("setBoolean #" + string));
        }
        try {
            this.cstmtImpl.setBoolean(string, bl);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcCallableStatement.setBoolean(String, boolean)", (String)"823", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void setByte(String string, byte by) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("setByte #" + string));
        }
        try {
            this.cstmtImpl.setByte(string, by);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcCallableStatement.setByte(String, byte)", (String)"841", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void setShort(String string, short s) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("setShort #" + string));
        }
        try {
            this.cstmtImpl.setShort(string, s);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcCallableStatement.setShort(String, short)", (String)"859", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void setInt(String string, int n) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("setInt #" + string));
        }
        try {
            this.cstmtImpl.setInt(string, n);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcCallableStatement.setint(String, int)", (String)"877", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void setLong(String string, long l) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("setLong #" + string));
        }
        try {
            this.cstmtImpl.setLong(string, l);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcCallableStatement.setLong(String, long)", (String)"895", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void setFloat(String string, float f) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("setFloat #" + string));
        }
        try {
            this.cstmtImpl.setFloat(string, f);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcCallableStatement.setFloat(String, float)", (String)"913", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void setDouble(String string, double d) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("setDouble #" + string));
        }
        try {
            this.cstmtImpl.setDouble(string, d);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcCallableStatement.setDouble(String, x)", (String)"931", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void setBigDecimal(String string, BigDecimal bigDecimal) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("setBigDecimal #" + string));
        }
        try {
            this.cstmtImpl.setBigDecimal(string, bigDecimal);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcCallableStatement.setBigDecimal(String, BigDecimal)", (String)"950", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void setString(String string, String string2) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("setString #" + string));
        }
        try {
            this.cstmtImpl.setString(string, string2);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcCallableStatement.setString(String, String)", (String)"967", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void setBytes(String string, byte[] byArray) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("setBytes #" + string), byArray == null ? null : "length = " + byArray.length);
        }
        try {
            this.cstmtImpl.setBytes(string, byArray);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcCallableStatement.setBytes(String, byte[])", (String)"986", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void setDate(String string, Date date) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("setDate #" + string));
        }
        try {
            this.cstmtImpl.setDate(string, date);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcCallableStatement.setDate(String, Date)", (String)"1005", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void setTime(String string, Time time) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("setTime #" + string));
        }
        try {
            this.cstmtImpl.setTime(string, time);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcCallableStatement.setTime(String, Time)", (String)"1024", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void setTimestamp(String string, Timestamp timestamp) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("setTimestamp #" + string));
        }
        try {
            this.cstmtImpl.setTimestamp(string, timestamp);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcCallableStatement.setTimestamp(String, x)", (String)"1043", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void setAsciiStream(String string, InputStream inputStream, int n) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("setAsciiStream #" + string), (Object)("length = " + n));
        }
        try {
            this.cstmtImpl.setAsciiStream(string, inputStream, n);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcCallableStatement.setAsciiStream(String, InputStream, int)", (String)"1065", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void setBinaryStream(String string, InputStream inputStream, int n) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("setBinaryStream #" + string), (Object)("length = " + n));
        }
        try {
            this.cstmtImpl.setBinaryStream(string, inputStream, n);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcCallableStatement.setBinaryStream(String, InputDtream, int)", (String)"1087", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void setObject(String string, Object object, int n, int n2) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("setObject #" + string), (Object)new Object[]{AdapterUtil.getSQLTypeString(n), new Integer(n2)});
        }
        try {
            this.cstmtImpl.setObject(string, object, n, n2);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcCallableStatement.setObject(String, Object, int, int)", (String)"1110", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void setObject(String string, Object object, int n) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("setObject #" + string), (Object)AdapterUtil.getSQLTypeString(n));
        }
        try {
            this.cstmtImpl.setObject(string, object, n);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcCallableStatement.setObject(parameterName, x, targetSqlType)", (String)"1129", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void setObject(String string, Object object) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("setObject #" + string));
        }
        try {
            this.cstmtImpl.setObject(string, object);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcCallableStatement.setObject(String, Object)", (String)"1147", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void setCharacterStream(String string, Reader reader, int n) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("setCharacterStream #" + string), (Object)("length = " + n));
        }
        try {
            this.cstmtImpl.setCharacterStream(string, reader, n);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcCallableStatement.setCharacterStream(String, Reader, int)", (String)"1169", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void setDate(String string, Date date, Calendar calendar) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("setDate with Calendar #" + string));
        }
        try {
            this.cstmtImpl.setDate(string, date, calendar);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcCallableStatement.setDate(String, Date, calendar)", (String)"1191", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void setTime(String string, Time time, Calendar calendar) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("setTime with Calendar #" + string));
        }
        try {
            this.cstmtImpl.setTime(string, time, calendar);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcCallableStatement.setTime(String, Time, Calendar)", (String)"1213", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void setTimestamp(String string, Timestamp timestamp, Calendar calendar) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("setTimestamp with Calendar #" + string));
        }
        try {
            this.cstmtImpl.setTimestamp(string, timestamp, calendar);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcCallableStatement.setTimestamp(String, Timestamp, Calendar)", (String)"1235", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void setNull(String string, int n, String string2) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("setNull #" + string), (Object)new Object[]{AdapterUtil.getSQLTypeString(n), string2});
        }
        try {
            this.cstmtImpl.setNull(string, n, string2);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcCallableStatement.setNull(String, int, String)", (String)"1254", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public Array getArray(String string) throws SQLException {
        try {
            return this.cstmtImpl.getArray(string);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcCallableStatement.getArray(String)", (String)"1273", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public BigDecimal getBigDecimal(String string) throws SQLException {
        try {
            return this.cstmtImpl.getBigDecimal(string);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcCallableStatement.getBigDecimal(String)", (String)"1293", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public Blob getBlob(String string) throws SQLException {
        try {
            return this.cstmtImpl.getBlob(string);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcCallableStatement.getBlob(String)", (String)"1312", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public boolean getBoolean(String string) throws SQLException {
        try {
            return this.cstmtImpl.getBoolean(string);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcCallableStatement.getBoolean(String)", (String)"1327", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public byte getByte(String string) throws SQLException {
        try {
            return this.cstmtImpl.getByte(string);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcCallableStatement.getByte(String)", (String)"1346", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public byte[] getBytes(String string) throws SQLException {
        try {
            return this.cstmtImpl.getBytes(string);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcCallableStatement.getBytes(String)", (String)"1363", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public Clob getClob(String string) throws SQLException {
        try {
            return this.cstmtImpl.getClob(string);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcCallableStatement.getClob", (String)"1381", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public Date getDate(String string) throws SQLException {
        try {
            return this.cstmtImpl.getDate(string);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcCallableStatement.getDate(String)", (String)"1400", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public Date getDate(String string, Calendar calendar) throws SQLException {
        try {
            return this.cstmtImpl.getDate(string, calendar);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcCallableStatement.getDate(String, Calendar)", (String)"1418", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public double getDouble(String string) throws SQLException {
        try {
            return this.cstmtImpl.getDouble(string);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcCallableStatement.getDouble(String)", (String)"1436", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public float getFloat(String string) throws SQLException {
        try {
            return this.cstmtImpl.getFloat(string);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcCallableStatement.getFloat(String)", (String)"1454", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public int getInt(String string) throws SQLException {
        try {
            return this.cstmtImpl.getInt(string);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcCallableStatement.getInt(String)", (String)"1472", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public long getLong(String string) throws SQLException {
        try {
            return this.cstmtImpl.getLong(string);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcCallableStatement.getLong(String)", (String)"1489", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public Object getObject(String string) throws SQLException {
        try {
            return this.cstmtImpl.getObject(string);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcCallableStatement.getObject(String)", (String)"1506", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public Object getObject(String string, Map map) throws SQLException {
        try {
            return this.cstmtImpl.getObject(string, map);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcCallableStatement.getObject(String, Map)", (String)"1524", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public Ref getRef(String string) throws SQLException {
        try {
            return this.cstmtImpl.getRef(string);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcCallableStatement.getRef(String)", (String)"1542", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public short getShort(String string) throws SQLException {
        try {
            return this.cstmtImpl.getShort(string);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcCallableStatement.getShort(String)", (String)"1561", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public String getString(String string) throws SQLException {
        try {
            return this.cstmtImpl.getString(string);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcCallableStatement.getString(String)", (String)"1578", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public Time getTime(String string) throws SQLException {
        try {
            return this.cstmtImpl.getTime(string);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcCallableStatement.getTime(String)", (String)"1597", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public Time getTime(String string, Calendar calendar) throws SQLException {
        try {
            return this.cstmtImpl.getTime(string, calendar);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcCallableStatement.getTime(String, Calendar)", (String)"1618", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public Timestamp getTimestamp(String string) throws SQLException {
        try {
            return this.cstmtImpl.getTimestamp(string);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcCallableStatement.getTimestamp(String)", (String)"1637", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public Timestamp getTimestamp(String string, Calendar calendar) throws SQLException {
        try {
            return this.cstmtImpl.getTimestamp(string, calendar);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcCallableStatement.getTimestamp(String, Calendar)", (String)"1656", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public URL getURL(int n) throws SQLException {
        try {
            return this.cstmtImpl.getURL(n);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcCallableStatement.getURL(int)", (String)"1674", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public URL getURL(String string) throws SQLException {
        try {
            return this.cstmtImpl.getURL(string);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcCallableStatement.getURL(String)", (String)"1692", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }
}

