/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.rsadapter.exceptions;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ws.exception.WsException;
import com.ibm.ws.exception.WsNestedException;
import com.ibm.ws.rsadapter.AdapterUtil;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.sql.SQLException;
import java.util.Locale;
import javax.resource.ResourceException;

public class DataStoreAdapterException
extends ResourceException
implements WsNestedException {
    private static final long serialVersionUID = -1282552127378991160L;
    private static final String DEFAULTTEXT = "Error in a data store adapter";
    private WsException ivException = null;
    static final String resBundle = "IBMDataStoreAdapterNLS";
    private static final TraceComponent tcLocal = Tr.register((Class)DataStoreAdapterException.class, (String)"RRA", (String)"IBMDataStoreAdapterNLS");
    private boolean connectionError = false;
    private boolean containsSqlException = false;
    private boolean beenMapped = false;
    private Object[] formatArgs;

    public DataStoreAdapterException(String string, String string2, Class clazz) {
        this(string, null, null, string2, clazz);
    }

    public DataStoreAdapterException(String string, Throwable throwable, String string2, Class clazz) {
        this(string, new Object[]{throwable.getMessage()}, throwable, string2, clazz);
    }

    public DataStoreAdapterException(String string, Throwable throwable, Class clazz) {
        this(string, new Object[]{throwable.getMessage()}, throwable, DEFAULTTEXT, clazz);
    }

    public DataStoreAdapterException(String string, Object[] objectArray, String string2, Class clazz) {
        this(string, objectArray, null, string2, clazz);
    }

    public DataStoreAdapterException(String string, Object[] objectArray, Throwable throwable, String string2, Class clazz) {
        this(TraceNLS.getFormattedMessage((String)resBundle, (String)string, (Locale)Locale.US, (Object[])objectArray, (String)string2), string, objectArray, throwable, clazz);
    }

    private DataStoreAdapterException(String string, String string2, Object[] objectArray, Throwable throwable, Class clazz) {
        super(string, string2);
        this.formatArgs = objectArray;
        TraceComponent traceComponent = Tr.register((Class)clazz, (String)"RRA", (String)resBundle);
        if (traceComponent.isDebugEnabled()) {
            Tr.debug((TraceComponent)traceComponent, (String)string2, (Object)objectArray);
        }
        if (throwable == null) {
            this.ivException = new WsException(string);
            this.ivException.fillInStackTrace();
            if (traceComponent.isDebugEnabled()) {
                Tr.debug((TraceComponent)tcLocal, (String)"DSA_ERROR", (Object)((Object)this));
            }
        } else {
            if (throwable instanceof SQLException) {
                this.containsSqlException = true;
                SQLException sQLException = (SQLException)throwable;
                String string3 = sQLException.getSQLState();
                int n = sQLException.getErrorCode();
                StringBuffer stringBuffer = new StringBuffer(150);
                stringBuffer.append(string).append(" with SQL State : ").append(string3).append(" SQL Code : ").append(n);
                string = stringBuffer.toString();
                String string4 = AdapterUtil.getNLSMessage("SQL_STATE_ERROR_CODE", new Object[]{string3, new Integer(n)});
                throwable = new SQLException(sQLException.getMessage() + string4, string3, n);
                throwable.setStackTrace(sQLException.getStackTrace());
            }
            this.ivException = new WsException(string, throwable);
            this.ivException.setStackTrace(throwable.getStackTrace());
            if (traceComponent.isDebugEnabled()) {
                Tr.debug((TraceComponent)traceComponent, (String)"Exception", (Object)throwable);
            }
        }
    }

    public void printStackTrace() {
        this.ivException.printStackTrace();
    }

    public void printStackTrace(PrintWriter printWriter) {
        this.ivException.printStackTrace(printWriter);
    }

    public void printStackTrace(PrintStream printStream) {
        this.ivException.printStackTrace(printStream);
    }

    public void printSuperStackTrace(PrintWriter printWriter) {
        super.printStackTrace(printWriter);
    }

    public boolean beenMapped() {
        return this.beenMapped;
    }

    public void setBeenMapped() {
        this.beenMapped = true;
    }

    public boolean isConnectionError() {
        return this.connectionError;
    }

    public boolean containsSqlException() {
        return this.containsSqlException;
    }

    public void setConnectionError(boolean bl) {
        this.connectionError = bl;
    }

    public Exception getLinkedException() {
        for (Throwable throwable = this.getCause(); throwable != null; throwable = throwable.getCause()) {
            if (!(throwable instanceof Exception)) continue;
            return (Exception)throwable;
        }
        return null;
    }

    public void setLinkedException(Exception exception) {
        String string = this.ivException.getMessage();
        this.ivException = new WsException(string, (Throwable)exception);
        this.containsSqlException = exception instanceof SQLException;
    }

    public Throwable getCause() {
        return this.ivException.getCause();
    }

    public Throwable initCause(Throwable throwable) throws IllegalArgumentException, IllegalStateException {
        return this.ivException.initCause(throwable);
    }

    public final String translate(Locale locale) {
        String string = this.getErrorCode();
        return TraceNLS.getFormattedMessage((String)resBundle, (String)string, (Locale)locale, (Object[])this.formatArgs, (String)string);
    }
}

