/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.rsadapter;

import com.ibm.ws.ffdc.FFDCSelfIntrospectable;
import com.ibm.ws.rsadapter.AdapterUtil;
import java.util.ArrayList;

public class FFDCLogger {
    private ArrayList lines;
    public static final String TAB = "  ";
    public static final String EOLN = System.getProperty("line.separator");

    public FFDCLogger(Object object) {
        this(40, object);
    }

    public FFDCLogger(int n, Object object) {
        this.lines = new ArrayList(n);
        this.createFFDCHeader(object);
    }

    public final FFDCLogger append(String string, Object object) {
        this.lines.add(string);
        this.lines.add(new String(new StringBuffer().append(TAB).append(object).append(EOLN)));
        return this;
    }

    public final FFDCLogger append(String string) {
        this.lines.add(new String(new StringBuffer().append(string).append(EOLN)));
        return this;
    }

    public final FFDCLogger append(String[] stringArray) {
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            this.lines.add(stringArray[i]);
        }
        return this;
    }

    public FFDCLogger createFFDCHeader(Object object) {
        this.lines.add("_______________________________________________________________________");
        this.lines.add("");
        this.lines.add("    First Failure Data Capture information for");
        this.lines.add(new String(new StringBuffer().append("          ").append(AdapterUtil.toString(object))));
        this.lines.add("_______________________________________________________________________");
        this.lines.add("");
        return this;
    }

    public final FFDCLogger eoln() {
        this.lines.add("");
        return this;
    }

    public final FFDCLogger indent(Object object) {
        this.lines.add(new String(new StringBuffer().append(TAB).append(object)));
        return this;
    }

    public final FFDCLogger introspect(String string, Object object) {
        if (object instanceof FFDCSelfIntrospectable) {
            this.append(((FFDCSelfIntrospectable)object).introspectSelf());
        } else {
            this.append(string, object);
        }
        return this;
    }

    public final String[] toStringArray() {
        int n = this.lines.size();
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = (String)this.lines.get(i);
        }
        return stringArray;
    }
}

