/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.rsadapter;

import com.ibm.ejs.j2c.ConnectionFactoryRefBuilder;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ce.cm.StaleConnectionException;
import com.ibm.websphere.ce.cm.StaleStatementException;
import com.ibm.websphere.ce.j2c.ConnectionWaitTimeoutException;
import com.ibm.ws.Transaction.TransactionManagerFactory;
import com.ibm.ws.Transaction.UOWCoordinator;
import com.ibm.ws.Transaction.UOWCurrent;
import com.ibm.ws.rsadapter.exceptions.DataStoreAdapterException;
import com.ibm.ws.rsadapter.spi.WSRdbManagedConnectionImpl;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Properties;
import java.util.logging.Level;
import javax.resource.ResourceException;
import javax.resource.cci.ConnectionFactory;
import javax.resource.spi.ResourceAllocationException;
import javax.sql.DataSource;
import javax.transaction.SystemException;
import javax.transaction.TransactionManager;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;

public class AdapterUtil {
    public static final String NLS_FILE = "IBMDataStoreAdapterNLS";
    public static final String TRACE_GROUP = "RRA";
    private static final TraceComponent tc = Tr.register((Class)AdapterUtil.class, (String)"RRA", (String)"IBMDataStoreAdapterNLS");
    private static final TraceNLS NLS = TraceNLS.getTraceNLS((String)"IBMDataStoreAdapterNLS");
    public static final String WS_SQL_STATE = "WS000";
    public static final String EOLN = System.getProperty("line.separator");
    public static final String INDENT = "                                 ";
    private static final String prepend = "eis/";
    private static final String postpend = "_CMP";
    private static final UOWCurrent uow = TransactionManagerFactory.getUOWCurrent();
    static final TransactionManager tm = TransactionManagerFactory.getTransactionManager();
    static /* synthetic */ Class class$java$lang$Throwable;

    public static String checkName(String string, int n, int n2) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("checkName " + string + ", EJB Mod Ver: " + n + ",EJB CMP Ver: " + n2));
        }
        String string2 = string;
        if (n >= 20) {
            if (n2 >= 2) {
                if (!string.startsWith(prepend) || !string.endsWith(postpend)) {
                    string2 = prepend + string + postpend;
                }
            } else if (n2 == 1 && string.startsWith(prepend) && string.endsWith(postpend)) {
                string2 = string.substring(prepend.length(), string.lastIndexOf(postpend));
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("checkName result: " + string2));
        }
        return string2;
    }

    public static String restoreJndiName(String string) {
        String string2 = string;
        if (string != null) {
            int n = string.indexOf(prepend);
            int n2 = string.indexOf(postpend);
            if (n != -1 && n2 != -1) {
                string2 = string.substring(n += prepend.length(), n2);
            }
        }
        return string2;
    }

    public static final DataStoreAdapterException createDataStoreAdapterException(String string, Object object, Throwable throwable, Class clazz) {
        Object[] objectArray;
        if (object == null) {
            objectArray = null;
        } else if (object instanceof Object[]) {
            objectArray = (Object[])object;
        } else {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = object;
        }
        return new DataStoreAdapterException(string, objectArray, throwable, object == null ? AdapterUtil.getNLSMessage(string) : (object instanceof Object[] ? AdapterUtil.getNLSMessage(string, (Object[])object) : AdapterUtil.getNLSMessage(string, object)), clazz);
    }

    public static XAException createXAException(String string, Object object, int n) {
        XAException xAException = new XAException(object == null ? AdapterUtil.getNLSMessage(string) : AdapterUtil.getNLSMessage(string, object));
        xAException.errorCode = n;
        return xAException;
    }

    public static Throwable getChainedException(Throwable throwable) {
        Method[] methodArray = throwable.getClass().getMethods();
        Throwable throwable2 = null;
        for (int i = 0; i < methodArray.length && throwable2 == null; ++i) {
            if (!(class$java$lang$Throwable == null ? AdapterUtil.class$("java.lang.Throwable") : class$java$lang$Throwable).isAssignableFrom(methodArray[i].getReturnType()) || methodArray[i].getName().equals("fillInStackTrace") || methodArray[i].getParameterTypes().length != 0) continue;
            try {
                throwable2 = (Throwable)methodArray[i].invoke((Object)throwable, null);
                continue;
            }
            catch (Throwable throwable3) {
                // empty catch block
            }
        }
        return throwable2;
    }

    public static String getConcurrencyModeString(int n) {
        switch (n) {
            case 1007: {
                return "CONCUR READ ONLY (" + n + ')';
            }
            case 1008: {
                return "CONCUR UPDATABLE (" + n + ')';
            }
        }
        return "UNKNOWN RESULT SET CONCURRENCY (" + n + ')';
    }

    public static String getConnectionEventString(int n) {
        switch (n) {
            case 1: {
                return "CONNECTION CLOSED (" + n + ')';
            }
            case 2: {
                return "LOCAL TRANSACTION STARTED (" + n + ')';
            }
            case 3: {
                return "LOCAL TRANSACTION COMMITTED (" + n + ')';
            }
            case 4: {
                return "LOCAL TRANSACTION ROLLEDBACK (" + n + ')';
            }
            case 5: {
                return "CONNECTION ERROR OCCURRED (" + n + ')';
            }
            case 900: {
                return "INTERACTION PENDING (" + n + ')';
            }
        }
        return "UNKNOWN CONNECTION EVENT CONSTANT (" + n + ')';
    }

    public static String getConnectionFactoryInterfaceName(Integer n) {
        if (AdapterUtil.match(n, ConnectionFactoryRefBuilder.FACTORY_WSJdbcDataSource)) {
            return DataSource.class.getName();
        }
        if (AdapterUtil.match(n, ConnectionFactoryRefBuilder.FACTORY_WSRdbConnectionFactory)) {
            return ConnectionFactory.class.getName();
        }
        return "UNKNOWN CONNECTION FACTORY TYPE: " + n;
    }

    public static String getFetchDirectionString(int n) {
        switch (n) {
            case 1000: {
                return "FETCH FORWARD (" + n + ')';
            }
            case 1001: {
                return "FETCH REVERSE (" + n + ')';
            }
            case 1002: {
                return "FETCH UNKNOWN (" + n + ')';
            }
        }
        return "UNRECOGNIZED FETCH DIRECTION CONSTANT (" + n + ')';
    }

    public static final int getGlobalTranStatus() {
        int n = 6;
        try {
            n = tm.getStatus();
        }
        catch (SystemException systemException) {
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"Recieving SystemException from TransactionManager, ignore it and change to STATUS_UNKNOWN");
            }
            n = 5;
        }
        return n;
    }

    public static final String getGlobalTranStatusAsString() {
        return AdapterUtil.getGlobalTranStatusString(AdapterUtil.getGlobalTranStatus());
    }

    public static String getGlobalTranStatusString(int n) {
        switch (n) {
            case 0: {
                return "STATUS ACTIVE (" + n + ')';
            }
            case 3: {
                return "STATUS COMMITTED (" + n + ')';
            }
            case 8: {
                return "STATUS COMMITTING (" + n + ')';
            }
            case 1: {
                return "STATUS MARKED ROLLBACK (" + n + ')';
            }
            case 6: {
                return "STATUS NO TRANSACTION (" + n + ')';
            }
            case 2: {
                return "STATUS PREPARED (" + n + ')';
            }
            case 7: {
                return "STATUS PREPARING (" + n + ')';
            }
            case 4: {
                return "STATUS ROLLEDBACK (" + n + ')';
            }
            case 9: {
                return "STATUS ROLLING BACK (" + n + ')';
            }
            case 5: {
                return "STATUS UNKNOWN (" + n + ')';
            }
        }
        return "UNKNOWN GLOBAL TRANSACTION STATUS (" + n + ')';
    }

    public static String getIsolationLevelString(int n) {
        switch (n) {
            case 0: {
                return "NONE (" + n + ')';
            }
            case 1: {
                return "READ UNCOMMITTED (" + n + ')';
            }
            case 2: {
                return "READ COMMITTED (" + n + ')';
            }
            case 4: {
                return "REPEATABLE READ (" + n + ')';
            }
            case 8: {
                return "SERIALIZABLE (" + n + ')';
            }
        }
        return "UNKNOWN ISOLATION LEVEL CONSTANT (" + n + ')';
    }

    public static final String getNLSMessage(String string) {
        return NLS.getString(string, string);
    }

    public static final String getNLSMessage(String string, Locale locale) {
        return locale == null ? AdapterUtil.getNLSMessage(string) : TraceNLS.getFormattedMessage((String)NLS_FILE, (String)string, (Locale)locale, null, (String)string);
    }

    public static final String getNLSMessage(String string, Locale locale, Object object) {
        String string2;
        if (locale == null) {
            string2 = AdapterUtil.getNLSMessage(string, object);
        } else {
            Object[] objectArray;
            if (object instanceof Object[]) {
                objectArray = (Object[])object;
            } else {
                Object[] objectArray2 = new Object[1];
                objectArray = objectArray2;
                objectArray2[0] = object;
            }
            string2 = TraceNLS.getFormattedMessage((String)NLS_FILE, (String)string, (Locale)locale, (Object[])objectArray, (String)string);
        }
        return string2;
    }

    public static final String getNLSMessage(String string, Object object) {
        Object[] objectArray;
        if (object instanceof Object[]) {
            objectArray = (Object[])object;
        } else {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = object;
        }
        return NLS.getFormattedMessage(string, objectArray, string);
    }

    public static String getResultSetTypeString(int n) {
        switch (n) {
            case 1003: {
                return "TYPE FORWARD ONLY (" + n + ')';
            }
            case 1004: {
                return "TYPE SCROLL INSENSITIVE (" + n + ')';
            }
            case 1005: {
                return "TYPE SCROLL SENSITIVE (" + n + ')';
            }
        }
        return "UNKNOWN RESULT SET TYPE CONSTANT (" + n + ')';
    }

    public static String getSQLTypeString(int n) {
        switch (n) {
            case 2003: {
                return "ARRAY (" + n + ')';
            }
            case -5: {
                return "BIGINT (" + n + ')';
            }
            case -2: {
                return "BINARY (" + n + ')';
            }
            case -7: {
                return "BIT (" + n + ')';
            }
            case 2004: {
                return "BLOB (" + n + ')';
            }
            case 1: {
                return "CHAR (" + n + ')';
            }
            case 2005: {
                return "CLOB (" + n + ')';
            }
            case 91: {
                return "DATE (" + n + ')';
            }
            case 3: {
                return "DECIMAL (" + n + ')';
            }
            case 2001: {
                return "DISTINCT (" + n + ')';
            }
            case 8: {
                return "DOUBLE (" + n + ')';
            }
            case 6: {
                return "FLOAT (" + n + ')';
            }
            case 4: {
                return "INTEGER (" + n + ')';
            }
            case 2000: {
                return "JAVA OBJECT (" + n + ')';
            }
            case -4: {
                return "LONGVARBINARY (" + n + ')';
            }
            case -1: {
                return "LONGVARCHAR (" + n + ')';
            }
            case 0: {
                return "NULL (" + n + ')';
            }
            case 2: {
                return "NUMERIC (" + n + ')';
            }
            case 1111: {
                return "OTHER (" + n + ')';
            }
            case 7: {
                return "REAL (" + n + ')';
            }
            case 2006: {
                return "REF (" + n + ')';
            }
            case 5: {
                return "SMALLINT (" + n + ')';
            }
            case 2002: {
                return "STRUCT (" + n + ')';
            }
            case 92: {
                return "TIME (" + n + ')';
            }
            case 93: {
                return "TIMESTAMP (" + n + ')';
            }
            case -6: {
                return "TINYINT (" + n + ')';
            }
            case -3: {
                return "VARBINARY (" + n + ')';
            }
            case 12: {
                return "VARCHAR (" + n + ')';
            }
        }
        return "UNKNOWN SQL TYPE (" + n + ')';
    }

    public static String getXAExceptionCodeString(int n) {
        switch (n) {
            case 107: {
                return "XA_RBTRANSIENT (" + n + ')';
            }
            case 100: {
                return "XA_RBROLLBACK (" + n + ')';
            }
            case 7: {
                return "XA_HEURCOM (" + n + ')';
            }
            case 8: {
                return "XA_HEURHAZ (" + n + ')';
            }
            case 5: {
                return "XA_HEURMIX (" + n + ')';
            }
            case 6: {
                return "XA_HEURRB (" + n + ')';
            }
            case 9: {
                return "XA_NOMIGRATE (" + n + ')';
            }
            case 101: {
                return "XA_RBCOMMFAIL (" + n + ')';
            }
            case 102: {
                return "XA_RBDEADLOCK (" + n + ')';
            }
            case 103: {
                return "XA_RBINTEGRITY (" + n + ')';
            }
            case 104: {
                return "XA_RBOTHER (" + n + ')';
            }
            case 105: {
                return "XA_RBPROTO (" + n + ')';
            }
            case 106: {
                return "XA_RBTIMEOUT (" + n + ')';
            }
            case 3: {
                return "XA_RDONLY (" + n + ')';
            }
            case 4: {
                return "XA_RETRY (" + n + ')';
            }
            case -2: {
                return "XAER_ASYNC (" + n + ')';
            }
            case -8: {
                return "XAER_DUPID (" + n + ')';
            }
            case -5: {
                return "XAER_INVAL (" + n + ')';
            }
            case -4: {
                return "XAER_NOTA (" + n + ')';
            }
            case -9: {
                return "XAER_OUTSIDE (" + n + ')';
            }
            case -6: {
                return "XAER_PROTO (" + n + ')';
            }
            case -3: {
                return "XAER_RMERR (" + n + ')';
            }
            case -7: {
                return "XAER_RMFAIL (" + n + ')';
            }
        }
        return "UNKNOWN XA EXCEPTION CODE (" + n + ')';
    }

    public static String getXAResourceEndFlagString(int n) {
        switch (n) {
            case 0x20000000: {
                return "TMFAIL (" + n + ')';
            }
            case 0x4000000: {
                return "TMSUCCESS (" + n + ')';
            }
            case 0x2000000: {
                return "TMSUSPEND (" + n + ')';
            }
        }
        return "UNKNOWN XA RESOURCE END FLAG (" + n + ')';
    }

    public static String getXAResourceRecoverFlagString(int n) {
        switch (n) {
            case 0x800000: {
                return "TMENDRSCAN (" + n + ')';
            }
            case 0: {
                return "TMNOFLAGS (" + n + ')';
            }
            case 0x1000000: {
                return "TMSTARTRSCAN (" + n + ')';
            }
            case 0x1800000: {
                return "TMSTARTRSCAN + TMENDRSCAN (" + n + ')';
            }
        }
        return "UNKNOWN XA RESOURCE RECOVER FLAG (" + n + ')';
    }

    public static String getXAResourceStartFlagString(int n) {
        switch (n) {
            case 0x200000: {
                return "TMJOIN (" + n + ')';
            }
            case 0: {
                return "TMNOFLAGS (" + n + ')';
            }
            case 0x8000000: {
                return "TMRESUME (" + n + ')';
            }
        }
        return "UNKNOWN XA RESOURCE START FLAG (" + n + ')';
    }

    public static String getXAResourceVoteString(int n) {
        switch (n) {
            case 0: {
                return "XA_OK (" + n + ')';
            }
            case 3: {
                return "XA_RDONLY (" + n + ')';
            }
        }
        return "UNKNOWN XA RESOURCE VOTE (" + n + ')';
    }

    public static Properties hidePassword(Properties properties) {
        Properties properties2 = properties;
        if (properties2 != null && (properties2 = (Properties)properties2.clone()).containsKey("password")) {
            properties2.setProperty("password", "******");
        }
        return properties2;
    }

    public static final boolean inGlobalTransaction() {
        UOWCoordinator uOWCoordinator = uow.getUOWCoord();
        return uOWCoordinator != null && uOWCoordinator.isGlobal();
    }

    public static final boolean match(Object object, Object object2) {
        return object == object2 || object != null && object.equals(object2);
    }

    public static String sqlWarningToString(SQLWarning sQLWarning) {
        if (sQLWarning == null) {
            return null;
        }
        StringWriter stringWriter = new StringWriter();
        sQLWarning.printStackTrace(new PrintWriter(stringWriter));
        StringBuffer stringBuffer = new StringBuffer(stringWriter.toString());
        SQLWarning sQLWarning2 = sQLWarning.getNextWarning();
        if (sQLWarning2 != null && sQLWarning2 != sQLWarning) {
            stringBuffer.append("-------- linked warning -------").append(EOLN).append(AdapterUtil.sqlWarningToString(sQLWarning2));
        }
        return stringBuffer.toString();
    }

    public static String stackTraceToString(Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        throwable.printStackTrace(new PrintWriter(stringWriter));
        StringBuffer stringBuffer = new StringBuffer(stringWriter.toString());
        Throwable throwable2 = AdapterUtil.getChainedException(throwable);
        if (throwable2 != null && throwable2 != throwable) {
            stringBuffer.append("-------- chained exception -------").append(EOLN).append(AdapterUtil.stackTraceToString(throwable2));
        }
        return stringBuffer.toString();
    }

    public static DataStoreAdapterException translateSQLException(SQLException sQLException, WSRdbManagedConnectionImpl wSRdbManagedConnectionImpl, boolean bl, Class clazz) {
        DataStoreAdapterException dataStoreAdapterException = new DataStoreAdapterException("DSA_ERROR", sQLException, clazz);
        dataStoreAdapterException = wSRdbManagedConnectionImpl.getManagedConnectionFactory().getInternalDataStoreHelper().mapException(dataStoreAdapterException);
        if (dataStoreAdapterException.getLinkedException() instanceof StaleStatementException) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"remapping StaleStatementException to StaleConnectionException");
            }
            dataStoreAdapterException.setLinkedException((Exception)new StaleConnectionException(((SQLException)dataStoreAdapterException.getLinkedException()).getNextException()));
        } else if (bl && dataStoreAdapterException.isConnectionError() && wSRdbManagedConnectionImpl != null) {
            wSRdbManagedConnectionImpl.processConnectionErrorOccurredEvent(null, (Exception)((Object)dataStoreAdapterException));
        }
        return dataStoreAdapterException;
    }

    public static String toErrorMessage(Throwable throwable) {
        String string = throwable.getMessage();
        StringBuffer stringBuffer = new StringBuffer(string == null ? "" : string);
        Throwable throwable2 = AdapterUtil.getChainedException(throwable);
        if (throwable2 != null && throwable2 != throwable) {
            stringBuffer.append(" Chained ").append(throwable2.getClass().getName()).append(": ").append(AdapterUtil.toErrorMessage(throwable2));
        }
        return stringBuffer.toString();
    }

    public static Properties toProperties(String string) throws IOException {
        Properties properties = new Properties();
        properties.load(new ByteArrayInputStream(string.replaceAll(";", EOLN).getBytes()));
        return properties;
    }

    public static SQLException toSQLException(ResourceException resourceException) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"toSQLException", (Object)((Object)resourceException));
        }
        SQLException sQLException = null;
        Throwable throwable = resourceException;
        while (throwable != null) {
            if (throwable instanceof SQLException) {
                sQLException = (SQLException)throwable;
                break;
            }
            if (throwable instanceof ResourceAllocationException && throwable.getMessage().indexOf("DSRA1110E") >= 0) {
                sQLException = new com.ibm.websphere.ce.cm.ConnectionWaitTimeoutException(throwable.getMessage());
                sQLException.initCause(resourceException);
                break;
            }
            if (throwable instanceof ConnectionWaitTimeoutException) {
                sQLException = new com.ibm.websphere.ce.cm.ConnectionWaitTimeoutException(throwable.getMessage());
                sQLException.initCause(resourceException);
                break;
            }
            throwable = AdapterUtil.getChainedException(throwable);
        }
        if (sQLException == null) {
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"Converting ResourceException to a SQLException");
            }
            sQLException = new SQLException(resourceException.getMessage());
            sQLException.initCause(resourceException);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"toSQLException", (Object)new Object[]{AdapterUtil.getStackTraceWithState(sQLException)});
        }
        return sQLException;
    }

    public static SQLException toSQLException(Throwable throwable) {
        if (throwable instanceof SQLException) {
            return (SQLException)throwable;
        }
        SQLException sQLException = new SQLException(throwable.getClass().getName() + ": " + throwable.getMessage());
        sQLException.initCause(throwable);
        return sQLException;
    }

    public static String toString(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer();
        if (byArray != null) {
            for (int i = 0; i < byArray.length; ++i) {
                int n = byArray[i] < 0 ? 256 + byArray[i] : byArray[i];
                stringBuffer.append(Integer.toHexString(n / 16)).append(Integer.toHexString(n % 16)).append(' ');
            }
        }
        return new String(stringBuffer);
    }

    public static String toString(Object object) {
        if (object == null) {
            return null;
        }
        return object.getClass().getName() + '@' + Integer.toHexString(System.identityHashCode(object));
    }

    public static String toString(Xid xid) {
        StringBuffer stringBuffer = new StringBuffer();
        if (xid != null) {
            stringBuffer.append(AdapterUtil.toString((Object)xid)).append(EOLN).append(INDENT).append(xid).append(EOLN).append(INDENT).append("Global Transaction ID: ").append(AdapterUtil.toString(xid.getGlobalTransactionId())).append(EOLN).append(INDENT).append("Branch Qualifier:      ").append(AdapterUtil.toString(xid.getBranchQualifier())).append(EOLN).append(INDENT).append("Format ID:             ").append(xid.getFormatId());
        }
        return new String(stringBuffer);
    }

    public static String getLockTypeAsString(int n) {
        switch (n) {
            case 1: {
                return "LOCKTYPE_SELECT (" + n + ')';
            }
            case 2: {
                return "LOCKTYPE_SELECT_FOR_UPDATE (" + n + ')';
            }
            case 3: {
                return "LOCKTYPE_SELECT_FOR_UPDATE_WITH_RS (" + n + ')';
            }
            case 4: {
                return "LOCKTYPE_SELECT_FOR_UPDATE_WITH_RR (" + n + ')';
            }
        }
        return "UNKNOWN LOCK TYPE (" + n + ')';
    }

    public static String getHelperTypeAsString(int n) {
        switch (n) {
            case -1: {
                return "CUSTOM_HELPER (" + n + ')';
            }
            case 0: {
                return "CLOUDSCAPE_HELPER (" + n + ')';
            }
            case 1: {
                return "DB2_HELPER (" + n + ')';
            }
            case 2: {
                return "DB2_400_HELPER (" + n + ')';
            }
            case 3: {
                return "DB2_390_HELPER (" + n + ')';
            }
            case 4: {
                return "DB2_UNIVERSAL_HELPER (" + n + ')';
            }
            case 5: {
                return "GENERIC_HELPER (" + n + ')';
            }
            case 6: {
                return "DATADIRECT_HELPER (" + n + ')';
            }
            case 7: {
                return "CONNECTJDBC_HELPER (" + n + ')';
            }
            case 8: {
                return "WSCONNECTJDBC_HELPER (" + n + ')';
            }
            case 9: {
                return "SEQUELINK_HELPER (" + n + ')';
            }
            case 10: {
                return "MSSQL_HELPER (" + n + ')';
            }
            case 11: {
                return "SYBASE_HELPER (" + n + ')';
            }
            case 12: {
                return "SYBASE11_HELPER (" + n + ')';
            }
            case 13: {
                return "ORACLE_HELPER (" + n + ')';
            }
            case 14: {
                return "INFORMIX_HELPER (" + n + ')';
            }
            case 15: {
                return "DB2_390_LOCAL_HELPER (" + n + ')';
            }
            case 16: {
                return "CLOUDSCAPE_NETWORK_SERVER_HELPER (" + n + ')';
            }
            case 17: {
                return "ORACLE_10G_HELPER (" + n + ')';
            }
        }
        return "UNKNOWN HELPER TYPE (" + n + ')';
    }

    public static StringBuffer getStackTraceWithState(SQLException sQLException) {
        SQLException sQLException2 = sQLException;
        boolean bl = false;
        StringBuffer stringBuffer = new StringBuffer(EOLN);
        do {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            sQLException2.printStackTrace(printWriter);
            if (bl) {
                stringBuffer.append("---- Begin backtrace for Nested Throwables").append(EOLN);
            }
            stringBuffer.append("SQL STATE:  " + sQLException2.getSQLState()).append(EOLN);
            stringBuffer.append("ERROR CODE: " + sQLException2.getErrorCode()).append(EOLN);
            stringBuffer.append(stringWriter.toString());
            bl = true;
        } while ((sQLException2 = sQLException2.getNextException()) != null);
        return stringBuffer;
    }

    public static String getResultSetCloseString(int n) {
        switch (n) {
            case 3: {
                return "CLOSE ALL RESULTS (" + n + ')';
            }
            case 1: {
                return "CLOSE CURRENT RESULT (" + n + ')';
            }
            case 2: {
                return "KEEP CURRENT RESULT (" + n + ')';
            }
        }
        return "UNKNOWN CLOSE RESULTSET CONSTANT (" + n + ')';
    }

    public static String getCursorHoldabilityString(int n) {
        switch (n) {
            case 2: {
                return "CLOSE CURSORS AT COMMIT (" + n + ')';
            }
            case 1: {
                return "HOLD CURSORS OVER COMMIT (" + n + ')';
            }
            case 0: {
                return "DEFAULT CURSOR HOLDABILITY VALUE (" + n + ')';
            }
        }
        return "UNKNOWN CURSOR HOLDABILITY CONSTANT (" + n + ')';
    }

    public static String getAutoGeneratedKeyString(int n) {
        switch (n) {
            case 2: {
                return "NO GENERATED KEYS (" + n + ')';
            }
            case 1: {
                return "RETURN GENERATED KEYS (" + n + ')';
            }
        }
        return "UNKNOWN AUTO GENERATED KEYS CONSTANT (" + n + ')';
    }

    public static Object[] populateArrayForTrace(Object[] objectArray) {
        if (objectArray == null) {
            return null;
        }
        int n = objectArray.length;
        ArrayList<Object> arrayList = new ArrayList<Object>(n + 2);
        for (int i = 0; i < n; ++i) {
            Object object = objectArray[i];
            if (object == null) {
                arrayList.add(null);
                continue;
            }
            if (object.getClass().isArray()) {
                int n2;
                int n3;
                Object[] objectArray2;
                arrayList.add("{");
                if (object.getClass().getComponentType().isPrimitive()) {
                    if (object.getClass().getComponentType() == Integer.TYPE) {
                        objectArray2 = (int[])object;
                        n3 = objectArray2.length;
                        for (n2 = 0; n2 < n3; ++n2) {
                            arrayList.add(new Integer((int)objectArray2[n2]));
                        }
                    } else if (object.getClass().getComponentType() == Float.TYPE) {
                        objectArray2 = (float[])object;
                        n3 = objectArray2.length;
                        for (n2 = 0; n2 < n3; ++n2) {
                            arrayList.add(new Float((float)objectArray2[n2]));
                        }
                    } else if (object.getClass().getComponentType() == Double.TYPE) {
                        objectArray2 = (double[])object;
                        n3 = objectArray2.length;
                        for (n2 = 0; n2 < n3; ++n2) {
                            arrayList.add(new Double((double)objectArray2[n2]));
                        }
                    } else if (object.getClass().getComponentType() == Byte.TYPE) {
                        objectArray2 = (byte[])object;
                        n3 = objectArray2.length;
                        for (n2 = 0; n2 < n3; ++n2) {
                            arrayList.add(new Byte((byte)objectArray2[n2]));
                        }
                    } else if (object.getClass().getComponentType() == Short.TYPE) {
                        objectArray2 = (short[])object;
                        n3 = objectArray2.length;
                        for (n2 = 0; n2 < n3; ++n2) {
                            arrayList.add(new Short((short)objectArray2[n2]));
                        }
                    } else if (object.getClass().getComponentType() == Long.TYPE) {
                        objectArray2 = (long[])object;
                        n3 = objectArray2.length;
                        for (n2 = 0; n2 < n3; ++n2) {
                            arrayList.add(new Long((long)objectArray2[n2]));
                        }
                    } else if (object.getClass().getComponentType() == Boolean.TYPE) {
                        objectArray2 = (boolean[])object;
                        n3 = objectArray2.length;
                        for (n2 = 0; n2 < n3; ++n2) {
                            arrayList.add(new Boolean((boolean)objectArray2[n2]));
                        }
                    } else if (object.getClass().getComponentType() == Character.TYPE) {
                        objectArray2 = (char[])object;
                        n3 = objectArray2.length;
                        for (n2 = 0; n2 < n3; ++n2) {
                            arrayList.add(new Character((char)objectArray2[n2]));
                        }
                    }
                } else {
                    objectArray2 = (Object[])object;
                    n3 = objectArray2.length;
                    for (n2 = 0; n2 < n3; ++n2) {
                        arrayList.add(objectArray2[n2]);
                    }
                }
                arrayList.add("}");
                continue;
            }
            arrayList.add(object);
        }
        return arrayList.toArray();
    }

    public static SQLException mapSQLException(SQLException sQLException, WSRdbManagedConnectionImpl wSRdbManagedConnectionImpl) {
        sQLException = wSRdbManagedConnectionImpl.getManagedConnectionFactory().getDataStoreHelper().mapException(sQLException);
        if (wSRdbManagedConnectionImpl != null && sQLException instanceof StaleConnectionException) {
            wSRdbManagedConnectionImpl.processConnectionErrorOccurredEvent(null, sQLException);
        }
        return sQLException;
    }

    public static Level getLevelBasedOnName(String string) {
        Level level = Level.INFO;
        if (string == null) {
            return level;
        }
        char c = string.charAt(0);
        switch (c) {
            case 'I': 
            case 'i': {
                level = Level.INFO;
                break;
            }
            case 'A': 
            case 'a': {
                level = Level.ALL;
                break;
            }
            case 'S': 
            case 's': {
                level = Level.SEVERE;
                break;
            }
            case 'W': 
            case 'w': {
                level = Level.WARNING;
                break;
            }
            case 'C': 
            case 'c': {
                level = Level.CONFIG;
                break;
            }
            case 'F': 
            case 'f': {
                if (string.equalsIgnoreCase("fine")) {
                    level = Level.FINE;
                }
                if (string.equalsIgnoreCase("finer")) {
                    level = Level.FINER;
                }
                if (!string.equalsIgnoreCase("finest")) break;
                level = Level.FINEST;
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"The level returned is: ", (Object)level);
        }
        return level;
    }
}

