/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.logging;

import com.ibm.websphere.logging.WsLevel;
import com.ibm.websphere.ras.RasMessage;
import com.ibm.ws.logging.LevelConstants;
import com.ibm.ws.logging.TraceLogFormatter;
import java.util.Locale;
import java.util.logging.LogRecord;

public class LogRecordRasMessageAdapter
implements RasMessage {
    private static final long serialVersionUID = -1334299662778779442L;
    private LogRecord ivLogRecord;

    public LogRecordRasMessageAdapter(LogRecord logRecord) {
        this.ivLogRecord = logRecord;
    }

    public String getLocalizedMessage(Locale locale) {
        return TraceLogFormatter.formatMessage(this.ivLogRecord, locale, 0);
    }

    public String getMessageKey() {
        return this.ivLogRecord.getMessage();
    }

    public String getMessageOriginator() {
        return this.ivLogRecord.getLoggerName();
    }

    public String getMessageSeverity() {
        int n = this.ivLogRecord.getLevel().intValue();
        if (n == WsLevel.LEVEL_VALUES[LevelConstants.DISTINCT_LEVELS[15]]) {
            return "Fatal";
        }
        if (n == WsLevel.LEVEL_VALUES[LevelConstants.DISTINCT_LEVELS[13]]) {
            return "Error";
        }
        if (n == WsLevel.LEVEL_VALUES[LevelConstants.DISTINCT_LEVELS[12]]) {
            return "Warning";
        }
        if (n == WsLevel.LEVEL_VALUES[LevelConstants.DISTINCT_LEVELS[11]]) {
            return "Audit";
        }
        if (n == WsLevel.LEVEL_VALUES[LevelConstants.DISTINCT_LEVELS[10]]) {
            return "Informational";
        }
        if (n == WsLevel.LEVEL_VALUES[LevelConstants.DISTINCT_LEVELS[9]]) {
            return "Informational";
        }
        if (n == WsLevel.LEVEL_VALUES[LevelConstants.DISTINCT_LEVELS[8]]) {
            return "Informational";
        }
        return "Unknown";
    }

    public String getThreadId() {
        return Integer.toHexString(this.ivLogRecord.getThreadID());
    }

    public long getTimeStamp() {
        return this.ivLogRecord.getMillis();
    }

    public String getResourceBundleName() {
        return this.ivLogRecord.getResourceBundleName();
    }
}

