/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ras.mgr;

import com.ibm.ras.RASConstants;
import com.ibm.ras.RASIOException;
import com.ibm.ras.RASUtil;
import com.ibm.ras.mgr.RASBaseGroup;
import com.ibm.ras.mgr.RASConfig;
import com.ibm.ras.mgr.RASGroup;
import com.ibm.ras.mgr.RASIDataStore;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.util.Properties;
import java.util.StringTokenizer;

public class RASPropertyDataStore
implements RASConstants,
RASIDataStore {
    private static final String S = "(C) Copyright IBM Corp. 1998.";
    private Properties props;

    public RASPropertyDataStore(Properties properties) {
        this.setPropertyDataStore(properties);
    }

    public RASPropertyDataStore(String string) throws RASIOException {
        this.setPropertyDataStore(new Properties());
        try {
            BufferedInputStream bufferedInputStream = new BufferedInputStream(this.getClass().getResourceAsStream(string));
            this.props.load(bufferedInputStream);
            bufferedInputStream.close();
        }
        catch (Exception exception) {
            throw new RASIOException(RASUtil.rasMsgs.getMessage("ERR_PROP_IO", string));
        }
    }

    public Properties getPropertyDataStore() {
        return this.props;
    }

    public void setPropertyDataStore(Properties properties) {
        this.props = properties;
    }

    public RASBaseGroup restoreConfig() throws RASIOException {
        RASBaseGroup rASBaseGroup = new RASBaseGroup();
        this.addRASObjects("msgLoggers", rASBaseGroup);
        this.addRASObjects("trcLoggers", rASBaseGroup);
        this.addRASObjects("handlers", rASBaseGroup);
        this.addRASObjects("formatters", rASBaseGroup);
        String string = this.props.getProperty("defaultHandlerNames");
        if (string != null) {
            rASBaseGroup.setDefaultHandlers(string);
        }
        if ((string = this.props.getProperty("defaultMessageHandlerNames")) != null) {
            rASBaseGroup.setDefaultMessageHandlers(string);
        }
        if ((string = this.props.getProperty("defaultTraceHandlerNames")) != null) {
            rASBaseGroup.setDefaultTraceHandlers(string);
        }
        return rASBaseGroup;
    }

    public void saveConfig(RASBaseGroup rASBaseGroup) throws RASIOException {
    }

    private void addRASObjects(String string, RASBaseGroup rASBaseGroup) throws RASIOException {
        String string2 = this.props.getProperty(string);
        if (string2 != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string2);
            while (stringTokenizer.hasMoreElements()) {
                String string3 = stringTokenizer.nextToken();
                if (string3 == null) continue;
                string3 = "/" + string3.replace('.', '/') + ".properties";
                Properties properties = new Properties();
                try {
                    RASGroup rASGroup;
                    BufferedInputStream bufferedInputStream = new BufferedInputStream(this.getClass().getResourceAsStream(string3));
                    properties.load(bufferedInputStream);
                    bufferedInputStream.close();
                    String string4 = properties.getProperty("group");
                    if (string4 == null || string4.equals("")) {
                        rASGroup = rASBaseGroup;
                    } else {
                        rASGroup = rASBaseGroup.getGroup(string4);
                        if (rASGroup == null) {
                            rASGroup = new RASGroup(string4);
                            rASBaseGroup.addGroup(rASGroup);
                        }
                    }
                    if (string.equals("msgLoggers")) {
                        rASGroup.addMessageLoggerConfig(new RASConfig(properties));
                        continue;
                    }
                    if (string.equals("trcLoggers")) {
                        rASGroup.addTraceLoggerConfig(new RASConfig(properties));
                        continue;
                    }
                    if (string.equals("handlers")) {
                        rASGroup.addHandlerConfig(new RASConfig(properties));
                        continue;
                    }
                    if (!string.equals("formatters")) continue;
                    rASGroup.addFormatterConfig(new RASConfig(properties));
                }
                catch (IOException iOException) {
                    throw new RASIOException(RASUtil.rasMsgs.getMessage("ERR_PROP_IO", string3));
                }
                catch (NullPointerException nullPointerException) {
                    throw new RASIOException(RASUtil.rasMsgs.getMessage("ERR_PROP_NOT_FOUND", string3));
                }
            }
        }
    }
}

