/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.ras;

import com.ibm.ejs.ras.RasException;
import com.ibm.ejs.ras.RasProperties;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceException;
import com.ibm.ws.bootstrap.WSLauncher;
import com.ibm.ws.bootstrap.WsLogManager;
import com.ibm.ws.security.util.AccessController;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.WriteAbortedException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.rmi.RemoteException;
import java.rmi.server.ServerCloneException;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.sql.SQLException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import javax.ejb.EJBException;
import javax.jms.JMSException;
import javax.mail.MessagingException;
import javax.naming.NamingException;
import javax.resource.ResourceException;
import javax.servlet.ServletException;
import javax.servlet.jsp.JspException;
import org.omg.CORBA.portable.UnknownException;
import org.xml.sax.SAXException;

public class RasHelper {
    private static TimeZone sysTimeZone = TimeZone.getDefault();
    private static final int MAX_BYTES = 256;
    private static String svProcessId = "";
    private static String svVersion = "";
    private static String svServerName = "";
    private static boolean svServer = false;
    private static char[] hexChars = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static String svFileNameSuffix = null;

    public static String getProcessId() {
        return svProcessId;
    }

    public static String getVersionId() {
        return svVersion;
    }

    public static boolean isServer() {
        return svServer;
    }

    public static void setServer() {
        svServer = true;
        LogManager logManager = LogManager.getLogManager();
        if (logManager instanceof WsLogManager) {
            ((WsLogManager)logManager).disableReset();
        }
        if (!WSLauncher.isZOS()) {
            Tr.createServerStartupListener();
        }
    }

    public static String getServerName() {
        return svServerName;
    }

    public static void setServerAttributes(String string, String string2, String string3) {
        if (string != null) {
            svServerName = string;
        }
        if (string2 != null) {
            svProcessId = string2;
        }
        if (string3 != null) {
            svVersion = string3;
        }
    }

    public static void setFileNameSuffix(String string) {
        svFileNameSuffix = string;
    }

    public static final String throwableToString(Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        RasHelper.printStackTrace(throwable, printWriter);
        return stringWriter.toString();
    }

    private static final void printStackTrace(Throwable throwable, PrintWriter printWriter) {
        if (throwable == null) {
            printWriter.println("none");
            return;
        }
        throwable.printStackTrace(printWriter);
        if (throwable instanceof TraceException) {
            TraceException traceException = (TraceException)((Object)throwable);
            Throwable[] throwableArray = traceException.getSubexceptions();
            if (throwableArray == null) {
                return;
            }
            for (int i = 0; i < throwableArray.length; ++i) {
                printWriter.println("----- Begin backtrace for subexception[" + i + "]");
                RasHelper.printStackTrace(throwableArray[i], printWriter);
            }
            return;
        }
        boolean bl = true;
        Throwable throwable2 = null;
        while (bl) {
            throwable2 = throwable.getCause();
            if (throwable2 != null) {
                throwable = throwable2;
                continue;
            }
            throwable2 = RasHelper.getNestedThrowable(throwable);
            if (throwable2 == null) {
                return;
            }
            if (RasHelper.pstRecursesOnNested(throwable)) {
                throwable = throwable2;
                continue;
            }
            bl = false;
        }
        printWriter.println("---- Begin backtrace for Nested Throwables");
        RasHelper.printStackTrace(throwable2, printWriter);
    }

    private static final Throwable getNestedThrowable(Throwable throwable) {
        if (throwable instanceof UnknownException) {
            return ((UnknownException)throwable).originalEx;
        }
        if (throwable instanceof RemoteException) {
            return ((RemoteException)throwable).detail;
        }
        if (throwable instanceof InvocationTargetException) {
            return ((InvocationTargetException)throwable).getTargetException();
        }
        if (throwable instanceof NamingException) {
            return ((NamingException)throwable).getRootCause();
        }
        if (throwable instanceof EJBException) {
            return ((EJBException)throwable).getCausedByException();
        }
        if (throwable instanceof SQLException) {
            return ((SQLException)throwable).getNextException();
        }
        if (throwable instanceof MessagingException) {
            return ((MessagingException)throwable).getNextException();
        }
        if (throwable instanceof SAXException) {
            return ((SAXException)throwable).getException();
        }
        if (throwable instanceof JspException) {
            return ((JspException)throwable).getRootCause();
        }
        if (throwable instanceof ServletException) {
            return ((ServletException)throwable).getRootCause();
        }
        if (throwable instanceof ResourceException) {
            return ((ResourceException)throwable).getLinkedException();
        }
        if (throwable instanceof JMSException) {
            return ((JMSException)throwable).getLinkedException();
        }
        if (throwable instanceof UndeclaredThrowableException) {
            return ((UndeclaredThrowableException)throwable).getUndeclaredThrowable();
        }
        if (throwable instanceof WriteAbortedException) {
            return ((WriteAbortedException)throwable).detail;
        }
        if (throwable instanceof ServerCloneException) {
            return ((ServerCloneException)throwable).detail;
        }
        if (throwable instanceof PrivilegedActionException) {
            return ((PrivilegedActionException)throwable).getException();
        }
        return null;
    }

    private static final boolean pstRecursesOnNested(Throwable throwable) {
        if (throwable instanceof UnknownException) {
            return false;
        }
        if (throwable instanceof MessagingException) {
            return false;
        }
        if (throwable instanceof SAXException) {
            return false;
        }
        if (throwable instanceof JspException) {
            return false;
        }
        if (throwable instanceof ServletException) {
            return false;
        }
        if (throwable instanceof NamingException) {
            return false;
        }
        if (throwable instanceof SQLException) {
            return false;
        }
        return !(throwable instanceof JMSException);
    }

    static String[] split(String string, int n) {
        if (string == null || string.equals("")) {
            return new String[0];
        }
        int n2 = 0;
        int n3 = 0;
        while (true) {
            n3 = string.indexOf(n, n3);
            ++n2;
            if (n3 == -1) break;
            ++n3;
        }
        String[] stringArray = new String[n2];
        int n4 = 0;
        int n5 = string.indexOf(n, 0);
        for (int i = 0; i < n2; ++i) {
            stringArray[i] = i + 1 == n2 ? string.substring(n4) : string.substring(n4, n5);
            n4 = n5 + 1;
            n5 = string.indexOf(n, n4);
        }
        return stringArray;
    }

    static final String peelQuotes(String string) {
        if (string == null || string.equals("")) {
            return null;
        }
        if (string.startsWith("\"")) {
            string = string.substring(1);
        }
        if (string.endsWith("\"")) {
            string = string.substring(0, string.length() - 1);
        }
        if (string.equals("")) {
            return null;
        }
        return string;
    }

    static String[] primitiveArrayToString(Object object) {
        if (Byte.TYPE.equals(object.getClass().getComponentType())) {
            return new String[]{RasHelper.byteArrayToHexString((byte[])object)};
        }
        if (Integer.TYPE.equals(object.getClass().getComponentType())) {
            int[] nArray = (int[])object;
            String[] stringArray = new String[nArray.length];
            for (int i = nArray.length - 1; i >= 0; --i) {
                stringArray[i] = Integer.toString(nArray[i]);
            }
            return stringArray;
        }
        if (Short.TYPE.equals(object.getClass().getComponentType())) {
            short[] sArray = (short[])object;
            String[] stringArray = new String[sArray.length];
            for (int i = sArray.length - 1; i >= 0; --i) {
                stringArray[i] = Short.toString(sArray[i]);
            }
            return stringArray;
        }
        if (Long.TYPE.equals(object.getClass().getComponentType())) {
            long[] lArray = (long[])object;
            String[] stringArray = new String[lArray.length];
            for (int i = lArray.length - 1; i >= 0; --i) {
                stringArray[i] = Long.toString(lArray[i]);
            }
            return stringArray;
        }
        if (Float.TYPE.equals(object.getClass().getComponentType())) {
            float[] fArray = (float[])object;
            String[] stringArray = new String[fArray.length];
            for (int i = fArray.length - 1; i >= 0; --i) {
                stringArray[i] = Float.toString(fArray[i]);
            }
            return stringArray;
        }
        if (Double.TYPE.equals(object.getClass().getComponentType())) {
            double[] dArray = (double[])object;
            String[] stringArray = new String[dArray.length];
            for (int i = dArray.length - 1; i >= 0; --i) {
                stringArray[i] = Double.toString(dArray[i]);
            }
            return stringArray;
        }
        if (Character.TYPE.equals(object.getClass().getComponentType())) {
            char[] cArray = (char[])object;
            String[] stringArray = new String[cArray.length];
            for (int i = cArray.length - 1; i >= 0; --i) {
                stringArray[i] = "" + cArray[i] + "";
            }
            return stringArray;
        }
        if (Boolean.TYPE.equals(object.getClass().getComponentType())) {
            boolean[] blArray = (boolean[])object;
            String[] stringArray = new String[blArray.length];
            for (int i = blArray.length - 1; i >= 0; --i) {
                stringArray[i] = Boolean.toString(blArray[i]);
            }
            return stringArray;
        }
        return new String[]{"Illegal trace argument: array of " + object.getClass().getComponentType()};
    }

    static String byteArrayToHexString(byte[] byArray) {
        int n = byArray.length > 256 ? 256 : byArray.length;
        StringBuffer stringBuffer = new StringBuffer(n * 2);
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(hexChars[byArray[i] >> 4 & 0xF]);
            stringBuffer.append(hexChars[byArray[i] & 0xF]);
        }
        if (n != byArray.length) {
            stringBuffer.append("...");
        }
        return new String(stringBuffer);
    }

    static DateFormat getBasicDateFormatter() {
        DateFormat dateFormat = DateFormat.getDateTimeInstance(3, 2);
        if (dateFormat instanceof SimpleDateFormat) {
            SimpleDateFormat simpleDateFormat = (SimpleDateFormat)dateFormat;
            String string = simpleDateFormat.toPattern();
            int n = string.length();
            int n2 = string.lastIndexOf(115) + 1;
            String string2 = string.substring(0, n2) + ":SSS z";
            if (n2 < n) {
                string2 = string2 + string.substring(n2, n);
            }
            string2 = string2.replace('h', 'H');
            string2 = string2.replace('K', 'H');
            string2 = string2.replace('k', 'H');
            string2 = string2.replace('a', ' ');
            string2 = string2.trim();
            simpleDateFormat.applyPattern(string2);
            dateFormat = simpleDateFormat;
        } else {
            dateFormat = new SimpleDateFormat("yy.MM.dd HH:mm:ss:SSS z");
        }
        if (sysTimeZone != null) {
            dateFormat.setTimeZone(sysTimeZone);
        }
        return dateFormat;
    }

    static String generateOutputFileName(String string, String string2, TraceComponent traceComponent) throws RasException {
        String string3 = null;
        if (string == null || string.equals("")) {
            string3 = RasHelper.generateFilename(string2);
            Tr.warning(traceComponent, "MSG_INVALID_FILENAME", new Object[]{string, string2, string3});
        } else {
            string3 = string.trim();
        }
        if (WSLauncher.isZOS() && svFileNameSuffix != null) {
            int n = string3.lastIndexOf(46);
            string3 = n == -1 ? string3 + '.' + svFileNameSuffix : string3.substring(0, n) + '.' + svFileNameSuffix + string3.substring(n);
        }
        File file = new File(string3);
        string3 = file.getAbsolutePath();
        RasHelper.validateFileName(string3);
        return string3;
    }

    static void validateFileName(String string) throws RasException {
        File file = new File(string);
        String string2 = file.getName();
        if (string2 == null || string2.equals("")) {
            throw new RasException("File name " + string + " does not have a usable name qualifier");
        }
        String string3 = null;
        if (RasHelper.fileExists(file)) {
            string3 = file.getParent();
        } else {
            string3 = file.getParent();
            if (string3 == null) {
                String string4 = file.getAbsolutePath();
                int n = string4.lastIndexOf(File.separator);
                if (n == -1) {
                    throw new RasException("Incoherent file name of " + string);
                }
                string3 = string4.substring(0, n);
                file = new File(string3);
            } else {
                file = new File(string3);
                if (!RasHelper.fileExists(file) && !RasHelper.makeDirectories(file)) {
                    throw new RasException("Unable to create directory  " + string3 + " for file " + string);
                }
            }
        }
        if (!RasHelper.canWriteFile(file)) {
            throw new RasException("Ras does not have necessary permission to write file " + string2 + " to directory " + file.getAbsolutePath());
        }
    }

    private static String generateFilename(String string) throws RasException {
        try {
            Date date = new Date(System.currentTimeMillis());
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yy.MM.dd_HH.mm.ss");
            String string2 = simpleDateFormat.format(date);
            String string3 = svServerName + "_" + string + "_" + string2 + ".txt";
            String string4 = RasProperties.getDefaultLoggingDirectory();
            string3 = string4 + File.separator + string3;
            return string3;
        }
        catch (Throwable throwable) {
            throw new RasException(throwable);
        }
    }

    static FileOutputStream createFileOutputStream(String string, boolean bl) throws RasException {
        final String string2 = string;
        final boolean bl2 = bl;
        try {
            FileOutputStream fileOutputStream = (FileOutputStream)AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    return new FileOutputStream(string2, bl2);
                }
            });
            return fileOutputStream;
        }
        catch (Throwable throwable) {
            throw new RasException("Unable to create FileOutputStream over file " + string, throwable);
        }
    }

    static String getSystemProperty(String string) {
        final String string2 = string;
        try {
            String string3 = (String)AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction(){

                public Object run() {
                    return System.getProperty(string2);
                }
            });
            return string3;
        }
        catch (SecurityException securityException) {
            return null;
        }
    }

    static void setSystemOut(PrintStream printStream) throws RasException {
        final PrintStream printStream2 = printStream;
        try {
            AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction(){

                public Object run() {
                    System.setOut(printStream2);
                    return null;
                }
            });
        }
        catch (Throwable throwable) {
            throw new RasException("Unable to replace System.out", throwable);
        }
    }

    static void setSystemErr(PrintStream printStream) throws RasException {
        final PrintStream printStream2 = printStream;
        try {
            AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction(){

                public Object run() {
                    System.setErr(printStream2);
                    return null;
                }
            });
        }
        catch (Throwable throwable) {
            throw new RasException("Unable to replace System.err", throwable);
        }
    }

    static String getHostName() throws RasException {
        try {
            String string = (String)AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                public Object run() throws UnknownHostException {
                    return InetAddress.getLocalHost().getHostName();
                }
            });
            return string;
        }
        catch (Throwable throwable) {
            throw new RasException("Unable to obtain host name ", throwable);
        }
    }

    static InputStream getResourceAsStream(String string) throws RasException {
        final String string2 = string;
        try {
            InputStream inputStream = (InputStream)AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return Thread.currentThread().getContextClassLoader().getResourceAsStream(string2);
                }
            });
            return inputStream;
        }
        catch (Throwable throwable) {
            throw new RasException("unable to get resource " + string, throwable);
        }
    }

    static boolean deleteFile(File file) {
        try {
            final File file2 = file;
            Boolean bl = (Boolean)AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction(){

                public Object run() {
                    return new Boolean(file2.delete());
                }
            });
            return bl;
        }
        catch (SecurityException securityException) {
            return false;
        }
    }

    static boolean fileExists(File file) {
        final File file2 = file;
        try {
            Boolean bl = (Boolean)AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction(){

                public Object run() {
                    return new Boolean(file2.exists());
                }
            });
            return bl;
        }
        catch (SecurityException securityException) {
            return false;
        }
    }

    static boolean canReadFile(File file) {
        final File file2 = file;
        try {
            Boolean bl = (Boolean)AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction(){

                public Object run() {
                    return new Boolean(file2.canRead());
                }
            });
            return bl;
        }
        catch (SecurityException securityException) {
            return false;
        }
    }

    static long fileLastModified(File file) throws RasException {
        final File file2 = file;
        try {
            Long l = (Long)AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction(){

                public Object run() {
                    return new Long(file2.lastModified());
                }
            });
            long l2 = l;
            if (l2 == 0L) {
                throw new RasException("Unable to determine time file was last modified");
            }
            return l2;
        }
        catch (Throwable throwable) {
            throw new RasException("Unable to determine time file was last modified", throwable);
        }
    }

    static long getFileLength(File file) {
        final File file2 = file;
        try {
            Long l = (Long)AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction(){

                public Object run() {
                    return new Long(file2.length());
                }
            });
            return l;
        }
        catch (SecurityException securityException) {
            return 0L;
        }
    }

    static boolean canWriteFile(File file) {
        final File file2 = file;
        try {
            Boolean bl = (Boolean)AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction(){

                public Object run() {
                    return new Boolean(file2.canWrite());
                }
            });
            return bl;
        }
        catch (SecurityException securityException) {
            return false;
        }
    }

    static boolean createNewFile(File file) throws IOException, RasException {
        final File file2 = file;
        try {
            Boolean bl = (Boolean)AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    return new Boolean(file2.createNewFile());
                }
            });
            return bl;
        }
        catch (Throwable throwable) {
            throw new RasException("unable to create new file", throwable);
        }
    }

    static boolean makeDirectories(File file) {
        final File file2 = file;
        try {
            Boolean bl = (Boolean)AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction(){

                public Object run() {
                    return new Boolean(file2.mkdirs());
                }
            });
            return bl;
        }
        catch (SecurityException securityException) {
            return false;
        }
    }

    static boolean renameFile(File file, File file2) {
        final File file3 = file;
        final File file4 = file2;
        try {
            Boolean bl = (Boolean)AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction(){

                public Object run() {
                    return new Boolean(file3.renameTo(file4));
                }
            });
            return bl;
        }
        catch (SecurityException securityException) {
            return false;
        }
    }

    static boolean isFile(File file) {
        final File file2 = file;
        try {
            Boolean bl = (Boolean)AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction(){

                public Object run() {
                    return new Boolean(file2.isFile());
                }
            });
            return bl;
        }
        catch (SecurityException securityException) {
            return false;
        }
    }

    static String[] listFileNames(File file) {
        final File file2 = file;
        try {
            String[] stringArray = (String[])AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction(){

                public Object run() {
                    return file2.list();
                }
            });
            return stringArray;
        }
        catch (SecurityException securityException) {
            return new String[0];
        }
    }

    static boolean isDirectory(File file) {
        final File file2 = file;
        try {
            Boolean bl = (Boolean)AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction(){

                public Object run() {
                    return new Boolean(file2.isDirectory());
                }
            });
            return bl;
        }
        catch (SecurityException securityException) {
            return false;
        }
    }

    public static String getThreadId() {
        LogRecord logRecord = new LogRecord(Level.FINE, "x");
        return RasHelper.getThreadId(logRecord);
    }

    public static String getThreadId(LogRecord logRecord) {
        int n;
        StringBuffer stringBuffer = new StringBuffer(16);
        String string = Integer.toHexString(logRecord.getThreadID());
        for (int i = n = string.length(); i < 8; ++i) {
            stringBuffer.append('0');
        }
        stringBuffer.append(string);
        return stringBuffer.toString();
    }

    static {
        try {
            svProcessId = Long.toString(System.currentTimeMillis());
        }
        catch (Throwable throwable) {
            svProcessId = "Unknown";
        }
    }
}

