/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.ras;

import com.ibm.ejs.ras.ByteBufferParser;
import com.ibm.ejs.ras.MessageDataObject;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.ZOSSharedLogReader;
import com.ibm.websphere.logging.WsLevel;
import com.ibm.ws.logging.object.WsLogRecord;
import com.ibm.ws.logging.object.WsLogRecordFactory;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.eclipse.hyades.logging.events.cbe.CommonBaseEvent;
import org.eclipse.hyades.logging.events.cbe.util.EventFormatter;
import org.eclipse.hyades.logging.java.CommonBaseEventLogRecord;

public class ErrorLogReader {
    private String logStream = null;
    private Date startTime;
    private Date endTime;
    boolean pendingMsg = false;
    private static String svClassName = "com.ibm.ejs.ras.ZOSSharedLogReader";
    private static String rbName = "com.ibm.ejs.resources.RasMessages";
    private TraceComponent tc;
    private static String nativeLibrary = "bborzelu";
    public ByteBufferParser bbParser = new ByteBufferParser();
    MessageDataObject[] mdObject;
    WsLogRecord wlr;
    Level level;
    private int recCount = 0;
    private int finished;
    private String msg = null;
    private int cumulativeDropCtr = 0;
    private int preservedRemDropped = 0;
    private static final int BUFFER_SIZE = 46080;
    public static final int INT_VALUEOF_HEX848 = 2120;
    private int nativeOpenResult = 0;
    private int nativeReadResult = 0;
    private String msgKey = null;
    private int messageControlFlag = 0;
    private Object[] parms = null;

    public ErrorLogReader() {
    }

    ErrorLogReader(String string, Date date, Date date2) {
        this.logStream = string;
        this.startTime = date;
        this.endTime = date2;
        try {
            this.nativeOpenResult = this.nativeOpenLogFile(this.bbParser, string, date.getTime() / 1000L, date2.getTime() / 1000L);
            this.finished = 0;
            if (this.nativeOpenResult != 0) {
                this.msgKey = "TRAS0210I";
                this.parms = null;
                this.level = WsLevel.INFO;
                this.wlr = this.elrCreateWsLogRecord(this.msgKey, this.parms, this.level);
                this.bbParser.setIsLogStreamOpen(1);
                this.finished = 1;
                this.pendingMsg = true;
            } else if (this.nativeOpenResult == 0 && this.bbParser.getMessageReturnCode() != 0) {
                this.msgKey = this.buildErrorMsg(string, date, this.bbParser.getMessageReturnCode(), this.bbParser.getMessageReasonCode(), this.bbParser.getService(), true);
                this.wlr = this.elrCreateWsLogRecord(this.msgKey, this.parms, this.level);
                this.finished = 1;
                this.pendingMsg = true;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public WsLogRecord readRecord() throws IOException {
        if (this.finished == 1) {
            if (this.pendingMsg) {
                this.pendingMsg = false;
            } else if (this.cumulativeDropCtr > 0) {
                this.msgKey = "TRAS0220I";
                this.level = WsLevel.INFO;
                this.parms = new Object[]{new Integer(this.cumulativeDropCtr)};
                this.cumulativeDropCtr = 0;
                this.wlr = this.elrCreateWsLogRecord(this.msgKey, this.parms, this.level);
            } else {
                this.wlr = this.close();
            }
            return this.wlr;
        }
        if (this.bbParser.getIsLogStreamOpen() == 0) {
            if (this.bbParser.getMsgCount() == 0 || this.recCount == this.bbParser.getMsgCount()) {
                if (this.bbParser.getEofStream() == 1) {
                    if (this.cumulativeDropCtr > 0) {
                        this.msgKey = "TRAS0220I";
                        this.parms = new Object[]{new Integer(this.cumulativeDropCtr)};
                        this.level = WsLevel.INFO;
                        this.cumulativeDropCtr = 0;
                        this.finished = 1;
                        this.wlr = this.elrCreateWsLogRecord(this.msgKey, this.parms, this.level);
                    } else if (this.cumulativeDropCtr == 0) {
                        this.finished = 1;
                        this.wlr = this.close();
                    }
                    return this.wlr;
                }
                ByteBuffer byteBuffer = ByteBuffer.allocateDirect(46080);
                this.nativeReadResult = this.nativeReadRecords(byteBuffer);
                if (this.nativeReadResult != 0) {
                    this.wlr = this.close();
                    return this.wlr;
                }
                this.mdObject = new MessageDataObject[this.bbParser.getMsgCount()];
                this.mdObject = this.bbParser.parseByteBuffer(byteBuffer);
                this.recCount = 0;
                if (this.bbParser.getMessageReturnCode() != 0) {
                    this.msgKey = this.buildErrorMsg(this.logStream, this.startTime, this.bbParser.getMessageReturnCode(), this.bbParser.getMessageReasonCode(), this.bbParser.getService(), true);
                    this.wlr = this.elrCreateWsLogRecord(this.msgKey, this.parms, this.level);
                    this.finished = 1;
                    this.messageControlFlag = 1;
                    return this.wlr;
                }
            }
            if (this.recCount < this.bbParser.getMsgCount()) {
                if (this.bbParser.getMsgCount() > 0) {
                    try {
                        long l = this.mdObject[this.recCount].getMsgTimeStamps();
                        if (this.bbParser.getEndTime() < l) {
                            this.finished = 1;
                            this.cumulativeDropCtr = this.cumulativeDropCtr + this.preservedRemDropped + this.mdObject[this.recCount].getDropCounts();
                            if (this.recCount == 1) {
                                this.preservedRemDropped = 0;
                            }
                            this.msgKey = "TRAS0230I";
                            this.level = WsLevel.INFO;
                            this.wlr = this.elrCreateWsLogRecord(this.msgKey, this.parms, this.level);
                            return this.wlr;
                        }
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                        arrayIndexOutOfBoundsException.printStackTrace();
                    }
                } else if (this.bbParser.getMsgCount() == 0) {
                    this.finished = 1;
                    this.cumulativeDropCtr = this.cumulativeDropCtr + this.preservedRemDropped + this.bbParser.getRemDropped();
                    if (this.cumulativeDropCtr > 0) {
                        this.msgKey = "TRAS0220I";
                        this.parms = new Object[]{new Integer(this.cumulativeDropCtr)};
                        this.cumulativeDropCtr = 0;
                        this.level = WsLevel.INFO;
                        this.wlr = this.elrCreateWsLogRecord(this.msgKey, this.parms, this.level);
                        return this.wlr;
                    }
                    return this.close();
                }
                if (this.recCount == this.bbParser.getMsgCount()) {
                    this.preservedRemDropped = this.bbParser.getRemDropped();
                }
                this.msg = this.mdObject[this.recCount].isEBCDIC() ? new String(this.mdObject[this.recCount].getMsg()) : new String(this.mdObject[this.recCount].getMsg(), "UTF-8");
                CommonBaseEventLogRecord commonBaseEventLogRecord = null;
                try {
                    CommonBaseEvent commonBaseEvent = EventFormatter.eventFromCanonicalXML((String)this.msg);
                    commonBaseEventLogRecord = new CommonBaseEventLogRecord(commonBaseEvent);
                }
                catch (Exception exception) {
                    commonBaseEventLogRecord = null;
                    exception.printStackTrace();
                }
                this.wlr = WsLogRecordFactory.getWsLogRecordIfConvertible((LogRecord)commonBaseEventLogRecord);
                this.cumulativeDropCtr = this.cumulativeDropCtr + this.bbParser.getRemDropped() + this.mdObject[this.recCount].getDropCounts();
                this.bbParser.setRemDropped(0);
                ++this.recCount;
            } else {
                this.wlr = null;
            }
        }
        return this.wlr;
    }

    private WsLogRecord elrCreateWsLogRecord(String string, Object[] objectArray, Level level) throws IOException {
        this.tc = Tr.register(ZOSSharedLogReader.class, null, rbName);
        this.wlr = WsLogRecordFactory.createWsLogRecord(null, level, string, objectArray, svClassName, null, rbName, null, null, "IBM", "WebSphere", null, null, Level.ALL.intValue(), this.tc.getName());
        return this.wlr;
    }

    public WsLogRecord close() throws IOException {
        if (this.bbParser.getIsLogStreamOpen() == 1) {
            this.wlr = null;
        } else {
            try {
                this.bbParser.setIsLogStreamOpen(1);
                if (this.bbParser.getMessageReturnCode() == 0 && this.bbParser.getMessageReasonCode() == 0) {
                    this.wlr = null;
                } else if (this.messageControlFlag == 0) {
                    this.msgKey = this.buildErrorMsg(this.logStream, this.startTime, this.bbParser.getMessageReturnCode(), this.bbParser.getMessageReasonCode(), this.bbParser.getService(), true);
                    this.wlr = this.elrCreateWsLogRecord(this.msgKey, this.parms, this.level);
                } else {
                    this.wlr = null;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.nativeClose(this.bbParser);
        return this.wlr;
    }

    private String buildErrorMsg(String string, Date date, int n, int n2, byte[] byArray, boolean bl) throws IOException {
        if (bl && n2 == 2120) {
            this.msgKey = "TRAS0240I";
            this.parms = new Object[]{string, date};
            this.level = WsLevel.INFO;
            this.finished = 1;
        } else {
            this.parms = new Object[]{new String(byArray), string, new Integer(n), new Integer(n2)};
            if (n == 4) {
                this.msgKey = "TRAS0250W";
                this.level = WsLevel.WARNING;
            } else if (n == 8) {
                this.parms = new Object[]{string, date};
                this.msgKey = "TRAS0240I";
                this.level = WsLevel.SEVERE;
            } else if (n == 98) {
                this.msgKey = "TRAS0260I";
                this.level = WsLevel.INFO;
            } else if (n > 4) {
                this.msgKey = "TRAS0270E";
                this.level = WsLevel.SEVERE;
            } else if (n < 0) {
                this.msgKey = "TRAS0250W";
                this.level = WsLevel.WARNING;
            }
        }
        return this.msgKey;
    }

    private native int nativeOpenLogFile(Object var1, String var2, long var3, long var5);

    private native int nativeReadRecords(ByteBuffer var1);

    private native void nativeClose(Object var1);

    static {
        System.loadLibrary(nativeLibrary);
    }
}

