/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.ras;

import com.ibm.ejs.ras.Dumpable;
import com.ibm.ejs.ras.Group;
import com.ibm.ejs.ras.RasHelper;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceElement;
import com.ibm.ejs.ras.TraceEnableEvent;
import com.ibm.ws.logging.LevelConstants;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Vector;

class ComponentManager {
    private static final char ELEMENT_DELIMITER = '=';
    private static final char LEVEL_DELIMITER = ',';
    private static final char COMPONENT_DELIMITER = ':';
    private static final String FLAG_LEVEL_ENABLED = "enabled";
    private static final String FLAG_LEVEL_DISABLED = "disabled";
    private static final String LOGGING_SPEC_TOKENS = new String(new char[]{'=', ',', ':'});
    static boolean svTraceEnabled = false;
    private static Hashtable traceTypeMap = new Hashtable();
    private Hashtable components = new Hashtable();
    private Hashtable groups = new Hashtable();
    private Hashtable dumpables;
    private Vector traceEnableEvents = new Vector();

    ComponentManager() {
        this.dumpables = new Hashtable();
    }

    synchronized String[] getGroups() {
        String[] stringArray = null;
        stringArray = new String[this.groups.size()];
        Enumeration enumeration = this.groups.keys();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            stringArray[n++] = (String)enumeration.nextElement();
        }
        return stringArray;
    }

    synchronized String[] getGroupComponents(String string) {
        Group group;
        String[] stringArray = new String[]{};
        if (string != null && (group = (Group)this.groups.get(string)) != null) {
            stringArray = group.getComponents();
        }
        return stringArray;
    }

    synchronized String getTraceSpecification(String string) {
        String string2 = null;
        if (string != null) {
            TraceElement traceElement = (TraceElement)this.groups.get(string);
            if (traceElement == null) {
                traceElement = (TraceElement)this.components.get(string);
            }
            if (traceElement != null) {
                string2 = traceElement.getTraceSpecification();
            }
        }
        return string2;
    }

    synchronized String getTraceSpecification() {
        StringBuffer stringBuffer = new StringBuffer(16);
        int n = this.traceEnableEvents.size();
        if (n == 0) {
            return "*=" + LevelConstants.NAMES[16];
        }
        for (int i = 0; i < n; ++i) {
            TraceEnableEvent traceEnableEvent = (TraceEnableEvent)this.traceEnableEvents.elementAt(i);
            if (i != 0) {
                stringBuffer.append(":");
            }
            stringBuffer.append(traceEnableEvent.getComponentName());
            stringBuffer.append("=").append(LevelConstants.NAMES[traceEnableEvent.getType()]);
        }
        return new String(stringBuffer);
    }

    synchronized void processTraceString(String string, boolean bl) {
        if (string == null) {
            string = "";
        }
        this.processLoggingSpecString(string, bl);
    }

    synchronized void processDumpString(String string) {
        Object object;
        Object object2;
        int n;
        if (string == null) {
            this.processNullDumpString();
            return;
        }
        if ((string = RasHelper.peelQuotes(string)) == null) {
            return;
        }
        String[] stringArray = RasHelper.split(string, 58);
        Object var3_3 = null;
        Vector<TraceComponent> vector = new Vector<TraceComponent>();
        Enumeration enumeration = this.components.elements();
        while (enumeration.hasMoreElements()) {
            TraceComponent traceComponent = (TraceComponent)enumeration.nextElement();
            if (!traceComponent.ivDebugEnabled) continue;
            traceComponent.ivDebugEnabled = false;
            vector.addElement(traceComponent);
        }
        for (n = 0; n < stringArray.length; ++n) {
            boolean bl = true;
            object2 = stringArray[n];
            if (((String)object2).endsWith("=disabled")) {
                bl = false;
                object2 = RasHelper.split((String)object2, 61)[0];
            }
            object = new TraceEnableEvent(bl, 0, (String)object2);
            this.fireTraceEnableEvent((TraceEnableEvent)object);
        }
        for (n = 0; n < stringArray.length; ++n) {
            String string2 = RasHelper.split(stringArray[n], 61)[0];
            object2 = this.dumpables.keys();
            while (object2.hasMoreElements()) {
                object = (String)object2.nextElement();
                if (!this.componentEnabled(string2, (String)object)) continue;
                Vector vector2 = (Vector)this.dumpables.get(object);
                for (int i = 0; i < vector2.size(); ++i) {
                    Dumpable dumpable = (Dumpable)vector2.elementAt(i);
                    dumpable.dump();
                }
            }
        }
        for (n = 0; n < stringArray.length; ++n) {
            String string3 = RasHelper.split(stringArray[n], 61)[0];
            object2 = new TraceEnableEvent(false, 0, string3);
            this.fireTraceEnableEvent((TraceEnableEvent)object2);
        }
        for (n = 0; n < vector.size(); ++n) {
            TraceComponent traceComponent = (TraceComponent)vector.elementAt(n);
            traceComponent.ivDebugEnabled = true;
        }
        Enumeration enumeration2 = this.dumpables.elements();
        while (enumeration2.hasMoreElements()) {
            Vector vector3 = (Vector)enumeration2.nextElement();
            for (int i = 0; i < vector3.size(); ++i) {
                object = (Dumpable)vector3.elementAt(i);
                object.resetDump();
            }
        }
    }

    synchronized TraceComponent register(String string) {
        return this.registerComponentAndGroup(string, null);
    }

    synchronized TraceComponent register(String string, String string2) {
        return this.registerComponentAndGroup(string, string2);
    }

    private synchronized TraceComponent registerComponentAndGroup(String string, String string2) {
        TraceComponent traceComponent = null;
        Group group = null;
        boolean bl = false;
        boolean bl2 = false;
        if (string != null) {
            traceComponent = (TraceComponent)this.components.get(string);
            if (traceComponent == null) {
                traceComponent = new TraceComponent(string);
                this.components.put(string, traceComponent);
                bl = true;
            }
            if (string2 != null) {
                group = (Group)this.groups.get(string2);
                if (group == null) {
                    group = new Group(string2);
                    this.groups.put(string2, group);
                    bl2 = true;
                }
                group.addComponent(traceComponent);
            }
        }
        int n = this.traceEnableEvents.size();
        TraceEnableEvent traceEnableEvent = null;
        String string3 = null;
        for (int i = 0; i < n; ++i) {
            traceEnableEvent = (TraceEnableEvent)this.traceEnableEvents.elementAt(i);
            string3 = traceEnableEvent.getComponentName();
            if (bl && this.componentEnabled(string3, string)) {
                traceComponent.applyTraceEnableEvent(traceEnableEvent);
            }
            if (string2 == null || !this.componentEnabled(string3, string2) || string3.equals("*")) continue;
            group.applyTraceEnableEvent(traceEnableEvent);
        }
        return traceComponent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void registerDumpable(TraceComponent traceComponent, Dumpable dumpable) {
        String string = traceComponent.getName();
        Hashtable hashtable = this.dumpables;
        synchronized (hashtable) {
            Vector<Dumpable> vector = (Vector<Dumpable>)this.dumpables.get(string);
            if (vector == null) {
                vector = new Vector<Dumpable>();
                this.dumpables.put(string, vector);
            }
            if (!vector.contains(dumpable)) {
                vector.addElement(dumpable);
            }
        }
    }

    synchronized String[] getComponents() {
        String[] stringArray = new String[this.components.size()];
        Enumeration enumeration = this.components.keys();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            stringArray[n++] = (String)enumeration.nextElement();
        }
        return stringArray;
    }

    synchronized Vector getTracedGroups() {
        Vector<Group> vector = new Vector<Group>();
        Enumeration enumeration = this.groups.keys();
        while (enumeration.hasMoreElements()) {
            Group group = (Group)this.groups.get(enumeration.nextElement());
            if (group.getLevel() >= 8) continue;
            vector.addElement(group);
        }
        return vector;
    }

    synchronized Vector getTracedComponents() {
        Vector<TraceComponent> vector = new Vector<TraceComponent>();
        Enumeration enumeration = this.components.keys();
        while (enumeration.hasMoreElements()) {
            TraceComponent traceComponent = (TraceComponent)this.components.get(enumeration.nextElement());
            if (traceComponent.getLevel() >= 8) continue;
            vector.addElement(traceComponent);
        }
        return vector;
    }

    private void fireTraceEnableEvent(TraceEnableEvent traceEnableEvent) {
        boolean bl;
        int n;
        Object object;
        String string = traceEnableEvent.getComponentName();
        Enumeration enumeration = this.groups.keys();
        while (enumeration.hasMoreElements()) {
            object = (Group)this.groups.get(enumeration.nextElement());
            if (!this.componentEnabled(string, ((TraceElement)object).getName())) continue;
            ((Group)object).applyTraceEnableEvent(traceEnableEvent);
        }
        object = this.components.keys();
        while (object.hasMoreElements()) {
            TraceComponent traceComponent = (TraceComponent)this.components.get(object.nextElement());
            if (!this.componentEnabled(string, traceComponent.getName())) continue;
            traceComponent.applyTraceEnableEvent(traceEnableEvent);
        }
        int n2 = this.traceEnableEvents.size();
        int n3 = 0;
        for (n = 0; n < n2; ++n) {
            bl = false;
            TraceEnableEvent traceEnableEvent2 = (TraceEnableEvent)this.traceEnableEvents.elementAt(n3);
            if (this.componentEnabled(string, traceEnableEvent2.getComponentName())) {
                bl = true;
            }
            if (bl) {
                this.traceEnableEvents.removeElementAt(n3);
                continue;
            }
            ++n3;
        }
        n = 1;
        bl = false;
        n2 = this.traceEnableEvents.size();
        for (int i = 0; i < n2; ++i) {
            TraceEnableEvent traceEnableEvent3 = (TraceEnableEvent)this.traceEnableEvents.elementAt(i);
            if (this.componentEnabled(traceEnableEvent3.getComponentName(), string)) {
                int n4 = n = traceEnableEvent3.getType() != traceEnableEvent.getType() ? 1 : 0;
            }
            if (bl || traceEnableEvent3.getType() >= 8) continue;
            bl = true;
        }
        if (n != 0) {
            this.traceEnableEvents.addElement(traceEnableEvent);
            if (!bl && traceEnableEvent.getType() < 8) {
                bl = true;
            }
        }
        svTraceEnabled = bl;
    }

    private boolean componentEnabled(String string, String string2) {
        if (string.equals(string2)) {
            return true;
        }
        int n = string.length();
        if (string.lastIndexOf(42) == n - 1) {
            return string.regionMatches(0, string2, 0, n - 1);
        }
        return false;
    }

    private void processNullDumpString() {
        Dumpable dumpable;
        int n;
        Vector vector;
        Enumeration enumeration = this.dumpables.elements();
        while (enumeration.hasMoreElements()) {
            vector = (Vector)enumeration.nextElement();
            for (n = 0; n < vector.size(); ++n) {
                dumpable = (Dumpable)vector.elementAt(n);
                dumpable.dump();
            }
        }
        enumeration = this.dumpables.elements();
        while (enumeration.hasMoreElements()) {
            vector = (Vector)enumeration.nextElement();
            for (n = 0; n < vector.size(); ++n) {
                dumpable = (Dumpable)vector.elementAt(n);
                dumpable.resetDump();
            }
        }
    }

    static int resolveEnabledLevel(boolean bl, int n) {
        int n2;
        block5: {
            block4: {
                if (bl) break block4;
                if (n >= 16) break block5;
                if (n > 1) {
                    n2 = n;
                    while (LevelConstants.DISTINCT_LEVELS[++n2] == LevelConstants.DISTINCT_LEVELS[n]) {
                    }
                } else {
                    n2 = 10;
                }
                break block5;
            }
            for (n2 = n; n2 > 0 && LevelConstants.DISTINCT_LEVELS[n2 - 1] == LevelConstants.DISTINCT_LEVELS[n2]; --n2) {
            }
        }
        return n2;
    }

    Vector parseLoggingSpec(String string, boolean bl) {
        Object object;
        Vector<String[]> vector = new Vector<String[]>();
        String[] stringArray = null;
        StringTokenizer stringTokenizer = new StringTokenizer(string, LOGGING_SPEC_TOKENS, true);
        String string2 = null;
        stringArray = new String[3];
        int n = 0;
        block7: while (stringTokenizer.hasMoreTokens() || n != 0) {
            try {
                string2 = stringTokenizer.nextToken();
            }
            catch (NoSuchElementException noSuchElementException) {
                string2 = String.valueOf(':');
                n = 0;
            }
            switch (string2.charAt(0)) {
                case '=': {
                    continue block7;
                }
                case ',': {
                    if (stringArray[0] == null || stringArray[1] == null || stringArray[2] == null) continue block7;
                    vector.add(stringArray);
                    object = stringArray[0];
                    stringArray = new String[3];
                    stringArray[0] = object;
                    n = 1;
                    continue block7;
                }
                case ':': {
                    if (stringArray[0] != null && stringArray[1] != null) {
                        if (stringArray[2] == null) {
                            stringArray[2] = FLAG_LEVEL_ENABLED;
                        }
                        vector.add(stringArray);
                        stringArray = new String[3];
                        n = 0;
                        continue block7;
                    }
                    if (n >= 3) continue block7;
                    n = 0;
                    continue block7;
                }
            }
            if (n == 0 && string2.trim().length() > 0 || n == 1 && traceTypeMap.get(string2) != null || n == 2 && (string2.equals(FLAG_LEVEL_ENABLED) || string2.equals(FLAG_LEVEL_DISABLED))) {
                if (n == 2 && string2.equals(FLAG_LEVEL_DISABLED)) {
                    stringArray[1] = LevelConstants.NAMES[ComponentManager.resolveEnabledLevel(false, (Integer)traceTypeMap.get(stringArray[1]))];
                    stringArray[n++] = FLAG_LEVEL_ENABLED;
                    continue;
                }
                if (n == 1) {
                    string2 = LevelConstants.NAMES[ComponentManager.resolveEnabledLevel(true, (Integer)traceTypeMap.get(string2))];
                }
                stringArray[n++] = string2;
                continue;
            }
            if (n >= stringArray.length) {
                n = 0;
                continue;
            }
            if (n <= 0 || stringArray[n - 1] == null) continue;
            ++n;
        }
        if (bl) {
            if (vector.size() > 0) {
                object = (String[])vector.elementAt(0);
                if (object[0] != null && !object[0].equals("*")) {
                    vector.add(0, new String[]{"*", LevelConstants.NAMES[10], FLAG_LEVEL_ENABLED});
                }
            } else {
                vector.add(0, new String[]{"*", LevelConstants.NAMES[10], FLAG_LEVEL_ENABLED});
            }
        }
        return vector;
    }

    private void processLoggingSpecString(String string, boolean bl) {
        Vector vector = this.parseLoggingSpec(string, bl);
        String[] stringArray = null;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            stringArray = (String[])enumeration.nextElement();
            this.fireTraceEnableEvent(new TraceEnableEvent(true, (int)((Integer)traceTypeMap.get(stringArray[1])), stringArray[0]));
        }
    }

    private int getLevel(String string) {
        Object v;
        if (string != null && string.length() > 0 && (v = traceTypeMap.get(string)) != null) {
            return (Integer)v;
        }
        return -1;
    }

    static {
        for (int i = 0; i < 17; ++i) {
            traceTypeMap.put(LevelConstants.NAMES[i], new Integer(i));
        }
    }
}

