/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.ras;

import com.ibm.ejs.ras.CBuff;
import com.ibm.ejs.ras.ExtendedTraceLogger;
import com.ibm.ejs.ras.ManagerAdmin;
import com.ibm.ejs.ras.RasException;
import com.ibm.ejs.ras.RasHelper;
import com.ibm.ejs.ras.RasProperties;
import com.ibm.ejs.ras.TraceLogger;
import com.ibm.ws.logging.WsHandler;
import com.ibm.ws.logging.object.WsLogRecord;
import com.ibm.ws.logging.object.WsLogRecordFactory;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.logging.LogRecord;

class CBuffLogger
implements WsHandler {
    private CBuff ivCBuff;

    CBuffLogger(int n) {
        if (n < 1) {
            n = 8;
        }
        int n2 = n * 1024;
        this.ivCBuff = new CBuff(n2);
    }

    synchronized void setSize(int n) {
        if (n < 1) {
            return;
        }
        int n2 = n * 1024;
        this.ivCBuff.setSize(n2);
    }

    synchronized int getSize() {
        int n = this.ivCBuff.getSize() / 1024;
        return n;
    }

    synchronized void clear() {
        int n = this.ivCBuff.getSize();
        this.ivCBuff = new CBuff(n);
    }

    public synchronized void processEvent(LogRecord logRecord) {
        if (ManagerAdmin.svTraceEnabled) {
            WsLogRecord wsLogRecord = WsLogRecordFactory.getWsLogRecordIfConvertible(logRecord);
            if (wsLogRecord != null && wsLogRecord.getExtension("service_log_only") != null) {
                return;
            }
            this.ivCBuff.put(logRecord);
        }
    }

    synchronized void dump(String string) throws RasException {
        FileOutputStream fileOutputStream = null;
        try {
            RasHelper.validateFileName(string.trim());
            fileOutputStream = RasHelper.createFileOutputStream(string, false);
            TraceLogger traceLogger = null;
            traceLogger = RasProperties.svTraceFormat.equals("loganalyzer") ? new ExtendedTraceLogger(fileOutputStream) : (RasProperties.svTraceFormat.equals("advanced") ? new TraceLogger((OutputStream)fileOutputStream, false) : new TraceLogger((OutputStream)fileOutputStream, true));
            traceLogger.printHeader();
            Enumeration enumeration = this.ivCBuff.elements();
            while (enumeration.hasMoreElements()) {
                LogRecord logRecord = (LogRecord)enumeration.nextElement();
                traceLogger.processEvent(logRecord);
            }
        }
        catch (RasException rasException) {
            throw new RasException("Failed to open file " + string, (Throwable)((Object)rasException));
        }
        catch (Throwable throwable) {
            throw new RasException("Failure dumping the ring buffer " + string, throwable);
        }
        finally {
            try {
                fileOutputStream.close();
            }
            catch (Throwable throwable) {}
        }
    }
}

