/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.java;

import java.util.ListIterator;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.eclipse.emf.common.util.EList;
import org.eclipse.hyades.logging.core.IExternalizableToXml;
import org.eclipse.hyades.logging.events.cbe.CommonBaseEvent;
import org.eclipse.hyades.logging.events.cbe.EventFactory;
import org.eclipse.hyades.logging.events.cbe.ExtendedDataElement;
import org.eclipse.hyades.logging.events.cbe.MsgCatalogToken;
import org.eclipse.hyades.logging.events.cbe.MsgDataElement;
import org.eclipse.hyades.logging.events.cbe.impl.EventFactoryContext;
import org.eclipse.hyades.logging.events.cbe.util.EventFormatter;
import org.eclipse.hyades.logging.java.CommonBaseEventLevel;

public final class CommonBaseEventLogRecord
extends LogRecord
implements IExternalizableToXml {
    private static final long serialVersionUID = -2592508067175423183L;
    private CommonBaseEvent commonBaseEvent = null;
    private ExtendedDataElement levelNameExtendedDataElement = null;
    private ExtendedDataElement levelValueExtendedDataElement = null;
    private ExtendedDataElement loggerNameExtendedDataElement = null;
    private ExtendedDataElement sequenceNumberExtendedDataElement = null;
    private ExtendedDataElement sourceClassNameExtendedDataElement = null;
    private ExtendedDataElement sourceMethodNameExtendedDataElement = null;
    private ExtendedDataElement threadIDExtendedDataElement = null;
    private boolean isThrownSet = false;
    private static final EventFactory EVENT_FACTORY = EventFactoryContext.getInstance().getEventFactoryHome("org.eclipse.hyades.logging.events.cbe.impl.SimpleEventFactoryHomeImpl").getEventFactory("org.eclipse.hyades.logging.java.CommonBaseEventLogRecord");
    public static final String EXTENDED_DATA_ELEMENT_NAME_NAMESPACE = "CommonBaseEventLogRecord:";
    public static final String EXTENDED_DATA_ELEMENT_NAME_LEVEL = "CommonBaseEventLogRecord:".concat("level");
    public static final String EXTENDED_DATA_ELEMENT_NAME_LEVEL_NAME = "CommonBaseEventLogRecord:".concat("name");
    public static final String EXTENDED_DATA_ELEMENT_NAME_LEVEL_VALUE = "CommonBaseEventLogRecord:".concat("value");
    public static final String EXTENDED_DATA_ELEMENT_NAME_LOGGER_NAME = "CommonBaseEventLogRecord:".concat("loggerName");
    public static final String EXTENDED_DATA_ELEMENT_NAME_SEQUENCE_NUMBER = "CommonBaseEventLogRecord:".concat("sequenceNumber");
    public static final String EXTENDED_DATA_ELEMENT_NAME_SOURCE_CLASS_NAME = "CommonBaseEventLogRecord:".concat("sourceClassName");
    public static final String EXTENDED_DATA_ELEMENT_NAME_SOURCE_METHOD_NAME = "CommonBaseEventLogRecord:".concat("sourceMethodName");
    public static final String EXTENDED_DATA_ELEMENT_NAME_THREAD_ID = "CommonBaseEventLogRecord:".concat("threadID");
    public static final String EXTENDED_DATA_ELEMENT_NAME_THROWN = "CommonBaseEventLogRecord:".concat("stackTrace");
    public static final String EXTENDED_DATA_ELEMENT_NAME_THROWN_STACK_FRAME = "CommonBaseEventLogRecord:".concat("stackFrame");

    public CommonBaseEventLogRecord(CommonBaseEvent commonBaseEvent) {
        super(Level.OFF, null);
        if (commonBaseEvent != null) {
            this.commonBaseEvent = commonBaseEvent;
            this.resolveExtendedDataElementReferences();
            if (commonBaseEvent.isSetSeverity() && this.levelNameExtendedDataElement == null) {
                short severity = commonBaseEvent.getSeverity();
                if (severity >= 50) {
                    this.setLevel(Level.SEVERE);
                } else if (severity >= 30 && severity <= 49) {
                    this.setLevel(Level.WARNING);
                } else {
                    this.setLevel(Level.INFO);
                }
            }
            if (!commonBaseEvent.isSetCreationTime()) {
                this.setMillis(super.getMillis());
            }
            if (this.sequenceNumberExtendedDataElement == null) {
                this.setSequenceNumber(super.getSequenceNumber());
            }
            if (this.threadIDExtendedDataElement == null) {
                this.setThreadID(super.getThreadID());
            }
        }
    }

    public CommonBaseEventLogRecord(CommonBaseEvent commonBaseEvent, Level level) {
        super(level, null);
        if (commonBaseEvent != null) {
            this.commonBaseEvent = commonBaseEvent;
            this.resolveExtendedDataElementReferences();
            this.setLevel(level);
            if (!commonBaseEvent.isSetCreationTime()) {
                this.setMillis(super.getMillis());
            }
            if (this.sequenceNumberExtendedDataElement == null) {
                this.setSequenceNumber(super.getSequenceNumber());
            }
            if (this.threadIDExtendedDataElement == null) {
                this.setThreadID(super.getThreadID());
            }
        }
    }

    public CommonBaseEventLogRecord(Level level, String message) {
        super(level, message);
    }

    public CommonBaseEventLogRecord(Level level) {
        super(level, null);
    }

    public CommonBaseEventLogRecord(LogRecord logRecord) {
        super(logRecord.getLevel(), logRecord.getMessage());
        super.setMillis(logRecord.getMillis());
        super.setSequenceNumber(logRecord.getSequenceNumber());
        super.setThreadID(logRecord.getThreadID());
        super.setLoggerName(logRecord.getLoggerName());
        super.setParameters(logRecord.getParameters());
        super.setResourceBundle(logRecord.getResourceBundle());
        super.setResourceBundleName(logRecord.getResourceBundleName());
        super.setSourceClassName(logRecord.getSourceClassName());
        super.setSourceMethodName(logRecord.getSourceMethodName());
        super.setThrown(logRecord.getThrown());
    }

    public void setCommonBaseEvent(CommonBaseEvent commonBaseEvent) {
        this.commonBaseEvent = commonBaseEvent;
        if (commonBaseEvent != null) {
            this.resolveExtendedDataElementReferences();
            if (commonBaseEvent.isSetSeverity() && this.levelNameExtendedDataElement == null) {
                short severity = commonBaseEvent.getSeverity();
                if (severity >= 50) {
                    this.setLevel(Level.SEVERE);
                } else if (severity >= 30 && severity <= 49) {
                    this.setLevel(Level.WARNING);
                } else {
                    this.setLevel(Level.INFO);
                }
            }
            if (!commonBaseEvent.isSetCreationTime()) {
                this.setMillis(super.getMillis());
            }
            if (this.sequenceNumberExtendedDataElement == null) {
                this.setSequenceNumber(super.getSequenceNumber());
            }
            if (this.threadIDExtendedDataElement == null) {
                this.setThreadID(super.getThreadID());
            }
        }
    }

    public void setLevel(Level level) {
        if (this.commonBaseEvent != null) {
            if (this.levelNameExtendedDataElement == null) {
                this.levelNameExtendedDataElement = EVENT_FACTORY.createExtendedDataElement();
                this.levelNameExtendedDataElement.setName(EXTENDED_DATA_ELEMENT_NAME_LEVEL_NAME);
                this.levelNameExtendedDataElement.setTypeAsInt(7);
                this.levelValueExtendedDataElement = EVENT_FACTORY.createExtendedDataElement();
                this.levelValueExtendedDataElement.setName(EXTENDED_DATA_ELEMENT_NAME_LEVEL_VALUE);
                this.levelValueExtendedDataElement.setTypeAsInt(3);
                ExtendedDataElement levelExtendedDataElement = EVENT_FACTORY.createExtendedDataElement();
                levelExtendedDataElement.setName(EXTENDED_DATA_ELEMENT_NAME_LEVEL);
                levelExtendedDataElement.setTypeAsInt(0);
                levelExtendedDataElement.addChild(this.levelNameExtendedDataElement);
                levelExtendedDataElement.addChild(this.levelValueExtendedDataElement);
                this.commonBaseEvent.addExtendedDataElement(levelExtendedDataElement);
            }
            this.levelNameExtendedDataElement.setValues(new String[]{level.getName()});
            this.levelValueExtendedDataElement.setValues(new String[]{Integer.toString(level.intValue())});
        } else {
            super.setLevel(level);
        }
    }

    public void setLoggerName(String name) {
        if (this.commonBaseEvent != null) {
            if (this.loggerNameExtendedDataElement == null) {
                this.loggerNameExtendedDataElement = EVENT_FACTORY.createExtendedDataElement();
                this.loggerNameExtendedDataElement.setName(EXTENDED_DATA_ELEMENT_NAME_LOGGER_NAME);
                this.loggerNameExtendedDataElement.setTypeAsInt(7);
                this.commonBaseEvent.addExtendedDataElement(this.loggerNameExtendedDataElement);
            }
            this.loggerNameExtendedDataElement.setValues(new String[]{name});
        } else {
            super.setLoggerName(name);
        }
    }

    public void setMessage(String message) {
        if (this.commonBaseEvent != null) {
            MsgDataElement msgDataElement = this.commonBaseEvent.getMsgDataElement();
            if (msgDataElement == null) {
                msgDataElement = EVENT_FACTORY.createMsgDataElement();
                this.commonBaseEvent.setMsgDataElement(msgDataElement);
            }
            msgDataElement.setMsgCatalogId(message);
        } else {
            super.setMessage(message);
        }
    }

    public void setMillis(long millis) {
        if (this.commonBaseEvent != null) {
            this.commonBaseEvent.setCreationTimeAsLong(millis);
        } else {
            super.setMillis(millis);
        }
    }

    public void setParameters(Object[] parameters) {
        super.setParameters(parameters);
        if (this.commonBaseEvent != null) {
            MsgDataElement msgDataElement = this.commonBaseEvent.getMsgDataElement();
            if (msgDataElement == null) {
                msgDataElement = EVENT_FACTORY.createMsgDataElement();
                this.commonBaseEvent.setMsgDataElement(msgDataElement);
            } else {
                msgDataElement.clearMsgCatalogTokens();
            }
            if (parameters != null) {
                MsgCatalogToken msgCatalogToken = null;
                for (int counter = 0; counter < parameters.length; ++counter) {
                    msgCatalogToken = EVENT_FACTORY.createMsgCatalogToken();
                    msgCatalogToken.setValue(String.valueOf(parameters[counter]));
                    msgDataElement.addMsgCatalogToken(msgCatalogToken);
                }
            }
        }
    }

    public void setResourceBundleName(String name) {
        if (this.commonBaseEvent != null) {
            MsgDataElement msgDataElement = this.commonBaseEvent.getMsgDataElement();
            if (msgDataElement == null) {
                msgDataElement = EVENT_FACTORY.createMsgDataElement();
                this.commonBaseEvent.setMsgDataElement(msgDataElement);
            }
            msgDataElement.setMsgCatalogType("Java");
            msgDataElement.setMsgCatalog(name);
        } else {
            super.setResourceBundleName(name);
        }
    }

    public void setSequenceNumber(long seq) {
        if (this.commonBaseEvent != null) {
            if (this.sequenceNumberExtendedDataElement == null) {
                this.sequenceNumberExtendedDataElement = EVENT_FACTORY.createExtendedDataElement();
                this.sequenceNumberExtendedDataElement.setName(EXTENDED_DATA_ELEMENT_NAME_SEQUENCE_NUMBER);
                this.sequenceNumberExtendedDataElement.setTypeAsInt(4);
                this.commonBaseEvent.addExtendedDataElement(this.sequenceNumberExtendedDataElement);
            }
            this.sequenceNumberExtendedDataElement.setValues(new String[]{Long.toString(seq)});
        } else {
            super.setSequenceNumber(seq);
        }
    }

    public void setSourceClassName(String sourceClassName) {
        if (this.commonBaseEvent != null) {
            if (this.sourceClassNameExtendedDataElement == null) {
                this.sourceClassNameExtendedDataElement = EVENT_FACTORY.createExtendedDataElement();
                this.sourceClassNameExtendedDataElement.setName(EXTENDED_DATA_ELEMENT_NAME_SOURCE_CLASS_NAME);
                this.sourceClassNameExtendedDataElement.setTypeAsInt(7);
                this.commonBaseEvent.addExtendedDataElement(this.sourceClassNameExtendedDataElement);
            }
            this.sourceClassNameExtendedDataElement.setValues(new String[]{sourceClassName});
        } else {
            super.setSourceClassName(sourceClassName);
        }
    }

    public void setSourceMethodName(String sourceMethodName) {
        if (this.commonBaseEvent != null) {
            if (this.sourceMethodNameExtendedDataElement == null) {
                this.sourceMethodNameExtendedDataElement = EVENT_FACTORY.createExtendedDataElement();
                this.sourceMethodNameExtendedDataElement.setName(EXTENDED_DATA_ELEMENT_NAME_SOURCE_METHOD_NAME);
                this.sourceMethodNameExtendedDataElement.setTypeAsInt(7);
                this.commonBaseEvent.addExtendedDataElement(this.sourceMethodNameExtendedDataElement);
            }
            this.sourceMethodNameExtendedDataElement.setValues(new String[]{sourceMethodName});
        } else {
            super.setSourceMethodName(sourceMethodName);
        }
    }

    public void setThreadID(int threadID) {
        if (this.commonBaseEvent != null) {
            if (this.threadIDExtendedDataElement == null) {
                this.threadIDExtendedDataElement = EVENT_FACTORY.createExtendedDataElement();
                this.threadIDExtendedDataElement.setName(EXTENDED_DATA_ELEMENT_NAME_THREAD_ID);
                this.threadIDExtendedDataElement.setTypeAsInt(3);
                this.commonBaseEvent.addExtendedDataElement(this.threadIDExtendedDataElement);
            }
            this.threadIDExtendedDataElement.setValues(new String[]{Integer.toString(threadID)});
        } else {
            super.setThreadID(threadID);
        }
    }

    public void setThrown(Throwable thrown) {
        super.setThrown(thrown);
        if (this.commonBaseEvent != null) {
            if (this.isThrownSet) {
                this.commonBaseEvent.removeExtendedDataElements(EXTENDED_DATA_ELEMENT_NAME_THROWN);
            } else {
                this.isThrownSet = true;
            }
            this.commonBaseEvent.addExtendedDataElement(this.convertToExtendedDataElement(thrown));
        }
    }

    public CommonBaseEvent getCommonBaseEvent() {
        return this.commonBaseEvent;
    }

    public Level getLevel() {
        if (this.commonBaseEvent != null && this.levelNameExtendedDataElement != null) {
            String name = (String)this.levelNameExtendedDataElement.getValues().get(0);
            if (name != null) {
                try {
                    return Level.parse(name);
                }
                catch (IllegalArgumentException i) {
                    // empty catch block
                }
            }
            try {
                return new CommonBaseEventLevel(name, Integer.parseInt((String)this.levelNameExtendedDataElement.getValues().get(0)));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return super.getLevel();
    }

    public String getLoggerName() {
        if (this.commonBaseEvent != null) {
            if (this.loggerNameExtendedDataElement != null) {
                return (String)this.loggerNameExtendedDataElement.getValues().get(0);
            }
        } else {
            return super.getLoggerName();
        }
        return null;
    }

    public String getMessage() {
        if (this.commonBaseEvent != null) {
            MsgDataElement msgDataElement = this.commonBaseEvent.getMsgDataElement();
            if (msgDataElement != null) {
                return msgDataElement.getMsgCatalogId();
            }
        } else {
            return super.getMessage();
        }
        return null;
    }

    public long getMillis() {
        if (this.commonBaseEvent != null) {
            return this.commonBaseEvent.getCreationTimeAsLong();
        }
        return super.getMillis();
    }

    public Object[] getParameters() {
        EList msgCatalogTokens;
        int msgCatalogTokensCount;
        MsgDataElement msgDataElement;
        Object[] parameters = super.getParameters();
        if (parameters != null) {
            return parameters;
        }
        if (this.commonBaseEvent != null && (msgDataElement = this.commonBaseEvent.getMsgDataElement()) != null && (msgCatalogTokensCount = (msgCatalogTokens = msgDataElement.getMsgCatalogTokens()).size()) > 0) {
            Object[] msgCatalogTokensArray = new String[msgCatalogTokensCount];
            for (int counter = 0; counter < msgCatalogTokensCount; ++counter) {
                msgCatalogTokensArray[counter] = new String(((MsgCatalogToken)msgCatalogTokens.get(counter)).getValue());
            }
            return msgCatalogTokensArray;
        }
        return null;
    }

    public String getResourceBundleName() {
        if (this.commonBaseEvent != null) {
            MsgDataElement msgDataElement = this.commonBaseEvent.getMsgDataElement();
            if (msgDataElement != null) {
                return msgDataElement.getMsgCatalog();
            }
        } else {
            return super.getResourceBundleName();
        }
        return null;
    }

    public long getSequenceNumber() {
        if (this.commonBaseEvent != null) {
            if (this.sequenceNumberExtendedDataElement != null) {
                try {
                    return Long.parseLong((String)this.sequenceNumberExtendedDataElement.getValues().get(0));
                }
                catch (NumberFormatException numberFormatException) {}
            }
        } else {
            return super.getSequenceNumber();
        }
        return 0L;
    }

    public String getSourceClassName() {
        if (this.commonBaseEvent != null) {
            if (this.sourceClassNameExtendedDataElement != null) {
                return (String)this.sourceClassNameExtendedDataElement.getValues().get(0);
            }
        } else {
            return super.getSourceClassName();
        }
        return null;
    }

    public String getSourceMethodName() {
        if (this.commonBaseEvent != null) {
            if (this.sourceMethodNameExtendedDataElement != null) {
                return (String)this.sourceMethodNameExtendedDataElement.getValues().get(0);
            }
        } else {
            return super.getSourceMethodName();
        }
        return null;
    }

    public int getThreadID() {
        if (this.commonBaseEvent != null) {
            if (this.threadIDExtendedDataElement != null) {
                try {
                    return Integer.parseInt((String)this.threadIDExtendedDataElement.getValues().get(0));
                }
                catch (NumberFormatException numberFormatException) {}
            }
        } else {
            return super.getThreadID();
        }
        return 0;
    }

    public String externalizeCanonicalXmlString() {
        if (this.commonBaseEvent != null) {
            return EventFormatter.toCanonicalXMLString(this.commonBaseEvent, true);
        }
        return null;
    }

    public String externalizeCanonicalXmlDocString() {
        if (this.commonBaseEvent != null) {
            return EventFormatter.toCanonicalXMLDocString(this.commonBaseEvent, true);
        }
        return null;
    }

    public String toString() {
        if (this.commonBaseEvent != null) {
            return this.commonBaseEvent.toString();
        }
        return super.toString();
    }

    private ExtendedDataElement convertToExtendedDataElement(Throwable throwable) {
        ExtendedDataElement extendedDataElement = EVENT_FACTORY.createExtendedDataElement();
        extendedDataElement.setName(EXTENDED_DATA_ELEMENT_NAME_THROWN);
        extendedDataElement.setTypeAsInt(7);
        if (throwable == null) {
            extendedDataElement.setValues(new String[]{"null"});
        } else {
            ExtendedDataElement childExtendedDataElement = null;
            StackTraceElement[] stackTraceElements = throwable.getStackTrace();
            int stackTraceElementCount = 0;
            if (stackTraceElements != null) {
                for (int counter = 0; counter < stackTraceElements.length; ++counter) {
                    childExtendedDataElement = EVENT_FACTORY.createExtendedDataElement();
                    childExtendedDataElement.setName(EXTENDED_DATA_ELEMENT_NAME_THROWN_STACK_FRAME.concat(String.valueOf(++stackTraceElementCount)));
                    childExtendedDataElement.setTypeAsInt(7);
                    childExtendedDataElement.setValues(new String[]{String.valueOf(stackTraceElements[counter])});
                    extendedDataElement.addChild(childExtendedDataElement);
                }
            }
            StringBuffer thrownString = new StringBuffer(throwable.getClass().getName());
            String thrownMessage = throwable.getMessage();
            if (thrownMessage != null && thrownMessage.trim().length() > 0) {
                thrownString.append(": ");
                thrownString.append(thrownMessage.trim());
            }
            for (Throwable cause = throwable.getCause(); cause != null; cause = cause.getCause()) {
                thrownString.append(": Cause: ");
                thrownString.append(cause.getClass().getName());
                thrownMessage = cause.getMessage();
                if (thrownMessage != null && thrownMessage.trim().length() > 0) {
                    thrownString.append(": ");
                    thrownString.append(thrownMessage.trim());
                }
                if ((stackTraceElements = cause.getStackTrace()) == null) continue;
                for (int counter = 0; counter < stackTraceElements.length; ++counter) {
                    childExtendedDataElement = EVENT_FACTORY.createExtendedDataElement();
                    childExtendedDataElement.setName(EXTENDED_DATA_ELEMENT_NAME_THROWN_STACK_FRAME.concat(String.valueOf(++stackTraceElementCount)));
                    childExtendedDataElement.setTypeAsInt(7);
                    childExtendedDataElement.setValues(new String[]{String.valueOf(stackTraceElements[counter])});
                    extendedDataElement.addChild(childExtendedDataElement);
                }
            }
            extendedDataElement.setValues(new String[]{String.valueOf(thrownString)});
        }
        return extendedDataElement;
    }

    private void resolveExtendedDataElementReferences() {
        ListIterator listIterator = this.commonBaseEvent.getExtendedDataElements().listIterator();
        ExtendedDataElement extendedDataElement = null;
        String extendedDataElementName = null;
        while (listIterator.hasNext()) {
            extendedDataElement = (ExtendedDataElement)listIterator.next();
            extendedDataElementName = extendedDataElement.getName().trim();
            if (!extendedDataElementName.startsWith(EXTENDED_DATA_ELEMENT_NAME_NAMESPACE)) continue;
            if (this.levelNameExtendedDataElement == null && extendedDataElementName.equals(EXTENDED_DATA_ELEMENT_NAME_LEVEL)) {
                EList nameExtendedDataElements = extendedDataElement.getChildren(EXTENDED_DATA_ELEMENT_NAME_LEVEL_NAME);
                EList valueExtendedDataElements = extendedDataElement.getChildren(EXTENDED_DATA_ELEMENT_NAME_LEVEL_VALUE);
                if (nameExtendedDataElements.size() <= 0 || valueExtendedDataElements.size() <= 0) continue;
                this.levelNameExtendedDataElement = (ExtendedDataElement)nameExtendedDataElements.get(0);
                this.levelValueExtendedDataElement = (ExtendedDataElement)valueExtendedDataElements.get(0);
                continue;
            }
            if (this.loggerNameExtendedDataElement == null && extendedDataElementName.equals(EXTENDED_DATA_ELEMENT_NAME_LOGGER_NAME)) {
                this.loggerNameExtendedDataElement = extendedDataElement;
                continue;
            }
            if (this.sequenceNumberExtendedDataElement == null && extendedDataElementName.equals(EXTENDED_DATA_ELEMENT_NAME_SEQUENCE_NUMBER)) {
                this.sequenceNumberExtendedDataElement = extendedDataElement;
                continue;
            }
            if (this.sourceClassNameExtendedDataElement == null && extendedDataElementName.equals(EXTENDED_DATA_ELEMENT_NAME_SOURCE_CLASS_NAME)) {
                this.sourceClassNameExtendedDataElement = extendedDataElement;
                continue;
            }
            if (this.sourceMethodNameExtendedDataElement == null && extendedDataElementName.equals(EXTENDED_DATA_ELEMENT_NAME_SOURCE_METHOD_NAME)) {
                this.sourceMethodNameExtendedDataElement = extendedDataElement;
                continue;
            }
            if (this.threadIDExtendedDataElement == null && extendedDataElementName.equals(EXTENDED_DATA_ELEMENT_NAME_THREAD_ID)) {
                this.threadIDExtendedDataElement = extendedDataElement;
                continue;
            }
            if (this.isThrownSet || !extendedDataElementName.equals(EXTENDED_DATA_ELEMENT_NAME_THROWN)) continue;
            this.isThrownSet = true;
        }
    }
}

