/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.events.cbe.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.StringReader;
import java.util.StringTokenizer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.hyades.logging.core.XmlUtility;
import org.eclipse.hyades.logging.events.cbe.AssociatedEvent;
import org.eclipse.hyades.logging.events.cbe.AssociationEngine;
import org.eclipse.hyades.logging.events.cbe.AvailableSituation;
import org.eclipse.hyades.logging.events.cbe.CommonBaseEvent;
import org.eclipse.hyades.logging.events.cbe.ComponentIdentification;
import org.eclipse.hyades.logging.events.cbe.ConfigureSituation;
import org.eclipse.hyades.logging.events.cbe.ConnectSituation;
import org.eclipse.hyades.logging.events.cbe.ContextDataElement;
import org.eclipse.hyades.logging.events.cbe.CreateSituation;
import org.eclipse.hyades.logging.events.cbe.DependencySituation;
import org.eclipse.hyades.logging.events.cbe.DestroySituation;
import org.eclipse.hyades.logging.events.cbe.ExtendedDataElement;
import org.eclipse.hyades.logging.events.cbe.FeatureSituation;
import org.eclipse.hyades.logging.events.cbe.FormattingException;
import org.eclipse.hyades.logging.events.cbe.MsgCatalogToken;
import org.eclipse.hyades.logging.events.cbe.OtherSituation;
import org.eclipse.hyades.logging.events.cbe.ReportSituation;
import org.eclipse.hyades.logging.events.cbe.RequestSituation;
import org.eclipse.hyades.logging.events.cbe.SituationType;
import org.eclipse.hyades.logging.events.cbe.StartSituation;
import org.eclipse.hyades.logging.events.cbe.StopSituation;
import org.eclipse.hyades.logging.events.cbe.impl.TemplateContentHandlerImpl;
import org.eclipse.hyades.logging.events.cbe.util.SAXEventHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public final class EventFormatter {
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");

    public static synchronized String toCanonicalXMLDocString(AssociationEngine associationEngine) {
        return EventFormatter.toCanonicalXMLDocString(associationEngine, true);
    }

    public static synchronized String toCanonicalXMLDocString(AssociationEngine associationEngine, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer(256);
        stringBuffer.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        stringBuffer.append("<CommonBaseEvents xmlns=\"http://www.ibm.com/AC/commonbaseevent1_0_1\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://www.ibm.com/AC/commonbaseevent1_0_1 commonbaseevent1_0_1.xsd \">");
        if (bl) {
            stringBuffer.append(LINE_SEPARATOR);
            stringBuffer.append("\t");
        }
        stringBuffer.append(EventFormatter.toCanonicalXMLString(associationEngine));
        if (bl) {
            stringBuffer.append(LINE_SEPARATOR);
        }
        stringBuffer.append("</CommonBaseEvents>");
        return stringBuffer.toString();
    }

    public static synchronized String toCanonicalXMLString(AssociationEngine associationEngine) {
        StringBuffer stringBuffer = new StringBuffer(256);
        stringBuffer.append("<AssociationEngine");
        String string = associationEngine.getId();
        if (string != null) {
            stringBuffer.append(" id=\"");
            stringBuffer.append(string);
            stringBuffer.append("\"");
        }
        if ((string = associationEngine.getName()) != null) {
            stringBuffer.append(" name=\"");
            stringBuffer.append(string);
            stringBuffer.append("\"");
        }
        if ((string = associationEngine.getType()) != null) {
            stringBuffer.append(" type=\"");
            stringBuffer.append(string);
            stringBuffer.append("\"");
        }
        stringBuffer.append("/>");
        return stringBuffer.toString();
    }

    public static synchronized void fromCanonicalXMLDocString(AssociationEngine associationEngine, String string) {
        try {
            AssociationEngine[] associationEngineArray = EventFormatter.associationEnginesFromCanonicalXMLDoc(string);
            if (associationEngine != null && associationEngineArray != null && associationEngineArray[0] != null) {
                associationEngine.setId(associationEngineArray[0].getId());
                associationEngine.setName(associationEngineArray[0].getName());
                associationEngine.setType(associationEngineArray[0].getType());
            } else {
                associationEngine = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static synchronized AssociationEngine[] associationEnginesFromCanonicalXMLDoc(String string) throws FormattingException {
        return EventFormatter.associationEnginesFromCanonicalXMLDoc(new InputSource(new StringReader(string)));
    }

    public static synchronized AssociationEngine[] associationEnginesFromCanonicalXMLDoc(InputSource inputSource) throws FormattingException {
        return EventFormatter.parse(inputSource).getAssociationEngines();
    }

    public static synchronized AssociationEngine[] associationEnginesFromCanonicalXMLDoc(InputStream inputStream) throws FormattingException {
        return EventFormatter.associationEnginesFromCanonicalXMLDoc(new InputSource(inputStream));
    }

    public static synchronized AssociationEngine[] associationEnginesFromCanonicalXMLDoc(File file) throws FormattingException {
        try {
            return EventFormatter.associationEnginesFromCanonicalXMLDoc(new InputSource(new FileInputStream(file)));
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new FormattingException(fileNotFoundException);
        }
    }

    public static synchronized void fromCanonicalXMLString(AssociationEngine associationEngine, String string) {
        try {
            AssociationEngine associationEngine2 = EventFormatter.associationEngineFromCanonicalXML(string);
            if (associationEngine != null && associationEngine2 != null) {
                associationEngine.setId(associationEngine2.getId());
                associationEngine.setName(associationEngine2.getName());
                associationEngine.setType(associationEngine2.getType());
            } else {
                associationEngine = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static synchronized AssociationEngine associationEngineFromCanonicalXML(String string) throws FormattingException {
        AssociationEngine[] associationEngineArray = EventFormatter.associationEnginesFromCanonicalXMLDoc(string);
        if (associationEngineArray != null) {
            return associationEngineArray[0];
        }
        return null;
    }

    public static synchronized String toCanonicalXMLDocString(CommonBaseEvent commonBaseEvent) {
        return EventFormatter.toCanonicalXMLDocString(commonBaseEvent, true);
    }

    public static synchronized String toCanonicalXMLDocString(CommonBaseEvent commonBaseEvent, boolean bl) {
        Object object;
        EList eList;
        StringBuffer stringBuffer = new StringBuffer(1024);
        stringBuffer.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        stringBuffer.append("<CommonBaseEvents xmlns=\"http://www.ibm.com/AC/commonbaseevent1_0_1\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://www.ibm.com/AC/commonbaseevent1_0_1 commonbaseevent1_0_1.xsd\">");
        if (bl) {
            stringBuffer.append(LINE_SEPARATOR);
        }
        if ((eList = commonBaseEvent.getAssociatedEvents()) != null && eList.size() > 0) {
            object = null;
            for (int i = 0; i < eList.size(); ++i) {
                object = ((AssociatedEvent)eList.get(i)).getAssociationEngineInfo();
                if (object == null) continue;
                if (bl) {
                    stringBuffer.append("\t");
                }
                stringBuffer.append(EventFormatter.toCanonicalXMLString((AssociationEngine)object));
                if (!bl) continue;
                stringBuffer.append(LINE_SEPARATOR);
            }
        }
        if (bl) {
            object = new StringTokenizer(EventFormatter.toCanonicalXMLString(commonBaseEvent, bl).trim(), LINE_SEPARATOR);
            while (((StringTokenizer)object).hasMoreTokens()) {
                stringBuffer.append("\t");
                stringBuffer.append(((StringTokenizer)object).nextToken());
                stringBuffer.append(LINE_SEPARATOR);
            }
        } else {
            stringBuffer.append(EventFormatter.toCanonicalXMLString(commonBaseEvent, bl));
        }
        stringBuffer.append("</CommonBaseEvents>");
        return stringBuffer.toString();
    }

    public static synchronized String toCanonicalXMLString(CommonBaseEvent commonBaseEvent) {
        return EventFormatter.toCanonicalXMLString(commonBaseEvent, true);
    }

    public static synchronized String toCanonicalXMLString(CommonBaseEvent commonBaseEvent, boolean bl) {
        EList eList;
        ComponentIdentification componentIdentification;
        Object object;
        Object object2;
        EList eList2;
        EList eList3;
        String string;
        StringBuffer stringBuffer = new StringBuffer(1024);
        stringBuffer.append("<CommonBaseEvent");
        if (commonBaseEvent.isSetCreationTime()) {
            stringBuffer.append(" creationTime=\"");
            stringBuffer.append(commonBaseEvent.getCreationTime());
            stringBuffer.append("\"");
        }
        if ((string = commonBaseEvent.getExtensionName()) != null) {
            stringBuffer.append(" extensionName=\"");
            stringBuffer.append(string);
            stringBuffer.append("\"");
        }
        if ((string = commonBaseEvent.getGlobalInstanceId()) != null) {
            stringBuffer.append(" globalInstanceId=\"");
            stringBuffer.append(string);
            stringBuffer.append("\"");
        }
        if ((string = commonBaseEvent.getLocalInstanceId()) != null) {
            stringBuffer.append(" localInstanceId=\"");
            stringBuffer.append(XmlUtility.normalize(string));
            stringBuffer.append("\"");
        }
        if ((string = commonBaseEvent.getMsg()) != null) {
            stringBuffer.append(" msg=\"");
            stringBuffer.append(XmlUtility.normalize(string));
            stringBuffer.append("\"");
        }
        if (commonBaseEvent.isSetElapsedTime()) {
            stringBuffer.append(" elapsedTime=\"");
            stringBuffer.append(commonBaseEvent.getElapsedTime());
            stringBuffer.append("\"");
        }
        if (commonBaseEvent.isSetPriority()) {
            stringBuffer.append(" priority=\"");
            stringBuffer.append(commonBaseEvent.getPriority());
            stringBuffer.append("\"");
        }
        if (commonBaseEvent.isSetRepeatCount()) {
            stringBuffer.append(" repeatCount=\"");
            stringBuffer.append(commonBaseEvent.getRepeatCount());
            stringBuffer.append("\"");
        }
        if (commonBaseEvent.isSetSequenceNumber()) {
            stringBuffer.append(" sequenceNumber=\"");
            stringBuffer.append(commonBaseEvent.getSequenceNumber());
            stringBuffer.append("\"");
        }
        if (commonBaseEvent.isSetSeverity()) {
            stringBuffer.append(" severity=\"");
            stringBuffer.append(commonBaseEvent.getSeverity());
            stringBuffer.append("\"");
        }
        if ((string = commonBaseEvent.getVersion()) != null) {
            stringBuffer.append(" version=\"");
            stringBuffer.append(XmlUtility.normalize(string));
            stringBuffer.append("\"");
        }
        stringBuffer.append(">");
        EList eList4 = commonBaseEvent.getContextDataElements();
        if (eList4 != null) {
            for (int i = 0; i < eList4.size(); ++i) {
                if (eList4.get(i) == null) continue;
                if (bl) {
                    stringBuffer.append(LINE_SEPARATOR);
                    stringBuffer.append("\t");
                }
                stringBuffer.append("<contextDataElements");
                string = ((ContextDataElement)eList4.get(i)).getName();
                if (string != null) {
                    stringBuffer.append(" name=\"");
                    stringBuffer.append(string);
                    stringBuffer.append("\"");
                }
                if ((string = ((ContextDataElement)eList4.get(i)).getType()) != null) {
                    stringBuffer.append(" type=\"");
                    stringBuffer.append(string);
                    stringBuffer.append("\"");
                }
                stringBuffer.append(">");
                string = ((ContextDataElement)eList4.get(i)).getContextId();
                if (string != null) {
                    if (bl) {
                        stringBuffer.append(LINE_SEPARATOR);
                        stringBuffer.append("\t\t");
                    }
                    stringBuffer.append("<contextId>");
                    stringBuffer.append(string);
                    stringBuffer.append("</contextId>");
                } else {
                    string = ((ContextDataElement)eList4.get(i)).getContextValue();
                    if (string != null) {
                        if (bl) {
                            stringBuffer.append(LINE_SEPARATOR);
                            stringBuffer.append("\t\t");
                        }
                        stringBuffer.append("<contextValue>");
                        stringBuffer.append(XmlUtility.normalize(string));
                        stringBuffer.append("</contextValue>");
                    }
                }
                if (bl) {
                    stringBuffer.append(LINE_SEPARATOR);
                    stringBuffer.append("\t");
                }
                stringBuffer.append("</contextDataElements>");
            }
        }
        if ((eList3 = commonBaseEvent.getExtendedDataElements()) != null) {
            for (int i = 0; i < eList3.size(); ++i) {
                stringBuffer.append(EventFormatter.getExtendedDataElementXML((ExtendedDataElement)eList3.get(i), "extendedDataElements", bl, bl ? 1 : 0));
            }
        }
        if ((eList2 = commonBaseEvent.getAssociatedEvents()) != null) {
            for (int i = 0; i < eList2.size(); ++i) {
                if (eList2.get(i) == null) continue;
                if (bl) {
                    stringBuffer.append(LINE_SEPARATOR);
                    stringBuffer.append("\t");
                }
                stringBuffer.append("<associatedEvents");
                object2 = ((AssociatedEvent)eList2.get(i)).getResolvedEvents();
                if (object2 != null) {
                    stringBuffer.append(" resolvedEvents=\"");
                    stringBuffer.append((String)object2);
                    stringBuffer.append("\"");
                }
                stringBuffer.append(">");
                if (bl) {
                    stringBuffer.append(LINE_SEPARATOR);
                    stringBuffer.append("\t\t");
                }
                if ((object = ((AssociatedEvent)eList2.get(i)).getAssociationEngineInfo()) != null) {
                    String string2 = EventFormatter.toCanonicalXMLString((AssociationEngine)object).trim();
                    stringBuffer.append("<associationEngineInfo");
                    stringBuffer.append(string2.substring(18));
                } else {
                    string = ((AssociatedEvent)eList2.get(i)).getAssociationEngine();
                    if (string != null) {
                        stringBuffer.append("<associationEngine>");
                        stringBuffer.append(string);
                        stringBuffer.append("</associationEngine>");
                    }
                }
                if (bl) {
                    stringBuffer.append(LINE_SEPARATOR);
                    stringBuffer.append("\t");
                }
                stringBuffer.append("</associatedEvents>");
            }
        }
        if ((componentIdentification = commonBaseEvent.getReporterComponentId()) != null) {
            if (bl) {
                stringBuffer.append(LINE_SEPARATOR);
                stringBuffer.append("\t");
            }
            stringBuffer.append("<reporterComponentId");
            string = componentIdentification.getApplication();
            if (string != null) {
                stringBuffer.append(" application=\"");
                stringBuffer.append(XmlUtility.normalize(string));
                stringBuffer.append("\"");
            }
            if ((string = componentIdentification.getComponent()) != null) {
                stringBuffer.append(" component=\"");
                stringBuffer.append(XmlUtility.normalize(string));
                stringBuffer.append("\"");
            }
            if ((string = componentIdentification.getComponentIdType()) != null) {
                stringBuffer.append(" componentIdType=\"");
                stringBuffer.append(XmlUtility.normalize(string));
                stringBuffer.append("\"");
            }
            if ((string = componentIdentification.getExecutionEnvironment()) != null) {
                stringBuffer.append(" executionEnvironment=\"");
                stringBuffer.append(XmlUtility.normalize(string));
                stringBuffer.append("\"");
            }
            if ((string = componentIdentification.getInstanceId()) != null) {
                stringBuffer.append(" instanceId=\"");
                stringBuffer.append(XmlUtility.normalize(string));
                stringBuffer.append("\"");
            }
            if ((string = componentIdentification.getLocation()) != null) {
                stringBuffer.append(" location=\"");
                stringBuffer.append(XmlUtility.normalize(string));
                stringBuffer.append("\"");
            }
            if ((string = componentIdentification.getLocationType()) != null) {
                stringBuffer.append(" locationType=\"");
                stringBuffer.append(string);
                stringBuffer.append("\"");
            }
            if ((string = componentIdentification.getProcessId()) != null) {
                stringBuffer.append(" processId=\"");
                stringBuffer.append(XmlUtility.normalize(string));
                stringBuffer.append("\"");
            }
            if ((string = componentIdentification.getSubComponent()) != null) {
                stringBuffer.append(" subComponent=\"");
                stringBuffer.append(XmlUtility.normalize(string));
                stringBuffer.append("\"");
            }
            if ((string = componentIdentification.getThreadId()) != null) {
                stringBuffer.append(" threadId=\"");
                stringBuffer.append(XmlUtility.normalize(string));
                stringBuffer.append("\"");
            }
            if ((string = componentIdentification.getComponentType()) != null) {
                stringBuffer.append(" componentType=\"");
                stringBuffer.append(XmlUtility.normalize(string));
                stringBuffer.append("\"");
            }
            stringBuffer.append("/>");
        }
        if ((componentIdentification = commonBaseEvent.getSourceComponentId()) != null) {
            if (bl) {
                stringBuffer.append(LINE_SEPARATOR);
                stringBuffer.append("\t");
            }
            stringBuffer.append("<sourceComponentId");
            string = componentIdentification.getApplication();
            if (string != null) {
                stringBuffer.append(" application=\"");
                stringBuffer.append(XmlUtility.normalize(string));
                stringBuffer.append("\"");
            }
            if ((string = componentIdentification.getComponent()) != null) {
                stringBuffer.append(" component=\"");
                stringBuffer.append(XmlUtility.normalize(string));
                stringBuffer.append("\"");
            }
            if ((string = componentIdentification.getComponentIdType()) != null) {
                stringBuffer.append(" componentIdType=\"");
                stringBuffer.append(XmlUtility.normalize(string));
                stringBuffer.append("\"");
            }
            if ((string = componentIdentification.getExecutionEnvironment()) != null) {
                stringBuffer.append(" executionEnvironment=\"");
                stringBuffer.append(XmlUtility.normalize(string));
                stringBuffer.append("\"");
            }
            if ((string = componentIdentification.getInstanceId()) != null) {
                stringBuffer.append(" instanceId=\"");
                stringBuffer.append(XmlUtility.normalize(string));
                stringBuffer.append("\"");
            }
            if ((string = componentIdentification.getLocation()) != null) {
                stringBuffer.append(" location=\"");
                stringBuffer.append(XmlUtility.normalize(string));
                stringBuffer.append("\"");
            }
            if ((string = componentIdentification.getLocationType()) != null) {
                stringBuffer.append(" locationType=\"");
                stringBuffer.append(string);
                stringBuffer.append("\"");
            }
            if ((string = componentIdentification.getProcessId()) != null) {
                stringBuffer.append(" processId=\"");
                stringBuffer.append(XmlUtility.normalize(string));
                stringBuffer.append("\"");
            }
            if ((string = componentIdentification.getSubComponent()) != null) {
                stringBuffer.append(" subComponent=\"");
                stringBuffer.append(XmlUtility.normalize(string));
                stringBuffer.append("\"");
            }
            if ((string = componentIdentification.getThreadId()) != null) {
                stringBuffer.append(" threadId=\"");
                stringBuffer.append(XmlUtility.normalize(string));
                stringBuffer.append("\"");
            }
            if ((string = componentIdentification.getComponentType()) != null) {
                stringBuffer.append(" componentType=\"");
                stringBuffer.append(XmlUtility.normalize(string));
                stringBuffer.append("\"");
            }
            stringBuffer.append("/>");
        }
        if ((object2 = commonBaseEvent.getMsgDataElement()) != null) {
            if (bl) {
                stringBuffer.append(LINE_SEPARATOR);
                stringBuffer.append("\t");
            }
            stringBuffer.append("<msgDataElement");
            string = object2.getMsgLocale();
            if (string != null) {
                stringBuffer.append(" msgLocale=\"");
                stringBuffer.append(string);
                stringBuffer.append("\"");
            }
            stringBuffer.append(">");
            object = object2.getMsgCatalogTokens();
            if (object != null) {
                for (int i = 0; i < object.size(); ++i) {
                    if (object.get(i) == null || ((MsgCatalogToken)object.get(i)).getValue() == null) continue;
                    if (bl) {
                        stringBuffer.append(LINE_SEPARATOR);
                        stringBuffer.append("\t\t");
                    }
                    stringBuffer.append("<msgCatalogTokens value=\"");
                    stringBuffer.append(XmlUtility.normalize(((MsgCatalogToken)object.get(i)).getValue()));
                    stringBuffer.append("\"/>");
                }
            }
            if ((string = object2.getMsgId()) != null) {
                if (bl) {
                    stringBuffer.append(LINE_SEPARATOR);
                    stringBuffer.append("\t\t");
                }
                stringBuffer.append("<msgId>");
                stringBuffer.append(XmlUtility.normalize(string));
                stringBuffer.append("</msgId>");
            }
            if ((string = object2.getMsgIdType()) != null) {
                if (bl) {
                    stringBuffer.append(LINE_SEPARATOR);
                    stringBuffer.append("\t\t");
                }
                stringBuffer.append("<msgIdType>");
                stringBuffer.append(string);
                stringBuffer.append("</msgIdType>");
            }
            if ((string = object2.getMsgCatalogId()) != null) {
                if (bl) {
                    stringBuffer.append(LINE_SEPARATOR);
                    stringBuffer.append("\t\t");
                }
                stringBuffer.append("<msgCatalogId>");
                stringBuffer.append(XmlUtility.normalize(string));
                stringBuffer.append("</msgCatalogId>");
            }
            if ((string = object2.getMsgCatalogType()) != null) {
                if (bl) {
                    stringBuffer.append(LINE_SEPARATOR);
                    stringBuffer.append("\t\t");
                }
                stringBuffer.append("<msgCatalogType>");
                stringBuffer.append(string);
                stringBuffer.append("</msgCatalogType>");
            }
            if ((string = object2.getMsgCatalog()) != null) {
                if (bl) {
                    stringBuffer.append(LINE_SEPARATOR);
                    stringBuffer.append("\t\t");
                }
                stringBuffer.append("<msgCatalog>");
                stringBuffer.append(XmlUtility.normalize(string));
                stringBuffer.append("</msgCatalog>");
            }
            if (bl) {
                stringBuffer.append(LINE_SEPARATOR);
                stringBuffer.append("\t");
            }
            stringBuffer.append("</msgDataElement>");
        }
        if ((object = commonBaseEvent.getSituation()) != null) {
            if (bl) {
                stringBuffer.append(LINE_SEPARATOR);
                stringBuffer.append("\t");
            }
            stringBuffer.append("<situation");
            string = object.getCategoryName();
            if (string != null) {
                stringBuffer.append(" categoryName=\"");
                stringBuffer.append(XmlUtility.normalize(string));
                stringBuffer.append("\"");
            }
            stringBuffer.append(">");
            SituationType situationType = object.getSituationType();
            if (situationType != null) {
                if (bl) {
                    stringBuffer.append(LINE_SEPARATOR);
                    stringBuffer.append("\t\t");
                }
                stringBuffer.append("<situationType xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"");
                string = situationType.getReasoningScope();
                if (situationType instanceof StartSituation) {
                    stringBuffer.append(" xsi:type=\"StartSituation\"");
                    if (string != null) {
                        stringBuffer.append(" reasoningScope=\"");
                        stringBuffer.append(XmlUtility.normalize(string));
                        stringBuffer.append("\"");
                    }
                    if ((string = ((StartSituation)situationType).getSuccessDisposition()) != null) {
                        stringBuffer.append(" successDisposition=\"");
                        stringBuffer.append(XmlUtility.normalize(string));
                        stringBuffer.append("\"");
                    }
                    if ((string = ((StartSituation)situationType).getSituationQualifier()) != null) {
                        stringBuffer.append(" situationQualifier=\"");
                        stringBuffer.append(XmlUtility.normalize(string));
                        stringBuffer.append("\"");
                    }
                    stringBuffer.append("/>");
                } else if (situationType instanceof StopSituation) {
                    stringBuffer.append(" xsi:type=\"StopSituation\"");
                    if (string != null) {
                        stringBuffer.append(" reasoningScope=\"");
                        stringBuffer.append(XmlUtility.normalize(string));
                        stringBuffer.append("\"");
                    }
                    if ((string = ((StopSituation)situationType).getSuccessDisposition()) != null) {
                        stringBuffer.append(" successDisposition=\"");
                        stringBuffer.append(XmlUtility.normalize(string));
                        stringBuffer.append("\"");
                    }
                    if ((string = ((StopSituation)situationType).getSituationQualifier()) != null) {
                        stringBuffer.append(" situationQualifier=\"");
                        stringBuffer.append(XmlUtility.normalize(string));
                        stringBuffer.append("\"");
                    }
                    stringBuffer.append("/>");
                } else if (situationType instanceof ConnectSituation) {
                    stringBuffer.append(" xsi:type=\"ConnectSituation\"");
                    if (string != null) {
                        stringBuffer.append(" reasoningScope=\"");
                        stringBuffer.append(XmlUtility.normalize(string));
                        stringBuffer.append("\"");
                    }
                    if ((string = ((ConnectSituation)situationType).getSuccessDisposition()) != null) {
                        stringBuffer.append(" successDisposition=\"");
                        stringBuffer.append(XmlUtility.normalize(string));
                        stringBuffer.append("\"");
                    }
                    if ((string = ((ConnectSituation)situationType).getSituationDisposition()) != null) {
                        stringBuffer.append(" situationDisposition=\"");
                        stringBuffer.append(XmlUtility.normalize(string));
                        stringBuffer.append("\"");
                    }
                    stringBuffer.append("/>");
                } else if (situationType instanceof ReportSituation) {
                    stringBuffer.append(" xsi:type=\"ReportSituation\"");
                    if (string != null) {
                        stringBuffer.append(" reasoningScope=\"");
                        stringBuffer.append(XmlUtility.normalize(string));
                        stringBuffer.append("\"");
                    }
                    if ((string = ((ReportSituation)situationType).getReportCategory()) != null) {
                        stringBuffer.append(" reportCategory=\"");
                        stringBuffer.append(XmlUtility.normalize(string));
                        stringBuffer.append("\"");
                    }
                    stringBuffer.append("/>");
                } else if (situationType instanceof FeatureSituation) {
                    stringBuffer.append(" xsi:type=\"FeatureSituation\"");
                    if (string != null) {
                        stringBuffer.append(" reasoningScope=\"");
                        stringBuffer.append(XmlUtility.normalize(string));
                        stringBuffer.append("\"");
                    }
                    if ((string = ((FeatureSituation)situationType).getFeatureDisposition()) != null) {
                        stringBuffer.append(" featureDisposition=\"");
                        stringBuffer.append(XmlUtility.normalize(string));
                        stringBuffer.append("\"");
                    }
                    stringBuffer.append("/>");
                } else if (situationType instanceof ConfigureSituation) {
                    stringBuffer.append(" xsi:type=\"ConfigureSituation\"");
                    if (string != null) {
                        stringBuffer.append(" reasoningScope=\"");
                        stringBuffer.append(XmlUtility.normalize(string));
                        stringBuffer.append("\"");
                    }
                    if ((string = ((ConfigureSituation)situationType).getSuccessDisposition()) != null) {
                        stringBuffer.append(" successDisposition=\"");
                        stringBuffer.append(XmlUtility.normalize(string));
                        stringBuffer.append("\"");
                    }
                    stringBuffer.append("/>");
                } else if (situationType instanceof DependencySituation) {
                    stringBuffer.append(" xsi:type=\"DependencySituation\"");
                    if (string != null) {
                        stringBuffer.append(" reasoningScope=\"");
                        stringBuffer.append(XmlUtility.normalize(string));
                        stringBuffer.append("\"");
                    }
                    if ((string = ((DependencySituation)situationType).getDependencyDisposition()) != null) {
                        stringBuffer.append(" dependencyDisposition=\"");
                        stringBuffer.append(XmlUtility.normalize(string));
                        stringBuffer.append("\"");
                    }
                    stringBuffer.append("/>");
                } else if (situationType instanceof CreateSituation) {
                    stringBuffer.append(" xsi:type=\"CreateSituation\"");
                    if (string != null) {
                        stringBuffer.append(" reasoningScope=\"");
                        stringBuffer.append(XmlUtility.normalize(string));
                        stringBuffer.append("\"");
                    }
                    if ((string = ((CreateSituation)situationType).getSuccessDisposition()) != null) {
                        stringBuffer.append(" successDisposition=\"");
                        stringBuffer.append(XmlUtility.normalize(string));
                        stringBuffer.append("\"");
                    }
                    stringBuffer.append("/>");
                } else if (situationType instanceof DestroySituation) {
                    stringBuffer.append(" xsi:type=\"DestroySituation\"");
                    if (string != null) {
                        stringBuffer.append(" reasoningScope=\"");
                        stringBuffer.append(XmlUtility.normalize(string));
                        stringBuffer.append("\"");
                    }
                    if ((string = ((DestroySituation)situationType).getSuccessDisposition()) != null) {
                        stringBuffer.append(" successDisposition=\"");
                        stringBuffer.append(XmlUtility.normalize(string));
                        stringBuffer.append("\"");
                    }
                    stringBuffer.append("/>");
                } else if (situationType instanceof AvailableSituation) {
                    stringBuffer.append(" xsi:type=\"AvailableSituation\"");
                    if (string != null) {
                        stringBuffer.append(" reasoningScope=\"");
                        stringBuffer.append(XmlUtility.normalize(string));
                        stringBuffer.append("\"");
                    }
                    if ((string = ((AvailableSituation)situationType).getOperationDisposition()) != null) {
                        stringBuffer.append(" operationDisposition=\"");
                        stringBuffer.append(XmlUtility.normalize(string));
                        stringBuffer.append("\"");
                    }
                    if ((string = ((AvailableSituation)situationType).getProcessingDisposition()) != null) {
                        stringBuffer.append(" processingDisposition=\"");
                        stringBuffer.append(XmlUtility.normalize(string));
                        stringBuffer.append("\"");
                    }
                    if ((string = ((AvailableSituation)situationType).getAvailabilityDisposition()) != null) {
                        stringBuffer.append(" availabilityDisposition=\"");
                        stringBuffer.append(XmlUtility.normalize(string));
                        stringBuffer.append("\"");
                    }
                    stringBuffer.append("/>");
                } else if (situationType instanceof RequestSituation) {
                    stringBuffer.append(" xsi:type=\"RequestSituation\"");
                    if (string != null) {
                        stringBuffer.append(" reasoningScope=\"");
                        stringBuffer.append(XmlUtility.normalize(string));
                        stringBuffer.append("\"");
                    }
                    if ((string = ((RequestSituation)situationType).getSuccessDisposition()) != null) {
                        stringBuffer.append(" successDisposition=\"");
                        stringBuffer.append(XmlUtility.normalize(string));
                        stringBuffer.append("\"");
                    }
                    if ((string = ((RequestSituation)situationType).getSituationQualifier()) != null) {
                        stringBuffer.append(" situationQualifier=\"");
                        stringBuffer.append(XmlUtility.normalize(string));
                        stringBuffer.append("\"");
                    }
                    stringBuffer.append("/>");
                } else if (situationType instanceof OtherSituation) {
                    stringBuffer.append(" xsi:type=\"OtherSituation\"");
                    if (string != null) {
                        stringBuffer.append(" reasoningScope=\"");
                        stringBuffer.append(XmlUtility.normalize(string));
                        stringBuffer.append("\"");
                    }
                    stringBuffer.append(">");
                    String string3 = ((OtherSituation)situationType).getAny();
                    if (string3 != null) {
                        if (bl) {
                            stringBuffer.append(LINE_SEPARATOR);
                            stringBuffer.append("\t\t\t");
                        }
                        stringBuffer.append(string3);
                    }
                    if (bl) {
                        stringBuffer.append(LINE_SEPARATOR);
                        stringBuffer.append("\t\t");
                    }
                    stringBuffer.append("</situationType>");
                } else {
                    stringBuffer.append("/>");
                }
            }
            if (bl) {
                stringBuffer.append(LINE_SEPARATOR);
                stringBuffer.append("\t");
            }
            stringBuffer.append("</situation>");
        }
        if ((eList = commonBaseEvent.getAny()) != null) {
            for (int i = 0; i < eList.size(); ++i) {
                if (eList.get(i) == null) continue;
                if (bl) {
                    stringBuffer.append(LINE_SEPARATOR);
                    stringBuffer.append("\t");
                }
                stringBuffer.append((String)eList.get(i));
            }
        }
        if (bl) {
            stringBuffer.append(LINE_SEPARATOR);
        }
        stringBuffer.append("</CommonBaseEvent>");
        return stringBuffer.toString();
    }

    public static synchronized void fromCanonicalXMLDocString(CommonBaseEvent commonBaseEvent, String string) {
        try {
            CommonBaseEvent[] commonBaseEventArray = EventFormatter.eventsFromCanonicalXMLDoc(string);
            if (commonBaseEvent != null && commonBaseEventArray != null && commonBaseEventArray[0] != null) {
                TemplateContentHandlerImpl templateContentHandlerImpl = new TemplateContentHandlerImpl();
                templateContentHandlerImpl.setTemplateEvent(commonBaseEventArray[0]);
                commonBaseEvent.setContentHandler(templateContentHandlerImpl);
                commonBaseEvent.complete();
                commonBaseEvent.setContentHandler(null);
            } else {
                commonBaseEvent = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static synchronized CommonBaseEvent[] eventsFromCanonicalXMLDoc(String string) throws FormattingException {
        return EventFormatter.eventsFromCanonicalXMLDoc(new InputSource(new StringReader(string)));
    }

    public static synchronized CommonBaseEvent[] eventsFromCanonicalXMLDoc(InputSource inputSource) throws FormattingException {
        return EventFormatter.parse(inputSource).getCommonBaseEvents();
    }

    public static synchronized CommonBaseEvent[] eventsFromCanonicalXMLDoc(InputStream inputStream) throws FormattingException {
        return EventFormatter.eventsFromCanonicalXMLDoc(new InputSource(inputStream));
    }

    public static synchronized CommonBaseEvent[] eventsFromCanonicalXMLDoc(File file) throws FormattingException {
        try {
            return EventFormatter.eventsFromCanonicalXMLDoc(new InputSource(new FileInputStream(file)));
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new FormattingException(fileNotFoundException);
        }
    }

    public static synchronized void fromCanonicalXMLString(CommonBaseEvent commonBaseEvent, String string) {
        try {
            CommonBaseEvent commonBaseEvent2 = EventFormatter.eventFromCanonicalXML(string);
            if (commonBaseEvent != null && commonBaseEvent2 != null) {
                TemplateContentHandlerImpl templateContentHandlerImpl = new TemplateContentHandlerImpl();
                templateContentHandlerImpl.setTemplateEvent(commonBaseEvent2);
                commonBaseEvent.setContentHandler(templateContentHandlerImpl);
                commonBaseEvent.complete();
                commonBaseEvent.setContentHandler(null);
            } else {
                commonBaseEvent = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static synchronized CommonBaseEvent eventFromCanonicalXML(String string) throws FormattingException {
        CommonBaseEvent[] commonBaseEventArray = EventFormatter.eventsFromCanonicalXMLDoc(string);
        if (commonBaseEventArray != null) {
            return commonBaseEventArray[0];
        }
        return null;
    }

    private static synchronized String getExtendedDataElementXML(ExtendedDataElement extendedDataElement, String string, boolean bl, int n) {
        if (extendedDataElement != null) {
            int n2;
            Object object;
            StringBuffer stringBuffer = new StringBuffer(512);
            if (bl) {
                stringBuffer.append(LINE_SEPARATOR);
                for (int i = 0; i < n; ++i) {
                    stringBuffer.append("\t");
                }
            }
            stringBuffer.append("<");
            if (string != null) {
                stringBuffer.append(string);
            } else {
                stringBuffer.append("extendedDataElements");
            }
            String string2 = extendedDataElement.getName();
            if (string2 != null) {
                stringBuffer.append(" name=\"");
                stringBuffer.append(XmlUtility.normalize(string2));
                stringBuffer.append("\"");
            }
            if ((string2 = extendedDataElement.getType()) != null) {
                stringBuffer.append(" type=\"");
                stringBuffer.append(XmlUtility.normalize(string2));
                stringBuffer.append("\"");
            }
            stringBuffer.append(">");
            if (extendedDataElement.getTypeAsInt() == 19) {
                object = extendedDataElement.getHexValue();
                if (object != null) {
                    if (bl) {
                        stringBuffer.append(LINE_SEPARATOR);
                        for (n2 = 0; n2 < n + 1; ++n2) {
                            stringBuffer.append("\t");
                        }
                    }
                    stringBuffer.append("<hexValue>");
                    stringBuffer.append((String)object);
                    stringBuffer.append("</hexValue>");
                }
            } else {
                object = extendedDataElement.getValues();
                if (object != null && object.size() > 0) {
                    for (n2 = 0; n2 < object.size(); ++n2) {
                        if (object.get(n2) == null) continue;
                        if (bl) {
                            stringBuffer.append(LINE_SEPARATOR);
                            for (int i = 0; i < n + 1; ++i) {
                                stringBuffer.append("\t");
                            }
                        }
                        stringBuffer.append("<values>");
                        stringBuffer.append(XmlUtility.normalize((String)object.get(n2)));
                        stringBuffer.append("</values>");
                    }
                }
            }
            if ((object = extendedDataElement.getChildren()) != null) {
                for (n2 = 0; n2 < object.size(); ++n2) {
                    stringBuffer.append(EventFormatter.getExtendedDataElementXML((ExtendedDataElement)object.get(n2), "children", bl, bl ? n + 1 : 0));
                }
            }
            if (bl) {
                stringBuffer.append(LINE_SEPARATOR);
                for (n2 = 0; n2 < n; ++n2) {
                    stringBuffer.append("\t");
                }
            }
            stringBuffer.append("</");
            if (string != null) {
                stringBuffer.append(string);
            } else {
                stringBuffer.append("extendedDataElements");
            }
            stringBuffer.append(">");
            return stringBuffer.toString();
        }
        return "";
    }

    private static SAXEventHandler parse(InputSource inputSource) throws FormattingException {
        try {
            SAXEventHandler sAXEventHandler = new SAXEventHandler();
            XMLReader xMLReader = null;
            try {
                xMLReader = XMLReaderFactory.createXMLReader();
            }
            catch (SAXException sAXException) {
                System.setProperty("org.xml.sax.driver", "org.apache.crimson.parser.XMLReaderImpl");
                xMLReader = XMLReaderFactory.createXMLReader();
            }
            xMLReader.setContentHandler(sAXEventHandler);
            xMLReader.setErrorHandler(sAXEventHandler);
            xMLReader.setFeature("http://xml.org/sax/features/validation", false);
            xMLReader.setFeature("http://xml.org/sax/features/namespaces", false);
            xMLReader.parse(inputSource);
            return sAXEventHandler;
        }
        catch (Exception exception) {
            throw new FormattingException(exception);
        }
    }
}

