/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.events.cbe;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class EventException
extends Exception {
    protected String file;
    protected String key = null;
    protected Object[] parms = null;
    private Throwable ivCause = this;

    public EventException() {
    }

    public EventException(String string) {
        super(string);
    }

    public EventException(String string, String string2) {
        this(string, string2, null);
    }

    public EventException(Throwable throwable) {
        this(throwable.getMessage());
        this.ivCause = throwable;
    }

    public EventException(String string, Throwable throwable) {
        this(string);
        this.ivCause = throwable;
    }

    public EventException(String string, String string2, Object[] objectArray) {
        this.key = string;
        this.file = string2;
        this.parms = objectArray;
        this.ivCause = null;
    }

    public EventException(String string, String string2, Object[] objectArray, Throwable throwable) {
        this.key = string;
        this.file = string2;
        this.parms = objectArray;
        if (throwable != null) {
            this.ivCause = throwable;
        }
    }

    public Throwable getCause() {
        if (this.ivCause == this) {
            return null;
        }
        return this.ivCause;
    }

    public String getKey() {
        return this.key;
    }

    public String getLocalizedMessage() {
        return this.getLocalizedMessage(Locale.getDefault());
    }

    public String getLocalizedMessage(Locale locale) {
        String string = null;
        if (this.key == null) {
            string = super.getMessage();
        } else {
            Object object;
            try {
                object = ResourceBundle.getBundle(this.file, locale);
                String string2 = ((ResourceBundle)object).getString(this.key);
                if (this.parms == null) {
                    string = string2;
                } else {
                    MessageFormat messageFormat = new MessageFormat(string2);
                    messageFormat.setLocale(locale);
                    string = messageFormat.format(this.parms);
                }
            }
            catch (MissingResourceException missingResourceException) {
                StringBuffer stringBuffer = new StringBuffer(100);
                stringBuffer.append(missingResourceException.getLocalizedMessage());
                if (this.parms != null) {
                    stringBuffer.append(": ");
                    for (int i = 0; i < this.parms.length - 1; ++i) {
                        stringBuffer.append(this.parms[i] == null ? "null" : this.parms[i].toString());
                        stringBuffer.append(", ");
                    }
                    stringBuffer.append(this.parms[this.parms.length - 1] == null ? "null" : this.parms[this.parms.length - 1].toString());
                }
                string = stringBuffer.toString();
            }
            if (this.ivCause != null && (object = this.ivCause instanceof EventException ? ((EventException)this.ivCause).getLocalizedMessage(locale) : this.ivCause.getLocalizedMessage()) != null) {
                string = string + " : " + (String)object;
            }
        }
        return string;
    }

    public String getMessage() {
        return this.getLocalizedMessage(Locale.ENGLISH);
    }

    public synchronized Throwable initCause(Throwable throwable) throws IllegalStateException, IllegalArgumentException {
        if (this.ivCause != this) {
            throw new IllegalStateException("Can't overwrite cause");
        }
        if (throwable == this) {
            throw new IllegalArgumentException("Self-causation not permitted");
        }
        this.ivCause = throwable;
        return this;
    }

    public void printStackTrace() {
        this.printStackTrace(System.err);
    }

    public void printStackTrace(PrintStream printStream) {
        super.printStackTrace(printStream);
        if (this.ivCause != null && this.ivCause != this) {
            printStream.println("---- Begin backtrace for nested exception");
            this.ivCause.printStackTrace(printStream);
        }
    }

    public void printStackTrace(PrintWriter printWriter) {
        super.printStackTrace(printWriter);
        if (this.ivCause != null && this.ivCause != this) {
            printWriter.println("---- Begin backtrace for nested exception");
            this.ivCause.printStackTrace(printWriter);
        }
    }
}

